/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.GroupBasedUsersListener;
import com.adventnet.sym.adsm.common.server.objects.GroupFromSIDListener;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class GroupHandler {
    public static ArrayList getChildObjects(String domainName, String childObjectClass, String guid) {
        ArrayList objectsList = new ArrayList();
        try {
            String baseTableName = "ADSMGroupMembers";
            ObjectClass objectClass = DirectoryObjectAPI.getInstance().getObjectClass(childObjectClass);
            String childTableName = objectClass.getBaseTable();
            Join join = new Join(baseTableName, childTableName, new String[]{"GROUP_MEMBER_OBJECTGUID"}, new String[]{"OBJECT_GUID"}, 1);
            Criteria criteria = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_GUID"), (Object)guid, 0);
            Table baseTable = Table.getTable((String)baseTableName);
            SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
            selectQuery.addJoin(join);
            selectQuery.addSelectColumn(Column.getColumn((String)baseTableName, (String)"MEMBER_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)baseTableName, (String)"OBJECT_GUID"));
            selectQuery.addSelectColumn(Column.getColumn((String)childTableName, (String)"OBJECT_GUID"));
            selectQuery.addSelectColumn(Column.getColumn((String)childTableName, (String)"SID_STRING"));
            if (childObjectClass.equalsIgnoreCase("user")) {
                selectQuery.addSelectColumn(Column.getColumn((String)childTableName, (String)"SAM_ACCOUNT_NAME"));
            }
            selectQuery.addSelectColumn(Column.getColumn((String)childTableName, (String)"SID_STRING"));
            selectQuery.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows(childTableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                HashMap<String, Object> objectMap = new HashMap<String, Object>();
                objectMap.put("OBJECT_GUID", row.get("OBJECT_GUID"));
                objectMap.put("SID_STRING", row.get("SID_STRING"));
                if (childObjectClass.equalsIgnoreCase("user")) {
                    objectMap.put("SAM_ACCOUNT_NAME", row.get("SAM_ACCOUNT_NAME"));
                }
                objectsList.add(objectMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectsList;
    }

    public static void updateGroups(String domainName, String[] groupSIDs) {
        try {
            GroupHandler.updateGroupDetails(domainName, groupSIDs);
            GroupHandler.updateGroupUsers(domainName, groupSIDs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateGroupDetails(String domainName, String[] groupSIDs) {
        for (String string : groupSIDs) {
            GroupFromSIDListener listener = new GroupFromSIDListener(string);
            ObjectUpdateHandler.runReport(domainName, listener, 110);
            while (!listener.isListenerCompleted()) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void updateGroupUsers(String domainName, String[] groupSIDs) {
        for (String string : groupSIDs) {
            try {
                Row row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, string, "SID_STRING", "group");
                if (row == null) continue;
                String dn = (String)row.get("DISTINGUISHED_NAME");
                GroupBasedUsersListener listener = new GroupBasedUsersListener(dn);
                ObjectUpdateHandler.runReport(domainName, listener, 17);
                while (!listener.isListenerCompleted()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

