/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.AlterTableQuery;
import com.adventnet.ds.query.AlterTableQueryImpl;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.CategoryHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ObjectAttributeHandler {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static ObjectAttributeHandler handler = null;
    private Hashtable reportTableNameMap = null;
    private Hashtable tableNameAttributesMap = null;
    private Hashtable reportIdVsViewAttributesMap = null;
    private ArrayList domainList = null;
    private String[] tableArray = new String[]{"ADSMUserCustomDetails", "ADSMPasswordCustomDetails", "ADSMGroupCustomDetails", "ADSMComputerCustomDetails", "ADSMExchangeCustomDetails", "ADSMPolicyCustomDetails"};
    private String[] baseTableArray = new String[]{"ADSMUserGeneralDetails", "*************", "ADSMGroupGeneralDetails", "ADSMComputerGeneralDetails", "ADSMMRGeneralDetails", "ADSMPwdPolicyDetails"};
    private String[] dataHandler = new String[]{"CHAR", "INTEGER", "BIGINT", "BOOLEAN"};
    private Long[] dataValue = new Long[]{3L, 7L, 10L, 6L};
    private String message = "";
    private Object syncObj = null;

    private ObjectAttributeHandler() {
        this.reportTableNameMap = new Hashtable();
        this.tableNameAttributesMap = new Hashtable();
        this.reportIdVsViewAttributesMap = new Hashtable();
        this.syncObj = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOUName(String domainName, String distinguishedName) {
        distinguishedName = distinguishedName.toLowerCase();
        String ret = "";
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        Hashtable<Integer, String> indexVsOU = new Hashtable<Integer, String>();
        Object object = this.syncObj;
        synchronized (object) {
            try {
                if (this.domainList == null) {
                    Hashtable domains = DomainHandler.getDomainsAndOUs(1L);
                    this.domainList = (ArrayList)domains.get("domainList");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int i = 0; i < this.domainList.size(); ++i) {
                Properties domainProp = (Properties)this.domainList.get(i);
                if (!((String)domainProp.get("DOMAIN_NAME")).equalsIgnoreCase(domainName)) continue;
                ArrayList ouList = (ArrayList)domainProp.get("ouList");
                for (int j = 0; j < ouList.size(); ++j) {
                    Properties ouProp = (Properties)ouList.get(j);
                    String dn = ((String)ouProp.get("DISTINGUISHED_NAME")).toLowerCase();
                    String ouName = (String)ouProp.get("OU_NAME");
                    if (!distinguishedName.endsWith(dn) || distinguishedName.equalsIgnoreCase(dn)) continue;
                    Integer ind = distinguishedName.indexOf(dn);
                    int insertedIndex = indexList.size();
                    for (int k = 0; k < indexList.size(); ++k) {
                        Integer index = (Integer)indexList.get(k);
                        if (ind <= index) continue;
                        insertedIndex = k;
                        break;
                    }
                    indexList.add(insertedIndex, ind);
                    indexVsOU.put(ind, ouName);
                }
            }
        }
        for (int i = 0; i < indexList.size(); ++i) {
            if (ret.length() != 0) {
                ret = ret + "/";
            }
            ret = ret + indexVsOU.get(indexList.get(i));
        }
        return ret;
    }

    public String getLocation(String domainName, String distinguishedName) {
        String domainDNSName = DomainDetailsAPI.getDomainDNSName(domainName);
        StringBuilder location = new StringBuilder(domainDNSName);
        String ouname = this.getOUName(domainName, distinguishedName);
        if (ouname != null && !ouname.equals("")) {
            location.append("/");
            location.append(ouname);
        }
        return location.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectAttributeHandler getInstance() {
        if (handler != null) return handler;
        Class<ObjectAttributeHandler> clazz = ObjectAttributeHandler.class;
        synchronized (ObjectAttributeHandler.class) {
            if (handler != null) return handler;
            handler = new ObjectAttributeHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public ArrayList getTableNames(Integer reportId) {
        return this.getTableNames(reportId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTableNames(Integer reportId, String objectClass) {
        ArrayList<String> reportTableList;
        String key = reportId.toString();
        if (objectClass != null) {
            objectClass = objectClass.toLowerCase();
            key = key + objectClass;
        }
        if ((reportTableList = (ArrayList<String>)this.reportTableNameMap.get(key)) == null) {
            reportTableList = new ArrayList<String>();
            try {
                String q = "select distinct(TABLE_NAME) from ADSMAttributeDetails inner join ADSMTotalReports on ADSMAttributeDetails.ATTRIB_ID = ADSMTotalReports.ATTRIB_ID where ADSMTotalReports.REPORT_ID = " + reportId.toString();
                if (objectClass != null) {
                    ObjectClass objClass = DirectoryObjectAPI.getInstance().getObjectClass(objectClass);
                    Integer startRange = objClass.getStartRange();
                    Integer endRange = objClass.getEndRange();
                    q = q + " and ADSMAttributeDetails.ATTRIB_ID >= " + startRange + " and ADSMAttributeDetails.ATTRIB_ID <= " + endRange;
                }
                Connection connection = null;
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    RelationalAPI relationalAPI = RelationalAPI.getInstance();
                    connection = relationalAPI.getConnection();
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery(q);
                    while (rs.next()) {
                        reportTableList.add(rs.getString(1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e) {}
                }
                this.reportTableNameMap.put(key, reportTableList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return reportTableList;
    }

    public Criteria getObjectClassCriteria(String objectClass) {
        Criteria crit = null;
        try {
            if (objectClass != null) {
                ObjectClass objClass = DirectoryObjectAPI.getInstance().getObjectClass(objectClass);
                Integer startRange = objClass.getStartRange();
                Integer endRange = objClass.getEndRange();
                crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)startRange, 4);
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)endRange, 6));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public ArrayList getAttributes(String tableName, Integer reportId) {
        return this.getAttributes(tableName, reportId, null);
    }

    public ArrayList getAttributes(String tableName, Integer reportId, String objectClass) {
        ArrayList attributeList = new ArrayList();
        try {
            String key = tableName + "-" + reportId;
            if (objectClass != null) {
                objectClass = objectClass.toLowerCase();
                key = key + objectClass;
            }
            if ((attributeList = (ArrayList)this.tableNameAttributesMap.get(key)) == null) {
                attributeList = new ArrayList();
                Table table = Table.getTable((String)"ADSMAttributeDetails");
                SelectQueryImpl selectQuery = new SelectQueryImpl(table);
                Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME");
                Criteria criteria = new Criteria(column, (Object)tableName, 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMTotalReports", (String)"REPORT_ID"), (Object)reportId, 0));
                Criteria objCrit = this.getObjectClassCriteria(objectClass);
                if (objCrit != null) {
                    criteria = criteria.and(objCrit);
                }
                selectQuery.setCriteria(criteria);
                selectQuery.addJoin(new Join(table, Table.getTable((String)"ADSMTotalReports"), new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DATA_TYPE"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"DATA_HANDLER_TYPE"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
                if (!dataObject.isEmpty()) {
                    attributeList = CommonUtil.getList(dataObject, new String[]{"ATTRIB_DISP_NAME", "ATTRIB_COLUMN_NAME", "DATA_HANDLER_TYPE", "RELATIONAL_TYPE", "ATTRIB_LDAP_NAME", "ATTRIB_DATA_TYPE", "ATTRIB_ID"}, "ADSMAttributeDetails");
                }
                this.tableNameAttributesMap.put(key, attributeList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attributeList;
    }

    public ArrayList getViewAttributes(Integer reportId) {
        return this.getViewAttributes(reportId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getViewAttributes(Integer reportId, String objectClass) {
        ArrayList<Object> viewList;
        String key = reportId.toString();
        if (objectClass != null) {
            objectClass = objectClass.toLowerCase();
            key = key + objectClass;
        }
        if ((viewList = (ArrayList<Object>)this.reportIdVsViewAttributesMap.get(key)) == null) {
            viewList = new ArrayList<Object>();
            Connection connection = null;
            try {
                Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
                Table joinTable = Table.getTable((String)"ADSMViewReports");
                SelectQueryImpl sq = new SelectQueryImpl(baseTable);
                sq.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMViewReports", (String)"REPORT_ID"), (Object)reportId, 0);
                Criteria objCrit = this.getObjectClassCriteria(objectClass);
                if (objCrit != null) {
                    criteria = criteria.and(objCrit);
                }
                sq.setCriteria(criteria);
                Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID");
                sq.addSelectColumn(column);
                sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
                boolean isAscending = true;
                SortColumn sortcolumn = new SortColumn(Column.getColumn((String)"ADSMViewReports", (String)"PRIORITY_ID"), isAscending);
                sq.addSortColumn(sortcolumn);
                RelationalAPI relAPI = RelationalAPI.getInstance();
                connection = relAPI.getConnection();
                DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
                while (dataSet.next()) {
                    viewList.add(dataSet.getValue(1));
                }
                dataSet.close();
                this.reportIdVsViewAttributesMap.put(key, viewList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException se) {}
            }
        }
        return viewList;
    }

    public ArrayList getViewColumn(Integer reportId) {
        return this.getViewColumn(reportId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getViewColumn(Integer reportId, String objectClass) {
        ArrayList<Properties> viewList = new ArrayList<Properties>();
        Connection connection = null;
        try {
            Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
            Table joinTable = Table.getTable((String)"ADSMViewReports");
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            sq.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMViewReports", (String)"REPORT_ID"), (Object)reportId, 0);
            Criteria objCrit = this.getObjectClassCriteria(objectClass);
            if (objCrit != null) {
                criteria = criteria.and(objCrit);
            }
            sq.setCriteria(criteria);
            boolean isAscending = true;
            SortColumn sortcolumn = new SortColumn(Column.getColumn((String)"ADSMViewReports", (String)"PRIORITY_ID"), isAscending);
            sq.addSortColumn(sortcolumn);
            Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID");
            sq.addSelectColumn(column);
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"SHOW_SEARCH"));
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Properties prop = new Properties();
                prop.put("ATTRIB_ID", dataSet.getValue(1));
                prop.put("ATTRIB_DISP_NAME", dataSet.getValue(2));
                prop.put("ATTRIB_LDAP_NAME", dataSet.getValue(3));
                prop.put("RELATIONAL_TYPE", dataSet.getValue(4));
                prop.put("TABLE_NAME", dataSet.getValue(5));
                prop.put("ATTRIB_COLUMN_NAME", dataSet.getValue(6));
                prop.put("SHOW_SEARCH", dataSet.getValue(7));
                viewList.add(prop);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return viewList;
    }

    public ArrayList getEditColumn(Integer reportId, ArrayList viewList) {
        ArrayList totalList = this.getTotalColumn(reportId);
        ArrayList<Properties> nonVisibleList = new ArrayList<Properties>();
        for (int i = 0; i < totalList.size(); ++i) {
            Properties prop = (Properties)totalList.get(i);
            if (viewList.contains(prop)) continue;
            nonVisibleList.add(prop);
        }
        return nonVisibleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTotalColumn(Integer reportId) {
        ArrayList<Properties> totalList = null;
        Connection connection = null;
        totalList = new ArrayList<Properties>();
        try {
            Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
            Table joinTable = Table.getTable((String)"ADSMTotalReports");
            SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
            selectQuery.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMTotalReports", (String)"REPORT_ID"), (Object)reportId, 0);
            selectQuery.setCriteria(criteria);
            Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID");
            boolean isAscending = true;
            SortColumn sortColumn = new SortColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"), isAscending);
            selectQuery.addSelectColumn(column);
            column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME");
            selectQuery.addSelectColumn(column);
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"SHOW_SEARCH"));
            selectQuery.addSortColumn(sortColumn);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                Properties reportprop = new Properties();
                reportprop.put("ATTRIB_ID", dataSet.getValue(1));
                reportprop.put("ATTRIB_DISP_NAME", dataSet.getValue(2));
                reportprop.put("ATTRIB_LDAP_NAME", dataSet.getValue(3));
                reportprop.put("RELATIONAL_TYPE", dataSet.getValue(4));
                reportprop.put("TABLE_NAME", dataSet.getValue(5));
                reportprop.put("ATTRIB_COLUMN_NAME", dataSet.getValue(6));
                reportprop.put("SHOW_SEARCH", dataSet.getValue(7));
                totalList.add(reportprop);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return totalList;
    }

    public boolean saveColumns(Integer reportId, ArrayList list) {
        boolean success = true;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMViewReports", (String)"REPORT_ID"), (Object)reportId, 0);
            CommonUtil.getPersistenceLite().delete(crit);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (int i = 0; i < list.size(); ++i) {
                Properties p = (Properties)list.get(i);
                Row r = new Row("ADSMViewReports");
                r.set("REPORT_ID", (Object)reportId);
                r.set("ATTRIB_ID", p.get("ATTRIB_ID"));
                r.set("PRIORITY_ID", p.get("PRIORITY_ID"));
                dataObject.addRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            this.reportIdVsViewAttributesMap.remove(reportId.toString());
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getModifiedColumns(Integer reportId) {
        ArrayList<Properties> modifiedList = new ArrayList<Properties>();
        Connection connection = null;
        try {
            Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
            Table joinTable = Table.getTable((String)"ADSMModifiedColumns");
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            sq.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMModifiedColumns", (String)"REPORT_ID"), (Object)reportId, 0);
            sq.setCriteria(criteria);
            boolean isAscending = true;
            SortColumn sortcolumn = new SortColumn(Column.getColumn((String)"ADSMModifiedColumns", (String)"PRIORITY_ID"), isAscending);
            sq.addSortColumn(sortcolumn);
            Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID");
            sq.addSelectColumn(column);
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Properties prop = new Properties();
                prop.put("ATTRIB_ID", dataSet.getValue(1));
                prop.put("ATTRIB_DISP_NAME", dataSet.getValue(2));
                prop.put("ATTRIB_LDAP_NAME", dataSet.getValue(3));
                prop.put("RELATIONAL_TYPE", dataSet.getValue(4));
                prop.put("TABLE_NAME", dataSet.getValue(5));
                prop.put("ATTRIB_COLUMN_NAME", dataSet.getValue(6));
                modifiedList.add(prop);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return modifiedList;
    }

    public void setValues(String tableName, String columnName, ArrayList list, String sid) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)sid, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            dataObj.deleteRows(tableName, criteria);
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            for (int i = 0; i < list.size(); ++i) {
                Row r = new Row(tableName);
                r.set("OBJECT_GUID", (Object)sid);
                r.set(columnName, (Object)((String)list.get(i)));
                dataObj.addRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCount(String tableName, String sid) {
        Connection connection = null;
        Table table = Table.getTable((String)tableName);
        int rowCount = 0;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)sid, 0);
            Column col = Column.getColumn(null, (String)"*").count();
            sq.addSelectColumn(col);
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                rowCount = (Integer)dataSet.getValue(1);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMultipleValues(String tableName, String sid, String columnName, boolean ascending, String searchPattern, String domainName) {
        Connection connection = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            Table baseTable = Table.getTable((String)tableName);
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Column column = Column.getColumn((String)tableName, (String)columnName);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)sid, 0);
            Criteria criteria = crit.and(column, (Object)searchPattern, 2, false);
            SortColumn sortColumn = new SortColumn(tableName, columnName, ascending);
            sq.addSelectColumn(column);
            sq.addSortColumn(sortColumn);
            sq.setCriteria(criteria);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            System.out.println("Query is1 : " + relAPI.getSelectSQL((Query)sq));
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                list.add((String)dataSet.getValue(1));
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return list;
    }

    public Integer insertCustomValues(Map hashMap, String tableName, String dataType, String columnName, Long reportCategoryId) throws Exception {
        Object criteria = null;
        Long dataHandlerType = 0L;
        int attribId = this.getAttribId("ADSMAttributeDetails", tableName);
        hashMap.put("ATTRIB_ID", ++attribId);
        for (int i = 0; i < this.dataHandler.length; ++i) {
            if (!dataType.equals(this.dataHandler[i])) continue;
            dataHandlerType = this.dataValue[i];
        }
        hashMap.put("DATA_HANDLER_TYPE", dataHandlerType);
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("ADSMAttributeDetails");
            row.setAll(hashMap);
            dataObj.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object defaultValue = null;
        AlterTableQueryImpl alt = new AlterTableQueryImpl(tableName, 1);
        alt.setColumnName(columnName);
        alt.setDataType(dataType);
        alt.setMaxLength(250);
        alt.setNullable(true);
        alt.setDefaultValue(defaultValue);
        try {
            CommonUtil.getPersistence(new boolean[0]).alterTable((AlterTableQuery)alt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateTotalTable(attribId, tableName);
        return attribId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getAttribId(String attributeTable, String tableName) throws Exception {
        String[] tables = new String[]{"ADSMUserCustomDetails", "ADSMGroupCustomDetails", "ADSMComputerCustomDetails", "ADSMPasswordCustomDetails", "ADSMExchangeCustomDetails", "ADSMPolicyCustomDetails"};
        int attribId = 0;
        int gThan = 0;
        int lThan = 0;
        Connection connection = null;
        Criteria crit = null;
        for (int i = 0; i < tables.length; ++i) {
            if (!tableName.equals(tables[i])) continue;
            gThan = 1500 + i * 1000;
            lThan = 2000 + i * 1000;
            crit = this.getCriteria(gThan, lThan, attributeTable);
            break;
        }
        try {
            Table table = Table.getTable((String)attributeTable);
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Column col = Column.getColumn((String)attributeTable, (String)"ATTRIB_ID").maximum();
            sq.addSelectColumn(col);
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                if (dataSet.getValue(1) != null) {
                    attribId = (Integer)dataSet.getValue(1);
                    continue;
                }
                attribId = gThan;
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return attribId;
    }

    public Criteria getCriteria(int gThan, int lThan, String attributeTable) {
        Criteria crit = new Criteria(Column.getColumn((String)attributeTable, (String)"ATTRIB_ID"), (Object)gThan, 4);
        Criteria criter = crit.and(new Criteria(Column.getColumn((String)attributeTable, (String)"ATTRIB_ID"), (Object)lThan, 6));
        return criter;
    }

    public void alterCustomTable(String tableName, String columnName, String dataType) throws Exception {
        Object criteria = null;
        Object defaultValue = null;
        AlterTableQueryImpl alt = new AlterTableQueryImpl(tableName, 1);
        alt.setColumnName(columnName);
        alt.setDataType(dataType);
        alt.setMaxLength(250);
        alt.setNullable(true);
        alt.setDefaultValue(defaultValue);
        try {
            CommonUtil.getPersistence(new boolean[0]).alterTable((AlterTableQuery)alt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateTotalTable(int attribId, String tableName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String baseTableName = null;
            for (int i = 0; i < this.tableArray.length; ++i) {
                if (!this.tableArray[i].equalsIgnoreCase(tableName)) continue;
                baseTableName = this.baseTableArray[i];
            }
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMReports", (String)"BASE_TABLE_NAME"), baseTableName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMReports", crit);
            Iterator ite = dataObj.getRows("ADSMReports");
            while (ite.hasNext()) {
                Row mapRow;
                Row r = (Row)ite.next();
                int reportId = (Integer)r.get("REPORT_ID");
                DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row row = new Row("ADSMTotalReports");
                row.set("REPORT_ID", (Object)reportId);
                row.set("ATTRIB_ID", (Object)attribId);
                dObj.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dObj);
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMMappingDetails", (String)"REPORT_ID"), (Object)reportId, 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMMappingDetails", criteria);
                Iterator iterator = obj.getRows("ADSMMappingDetails");
                while (iterator.hasNext()) {
                    mapRow = (Row)iterator.next();
                    list.add((String)mapRow.get("TABLE_NAME"));
                }
                if (list.contains(tableName)) continue;
                mapRow = new Row("ADSMMappingDetails");
                mapRow.set("REPORT_ID", (Object)reportId);
                mapRow.set("TABLE_NAME", (Object)tableName);
                obj.addRow(mapRow);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getFieldList() {
        ArrayList<Properties> fieldList = new ArrayList<Properties>();
        try {
            Criteria crit = null;
            String tableName = "ADSMCustomFields";
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomFields", crit);
            Iterator ite = dataObj.getRows(tableName);
            while (ite.hasNext()) {
                Row r = (Row)ite.next();
                Properties prop = new Properties();
                prop.put("FIELD_ID", (Long)r.get("FIELD_ID"));
                prop.put("LDAP_NAME", (String)r.get("LDAP_NAME"));
                prop.put("DISPLAY_NAME", (String)r.get("DISPLAY_NAME"));
                prop.put("DATA_TYPE", (String)r.get("DATA_TYPE"));
                prop.put("FOR_REPORTS", (String)r.get("FOR_REPORTS"));
                fieldList.add(prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldList;
    }

    public void addCustomFields(ArrayList categoryList, Hashtable hashIds, Map hashMap) throws Exception {
        String[] reports = new String[]{rb.getString("adap.ObjectAttributeHandler.User_Reports"), rb.getString("adap.ObjectAttributeHandler.Password_Reports"), rb.getString("adap.ObjectAttributeHandler.Group_Reports"), rb.getString("adap.ObjectAttributeHandler.Computer_Reports"), rb.getString("adap.ObjectAttributeHandler.Exchange_Reports"), rb.getString("adap.ObjectAttributeHandler.Policy_Reports")};
        String forReports = "";
        String dataHandlerType = "";
        for (int i = 0; i < categoryList.size(); ++i) {
            Long categoryId = (Long)categoryList.get(i);
            if (i != 0) {
                forReports = forReports + ", ";
            }
            forReports = forReports + reports[(int)categoryId.longValue() - 1];
        }
        Row r = new Row("ADSMCustomFields");
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            r.set("LDAP_NAME", (Object)((String)hashMap.get("ATTRIB_LDAP_NAME")));
            r.set("DISPLAY_NAME", (Object)((String)hashMap.get("ATTRIB_DISP_NAME")));
            Long dataType = (Long)hashMap.get("DATA_HANDLER_TYPE");
            for (int i = 0; i < this.dataValue.length; ++i) {
                if (!dataType.equals(this.dataValue[i])) continue;
                dataHandlerType = this.dataHandler[i];
            }
            r.set("DATA_TYPE", (Object)dataHandlerType);
            r.set("FOR_REPORTS", (Object)forReports);
            dObj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Enumeration enumer = hashIds.keys();
        while (enumer.hasMoreElements()) {
            Long cateId = (Long)enumer.nextElement();
            try {
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row row = new Row("ADSMCustomIds");
                row.set("FIELD_ID", r.get("FIELD_ID"));
                row.set("CATEGORY_ID", (Object)cateId);
                row.set("ATTRIB_ID", (Object)((Integer)hashIds.get(cateId)));
                dataObj.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String deleteCustomFields(Long fieldId) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"FIELD_ID"), (Object)fieldId, 0);
        Criteria fieldCrit = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
        try {
            if (fieldId != null) {
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomIds", criteria);
                Iterator ite = dataObj.getRows("ADSMCustomIds", criteria);
                while (ite.hasNext()) {
                    ArrayList<Long> list = new ArrayList<Long>();
                    Row r = (Row)ite.next();
                    int attribId = (Integer)r.get("ATTRIB_ID");
                    Long categId = (Long)r.get("CATEGORY_ID");
                    Criteria mapCrit = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"CATEGORY_ID"), (Object)categId, 0);
                    DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomIds", mapCrit);
                    Iterator iterator = obj.getRows("ADSMCustomIds", mapCrit);
                    while (iterator.hasNext()) {
                        Row mapRow = (Row)iterator.next();
                        list.add((Long)mapRow.get("CATEGORY_ID"));
                    }
                    if (list.size() == 1) {
                        String tableName = this.tableArray[(int)categId.longValue() - 1];
                        ArrayList subCatList = CategoryHandler.getSubCategIds(categId);
                        for (int i = 0; i < subCatList.size(); ++i) {
                            Criteria mapCriteria = new Criteria(Column.getColumn((String)"ADSMReports", (String)"SUB_CATEGORY_ID"), subCatList.get(i), 0);
                            DataObject reportObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMReports", mapCriteria);
                            Iterator item = reportObj.getRows("ADSMReports");
                            while (item.hasNext()) {
                                Row mapRow = (Row)item.next();
                                int reportId = (Integer)mapRow.get("REPORT_ID");
                                DataObject doObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMMappingDetails", new Criteria(Column.getColumn((String)"ADSMMappingDetails", (String)"REPORT_ID"), (Object)reportId, 0));
                                doObj.deleteRows("ADSMMappingDetails", new Criteria(Column.getColumn((String)"ADSMMappingDetails", (String)"TABLE_NAME"), (Object)tableName, 0));
                                CommonUtil.getPersistence(new boolean[0]).update(doObj);
                            }
                        }
                    }
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribId, 0);
                    DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMAttributeDetails", crit);
                    String columnName = (String)dObj.getValue("ADSMAttributeDetails", "ATTRIB_COLUMN_NAME", crit);
                    boolean status = this.deleteCustomDetails(categId, columnName);
                    dObj.deleteRows("ADSMAttributeDetails", crit);
                    CommonUtil.getPersistence(new boolean[0]).update(dObj);
                }
                dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomFields", fieldCrit);
                dataObj.deleteRows("ADSMCustomFields", fieldCrit);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = e.getMessage();
        }
        if (this.message.length() == 0) {
            this.message = "Successfully deleted.";
        }
        return this.message;
    }

    public boolean deleteCustomDetails(Long categId, String columnName) {
        boolean status = true;
        String tableName = this.tableArray[(int)categId.longValue() - 1];
        AlterTableQueryImpl alt = new AlterTableQueryImpl(tableName, columnName, 3);
        try {
            CommonUtil.getPersistence(new boolean[0]).alterTable((AlterTableQuery)alt);
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    public Properties getFieldRow(Long fieldId) {
        Properties p = new Properties();
        ArrayList<String> list = new ArrayList<String>();
        Criteria crit = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"FIELD_ID"), (Object)fieldId, 0);
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomFields", crit);
            Row fieldRow = dataObj.getRow("ADSMCustomFields", crit);
            p.put("LDAP_NAME", fieldRow.get("LDAP_NAME"));
            p.put("DISPLAY_NAME", fieldRow.get("DISPLAY_NAME"));
            p.put("DATA_TYPE", fieldRow.get("DATA_TYPE"));
            p.put("UPDATE_FIELD_ID", fieldId);
            DataObject idObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomIds", criteria);
            Iterator ite = idObj.getRows("ADSMCustomIds", criteria);
            while (ite.hasNext()) {
                Row r = (Row)ite.next();
                Long categId = (Long)r.get("CATEGORY_ID");
                String customTable = this.tableArray[(int)categId.longValue() - 1];
                p.put(customTable, Boolean.TRUE);
                list.add(customTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetValues() {
        Object object = this.syncObj;
        synchronized (object) {
            this.domainList = null;
        }
    }

    public void resetAttributes() {
        this.reportTableNameMap = new Hashtable();
        this.tableNameAttributesMap = new Hashtable();
        this.reportIdVsViewAttributesMap = new Hashtable();
    }
}

