/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.GPOAlertProfileListener;
import com.adventnet.sym.adsm.auditing.server.gpo.GPOManagementListener;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DBQueue;
import com.adventnet.sym.adsm.common.server.ProcessObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.ObjectAttributeHandler;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateTask;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class ObjectListener
implements NativeListener,
ObjectUpdateTask {
    protected static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    String className = ObjectListener.class.getName();
    Logger outLog = Logger.getLogger(this.className);
    private String ldapQuery;
    boolean data_available = true;
    protected Integer reportId = null;
    protected Long generationId = null;
    protected Long loginId = 1L;
    protected PrintWriter out = null;
    protected boolean isCompleted = true;
    protected boolean continueAction = true;
    protected long sleepMillis = 700L;
    private ArrayList updateList = null;
    protected DBQueue queue = null;
    protected String baseTableName = null;
    protected String resultTableName = null;
    protected String domainName = null;
    protected String onClickText = null;
    protected ArrayList guidList = null;
    protected String desc = "";
    protected boolean updateDetails = true;
    protected String noOfObjects = "unlimited";
    protected ArrayList toBeExecutedAttributeList = null;
    protected String title = rb.getString("adap.ObjectListener.Active_Directory_Reports");
    protected Long categoryId = 1003L;
    protected String tableKey = "OBJECT_GUID";
    protected String attrKey = "objectGUID";
    protected String attrKey2 = "objectGUID";
    protected int[] mgmtIds = new int[]{1004, 1144, 1143, 1006};
    protected Long mgmtGenerationId = null;
    protected String mgmtResultTableName = null;
    protected int updatedCount = -1;
    protected int totalCount = 0;
    protected String errorMessage = null;
    private static char[] spec = new char[]{'\\', '\'', '&'};
    protected String[] cks = null;

    protected abstract void checkAttributeList(ArrayList var1);

    protected abstract void doAction(String var1, Long var2, String var3, ArrayList var4, NativeListener var5) throws Exception;

    public ObjectListener() {
        this.updateList = new ArrayList();
        this.guidList = new ArrayList();
        this.queue = DBQueue.getInstance();
    }

    public void getDescription() {
        this.desc = rb.getString("adap.ObjectListener.Report_generated_for_the_Domains");
    }

    @Override
    public void setQueryCompleted() {
        this.stop(null);
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    protected void updateOutList() {
        if (this.updateList.size() > 0) {
            reportLogger.log(Level.INFO, "REPORT UPDATE COUNTS : " + this.updateList.size());
            for (int i = 0; i < this.updateList.size() && i < 24; ++i) {
                this.out.write((String)this.updateList.get(i));
                this.out.flush();
            }
            this.updateList.clear();
        }
    }

    public void updateUI(String str) {
        ++this.updatedCount;
        if (this.out != null) {
            this.updateOutList();
            if (this.updatedCount <= 25) {
                this.out.write("<script>if(this.load) updateUI(" + str + ")</script>");
            }
            this.out.write("<script>updateCount(" + this.updatedCount + ")</script>");
            this.out.flush();
        } else {
            this.updateList.add("<script>updateUI(" + str + ")</script>");
        }
    }

    @Override
    public void init(Row r) {
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
    }

    @Override
    public void shutDownQueue() {
    }

    public void init(HttpServletRequest request, Row r) {
        reportLogger.log(Level.INFO, "REPORT QUEUE INITIALIZATION... ");
        HttpSession session = request.getSession();
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.reportId = (Integer)r.get("REPORT_ID");
        this.onClickText = (String)r.get("ONCLICK_TEXT");
        this.title = (String)r.get("REPORT_NAME");
        this.setGenerationId(request);
    }

    public Hashtable getQueueProps() {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("generationId", this.generationId);
        tableProps.put("resultHandling", "add");
        return tableProps;
    }

    public void setGenerationId(HttpServletRequest request) {
        HttpSession session = request.getSession();
        this.loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String generationIdStr = request.getParameter("generationId");
        reportLogger.log(Level.INFO, "Generation Id Str : " + generationIdStr);
        if (generationIdStr != null) {
            try {
                this.generationId = Long.parseLong(generationIdStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.generationId = null;
                reportLogger.log(Level.INFO, "Generation Id set to null : " + generationIdStr);
            }
        } else {
            this.generationId = ObjectUpdateHandler.getRecentlyGeneratedReports(this.reportId, this.loginId);
            reportLogger.log(Level.INFO, "Recently Generated Id : " + this.generationId);
        }
    }

    public void setGenerationId(Long id) {
        this.generationId = id;
    }

    public void setWriter(PrintWriter o) {
        this.out = o;
    }

    @Override
    public Long getGenerationId() {
        return this.generationId;
    }

    public String getResultTableName() {
        return this.resultTableName;
    }

    protected String getDynamicUpdateValues(Integer attributeId, Object obj) {
        String ret = this.getUICustomizedValues(attributeId, obj);
        if (attributeId == 1021 || attributeId == 2012 || attributeId == 3014 || attributeId == 2011 || attributeId == 1037) {
            ret = "-";
        } else {
            String s = obj.toString();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                for (int j = 0; j < spec.length; ++j) {
                    if (c != spec[j]) continue;
                    return "-";
                }
            }
        }
        return ret;
    }

    public String getUICustomizedValues(Integer attributeId, Object obj) {
        String ret = null;
        ret = obj.toString();
        return ret;
    }

    private void updateDcVersion(Row r, Properties prop) {
        try {
            DataObject d1;
            ArrayList samArray = (ArrayList)prop.get("sAMAccountName");
            String sam = (String)samArray.get(0);
            sam = sam.substring(0, sam.indexOf(36));
            String dns = (String)r.get("DNS_NAME");
            Criteria c1 = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"), (Object)sam, 0);
            if (!dns.equalsIgnoreCase("-")) {
                Criteria c2 = new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"), (Object)dns, 0);
                c1 = c1.or(c2);
            }
            if (!(d1 = CommonUtil.getPersistence(new boolean[0]).get("ADSMDCConfiguration", c1)).isEmpty()) {
                Row r3 = d1.getFirstRow("ADSMDCConfiguration");
                long dc_id = (Long)r3.get("DOMAIN_CONTROLLER_ID");
                c1 = new Criteria(Column.getColumn((String)"AUDDCEventRead", (String)"DOMAIN_CONTROLLER_ID"), (Object)dc_id, 0);
                DataObject d = CommonUtil.getPersistence(new boolean[0]).get("AUDDCEventRead", c1);
                if (!d.isEmpty()) {
                    String v2;
                    float ver2;
                    float ver1;
                    String v1 = (String)r.get("VERSION");
                    int ii = -1;
                    if (v1 != null) {
                        ii = v1.indexOf("(");
                    }
                    if ((ver1 = ii == -1 ? 0.0f : Float.parseFloat(v1.substring(0, ii))) > (ver2 = (ii = (v2 = (String)(r3 = d.getFirstRow("AUDDCEventRead")).get("OS_VERSION")) != null ? v2.indexOf("(") : -1) == -1 ? 0.0f : Float.parseFloat(v2.substring(0, ii)))) {
                        UpdateQueryImpl s = new UpdateQueryImpl("AUDDCEventRead");
                        s.setCriteria(c1);
                        s.setUpdateColumn("OS_VERSION", (Object)v1);
                        CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)s);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Hashtable uiValues) {
        ArrayList values = null;
        ArrayList tableNames = ObjectAttributeHandler.getInstance().getTableNames(this.reportId);
        int baseTableIndex = tableNames.indexOf(this.baseTableName);
        if (baseTableIndex > 0) {
            tableNames.remove(baseTableIndex);
            tableNames.add(0, this.baseTableName);
        }
        ArrayList viewAttributeList = ObjectAttributeHandler.getInstance().getViewAttributes(this.reportId);
        for (int i = 0; i < tableNames.size(); ++i) {
            String tableName = (String)tableNames.get(i);
            ArrayList attributeList = ObjectAttributeHandler.getInstance().getAttributes(tableName, this.reportId);
            ArrayList<Object> rowList = new ArrayList<Object>();
            Row r = null;
            Integer relationalType = null;
            ArrayList<Row> multipleTableRowList = new ArrayList<Row>();
            for (int j = 0; j < attributeList.size(); ++j) {
                Properties p = (Properties)attributeList.get(j);
                String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
                String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)p.get("ATTRIB_ID");
                relationalType = (Integer)p.get("RELATIONAL_TYPE");
                if (this.toBeExecutedAttributeList != null && !this.toBeExecutedAttributeList.contains(ldapName)) continue;
                values = (ArrayList)prop.get(ldapName);
                values = ObjectUpdateUtil.getDBCustomizedValues(this.domainName, columnName, ldapName, prop);
                StringBuffer buf = new StringBuffer();
                if (relationalType.equals(1)) {
                    buf.append("-");
                    if (values != null && !values.isEmpty()) {
                        for (int k = 0; k < values.size(); ++k) {
                            String value = (String)values.get(k);
                            Row r1 = null;
                            if (multipleTableRowList.size() > k) {
                                r1 = (Row)multipleTableRowList.get(k);
                            } else {
                                r1 = new Row(tableName);
                                multipleTableRowList.add(k, r1);
                            }
                            r1.set(columnName, (Object)value);
                            r1.set(this.tableKey, (Object)guid);
                            buf.append(value);
                            if (k == values.size() - 1) continue;
                            buf.append(",");
                        }
                    } else {
                        if (r == null) {
                            r = new Row(tableName);
                        }
                        r.set(columnName, (Object)"-");
                    }
                } else if (values != null && !values.isEmpty()) {
                    if (r == null) {
                        r = new Row(tableName);
                    }
                    r.set(columnName, values.get(0));
                    buf.append(values.get(0));
                } else {
                    if (r == null) {
                        r = new Row(tableName);
                    }
                    r.set(columnName, (Object)"-");
                    buf.append("-");
                }
                if (!viewAttributeList.contains(attributeId)) continue;
                uiValues.put(attributeId, buf.toString());
            }
            if (r != null) {
                String rol;
                if (tableName.equalsIgnoreCase("ADSMComputerGeneralDetails") && (rol = (String)r.get("ROLE")).equalsIgnoreCase("DomainController")) {
                    this.updateDcVersion(r, prop);
                }
                r.set(this.tableKey, (Object)guid);
                rowList.add(r);
            }
            if (multipleTableRowList.size() > 0) {
                rowList.addAll(multipleTableRowList);
            }
            if (relationalType.equals(0)) {
                tableRowMap.put(tableName, rowList);
                continue;
            }
            if (rowList.size() <= 0) continue;
            relationalTableRowMap.put(tableName, rowList);
        }
    }

    protected String getGuid(Properties prop) {
        ArrayList guids = (ArrayList)prop.get(this.attrKey);
        if (guids == null) {
            guids = (ArrayList)prop.get(this.attrKey2);
        }
        if (guids == null) {
            reportLogger.log(Level.INFO, prop.toString());
            return null;
        }
        String guid = (String)guids.get(0);
        return guid;
    }

    @Override
    public String queryCompleted() {
        String c = "false";
        if (this.isCompleted() || this.isCompleted) {
            c = "true";
        }
        return c;
    }

    @Override
    public void addRow(Properties prop) {
        reportLogger.log(Level.FINE, "RESULT FROM NATIVE : " + prop);
        if (this.noOfObjects == null) {
            this.continueAction = false;
            System.out.println("Number Of Objects exceeded beyond the License Limit");
            return;
        }
        if (!this.noOfObjects.equalsIgnoreCase("unlimited")) {
            int licensedCount = 100;
            try {
                licensedCount = Integer.parseInt(this.noOfObjects);
                if (this.totalCount >= licensedCount) {
                    this.updateQueue();
                    this.continueAction = false;
                    System.out.println("Number Of Objects exceeded beyond the License Limit");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String guid = this.getGuid(prop);
            if (guid == null) {
                reportLogger.log(Level.FINE, "SID is NULL for the Properties : " + prop);
                return;
            }
            ++this.totalCount;
            Hashtable tableRowMap = new Hashtable();
            Hashtable relationalTableRowMap = new Hashtable();
            Hashtable uiValues = new Hashtable();
            this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues);
            this.queue.add(this.generationId, guid, tableRowMap, relationalTableRowMap);
            if (!this.guidList.contains(guid)) {
                this.guidList.add(guid);
            }
            StringBuffer b = new StringBuffer();
            b.append("[");
            ArrayList viewAttributeList = ObjectAttributeHandler.getInstance().getViewAttributes(this.reportId);
            for (int i = 0; i < viewAttributeList.size(); ++i) {
                Integer attributeId = (Integer)viewAttributeList.get(i);
                b.append("'");
                String s = (String)uiValues.get(attributeId);
                if (s == null || s.trim().equalsIgnoreCase("")) {
                    b.append("-");
                } else {
                    s = this.getDynamicUpdateValues(attributeId, s);
                    b.append(s);
                }
                b.append("'");
                if (i == viewAttributeList.size() - 1) continue;
                b.append(",");
            }
            b.append("]");
            this.updateUI(b.toString());
            this.queue.checkForNextUpdate(this.generationId);
        }
        catch (Exception e) {
            reportLogger.fine(prop.toString());
            e.printStackTrace();
        }
    }

    protected String getDescription(String[] domainList, Hashtable dnDomainNameMap) {
        String description = "";
        if (domainList == null) {
            return description;
        }
        for (int i = 0; i < domainList.length; ++i) {
            String val;
            if (i != 0) {
                this.desc = this.desc + ", ";
            }
            if ((val = domainList[i]).equalsIgnoreCase("")) continue;
            this.desc = this.desc + dnDomainNameMap.get(val);
        }
        return this.desc;
    }

    public ArrayList getAttributeList() {
        ArrayList<Object> attributeList = new ArrayList<Object>();
        ArrayList tableNames = ObjectAttributeHandler.getInstance().getTableNames(this.reportId);
        for (int i = 0; i < tableNames.size(); ++i) {
            ArrayList l = ObjectAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), this.reportId);
            for (int j = 0; j < l.size(); ++j) {
                Properties p = (Properties)l.get(j);
                if (attributeList.contains(p.get("ATTRIB_LDAP_NAME"))) continue;
                attributeList.add(p.get("ATTRIB_LDAP_NAME"));
            }
        }
        if (this.ldapQuery != null) {
            attributeList.remove("member");
            attributeList.remove("memberOf");
        }
        attributeList.add("objectSID");
        if (!attributeList.contains("objectGUID")) {
            attributeList.add("objectGUID");
        }
        if (!attributeList.contains("sAMAccountName")) {
            attributeList.add("sAMAccountName");
        }
        return attributeList;
    }

    protected void updateQueue() {
        if (this.updateDetails) {
            while (!this.queue.isCompleted(this.generationId)) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void completedAction() {
        if (this.updateDetails) {
            reportLogger.log(Level.INFO, "Receiving Completed Action");
            this.updateQueue();
            reportLogger.log(Level.INFO, "Updating Completed Action");
            ObjectUpdateHandler.updateReportGenerationDetails(this.generationId, 1, this.desc, this.loginId);
        }
        this.isCompleted = true;
    }

    public void stop(HttpServletRequest request) {
        reportLogger.log(Level.INFO, "Receiving Stop Action");
        this.continueAction = false;
        if (this.ldapQuery == null) {
            while (!this.isCompleted) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean isCompleted() {
        return !this.continueAction;
    }

    public boolean isListenerCompleted() {
        return this.isCompleted;
    }

    protected void setClientButtons(boolean flag) {
        if (this.out != null) {
            this.out.write("<script> setClientButtons(" + flag + "); </script>");
            this.out.flush();
        }
    }

    public void controlUI(PrintWriter o) {
        if (this.isCompleted) {
            return;
        }
        this.out = o;
        boolean actionSet = false;
        while (!this.isCompleted && this.continueAction) {
            try {
                if (this.continueAction && !this.out.checkError() && !actionSet) {
                    this.setClientButtons(true);
                    actionSet = true;
                }
                Thread.sleep(this.sleepMillis);
                if (this.sleepMillis != 700L) continue;
                this.sleepMillis = 200L;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.out.write("<b> Error Occured : " + e.getMessage() + " </b>");
            }
        }
        boolean check = true;
        try {
            if (this.out == null || this.out.checkError() || !this.isCompleted) {
                check = false;
            }
        }
        catch (Exception e) {
            check = false;
            e.printStackTrace();
        }
        if (check) {
            try {
                this.setClientButtons(false);
                this.updateOutList();
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.out = null;
    }

    private SelectQuery getCountSQ(Criteria c, ArrayList tableNames) {
        SelectQueryImpl sq = null;
        try {
            Column countColumn = Column.getColumn(null, (String)"*");
            Criteria crit = new Criteria(Column.getColumn((String)this.resultTableName, (String)"REPORT_GENERATION_ID"), (Object)this.generationId, 0);
            if (c != null) {
                crit = crit.and(c);
            }
            sq = new SelectQueryImpl(Table.getTable((String)this.resultTableName));
            sq.addSelectColumn(countColumn.count());
            sq.setCriteria(crit);
            for (int i = 0; i < tableNames.size(); ++i) {
                String tableName = (String)tableNames.get(i);
                Join join = new Join(Table.getTable((String)this.resultTableName), Table.getTable((String)tableName), new String[]{this.tableKey}, new String[]{this.tableKey}, 2);
                sq.addJoin(join);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    public String getSearchString(String searchString, Integer id) {
        String val = "";
        int index = searchString.indexOf("search" + id + "=");
        if (index != -1) {
            val = searchString.indexOf("&", index) != -1 ? searchString.substring(searchString.indexOf("=", index) + 1, searchString.indexOf("&", index)) : searchString.substring(searchString.indexOf("=", index) + 1);
        }
        return val;
    }

    public void getCustomizedMultipleValues(Hashtable multipleValuesSids) {
        Enumeration e = multipleValuesSids.keys();
        while (e.hasMoreElements()) {
            String guid = (String)e.nextElement();
            Hashtable colVsValues = (Hashtable)multipleValuesSids.get(guid);
            Enumeration e1 = colVsValues.keys();
            while (e1.hasMoreElements()) {
                Integer attributeId = (Integer)e1.nextElement();
                ArrayList values = (ArrayList)colVsValues.get(attributeId);
                colVsValues.put(attributeId, values);
            }
        }
    }

    private Integer getDefaultSortingProp(ArrayList list) {
        Integer id = null;
        for (int i = 0; i < list.size(); ++i) {
            Properties p = (Properties)list.get(i);
            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
            String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
            if (this.reportId == 5 || this.reportId == 14) {
                id = this.getDefaultSortingProp(list, "PASSWORD_EXPIRY_DATE");
                break;
            }
            if (ldapName.equalsIgnoreCase("memberOf") || ldapName.equalsIgnoreCase("member") || ldapName.equalsIgnoreCase("logonHours")) continue;
            id = (Integer)p.get("ATTRIB_ID");
            break;
        }
        return id;
    }

    private Integer getDefaultSortingProp(ArrayList list, String sortColumn) {
        Integer id = null;
        Integer defaultId = null;
        for (int i = 0; i < list.size(); ++i) {
            Properties p = (Properties)list.get(i);
            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
            String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
            id = (Integer)p.get("ATTRIB_ID");
            if (defaultId == null) {
                defaultId = id;
            }
            if (ldapName.equalsIgnoreCase("memberOf") || ldapName.equalsIgnoreCase("member") || ldapName.equalsIgnoreCase("logonHours")) continue;
            if (columnName.equalsIgnoreCase(sortColumn)) break;
            id = defaultId;
        }
        return id;
    }

    private Properties getAttributeProp(Integer attributeId, ArrayList list) {
        Properties p = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Properties)list.get(i)).get("ATTRIB_ID").equals(attributeId)) continue;
            p = (Properties)list.get(i);
        }
        return p;
    }

    public ArrayList getRows(ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria crit) {
        return this.getRows(this.generationId, this.resultTableName, attributeList, attributeProp, ascending, startIndex, numOfObjects, multipleValuesSids, crit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRows(Long generationId, String tableName, ArrayList attributeList, Properties attributeProp, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria crit) {
        Connection connection = null;
        ArrayList resultList = null;
        try {
            int i;
            String table;
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            Table baseTable = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            ArrayList<String> tableNames = new ArrayList<String>();
            boolean relationalTypePresent = false;
            for (int i2 = 0; i2 < attributeList.size(); ++i2) {
                Properties attributeProperties = (Properties)attributeList.get(i2);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(1)) {
                    relationalTypePresent = true;
                    continue;
                }
                table = attributeProperties.getProperty("TABLE_NAME");
                Column column = Column.getColumn((String)table, (String)attributeProperties.getProperty("ATTRIB_COLUMN_NAME"));
                selectColumnList.add(column);
                if (tableNames.contains(table)) continue;
                tableNames.add(table);
            }
            ArrayList onClickTextAttributeList = this.getOnClickTextAttributes();
            for (i = 0; onClickTextAttributeList != null && i < onClickTextAttributeList.size(); ++i) {
                Properties p = (Properties)onClickTextAttributeList.get(i);
                table = p.getProperty("TABLE_NAME");
                String columnName = p.getProperty("ATTRIB_COLUMN_NAME");
                Column column = Column.getColumn((String)table, (String)columnName);
                selectColumnList.add(column);
                if (tableNames.contains(table)) continue;
                tableNames.add(table);
            }
            for (i = 0; i < tableNames.size(); ++i) {
                String table2 = (String)tableNames.get(i);
                Join join = new Join(baseTable, Table.getTable((String)table2), new String[]{this.tableKey}, new String[]{this.tableKey}, 1);
                query.addJoin(join);
            }
            query.addSelectColumns(selectColumnList);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)this.tableKey));
            Criteria generationCriteria = new Criteria(Column.getColumn((String)tableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            if (crit != null) {
                generationCriteria = generationCriteria.and(crit);
            }
            query.setCriteria(generationCriteria);
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (attributeProp != null && attributeProp.getProperty("TABLE_NAME") != null) {
                SortColumn sortcolumn = new SortColumn(Column.getColumn((String)attributeProp.getProperty("TABLE_NAME"), (String)attributeProp.getProperty("ATTRIB_COLUMN_NAME")), ascending);
                query.addSortColumn(sortcolumn);
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            DataSet dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList();
            while (dataSet.next()) {
                Hashtable<String, String> resultTable = new Hashtable<String, String>();
                this.fillResult(dataSet, resultTable, attributeList);
                this.fillResult(dataSet, resultTable, onClickTextAttributeList);
                String guid = (String)dataSet.getValue(selectColumnList.size() + 1);
                if (guid != null) {
                    resultTable.put(this.tableKey, guid);
                }
                if (relationalTypePresent) {
                    multipleValuesSids.put(guid, new Hashtable());
                }
                resultList.add(resultTable);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return resultList;
    }

    private void fillResult(DataSet dataSet, Hashtable result, ArrayList attributeList) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(1)) continue;
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                if (dataSet.getValue(columnName) == null) continue;
                Object obj = dataSet.getValue(columnName);
                result.put(attributeId, this.getUICustomizedValues(attributeId, obj));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList getOnClickTextAttributes() {
        if (this.onClickText == null || this.onClickText.equalsIgnoreCase("")) {
            return null;
        }
        ArrayList<Properties> list = new ArrayList<Properties>();
        int from = 0;
        int index = -1;
        while ((index = this.onClickText.indexOf("{", from)) != -1) {
            from = this.onClickText.indexOf("}", index);
            String ids = this.onClickText.substring(index + 1, from);
            StringTokenizer token = new StringTokenizer(ids, ",");
            Properties p = new Properties();
            p.put("ATTRIB_ID", Integer.valueOf(token.nextToken()));
            p.put("TABLE_NAME", token.nextToken());
            p.put("ATTRIB_COLUMN_NAME", token.nextToken());
            p.put("RELATIONAL_TYPE", (Object)0);
            list.add(p);
        }
        return list;
    }

    public void deleteResult(String tableName, long time) {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"LAST_LOGON_TIME"), (Object)time, 5);
            crit = crit.and(new Criteria(Column.getColumn((String)this.resultTableName, (String)"REPORT_GENERATION_ID"), (Object)this.generationId, 0));
            sq.setCriteria(crit);
            Join join = new Join(Table.getTable((String)tableName), Table.getTable((String)this.resultTableName), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            sq.addJoin(join);
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            ArrayList<Object> l = new ArrayList<Object>();
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                l.add(r.get("OBJECT_GUID"));
            }
            if (l.size() > 0) {
                String[] guids = new String[l.size()];
                for (int i = 0; i < l.size(); ++i) {
                    guids[i] = (String)l.get(i);
                }
                Criteria c = new Criteria(Column.getColumn((String)this.resultTableName, (String)"OBJECT_GUID"), (Object)guids, 8);
                c = c.and(new Criteria(Column.getColumn((String)this.resultTableName, (String)"REPORT_GENERATION_ID"), (Object)this.generationId, 0));
                CommonUtil.getPersistenceLite().delete(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void executeTask(ArrayList containerList, Hashtable dnDomainNameMap, ArrayList inputParams, String query, String base_dn) {
        try {
            reportLogger.log(Level.INFO, "Execute Task Started ");
            this.ldapQuery = query;
            this.isCompleted = false;
            this.desc = "Report generated for the domain(s) " + dnDomainNameMap.get(containerList.get(0));
            this.generationId = ObjectUpdateHandler.addReportGenerationDetails(this.reportId, this.desc, this.loginId);
            Action action = new Action(1L, containerList, this.getAttributeList(), this, dnDomainNameMap, this.ldapQuery, base_dn);
            action.start();
            if (this.ldapQuery == null) {
                while (!this.isCompleted) {
                    try {
                        Thread.sleep(200L);
                        if (this.reportId != 503) continue;
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.reportId == 503) {
                int gpoRowsCount = DirectoryObjectAPI.getInstance().getObjectRowsCount(containerList, dnDomainNameMap, "groupPolicyContainer");
                if (gpoRowsCount > 0) {
                    GPOManagementListener.getInstance().addGPONameInQueue((String)dnDomainNameMap.get(containerList.get(0)));
                    GPOAlertProfileListener.getInstance().CreateDefaultAlertProfile((String)dnDomainNameMap.get(containerList.get(0)));
                }
            } else if (this.reportId == 210) {
                EventDataUtil.updateTerminalServerDetails(this.domainName, null);
                ProcessObject.updateExchangeServerDetails(this.domainName);
            }
            ObjectUpdateHandler.updateReportGenerationDetails(this.generationId, 1, this.desc, this.loginId);
            reportLogger.log(Level.INFO, "Execute Task Completed ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Integer getResultCount() {
        if (this.errorMessage != null) {
            return -1;
        }
        return ObjectUpdateHandler.getSIDReportCount(this.generationId, this.resultTableName);
    }

    public ArrayList getReportAttributeList() {
        ArrayList<Object> attributeList = new ArrayList<Object>();
        ArrayList tableNames = ObjectAttributeHandler.getInstance().getTableNames(this.reportId);
        for (int i = 0; i < tableNames.size(); ++i) {
            ArrayList l = ObjectAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), this.reportId);
            for (int j = 0; j < l.size(); ++j) {
                Properties p = (Properties)l.get(j);
                attributeList.add(p.get("ATTRIB_LDAP_NAME"));
            }
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getModifyRows(Long id, String tableName, ArrayList attributeList, Column sortColumn, boolean ascending, int startIndex, int numOfObjects, Hashtable multipleValuesSids, Criteria crit) {
        Connection connection = null;
        ArrayList resultList = null;
        try {
            int i;
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            Table baseTable = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            ArrayList<String> tableNames = new ArrayList<String>();
            boolean relationalTypePresent = false;
            for (i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(1)) {
                    relationalTypePresent = true;
                    continue;
                }
                String table = attributeProperties.getProperty("TABLE_NAME");
                Column column = Column.getColumn((String)table, (String)attributeProperties.getProperty("ATTRIB_COLUMN_NAME"));
                selectColumnList.add(column);
                if (tableNames.contains(table)) continue;
                tableNames.add(table);
            }
            for (i = 0; i < tableNames.size(); ++i) {
                String table = (String)tableNames.get(i);
                Join join = new Join(baseTable, Table.getTable((String)table), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                query.addJoin(join);
            }
            query.addSelectColumns(selectColumnList);
            query.addSelectColumn(Column.getColumn((String)this.baseTableName, (String)"OBJECT_GUID"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"MESSAGE"));
            Criteria generationCriteria = new Criteria(Column.getColumn((String)tableName, (String)"REPORT_GENERATION_ID"), (Object)id, 0);
            if (crit != null) {
                generationCriteria = generationCriteria.and(crit);
            }
            query.setCriteria(generationCriteria);
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (sortColumn != null) {
                SortColumn sort = new SortColumn(sortColumn, ascending);
                query.addSortColumn(sort);
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            reportLogger.log(Level.INFO, "QUERY : " + query);
            DataSet dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList();
            while (dataSet.next()) {
                Hashtable<Object, String> resultTable = new Hashtable<Object, String>();
                for (int i2 = 0; i2 < attributeList.size(); ++i2) {
                    Properties attributeProperties = (Properties)attributeList.get(i2);
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    if (relationalType.equals(1)) {
                        relationalTypePresent = true;
                        continue;
                    }
                    String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                    if (dataSet.getValue(columnName) == null) continue;
                    Object obj = dataSet.getValue(columnName);
                    resultTable.put(attributeId, this.getUICustomizedValues(attributeId, obj));
                }
                String guid = (String)dataSet.getValue(selectColumnList.size() + 1);
                String message = (String)dataSet.getValue(selectColumnList.size() + 2);
                if (guid != null) {
                    resultTable.put("OBJECT_GUID", guid);
                }
                if (message != null) {
                    resultTable.put("MESSAGE", message);
                }
                if (relationalTypePresent) {
                    multipleValuesSids.put(guid, new Hashtable());
                }
                resultList.add(resultTable);
            }
            reportLogger.log(Level.INFO, "LIST : " + resultList);
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return resultList;
    }

    @Override
    public void exportReport(int reportId, Long loginId, Long generationId, ObjectUpdateTask listener, boolean zip, Long schedule_id, String dir) {
    }

    public class Action
    extends Thread {
        private ArrayList containerList = null;
        private ArrayList attributeList = null;
        private NativeListener listener = null;
        private Hashtable dnDomainNameMap = null;
        private Long loginId = null;
        private String query = null;
        private String base_dn = null;

        public Action(Long loginId, ArrayList list, ArrayList attributeList, NativeListener li, Hashtable map, String query, String base_dn) {
            this.loginId = loginId;
            this.containerList = list;
            this.attributeList = attributeList;
            this.listener = li;
            this.dnDomainNameMap = map;
            this.query = query;
            this.base_dn = base_dn;
        }

        @Override
        public void run() {
            ObjectListener.this.errorMessage = null;
            ObjectListener.this.guidList = new ArrayList();
            ObjectListener.this.updatedCount = 0;
            Hashtable tableProps = ObjectListener.this.getQueueProps();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    ObjectListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    ObjectListener.this.queue.registerForUpdation(ObjectListener.this.baseTableName, ObjectListener.this.generationId, tableProps);
                    reportLogger.log(Level.INFO, "Getting the Empty Groups from the domain " + ObjectListener.this.domainName);
                    if (this.query == null) {
                        ObjectListener.this.doAction(ObjectListener.this.domainName, this.loginId, dn, this.attributeList, this.listener);
                    } else {
                        ADHandler.getObjects(ObjectListener.this.domainName, this.loginId, this.base_dn, this.attributeList, this.query, this.listener);
                    }
                    ObjectListener.this.updateQueue();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ObjectListener.this.errorMessage = e.getMessage();
                    break;
                }
            }
            reportLogger.log(Level.INFO, "Completed the Reports Count : " + ObjectListener.this.totalCount);
            ObjectListener.this.updatedCount = 0;
            ObjectListener.this.totalCount = 0;
            ObjectListener.this.completedAction();
        }
    }
}

