/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AudMonitorCriteriaHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateTask;
import com.adventnet.sym.adsm.common.server.sql.RecordWriter;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectUpdateHandler {
    private static ObjectUpdateTask taskListener = null;
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static DataObject getReports() {
        DataObject dataObj = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMReports"));
            Column id = Column.getColumn((String)"ADSMReports", (String)"REPORT_ID");
            Column name = Column.getColumn((String)"ADSMReports", (String)"REPORT_NAME");
            Column categoryId = Column.getColumn((String)"ADSMReports", (String)"REPORT_CATEGORY_ID");
            Column description = Column.getColumn((String)"ADSMReports", (String)"DESCRIPTION");
            ArrayList<Column> l = new ArrayList<Column>();
            l.add(id);
            l.add(name);
            l.add(categoryId);
            l.add(description);
            query.addSelectColumns(l);
            Column col = Column.getColumn((String)"ADSMReports", (String)"PRIORITY");
            SortColumn sort = new SortColumn(col, true);
            query.addSortColumn(sort);
            Column status = Column.getColumn((String)"ADSMReports", (String)"STATUS");
            Criteria crit = new Criteria(status, (Object)1L, 0);
            query.setCriteria(crit);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static DataObject getReportDetails(Integer reportId) {
        DataObject dataObj = null;
        try {
            Column col = Column.getColumn((String)"ADSMReports", (String)"REPORT_ID");
            Criteria criteria = new Criteria(col, (Object)reportId, 0);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMReports", criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static void addConsolidatedReport(Long loginId, Integer reportId, String propertyName, String resultTableName) {
        try {
            ArrayList generationIdList = new ArrayList();
            Long newGenerationId = ObjectUpdateHandler.addReportGenerationDetails(reportId, 1L, rb.getString("adap.ObjectUpdateHandler.Report_Generated_at_6_AM"), 1L);
            Long[] generationIds = new Long[generationIdList.size()];
            for (int i = 0; i < generationIdList.size(); ++i) {
                generationIds[i] = (Long)generationIdList.get(i);
            }
            Column col = Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID");
            Criteria criteria = new Criteria(col, (Object)generationIds, 8);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(resultTableName, criteria);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Iterator it = dataObj.getRows(resultTableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String guid = (String)r.get("OBJECT_GUID");
                Row row = new Row(resultTableName);
                row.set("REPORT_GENERATION_ID", (Object)newGenerationId);
                row.set("OBJECT_GUID", (Object)guid);
                obj.addRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).add(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Row getGeneratedReportDetails(Long generationId, Long loginId) {
        Row desc = null;
        try {
            Column col = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID");
            Criteria criteria = new Criteria(col, (Object)generationId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMObjectGenerationDetails", criteria);
            desc = dataObj.getRow("ADSMObjectGenerationDetails");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return desc;
    }

    public static void updateGeneratedReportDetails(Long generationId, String description, Long loginId) {
        try {
            Column col = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID");
            Criteria criteria = new Criteria(col, (Object)generationId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMObjectGenerationDetails", criteria);
            Row desc = dataObj.getRow("ADSMObjectGenerationDetails");
            desc.set("DESCRIPTION", (Object)description);
            desc.set("LOGIN_ID", (Object)loginId);
            dataObj.updateRow(desc);
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long addReportGenerationDetails(Integer reportId, String desc, Long loginId) {
        return ObjectUpdateHandler.addReportGenerationDetails(reportId, 0L, desc, loginId);
    }

    public static Long addReportGenerationDetails(Integer reportId, Long status, String desc, Long loginId) {
        Long ret = null;
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("ADSMObjectGenerationDetails");
            r.set("LOGIN_ID", (Object)loginId);
            r.set("REPORT_ID", (Object)reportId);
            r.set("CREATION_TIME", (Object)System.currentTimeMillis());
            r.set("STATUS", (Object)status);
            r.set("REPORT_GENERATION_NAME", (Object)new Date().toString());
            r.set("DESCRIPTION", (Object)desc);
            dataObj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            ret = (Long)r.get("REPORT_GENERATION_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void updateReportGenerationDetails(Long generationId, int status, String desc, Long loginId) {
        try {
            Column col = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID");
            Criteria criteria = new Criteria(col, (Object)generationId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMObjectGenerationDetails", criteria);
            Row r = dataObj.getRow("ADSMObjectGenerationDetails");
            r.set("STATUS", (Object)status);
            r.set("DESCRIPTION", (Object)desc);
            r.set("LOGIN_ID", (Object)loginId);
            dataObj.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long getRecentlyGeneratedReports(Integer reportId, Long loginId) {
        Long ret = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMObjectGenerationDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID"));
            Column col = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_ID");
            Criteria criteria = new Criteria(col, (Object)reportId, 0);
            Column col1 = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"LOGIN_ID");
            criteria = criteria.and(new Criteria(col1, (Object)loginId, 0));
            Column column = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"CREATION_TIME");
            SortColumn sortCol = new SortColumn(column, false);
            sq.addSortColumn(sortCol);
            sq.setCriteria(criteria);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getRow("ADSMObjectGenerationDetails");
                ret = (Long)r.get("REPORT_GENERATION_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void addSIDReportResult(Long generationId, String resultTableName, ArrayList guids) {
        RecordWriter writer = new RecordWriter(resultTableName);
        writer.writeData(generationId, guids);
        writer.flush();
    }

    public static void checkAndAddSIDReportResult(Long generationId, String resultTableName, ArrayList guids) {
        DataObject dataObject = null;
        Object connection = null;
        try {
            String[] objectIds = new String[guids.size()];
            for (int i = 0; i < guids.size(); ++i) {
                objectIds[i] = (String)guids.get(i);
            }
            Criteria crit = new Criteria(Column.getColumn((String)resultTableName, (String)"OBJECT_GUID"), (Object)objectIds, 8);
            Criteria c = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            c = c.and(crit);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get(resultTableName, c);
            for (int j = 0; j < guids.size(); ++j) {
                String guid = (String)guids.get(j);
                Row r = dataObject.getRow(resultTableName, new Criteria(Column.getColumn((String)resultTableName, (String)"OBJECT_GUID"), (Object)guid, 0));
                if (r != null) continue;
                Row row = new Row(resultTableName);
                row.set("REPORT_GENERATION_ID", (Object)generationId);
                row.set("OBJECT_GUID", (Object)guid);
                dataObject.addRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(" Error while updating the SID Report Result : " + e.getMessage());
        }
    }

    public static void updateSIDMessage(String resultTableName, Long generationId, String guid, String message) {
        try {
            UpdateQueryImpl query = new UpdateQueryImpl(resultTableName);
            Criteria crit = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)resultTableName, (String)"OBJECT_GUID"), (Object)guid, 0));
            query.setCriteria(crit);
            query.setUpdateColumn("MESSAGE", (Object)message);
            CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getMultipleValues(ArrayList attributeList, Hashtable multipleValuesSids) {
        ObjectUpdateHandler.getMultipleValues(attributeList, multipleValuesSids, "OBJECT_GUID");
    }

    public static void getMultipleValues(ArrayList attributeList, Hashtable multipleValuesSids, String tableKey) {
        try {
            ArrayList<String> checkList = new ArrayList<String>();
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProp = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProp.get("RELATIONAL_TYPE");
                if (relationalType.equals(0)) continue;
                String tableName = attributeProp.getProperty("TABLE_NAME");
                String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProp.get("ATTRIB_ID");
                if (checkList.contains(tableName)) continue;
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
                String[] guids = new String[multipleValuesSids.size()];
                int j = 0;
                Enumeration e = multipleValuesSids.keys();
                while (e.hasMoreElements()) {
                    guids[j] = (String)e.nextElement();
                    ++j;
                }
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)tableKey), (Object)guids, 8);
                sq.setCriteria(crit);
                sq.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows(tableName);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        String s = (String)r.get(tableKey);
                        ArrayList tableValues = ObjectUpdateHandler.getTableAttributes(attributeList, tableName);
                        Hashtable attributeIds = (Hashtable)multipleValuesSids.get(s);
                        for (int k = 0; k < tableValues.size(); ++k) {
                            Properties props = (Properties)tableValues.get(k);
                            ArrayList<Object> values = (ArrayList<Object>)attributeIds.get((Integer)props.get("ATTRIB_ID"));
                            if (values == null) {
                                values = new ArrayList<Object>();
                                attributeIds.put((Integer)props.get("ATTRIB_ID"), values);
                            }
                            values.add(r.get((String)props.get("COLUMN_NAME")));
                        }
                    }
                }
                checkList.add(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getTableAttributes(ArrayList attributeList, String tableName) {
        ArrayList<Properties> tableValues = new ArrayList<Properties>();
        try {
            String baseTable = "ADSMAttributeDetails";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)baseTable));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"*"));
            sq.setCriteria(new Criteria(Column.getColumn((String)baseTable, (String)"TABLE_NAME"), (Object)tableName, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows(baseTable);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Properties p = new Properties();
                    p.put("ATTRIB_ID", (Integer)r.get("ATTRIB_ID"));
                    p.put("COLUMN_NAME", (String)r.get("ATTRIB_COLUMN_NAME"));
                    tableValues.add(p);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableValues;
    }

    public static Integer getSIDReportCount(Long generationId, String resultTableName) {
        return ObjectUpdateHandler.getSIDReportCount(generationId, resultTableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getSIDReportCount(Long generationId, String resultTableName, Criteria c) {
        Connection connection = null;
        Integer ret = null;
        try {
            Column countColumn = Column.getColumn(null, (String)"*");
            Criteria crit = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            if (c != null) {
                crit = crit.and(c);
            }
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)resultTableName));
            sq.addSelectColumn(countColumn.count());
            sq.setCriteria(crit);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            DataSet dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                ret = (Integer)dataSet.getValue(1);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getCount(SelectQuery sq) {
        Connection connection = null;
        Integer ret = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            DataSet dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                ret = (Integer)dataSet.getValue(1);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return ret;
    }

    public static void updateResultCount(String domainName, String propertyName, Integer count) {
        ObjectUpdateHandler.updateResultCount(domainName, propertyName, count, null);
    }

    public static void updateResultCount(String domainName, String propertyName, Integer count, Long generationId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            c = c.and(new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)"PROPERTY_NAME"), (Object)propertyName, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMHomeProps", c);
            Row r = new Row("ADSMHomeProps");
            r.set("LOGIN_ID", (Object)1L);
            r.set("DOMAIN_NAME", (Object)domainName);
            r.set("PROPERTY_NAME", (Object)propertyName);
            r.set("RESULT_COUNT", (Object)count);
            if (generationId != null) {
                r.set("REPORT_GENERATION_ID", (Object)generationId);
            }
            if (!obj.isEmpty()) {
                obj.updateRow(r);
            } else {
                obj.addRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runDailyReport(ArrayList reportIds) {
        ObjectUpdateHandler.runDailyReport(null, 1L, reportIds);
    }

    public static void runDailyReport(String domain, Long loginId) {
        long scheduleID = DBObjectUtil.getUVHValues("Schedule", "Schedule:schedule_id:UVH@3472");
        Hashtable getScheduledReportsDetails = SchedulerUtil.getScheduledReportsDetails(scheduleID);
        ArrayList reportIDS = (ArrayList)getScheduledReportsDetails.get("reportIDS");
        ObjectUpdateHandler.runDailyReport(domain, loginId, reportIDS, false, null, null, null, null, null);
    }

    public static void runDailyReport(String domain, Long loginId, ArrayList reportIds) {
        ObjectUpdateHandler.runDailyReport(domain, loginId, reportIds, false, null, null, null, null, null);
    }

    public static void runSelectedReport(String domain, Long loginId, int[] reportIds) {
        ArrayList report_id = ObjectUpdateHandler.getReportInputs(reportIds);
        ObjectUpdateHandler.runDailyReport(domain, loginId, report_id, true, null, null, null, null, null);
    }

    public static void runSelectedReport(String domain, Long loginId, Hashtable props) {
        int[] selectedUpdates = (int[])props.get("actionList");
        ArrayList report_id = ObjectUpdateHandler.getReportInputs(selectedUpdates);
        ObjectUpdateHandler.runDailyReport(domain, loginId, report_id, false, null, null, null, null, null);
    }

    public static ArrayList getReportInputs(int[] reportIds) {
        ArrayList report_id = new ArrayList();
        for (int i = 0; i < reportIds.length; ++i) {
            if (reportIds[i] == 0) continue;
            Hashtable<String, Number> hash = new Hashtable<String, Number>();
            hash.put("report_id", reportIds[i]);
            hash.put("unique_id", 0L);
            report_id.add(hash);
        }
        return report_id;
    }

    public static Long getGenerationID() {
        return taskListener.getGenerationId();
    }

    public static String getCompleted() {
        return taskListener.queryCompleted();
    }

    public static void setCompleted() {
        if (taskListener != null) {
            taskListener.setQueryCompleted();
        }
    }

    public static void runDailyReport(String domain, Long loginId, ArrayList reportIds, boolean updated, ArrayList mailId, Long schedule_id, String schedule_Name, String ldapQuery, String base_dn) {
        String dir = "";
        try {
            for (int i = 0; i < reportIds.size(); ++i) {
                Long generationId = 0L;
                ArrayList<Long> generationIdList = new ArrayList<Long>();
                Integer reportId = 0;
                if (ldapQuery == null) {
                    Hashtable inputs = (Hashtable)reportIds.get(i);
                    reportId = (Integer)inputs.get("report_id");
                } else {
                    reportId = (Integer)reportIds.get(i);
                }
                if (reportId != 0) {
                    if (reportId == -1) {
                        reportId = 1;
                    }
                    DataObject obj = ObjectUpdateHandler.getReportDetails(reportId);
                    Row r = obj.getFirstRow("ADSMReports");
                    String className = (String)r.get("CLASS_NAME");
                    Class<?> classToInvoke = Class.forName(className.trim());
                    taskListener = (ObjectUpdateTask)classToInvoke.newInstance();
                    taskListener.init(r);
                    Hashtable domains = DomainHandler.getConfiguredDomains();
                    boolean check = false;
                    String reportName = null;
                    String domainName = null;
                    Enumeration e = domains.keys();
                    while (e.hasMoreElements()) {
                        try {
                            String dn = (String)e.nextElement();
                            Properties p = (Properties)domains.get(dn);
                            domainName = p.getProperty("DOMAIN_NAME");
                            if (domain != null && !domain.equalsIgnoreCase(domainName)) continue;
                            ArrayList<String> containerList = new ArrayList<String>();
                            containerList.add(dn);
                            Hashtable<String, String> dnDomainNameMap = new Hashtable<String, String>();
                            dnDomainNameMap.put(dn, domainName);
                            ArrayList inputParams = new ArrayList();
                            reportLogger.log(Level.INFO, "Generating the Report for the ID :" + reportId + ", Domain: " + domain + ", Domain :" + domainName + ", inputParams: " + inputParams);
                            taskListener.executeTask(containerList, dnDomainNameMap, inputParams, ldapQuery, base_dn);
                            Integer c = taskListener.getResultCount();
                            reportName = (String)r.get("REPORT_NAME");
                            generationIdList.add(taskListener.getGenerationId());
                            generationId = taskListener.getGenerationId();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    taskListener.shutDownQueue();
                    if (check) {
                        updated = true;
                    }
                    if (loginId.equals(1L)) {
                        ObjectUpdateHandler.addConsolidatedReport(loginId, reportId, (String)r.get("REPORT_NAME"), (String)r.get("RESULT_TABLE_NAME"));
                    }
                    boolean zip = false;
                    if (Integer.valueOf(reportIds.size() - 1).equals(i)) {
                        zip = true;
                    }
                    if (!(schedule_id == null || !Integer.valueOf(reportIds.size() - 1).equals(i) && schedule_Name.equalsIgnoreCase("ADUpdateScheduler") && schedule_Name.equalsIgnoreCase("SignificantReports") && schedule_Name.equalsIgnoreCase("DailyReportScheduler"))) {
                        taskListener.exportReport(reportId, loginId, generationId, taskListener, zip, schedule_id, dir);
                    }
                    reportLogger.log(Level.INFO, "Going to update MonitorCriteria Object");
                    Enumeration e2 = domains.keys();
                    while (e2.hasMoreElements()) {
                        try {
                            String dn = (String)e2.nextElement();
                            Properties p = (Properties)domains.get(dn);
                            reportLogger.log(Level.INFO, "Going to check and update MonitorCriteria object of the domain " + p.getProperty("DOMAIN_NAME"));
                            AudMonitorCriteriaHandler.updateMonitorCriteriaObjects(p.getProperty("DOMAIN_NAME"), reportId);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    reportLogger.log(Level.INFO, "MonitorCriteria Object ends Here");
                }
                if (reportId != 109) continue;
                AlertProfileHandler.scheduleUserNameAlerts();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runReport(String domain, ObjectUpdateTask listener, Integer reportId) {
        try {
            Long generationId = 0L;
            ArrayList<Long> generationIdList = new ArrayList<Long>();
            DataObject obj = ObjectUpdateHandler.getReportDetails(reportId);
            Row r = obj.getFirstRow("ADSMReports");
            listener.init(r);
            Hashtable domains = DomainHandler.getConfiguredDomains();
            String reportName = null;
            String domainName = null;
            Enumeration e = domains.keys();
            while (e.hasMoreElements()) {
                try {
                    String dn = (String)e.nextElement();
                    Properties p = (Properties)domains.get(dn);
                    domainName = p.getProperty("DOMAIN_NAME");
                    if (domain != null && !domain.equalsIgnoreCase(domainName)) continue;
                    ArrayList<String> containerList = new ArrayList<String>();
                    containerList.add(dn);
                    Hashtable<String, String> dnDomainNameMap = new Hashtable<String, String>();
                    dnDomainNameMap.put(dn, domainName);
                    ArrayList inputParams = new ArrayList();
                    reportLogger.log(Level.INFO, "Generating the Report for the ID :" + reportId + ", Domain: " + domain + ", Domain :" + domainName + ", inputParams: " + inputParams);
                    listener.executeTask(containerList, dnDomainNameMap, inputParams, null, null);
                    Integer c = listener.getResultCount();
                    reportName = (String)r.get("REPORT_NAME");
                    generationIdList.add(listener.getGenerationId());
                    generationId = listener.getGenerationId();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            listener.shutDownQueue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long getGenerationId(String propertyName) {
        Long ret = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)"PROPERTY_NAME"), (Object)propertyName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMHomeProps", c);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("ADSMHomeProps");
                ret = (Long)r.get("REPORT_GENERATION_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static ArrayList getInputParams(int reportId, Long unique_id) {
        ArrayList ret = new ArrayList();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMSchedulerValues", (String)"REPORT_VALUE_ID"), (Object)unique_id, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMSchedulerValues", (String)"REPORT_ID"), (Object)reportId, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMSchedulerValues", criteria);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSMSchedulerValues");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String values = (String)r.get("VALUE");
                    Hashtable<String, String> inputs = new Hashtable<String, String>();
                    inputs.put("values", values);
                    ret.add(inputs);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

