/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectUpdateQueue
extends Thread {
    private boolean shutDown = false;
    private ArrayList guidList = null;
    private Hashtable tableRowMap = null;
    private Hashtable relationalTableRowMap = null;
    private Object obj = new Object();
    private int totalCount = 0;
    private Hashtable generationIdPropMap = null;
    private String baseTableName = null;
    protected String tableKey = "OBJECT_GUID";
    public static Logger reportLogger = Logger.getLogger("ReportLogger");

    public ObjectUpdateQueue() {
        reportLogger.log(Level.INFO, "Initialiazing Report Queue");
        this.guidList = new ArrayList();
        this.tableRowMap = new Hashtable();
        this.relationalTableRowMap = new Hashtable();
        this.generationIdPropMap = new Hashtable();
        this.start();
    }

    public boolean isCompleted(Long generationId) {
        if (this.shutDown) {
            if (this.guidList.size() > 0) {
                reportLogger.log(Level.INFO, "BUG : It Should not happen " + this.guidList);
            }
            return true;
        }
        Hashtable genProp = (Hashtable)this.generationIdPropMap.get(generationId);
        ArrayList guids = (ArrayList)genProp.get("guids");
        if (guids != null && guids.size() > 0) {
            return false;
        }
        return !genProp.get("isCompleted").equals("false");
    }

    public void shutDown() {
        this.shutDown = true;
    }

    public void setProps(Long generationId, Hashtable props) {
        Hashtable genProp;
        this.baseTableName = (String)props.get("baseTableName");
        if (props.get("tableKey") != null) {
            this.tableKey = (String)props.get("tableKey");
        }
        if ((genProp = (Hashtable)this.generationIdPropMap.get(generationId)) == null) {
            genProp = new Hashtable();
        }
        genProp.put("resultTableName", props.get("resultTableName"));
        genProp.put("resultHandling", props.get("resultHandling"));
        genProp.put("isCompleted", "true");
        this.generationIdPropMap.put(generationId, genProp);
    }

    public synchronized void waitForUpdate(long t) {
        try {
            super.wait(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUpdateResult(Long generationId) {
        Hashtable genProp = (Hashtable)this.generationIdPropMap.get(generationId);
        genProp.put("updateResult", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToQueue(Long generationId, String guid, Hashtable map, Hashtable relationalMap) {
        Object object = this.obj;
        synchronized (object) {
            if (!this.guidList.contains(guid)) {
                this.guidList.add(guid);
            }
            this.addToQueue(map, this.tableRowMap);
            this.addToQueue(relationalMap, this.relationalTableRowMap);
            Hashtable genProp = (Hashtable)this.generationIdPropMap.get(generationId);
            ArrayList<String> guids = (ArrayList<String>)genProp.get("guids");
            genProp.put("isCompleted", "false");
            if (guids == null) {
                guids = new ArrayList<String>();
            }
            guids.add(guid);
            genProp.put("guids", guids);
            if (this.guidList.size() >= 500) {
                this.notifyAll();
            }
        }
    }

    private void addToQueue(Hashtable map, Hashtable tableRowMap) {
        Enumeration enumeration = map.keys();
        while (enumeration.hasMoreElements()) {
            String tableName = (String)enumeration.nextElement();
            ArrayList source = (ArrayList)map.get(tableName);
            ArrayList destination = (ArrayList)tableRowMap.get(tableName);
            if (destination == null) {
                destination = new ArrayList();
                tableRowMap.put(tableName, destination);
            }
            destination.addAll(source);
        }
    }

    public void checkForNextUpdate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            ArrayList l = null;
            Hashtable h = null;
            Hashtable relMap = null;
            Hashtable<Long, ArrayList> genGuidMap = new Hashtable<Long, ArrayList>();
            Object object = this.obj;
            synchronized (object) {
                if (this.guidList.size() == 0) {
                    return;
                }
                l = this.guidList;
                h = this.tableRowMap;
                relMap = this.relationalTableRowMap;
                this.guidList = new ArrayList();
                this.tableRowMap = new Hashtable();
                this.relationalTableRowMap = new Hashtable();
                Enumeration e = this.generationIdPropMap.keys();
                while (e.hasMoreElements()) {
                    Long generationId = (Long)e.nextElement();
                    Hashtable genProp = (Hashtable)this.generationIdPropMap.get(generationId);
                    ArrayList guidList = (ArrayList)genProp.remove("guids");
                    if (guidList == null) continue;
                    genGuidMap.put(generationId, guidList);
                }
            }
            this.totalCount += l.size();
            DBObjectUtil.addOrUpdate(this.baseTableName, this.tableKey, l, h, relMap);
            this.processResult(genGuidMap);
            reportLogger.log(Level.INFO, "Completing the Updation with the total count of " + this.totalCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processResult(Hashtable genGuidMap) {
        Enumeration e = genGuidMap.keys();
        while (e.hasMoreElements()) {
            Long generationId = (Long)e.nextElement();
            ArrayList guidList = (ArrayList)genGuidMap.get(generationId);
            if (guidList == null) continue;
            this.updateResult(generationId, guidList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateResult(Long generationId, ArrayList guids) {
        Hashtable genProp = (Hashtable)this.generationIdPropMap.get(generationId);
        String resultTableName = (String)genProp.get("resultTableName");
        String resultHandling = (String)genProp.get("resultHandling");
        if (resultHandling.equalsIgnoreCase("add")) {
            ObjectUpdateHandler.addSIDReportResult(generationId, resultTableName, guids);
        } else if (resultHandling.equalsIgnoreCase("addOrUpdate")) {
            ObjectUpdateHandler.checkAndAddSIDReportResult(generationId, resultTableName, guids);
        }
        Object object = this.obj;
        synchronized (object) {
            ArrayList guidList = (ArrayList)genProp.get("guids");
            if (guidList == null || guidList.size() == 0) {
                genProp.put("isCompleted", "true");
            }
        }
    }

    public void checkAndProcess() {
        this.waitForUpdate(300L);
        this.process();
    }

    @Override
    public void run() {
        try {
            while (!this.shutDown) {
                this.checkAndProcess();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

