/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.WellKnownSIDsHandler;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.ComputerFromSIDListener;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.GroupFromSIDListener;
import com.adventnet.sym.adsm.common.server.objects.ObjectAttributeHandler;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.objects.UserAccountControl;
import com.adventnet.sym.adsm.common.server.objects.UserFromSIDListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class ObjectUpdateUtil {
    protected static Logger reportLogger = Logger.getLogger("ReportLogger");
    public static final int ADS_GROUP_TYPE_GLOBAL_GROUP = 2;
    public static final int ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP = 4;
    public static final int ADS_GROUP_TYPE_LOCAL_GROUP = 4;
    public static final int ADS_GROUP_TYPE_UNIVERSAL_GROUP = 8;
    public static final int ADS_GROUP_TYPE_SECURITY_ENABLED = Integer.MIN_VALUE;

    public static void updateObjectFromSID(String domainName, String sid, String objClassName) throws Exception {
        reportLogger.log(Level.INFO, "For domain [{0}], Updating [{1}] with SID [{2}]", new Object[]{domainName, objClassName, sid});
        if (objClassName.equalsIgnoreCase("user")) {
            UserFromSIDListener listener = new UserFromSIDListener(sid);
            ObjectUpdateHandler.runReport(domainName, listener, 16);
            while (!listener.isListenerCompleted()) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (objClassName.equalsIgnoreCase("computer")) {
            ComputerFromSIDListener listener = new ComputerFromSIDListener(sid);
            ObjectUpdateHandler.runReport(domainName, listener, 211);
            while (!listener.isListenerCompleted()) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (objClassName.equalsIgnoreCase("group")) {
            GroupFromSIDListener listener = new GroupFromSIDListener(sid);
            ObjectUpdateHandler.runReport(domainName, listener, 110);
            while (!listener.isListenerCompleted()) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (objClassName.equalsIgnoreCase("foreignSecurityPrincipal")) {
            WellKnownSIDsHandler.addWellKnownSIDs(domainName);
        }
    }

    public static Properties getObjectFromGuid(String domainName, String guid, String dcName) {
        Properties objectProps = null;
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("dc");
        attributeList.add("cn");
        attributeList.add("canonicalName");
        attributeList.add("distinguishedName");
        try {
            if (guid.indexOf("{") != -1) {
                guid = guid.substring(guid.indexOf("{") + 1, guid.lastIndexOf("}"));
            }
            objectProps = ADHandler.getObjectFromGUID(domainName, 1L, guid, attributeList, dcName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectProps;
    }

    public static void updateObjectFromGUID(String domainName, String guid, ObjectClass object, String dcName, Boolean isNeedUpdate) {
        try {
            if (object != null) {
                Integer reportId = object.getReportId();
                ArrayList arrayList = ObjectAttributeHandler.getInstance().getTotalColumn(reportId);
                ArrayList<String> attributeList = new ArrayList<String>();
                for (Object object2 : arrayList) {
                    Properties properties = (Properties)object2;
                    attributeList.add(properties.getProperty("ATTRIB_LDAP_NAME"));
                }
                if (guid.indexOf("{") != -1) {
                    guid = guid.substring(guid.indexOf("{") + 1, guid.lastIndexOf("}"));
                    reportLogger.log(Level.INFO, "trimmed guid for [{0}] is [{1}] : ", new Object[]{object.getObjectClass(), guid});
                    reportLogger.log(Level.INFO, "attributeList to fetch is [{0}] ", new Object[]{attributeList});
                    Properties objectProps = ADHandler.getObjectFromGUID(domainName, 1L, guid, attributeList, dcName);
                    ArrayList list = (ArrayList)objectProps.remove("objectSid");
                    if (list != null) {
                        objectProps.put("objectSID", list);
                    }
                    reportLogger.log(Level.INFO, "Properties of Objects From GUID [{0}]", new Object[]{objectProps});
                    ObjectUpdateUtil.updateObjects(reportId, objectProps, domainName, isNeedUpdate);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateObjects(Integer reportId, Properties prop, String domainName, Boolean isNeedUpdate) {
        try {
            String guid = ObjectUpdateUtil.getGuid(prop);
            DataObject obj = ObjectUpdateHandler.getReportDetails(reportId);
            Row reportRow = obj.getFirstRow("ADSMReports");
            String baseTableName = (String)reportRow.get("BASE_TABLE_NAME");
            String resultTableName = (String)reportRow.get("RESULT_TABLE_NAME");
            reportLogger.log(Level.INFO, "ReportRow [{0}]", new Object[]{reportRow});
            Row r = null;
            Integer relationalType = null;
            ArrayList multipleTableRowList = new ArrayList();
            ArrayList attributeList = ObjectAttributeHandler.getInstance().getTotalColumn(reportId);
            reportLogger.log(Level.INFO, "AttributeList [{0}]", new Object[]{attributeList});
            for (int j = 0; j < attributeList.size(); ++j) {
                Properties p = (Properties)attributeList.get(j);
                String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
                String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)p.get("ATTRIB_ID");
                relationalType = (Integer)p.get("RELATIONAL_TYPE");
                ArrayList values = (ArrayList)prop.get(ldapName);
                if (!relationalType.equals(0)) continue;
                values = ObjectUpdateUtil.getDBCustomizedValues(domainName, columnName, ldapName, prop);
                reportLogger.log(Level.INFO, "DB Customised values [{0}]", new Object[]{values});
                if (r == null) {
                    r = new Row(baseTableName);
                }
                if (values != null && !values.isEmpty()) {
                    r.set(columnName, values.get(0));
                    continue;
                }
                r.set(columnName, (Object)"-");
            }
            reportLogger.log(Level.INFO, "Object Row [{0}]", new Object[]{r});
            if (r != null) {
                r.set("OBJECT_GUID", (Object)guid);
                Criteria crit = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_GUID"), (Object)guid, 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(baseTableName, crit);
                if (dataObj.isEmpty()) {
                    CommonUtil.addOrUpdateRow("OBJECT_GUID", guid, r, baseTableName);
                } else if (isNeedUpdate.booleanValue()) {
                    UpdateQueryImpl query = new UpdateQueryImpl(baseTableName);
                    query.setCriteria(crit);
                    query.setUpdateColumn("VERSION", r.get("VERSION"));
                    CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)query);
                }
            }
        }
        catch (Exception e) {
            reportLogger.log(Level.INFO, prop.toString());
            e.printStackTrace();
        }
    }

    protected static String getGuid(Properties prop) {
        ArrayList guids = (ArrayList)prop.get("objectGUID");
        if (guids == null) {
            guids = (ArrayList)prop.get("objectGuid");
        }
        if (guids == null) {
            reportLogger.log(Level.INFO, prop.toString());
            return null;
        }
        String guid = (String)guids.get(0);
        return guid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList getDBCustomizedValues(String domainName, String columnName, String ldapName, Properties prop) {
        ArrayList values = (ArrayList)prop.get(ldapName);
        ArrayList ret = new ArrayList();
        if (values == null || values.size() == 0) {
            if (columnName.equalsIgnoreCase("WHEN_CREATED") || columnName.equalsIgnoreCase("WHEN_CHANGED") || columnName.equalsIgnoreCase("LAST_LOGON_TIME") || columnName.equalsIgnoreCase("LAST_LOGOFF_TIME") || columnName.equalsIgnoreCase("BAD_PASSWORD_TIME") || columnName.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") || columnName.equalsIgnoreCase("ACCOUNT_LOCK_ON_TIME") || columnName.equalsIgnoreCase("CHANGED_ON") || columnName.equalsIgnoreCase("CREATED_ON") || columnName.equalsIgnoreCase("CREATION_TIME") || columnName.equalsIgnoreCase("MODIFIED_TIME") || columnName.equalsIgnoreCase("LOCK_OUT_TIME") || columnName.equalsIgnoreCase("LOGON_COUNT")) {
                ret.add(0L);
                return ret;
            }
            if (!columnName.equalsIgnoreCase("DOMAIN_NAME")) return null;
            ret.add(domainName);
            return ret;
        }
        if (ldapName.equalsIgnoreCase("objectclass") || ldapName.equalsIgnoreCase("directReports")) {
            ret.add(values.get(values.size() - 1));
            return ret;
        }
        if (columnName.equalsIgnoreCase("ACCOUNT_STATUS") || columnName.equalsIgnoreCase("COMPUTER_STATUS")) {
            Integer obj = Integer.valueOf((String)values.get(0));
            int val = obj;
            ret.add(UserAccountControl.getAccountStatus(val));
            return ret;
        }
        if (columnName.equalsIgnoreCase("TRUSTED_FOR_DELEGATION")) {
            Integer obj = Integer.valueOf((String)values.get(0));
            int val = obj;
            ret.add(UserAccountControl.delegationTrust(val));
            return ret;
        }
        if (columnName.equalsIgnoreCase("Role")) {
            Integer obj = Integer.valueOf((String)values.get(0));
            int val = obj;
            if ((val & 0x4000000) == 0x4000000) {
                ret.add("Read-only DomainController");
                return ret;
            } else if ((val & 0x1000) == 4096) {
                ret.add("WorkStation or Server");
                return ret;
            } else {
                ret.add("DomainController");
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("GROUP_TYPE")) {
            String bitwtype = (String)values.get(0);
            int bitopt = Integer.parseInt(bitwtype);
            if ((bitopt & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                ret.add("Security");
                return ret;
            } else {
                ret.add("Distribution");
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("GROUP_SCOPE")) {
            String bitws = (String)values.get(0);
            int bitops = Integer.parseInt(bitws);
            if ((bitops & 2) == 2) {
                ret.add("Global");
                return ret;
            } else if ((bitops & 4) == 4) {
                ret.add("Domain Local");
                return ret;
            } else {
                if ((bitops & 8) != 8) return ret;
                ret.add("Universal");
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("DOMAIN_NAME")) {
            ret.add(domainName);
            return ret;
        }
        if (columnName.equalsIgnoreCase("OU_NAME")) {
            String ouName = ObjectAttributeHandler.getInstance().getOUName(domainName, (String)values.get(0));
            if (ouName != null && !ouName.equals("")) {
                ret.add(ouName);
                return ret;
            } else {
                ret.add("-");
            }
            return ret;
        }
        if (columnName.equalsIgnoreCase("WHEN_CREATED") || columnName.equalsIgnoreCase("WHEN_CHANGED") || columnName.equalsIgnoreCase("LAST_LOGON_TIME") || columnName.equalsIgnoreCase("LAST_LOGOFF_TIME") || columnName.equalsIgnoreCase("BAD_PASSWORD_TIME") || columnName.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") || columnName.equalsIgnoreCase("ACCOUNT_LOCK_ON_TIME") || columnName.equalsIgnoreCase("PASSWORD_LAST_SET") || columnName.equalsIgnoreCase("CHANGED_ON") || columnName.equalsIgnoreCase("CREATED_ON") || columnName.equalsIgnoreCase("MESSAGE_SIZE") || columnName.equalsIgnoreCase("CREATION_TIME") || columnName.equalsIgnoreCase("LAST_ACCESS_TIME") || columnName.equalsIgnoreCase("LAST_WRITE_TIME") || columnName.equalsIgnoreCase("MODIFIED_TIME") || columnName.equalsIgnoreCase("LOCK_OUT_TIME")) {
            long l = System.currentTimeMillis();
            try {
                l = Long.parseLong((String)values.get(0));
                if (columnName.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") && l >= 5223372036854775807L) {
                    l = 0L;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                l = System.currentTimeMillis();
            }
            ret.add(l);
            return ret;
        }
        if (columnName.equalsIgnoreCase("SIZE")) {
            long l = Long.parseLong((String)values.get(0));
            ret.add(l);
            return ret;
        } else if (columnName.equalsIgnoreCase("DAYS_SINCE_PASSWORD_SET")) {
            Long longObj = Long.valueOf((String)values.get(0));
            long noDays = -1L;
            if (longObj != 0L) {
                long l = CommonUtil.getNoOfDays(longObj);
                noDays = l - 1L;
            }
            ret.add(noDays);
            return ret;
        } else if (columnName.equalsIgnoreCase("LOCK_OUT_DURATION") || columnName.equalsIgnoreCase("LOCK_OUT_OBS_WINDOW")) {
            long l = Long.parseLong((String)values.get(0));
            ret.add(Long.valueOf(l /= 600000000L).toString());
            return ret;
        } else if (columnName.equalsIgnoreCase("PWD_PROPS")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            if (integer.equals(0)) {
                ret.add("Disabled");
                return ret;
            } else {
                ret.add("Enabled");
            }
            return ret;
        } else if (columnName.equalsIgnoreCase("COMP_CONFIG")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            if (integer.equals(0)) {
                ret.add("Enabled");
                return ret;
            } else if (integer.equals(1)) {
                ret.add("Enabled");
                return ret;
            } else if (integer.equals(2)) {
                ret.add("Disabled");
                return ret;
            } else if (integer.equals(3)) {
                ret.add("Disabled");
                return ret;
            } else {
                ret.add("Enabled");
            }
            return ret;
        } else if (columnName.equalsIgnoreCase("USER_CONFIG")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            if (integer.equals(0)) {
                ret.add("Enabled");
                return ret;
            } else if (integer.equals(1)) {
                ret.add("Disabled");
                return ret;
            } else if (integer.equals(2)) {
                ret.add("Enabled");
                return ret;
            } else if (integer.equals(3)) {
                ret.add("Disabled");
                return ret;
            } else {
                ret.add("Enabled");
            }
            return ret;
        } else if (columnName.equalsIgnoreCase("USER_VERSION")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            int ver = integer;
            ret.add(ver / 65536);
            return ret;
        } else if (columnName.equalsIgnoreCase("COMPUTER_VERSION")) {
            Integer integer = Integer.parseInt((String)values.get(0));
            int ver = integer;
            ret.add(ver % 65536);
            return ret;
        } else {
            if (ldapName.equalsIgnoreCase("member")) {
                int j = 0;
                while (j < values.size()) {
                    Properties p = (Properties)values.get(j);
                    String cn = p.getProperty("cn");
                    if (columnName.equalsIgnoreCase("MEMBERS")) {
                        String dn = p.getProperty("distinguishedName");
                        String ouName = ObjectAttributeHandler.getInstance().getLocation(domainName, dn);
                        if (ouName != null && !ouName.equals("")) {
                            ret.add(cn + "[" + ouName + "]");
                        } else {
                            ret.add(cn + "[ Users ]");
                        }
                    } else if (columnName.equalsIgnoreCase("DISPLAY_MEMBERS")) {
                        ret.add(cn);
                    } else if (columnName.equalsIgnoreCase("GROUP_MEMBER_OBJECTGUID") || columnName.equalsIgnoreCase("MR_MEMBER_OBJECTGUID")) {
                        String guid = p.getProperty("objectGUID");
                        ret.add(guid);
                    }
                    ++j;
                }
                return ret;
            }
            if (!ldapName.equalsIgnoreCase("memberOf")) return values;
            int j = 0;
            while (j < values.size()) {
                Properties p = (Properties)values.get(j);
                String guid = p.getProperty("objectGUID");
                String cn = p.getProperty("cn");
                if (columnName.equalsIgnoreCase("MEMBER_OF")) {
                    ret.add(cn);
                }
                if (columnName.equalsIgnoreCase("MEMBEROF_LOCATION")) {
                    String dn = p.getProperty("distinguishedName");
                    String ouName = ObjectAttributeHandler.getInstance().getLocation(domainName, dn);
                    if (ouName != null && !ouName.equals("")) {
                        ret.add(cn + "[" + ouName + "]");
                    } else {
                        ret.add(cn + "[ Users ]");
                    }
                } else if (columnName.equalsIgnoreCase("GROUP_OBJECT_GUID") || columnName.equalsIgnoreCase("COMPUTERS_GROUP_GUID") || columnName.equalsIgnoreCase("MAILRECIPIENTS_GROUP_GUID") || columnName.equalsIgnoreCase("GROUP_MEMBEROF_OBJECTGUID") || columnName.equalsIgnoreCase("CONTACTS_GROUP_GUID")) {
                    ret.add(guid);
                }
                ++j;
            }
            return ret;
        }
    }

    public static void updateComputerFromName(String domainName, String name, Boolean isNeedUpdate) {
        try {
            ObjectClass object = DirectoryObjectAPI.getInstance().getObjectClass("computer");
            Integer reportId = object.getReportId();
            ArrayList arrayList = ObjectAttributeHandler.getInstance().getTotalColumn(reportId);
            ArrayList<String> attributeList = new ArrayList<String>();
            for (Object object2 : arrayList) {
                Properties properties = (Properties)object2;
                attributeList.add(properties.getProperty("ATTRIB_LDAP_NAME"));
            }
            String searchString = "(&(objectClass=computer)(|(name=" + name + ")(dNSHostName=" + name + ")))";
            System.out.println("searchString : " + searchString);
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
            System.out.println("attributeList : " + attributeList);
            ArrayList objectsList = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, searchString);
            System.out.println("objectsList : " + objectsList);
            if (objectsList != null && !objectsList.isEmpty()) {
                Properties properties = (Properties)objectsList.get(0);
                ObjectUpdateUtil.updateObjects(reportId, properties, domainName, isNeedUpdate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getRDN(String distinguishedName) {
        String rdnString = null;
        try {
            LdapName ldapName = new LdapName(distinguishedName);
            List<Rdn> rdnList = ldapName.getRdns();
            Rdn rdn = rdnList.get(rdnList.size() - 1);
            rdnString = rdn.getValue().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rdnString;
    }
}

