/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;

public class UserAccountControl {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static final int ADS_UF_SCRIPT = 1;
    public static final int ADS_UF_ACCOUNTDISABLE = 2;
    public static final int ADS_UF_HOMEDIR_REQUIRED = 8;
    public static final int ADS_UF_LOCKOUT = 16;
    public static final int ADS_UF_PASSWD_NOTREQD = 32;
    public static final int ADS_UF_PASSWD_CANT_CHANGE = 64;
    public static final int ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED = 128;
    public static final int ADS_UF_TEMP_DUPLICATE_ACCOUNT = 256;
    public static final int ADS_UF_NORMAL_ACCOUNT = 512;
    public static final int ADS_UF_INTERDOMAIN_TRUST_ACCOUNT = 2048;
    public static final int ADS_UF_WORKSTATION_TRUST_ACCOUNT = 4096;
    public static final int ADS_UF_SERVER_TRUST_ACCOUNT = 8192;
    public static final int ADS_UF_DONT_EXPIRE_PASSWD = 65536;
    public static final int ADS_UF_MNS_LOGON_ACCOUNT = 131072;
    public static final int ADS_UF_SMARTCARD_REQUIRED = 262144;
    public static final int ADS_UF_TRUSTED_FOR_DELEGATION = 524288;
    public static final int ADS_UF_NOT_DELEGATED = 0x100000;
    public static final int ADS_UF_USE_DES_KEY_ONLY = 0x200000;
    public static final int ADS_UF_DONT_REQUIRE_PREAUTH = 0x400000;
    public static final int ADS_UF_PASSWORD_EXPIRED = 0x800000;
    public static final int ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION = 0x1000000;
    public static final int ADS_UF_PARTIAL_SECRETS_ACCOUNT = 0x4000000;
    public static final int[] UAC_FLAGS = new int[]{1, 2, 8, 16, 32, 64, 128, 256, 512, 2048, 4096, 8192, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x4000000};
    public static final String[] UAC_STRINGS = new String[]{rb.getString("adap.UserAccountControl.ADS_UF_SCRIPT"), rb.getString("adap.UserAccountControl.ADS_UF_ACCOUNTDISABLE"), rb.getString("adap.UserAccountControl.ADS_UF_HOMEDIR_REQUIRED"), rb.getString("adap.UserAccountControl.ADS_UF_LOCKOUT"), rb.getString("adap.UserAccountControl.ADS_UF_PASSWD_NOTREQD"), rb.getString("adap.UserAccountControl.ADS_UF_PASSWD_CANT_CHANGE"), rb.getString("adap.UserAccountControl.ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED"), rb.getString("adap.UserAccountControl.ADS_UF_TEMP_DUPLICATE_ACCOUNT"), rb.getString("adap.UserAccountControl.ADS_UF_NORMAL_ACCOUNT"), rb.getString("adap.UserAccountControl.ADS_UF_INTERDOMAIN_TRUST_ACCOUNT"), rb.getString("adap.UserAccountControl.ADS_UF_WORKSTATION_TRUST_ACCOUNT"), rb.getString("adap.UserAccountControl.ADS_UF_SERVER_TRUST_ACCOUNT"), rb.getString("adap.UserAccountControl.ADS_UF_DONT_EXPIRE_PASSWD"), rb.getString("adap.UserAccountControl.ADS_UF_MNS_LOGON_ACCOUNT"), rb.getString("adap.UserAccountControl.ADS_UF_SMARTCARD_REQUIRED"), rb.getString("adap.UserAccountControl.ADS_UF_TRUSTED_FOR_DELEGATION"), rb.getString("adap.UserAccountControl.ADS_UF_NOT_DELEGATED"), rb.getString("adap.UserAccountControl.ADS_UF_USE_DES_KEY_ONLY"), rb.getString("adap.UserAccountControl.ADS_UF_DONT_REQUIRE_PREAUTH"), rb.getString("adap.UserAccountControl.ADS_UF_PASSWORD_EXPIRED"), rb.getString("adap.UserAccountControl.ADS_UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION"), rb.getString("adap.UserAccountControl.ADS_UF_PARTIAL_SECRETS_ACCOUNT")};

    public static String getPasswordStatus(int val) {
        StringBuffer str = new StringBuffer();
        if ((val & 0x40) == 64) {
            str.append(rb.getString("adap.UserAccountControl.ADS_UF_PASSWD_CANT_CHANGE"));
        }
        if ((val & 0x800000) == 0x800000) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(rb.getString("adap.UserAccountControl.ADS_UF_PASSWORD_EXPIRED"));
        }
        if ((val & 0x10000) == 65536) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(rb.getString("adap.UserAccountControl.ADS_UF_DONT_EXPIRE_PASSWD"));
        }
        if (str.length() == 0) {
            str.append(rb.getString("adap.UserAccountControl.Active"));
        }
        return str.toString();
    }

    public static String getAccountStatus(int val) {
        StringBuffer str = new StringBuffer();
        if ((val & 2) == 2) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(rb.getString("adap.UserAccountControl.Disabled"));
        }
        if (str.length() == 0) {
            str.append(rb.getString("adap.UserAccountControl.Enabled"));
        }
        return str.toString();
    }

    public static String delegationTrust(int val) {
        StringBuffer str = new StringBuffer();
        if ((val & 0x80000) == 524288) {
            str.append(rb.getString("adap.DomainConfiguration.Yes"));
        } else {
            str.append(rb.getString("adap.common.text.no"));
        }
        return str.toString();
    }

    public static String getUACString(int val) {
        StringBuffer str = new StringBuffer();
        try {
            int i = 0;
            for (int uacVal : UAC_FLAGS) {
                if ((val & uacVal) == uacVal) {
                    if (str.length() > 0) {
                        str.append(",");
                    }
                    str.append(UAC_STRINGS[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str.toString();
    }
}

