/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects.dns;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public final class DNSAttibuteConstants {
    private static final AdventNetResourceBundle RB;
    public static final String DNS_OBJECTS_TABLE = "AUDDNSObjectDetails";
    public static final String DNS_NODE_TABLE = "AUDDNSNodeDetails";
    public static final String DNS_ZONE_CLASS = "dnsZone";
    public static final String DNS_NODE_CLASS = "dnsNode";
    public static final String DNS_NODE_CLASS_GUID = "e0fa1e8c-9b45-11d0-afdd-00c04fd930c9";
    public static final String DNS_ZONE_CLASS_GUID = "e0fa1e8b-9b45-11d0-afdd-00c04fd930c9";
    public static final String OBJECT_GUID_COLUMN = "OBJECT_GUID";
    public static final String NAME_COLUMN = "NAME";
    public static final String COMMON_NAME_COLUMN = "NAME";
    public static final String CANONICAL_NAME_COLUMN = "CANONICAL_NAME";
    public static final String DISTINGUISHED_NAME_COLUMN = "DISTINGUISHED_NAME";
    public static final String DNS_TOMBSTONED_COLUMN = "DNS_TOMBSTONED";
    public static final String DNS_RECORD_COLUMN = "DNS_RECORD";
    public static final String DNS_PROPERTY_COLUMN = "DNS_PROPERTY";
    public static final String DOMAIN_NAME_COLUMN = "DOMAIN_NAME";
    public static final String OBJECT_CLASS_COLUMN = "OBJECT_CLASS";
    public static final String DNS_RECORD = "dnsRecord";
    public static final String NAME = "name";
    public static final String DNS_PROPERTY = "dNSProperty";
    public static final String OBJECT_GUID = "objectGUID";
    public static final String CANONICAL_NAME = "canonicalName";
    public static final String DISTINGUISHED_NAME = "distinguishedName";
    public static final String DNS_TOMBSTONED = "dNSTombstoned";
    public static final String DOMAIN_NAME = "domainName";
    public static final String OBJECT_CLASS = "objectClass";
    public static final String[] DNS_NODE_ATTRIBUTES;
    public static final String[] DNS_ZONE_ATTRIBUTES;
    public static final int DNS_TYPE_ZERO = 0;
    public static final int DNS_TYPE_A = 1;
    public static final int DNS_TYPE_NS = 2;
    public static final int DNS_TYPE_CNAME = 5;
    public static final int DNS_TYPE_SOA = 6;
    public static final int DNS_TYPE_PTR = 12;
    public static final int DNS_TYPE_HINFO = 13;
    public static final int DNS_TYPE_MX = 15;
    public static final int DNS_TYPE_TXT = 16;
    public static final int DNS_TYPE_AAAA = 28;
    public static final int DNS_TYPE_SRV = 33;
    public static final String DNS_TYPE_ZERO_STRING;
    public static final String DNS_TYPE_A_STRING;
    public static final String DNS_TYPE_NS_STRING;
    public static final String DNS_TYPE_CNAME_STRING;
    public static final String DNS_TYPE_SOA_STRING;
    public static final String DNS_TYPE_PTR_STRING;
    public static final String DNS_TYPE_HINFO_STRING;
    public static final String DNS_TYPE_MX_STRING;
    public static final String DNS_TYPE_TXT_STRING;
    public static final String DNS_TYPE_AAAA_STRING;
    public static final String DNS_TYPE_SRV_STRING;
    public static final int[] HOST_TYPES;
    public static final String[] HOST_TYPE_STRINGS;
    public static final int DSPROPERTY_ZONE_TYPE = 1;
    public static final int DSPROPERTY_ZONE_ALLOW_UPDATE = 2;
    public static final int DSPROPERTY_ZONE_SECURE_TIME = 8;
    public static final int DSPROPERTY_ZONE_NOREFRESH_INTERVAL = 16;
    public static final int DSPROPERTY_ZONE_REFRESH_INTERVAL = 32;
    public static final int DSPROPERTY_ZONE_AGING_STATE = 64;
    public static final int DSPROPERTY_ZONE_SCAVENGING_SERVERS = 17;
    public static final int DSPROPERTY_ZONE_AGING_ENABLED_TIME = 18;
    public static final int DSPROPERTY_ZONE_DELETED_FROM_HOSTNAME = 128;
    public static final int DSPROPERTY_ZONE_MASTER_SERVERS = 129;
    public static final int DSPROPERTY_ZONE_AUTO_NS_SERVERS = 130;
    public static final int DSPROPERTY_ZONE_DCPROMO_CONVERT = 131;
    public static final int DSPROPERTY_ZONE_SCAVENGING_SERVERS_DA = 144;
    public static final int DSPROPERTY_ZONE_MASTER_SERVERS_DA = 145;
    public static final int DSPROPERTY_ZONE_AUTO_NS_SERVERS_DA = 146;
    public static final int DSPROPERTY_ZONE_NODE_DBFLAGS = 256;
    public static final int DNS_ZONE_TYPE_CACHE = 0;
    public static final int DNS_ZONE_TYPE_PRIMARY = 1;
    public static final int DNS_ZONE_TYPE_SECONDARY = 2;
    public static final int DNS_ZONE_TYPE_STUB = 3;
    public static final int DNS_ZONE_TYPE_FORWARDER = 4;
    public static final int DNS_ZONE_TYPE_SECONDARY_CACHE = 5;
    public static final String DATA_LENGTH = "DATA_LENGTH";
    public static final String UPDATED_AT_SERIAL = "UPDATED_AT_SERIAL";
    public static final String HOST_TYPE = "HOST_TYPE";
    public static final String HOST_TYPE_STRING = "HOST_TYPE_STRING";
    public static final String TTL_SECONDS = "TTL_SECONDS";
    public static final String TIME_STAMP = "TIME_STAMP";
    public static final String TIME_STAMP_STRING = "TIME_STAMP_STRING";
    public static final String IPV4_ADDRESS = "IPV4_ADDRESS";
    public static final String NS_NAME = "NS_NAME";
    public static final String ALIAS = "ALIAS";
    public static final String PRIMARY_SERVER_NAME = "PRIMARY_SERVER_NAME";
    public static final String RESPONSIBLE_PARTY = "RESPONSIBLE_PARTY";
    public static final String SERIAL_NUMBER = "SERIAL_NUMBER";
    public static final String REFRESH_INTERVEL = "REFRESH_INTERVEL";
    public static final String RETRY_INTERVAL = "RETRY_INTERVAL";
    public static final String MIN_TTL = "MIN_TTL";
    public static final String TTL_EXPIRES = "TTL_EXPIRES";
    public static final String FQDN_POINTER = "FQDN_POINTER";
    public static final String CPU_TYPE = "CPU_TYPE";
    public static final String OS_TYPE = "OS_TYPE";
    public static final String PRIORITY = "PRIORITY";
    public static final String MX_HOST = "MX_HOST";
    public static final String TEXT = "TEXT";
    public static final String IPV6_ADDRESS = "IPV6_ADDRESS";
    public static final String WEIGHT = "WEIGHT";
    public static final String PORT_NUMBER = "PORT_NUMBER";
    public static final String SRV_HOST_NAME = "SRV_HOST_NAME";
    public static final String DNS_RECORD_DATA = "DNS_RECORD_DATA";
    public static final String[] HOST_TYPE_KEY_COLUMNS;
    public static final String[] DNS_RECORD_EDITABLE_PROPS;
    public static final String DATA_LENGTH_STRING_KEY;
    public static final String UPDATED_AT_SERIAL_STRING_KEY;
    public static final String HOST_TYPE_STRING_KEY;
    public static final String HOST_TYPE_STRING_STRING_KEY;
    public static final String TTL_SECONDS_STRING_KEY;
    public static final String TIME_STAMP_STRING_KEY;
    public static final String TIME_STAMP_STRING_STRING_KEY;
    public static final String IPV4_ADDRESS_STRING_KEY;
    public static final String NS_NAME_STRING_KEY;
    public static final String ALIAS_STRING_KEY;
    public static final String PRIMARY_SERVER_NAME_STRING_KEY;
    public static final String RESPONSIBLE_PARTY_STRING_KEY;
    public static final String SERIAL_NUMBER_STRING_KEY;
    public static final String REFRESH_INTERVEL_STRING_KEY;
    public static final String RETRY_INTERVAL_STRING_KEY;
    public static final String MIN_TTL_STRING_KEY;
    public static final String TTL_EXPIRES_STRING_KEY;
    public static final String FQDN_POINTER_STRING_KEY;
    public static final String CPU_TYPE_STRING_KEY;
    public static final String OS_TYPE_STRING_KEY;
    public static final String PRIORITY_STRING_KEY;
    public static final String MX_HOST_STRING_KEY;
    public static final String TEXT_STRING_KEY;
    public static final String IPV6_ADDRESS_STRING_KEY;
    public static final String WEIGHT_STRING_KEY;
    public static final String PORT_NUMBER_STRING_KEY;
    public static final String SRV_HOST_NAME_STRING_KEY;
    public static final String DNS_RECORD_DATA_STRING_KEY;
    public static final String[] DNS_RECORD_PROPS;
    public static final String[] DNS_RECORD_STRING_PROPS;
    public static final String DNS_ZONE_TYPE_CACHE_STRING;
    public static final String DNS_ZONE_TYPE_PRIMARY_STRING;
    public static final String DNS_ZONE_TYPE_SECONDARY_STRING;
    public static final String DNS_ZONE_TYPE_STUB_STRING;
    public static final String DNS_ZONE_TYPE_FORWARDER_STRING;
    public static final String DNS_ZONE_TYPE_SECONDARY_CACHE_STRING;
    public static final int[] ZONE_TYPES;
    public static final String[] ZONE_TYPE_SRINGS;
    private static HashMap<Integer, String> hostTypeMap;
    private static HashMap<Integer, String> zoneTypeMap;
    private static ArrayList<String> dnsNodeAttributes;
    private static ArrayList<String> dnsZoneAttributes;
    private static Properties dnsRecordStrings;
    private static ArrayList<String> dnsRecordEditableProps;
    private static HashMap<Integer, String> hostTypeKeyColumnMap;
    public static final String DNS_NODE_SEARCH_STRING = "(&(objectClass=dnsNode))";
    public static final String DNS_ZONE_SEARCH_STRING = "(&(objectClass=dnsZone))";
    public static final String DNS_NODE_ZONE_SEARCH_STRING = "(|(objectClass=dnsNode)(objectClass=dnsZone))";
    public static final int DNS_OBJECT_CREATED = 1;
    public static final int DNS_OBJECT_MODIFIED = 2;
    public static final int DNS_OBJECT_PERMISSION_CHANGED = 3;
    public static final int DNS_OBJECT_DELETED_FROM_AD = 10;
    public static final int DNS_OBJECT_DELETED_BY_DNS_SERVER_SCAVENGING = 11;
    public static final int DNS_OBJECT_DELETED_BY_DHCP_SERVER = 12;
    public static final int DNS_OBJECT_DELETED_BY_CLIENT_MC = 13;
    public static final int DNS_OBJECT_DELETED_BY_USER = 14;

    public static String getHostTypeString(Integer hostType) {
        return hostTypeMap.get(hostType) == null ? hostType.toString() : hostTypeMap.get(hostType);
    }

    public static String getZoneTypeString(Integer zoneType) {
        return zoneTypeMap.get(zoneType) == null ? zoneType.toString() : zoneTypeMap.get(zoneType);
    }

    public static ArrayList<String> getDNSAttributes(String objectClass) {
        return objectClass.equalsIgnoreCase(DNS_NODE_CLASS) ? dnsNodeAttributes : dnsZoneAttributes;
    }

    public static String getDNSRecordDisplayProperty(String propertyName) {
        return dnsRecordStrings.getProperty(propertyName);
    }

    public static boolean isEditableProperty(String propertyName) {
        return dnsRecordEditableProps.contains(propertyName);
    }

    public static String getKeyColumn(Integer hostType) {
        return hostTypeKeyColumnMap.get(hostType) != null ? hostTypeKeyColumnMap.get(hostType) : DNS_RECORD_DATA;
    }

    static {
        int i;
        RB = ResourceBundleMgr.getInstance().getBundle();
        DNS_NODE_ATTRIBUTES = new String[]{OBJECT_GUID, DISTINGUISHED_NAME, CANONICAL_NAME, NAME, DNS_RECORD, DNS_TOMBSTONED, DNS_PROPERTY};
        DNS_ZONE_ATTRIBUTES = new String[]{OBJECT_GUID, DISTINGUISHED_NAME, CANONICAL_NAME, NAME, DNS_PROPERTY};
        DNS_TYPE_ZERO_STRING = RB.getString("adap.DNSAttributes.displayName.Empty");
        DNS_TYPE_A_STRING = RB.getString("adap.DNSAttributes.displayName.Host_A");
        DNS_TYPE_NS_STRING = RB.getString("adap.DNSAttributes.displayName.Name_Server");
        DNS_TYPE_CNAME_STRING = RB.getString("adap.DNSAttributes.displayName.CName");
        DNS_TYPE_SOA_STRING = RB.getString("adap.DNSAttributes.displayName.SOA");
        DNS_TYPE_PTR_STRING = RB.getString("adap.DNSAttributes.displayName.PTR");
        DNS_TYPE_HINFO_STRING = RB.getString("adap.DNSAttributes.displayName.HINFO");
        DNS_TYPE_MX_STRING = RB.getString("adap.DNSAttributes.displayName.MX");
        DNS_TYPE_TXT_STRING = RB.getString("adap.DNSAttributes.displayName.TXT");
        DNS_TYPE_AAAA_STRING = RB.getString("adap.DNSAttributes.displayName.Host_AAAA");
        DNS_TYPE_SRV_STRING = RB.getString("adap.DNSAttributes.displayName.SRV");
        HOST_TYPES = new int[]{0, 1, 2, 5, 6, 12, 13, 15, 16, 28, 33};
        HOST_TYPE_STRINGS = new String[]{DNS_TYPE_ZERO_STRING, DNS_TYPE_A_STRING, DNS_TYPE_NS_STRING, DNS_TYPE_CNAME_STRING, DNS_TYPE_SOA_STRING, DNS_TYPE_PTR_STRING, DNS_TYPE_HINFO_STRING, DNS_TYPE_MX_STRING, DNS_TYPE_TXT_STRING, DNS_TYPE_AAAA_STRING, DNS_TYPE_SRV_STRING};
        HOST_TYPE_KEY_COLUMNS = new String[]{DNS_RECORD_DATA, IPV4_ADDRESS, NS_NAME, ALIAS, PRIMARY_SERVER_NAME, FQDN_POINTER, CPU_TYPE, MX_HOST, TEXT, IPV6_ADDRESS, SRV_HOST_NAME};
        DNS_RECORD_EDITABLE_PROPS = new String[]{TIME_STAMP_STRING, IPV4_ADDRESS, NS_NAME, ALIAS, PRIMARY_SERVER_NAME, RESPONSIBLE_PARTY, REFRESH_INTERVEL, RETRY_INTERVAL, MIN_TTL, TTL_EXPIRES, FQDN_POINTER, CPU_TYPE, OS_TYPE, MX_HOST, TEXT, IPV6_ADDRESS, WEIGHT, PORT_NUMBER, SRV_HOST_NAME, DNS_RECORD_DATA};
        DATA_LENGTH_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.DATA_LENGTH");
        UPDATED_AT_SERIAL_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.UPDATED_AT_SERIAL");
        HOST_TYPE_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.HOST_TYPE");
        HOST_TYPE_STRING_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.HOST_TYPE_STRING");
        TTL_SECONDS_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.TTL_SECONDS");
        TIME_STAMP_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.TIME_STAMP");
        TIME_STAMP_STRING_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.TIME_STAMP_STRING");
        IPV4_ADDRESS_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.IPV4_ADDRESS");
        NS_NAME_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.NS_NAME");
        ALIAS_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.ALIAS");
        PRIMARY_SERVER_NAME_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.PRIMARY_SERVER_NAME");
        RESPONSIBLE_PARTY_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.RESPONSIBLE_PARTY");
        SERIAL_NUMBER_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.SERIAL_NUMBER");
        REFRESH_INTERVEL_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.REFRESH_INTERVEL");
        RETRY_INTERVAL_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.RETRY_INTERVAL");
        MIN_TTL_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.MIN_TTL");
        TTL_EXPIRES_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.TTL_EXPIRES");
        FQDN_POINTER_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.FQDN_POINTER");
        CPU_TYPE_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.CPU_TYPE");
        OS_TYPE_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.OS_TYPE");
        PRIORITY_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.PRIORITY");
        MX_HOST_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.MX_HOST");
        TEXT_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.TEXT");
        IPV6_ADDRESS_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.IPV6_ADDRESS");
        WEIGHT_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.WEIGHT");
        PORT_NUMBER_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.PORT_NUMBER");
        SRV_HOST_NAME_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.SRV_HOST_NAME");
        DNS_RECORD_DATA_STRING_KEY = RB.getString("adap.DNSAttributes.displayName.DNS_RECORD_DATA");
        DNS_RECORD_PROPS = new String[]{DATA_LENGTH, UPDATED_AT_SERIAL, HOST_TYPE, HOST_TYPE_STRING, TTL_SECONDS, TIME_STAMP, TIME_STAMP_STRING, IPV4_ADDRESS, NS_NAME, ALIAS, PRIMARY_SERVER_NAME, RESPONSIBLE_PARTY, SERIAL_NUMBER, REFRESH_INTERVEL, RETRY_INTERVAL, MIN_TTL, TTL_EXPIRES, FQDN_POINTER, CPU_TYPE, OS_TYPE, PRIORITY, MX_HOST, TEXT, IPV6_ADDRESS, WEIGHT, PORT_NUMBER, SRV_HOST_NAME, DNS_RECORD_DATA};
        DNS_RECORD_STRING_PROPS = new String[]{DATA_LENGTH_STRING_KEY, UPDATED_AT_SERIAL_STRING_KEY, HOST_TYPE_STRING_KEY, HOST_TYPE_STRING_STRING_KEY, TTL_SECONDS_STRING_KEY, TIME_STAMP_STRING_KEY, TIME_STAMP_STRING_STRING_KEY, IPV4_ADDRESS_STRING_KEY, NS_NAME_STRING_KEY, ALIAS_STRING_KEY, PRIMARY_SERVER_NAME_STRING_KEY, RESPONSIBLE_PARTY_STRING_KEY, SERIAL_NUMBER_STRING_KEY, REFRESH_INTERVEL_STRING_KEY, RETRY_INTERVAL_STRING_KEY, MIN_TTL_STRING_KEY, TTL_EXPIRES_STRING_KEY, FQDN_POINTER_STRING_KEY, CPU_TYPE_STRING_KEY, OS_TYPE_STRING_KEY, PRIORITY_STRING_KEY, MX_HOST_STRING_KEY, TEXT_STRING_KEY, IPV6_ADDRESS_STRING_KEY, WEIGHT_STRING_KEY, PORT_NUMBER_STRING_KEY, SRV_HOST_NAME_STRING_KEY, DNS_RECORD_DATA_STRING_KEY};
        DNS_ZONE_TYPE_CACHE_STRING = RB.getString("adap.DNSAttributes.displayName.Cache_Zone");
        DNS_ZONE_TYPE_PRIMARY_STRING = RB.getString("adap.DNSAttributes.displayName.Primary_Zone");
        DNS_ZONE_TYPE_SECONDARY_STRING = RB.getString("adap.DNSAttributes.displayName.Secondary_Zone");
        DNS_ZONE_TYPE_STUB_STRING = RB.getString("adap.DNSAttributes.displayName.Stub_Zone");
        DNS_ZONE_TYPE_FORWARDER_STRING = RB.getString("adap.DNSAttributes.displayName.Forwarder_Zone");
        DNS_ZONE_TYPE_SECONDARY_CACHE_STRING = RB.getString("adap.DNSAttributes.displayName.Secondary_Cache_Zone");
        ZONE_TYPES = new int[]{0, 1, 2, 3, 4, 5};
        ZONE_TYPE_SRINGS = new String[]{DNS_ZONE_TYPE_CACHE_STRING, DNS_ZONE_TYPE_PRIMARY_STRING, DNS_ZONE_TYPE_SECONDARY_STRING, DNS_ZONE_TYPE_STUB_STRING, DNS_ZONE_TYPE_FORWARDER_STRING, DNS_ZONE_TYPE_SECONDARY_CACHE_STRING};
        hostTypeMap = new HashMap();
        zoneTypeMap = new HashMap();
        dnsNodeAttributes = new ArrayList();
        dnsZoneAttributes = new ArrayList();
        dnsRecordStrings = new Properties();
        dnsRecordEditableProps = new ArrayList();
        hostTypeKeyColumnMap = new HashMap();
        for (i = 0; i < HOST_TYPES.length; ++i) {
            hostTypeMap.put(HOST_TYPES[i], HOST_TYPE_STRINGS[i]);
        }
        for (i = 0; i < ZONE_TYPES.length; ++i) {
            zoneTypeMap.put(ZONE_TYPES[i], ZONE_TYPE_SRINGS[i]);
        }
        for (String attribute : DNS_NODE_ATTRIBUTES) {
            dnsNodeAttributes.add(attribute);
        }
        for (String attribute : DNS_ZONE_ATTRIBUTES) {
            dnsZoneAttributes.add(attribute);
        }
        for (int i2 = 0; i2 < DNS_RECORD_PROPS.length; ++i2) {
            dnsRecordStrings.setProperty(DNS_RECORD_PROPS[i2], DNS_RECORD_STRING_PROPS[i2]);
        }
        for (String string : DNS_RECORD_EDITABLE_PROPS) {
            dnsRecordEditableProps.add(string);
        }
        for (int i3 = 0; i3 < HOST_TYPES.length; ++i3) {
            hostTypeKeyColumnMap.put(HOST_TYPES[i3], HOST_TYPE_KEY_COLUMNS[i3]);
        }
    }
}

