/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects.dns;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSAttibuteConstants;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;

public final class DNSAttributeUtil {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();

    private static int getRDataLength(int[] dnsPropValue) {
        return DNSAttributeUtil.convertWordLittleEndian(dnsPropValue, 0);
    }

    private static int getRDataType(int[] dnsPropValue) {
        return DNSAttributeUtil.convertWordLittleEndian(dnsPropValue, 2);
    }

    private static long getUpdatedAtSerial(int[] dnsPropValue) {
        return DNSAttributeUtil.convertDwordLittleEndian(dnsPropValue, 8);
    }

    private static long getTTL(int[] dnsPropValue) {
        return DNSAttributeUtil.convertDwordBigEndian(dnsPropValue, 12);
    }

    private static long getTimeStamp(int[] dnsPropValue) {
        return DNSAttributeUtil.convertDwordLittleEndian(dnsPropValue, 20);
    }

    private static String formatTimeStamp(int[] dnsPropValue) {
        return DNSAttributeUtil.getTimeStamp(dnsPropValue) == 0L ? RB.getString("adap.DNSAttributes.displayName.Static") : TimeUtil.formatDate(TimeUtil.getTimeFromdwTimeStamp(DNSAttributeUtil.getTimeStamp(dnsPropValue)));
    }

    private static void setRData(HashMap<String, Object> properties, int[] dnsPropValue, int hostType) {
        switch (hostType) {
            case 1: {
                StringBuilder ipBuilder = null;
                for (int i = 24; i < 28; ++i) {
                    if (ipBuilder != null) {
                        ipBuilder.append(":");
                    } else {
                        ipBuilder = new StringBuilder();
                    }
                    ipBuilder.append(dnsPropValue[i]);
                }
                if (ipBuilder == null) {
                    ipBuilder = new StringBuilder("-");
                }
                properties.put("IPV4_ADDRESS", ipBuilder.toString());
                break;
            }
            case 2: {
                properties.put("NS_NAME", DNSAttributeUtil.decodeName(dnsPropValue, 24));
            }
            case 5: {
                properties.put("ALIAS", DNSAttributeUtil.decodeName(dnsPropValue, 24));
                break;
            }
            case 6: {
                int nsLength = dnsPropValue[44];
                properties.put("PRIMARY_SERVER_NAME", DNSAttributeUtil.decodeName(dnsPropValue, 44));
                int index = 46 + nsLength;
                properties.put("RESPONSIBLE_PARTY", DNSAttributeUtil.decodeName(dnsPropValue, index));
                properties.put("SERIAL_NUMBER", DNSAttributeUtil.convertDwordBigEndian(dnsPropValue, 24));
                properties.put("REFRESH_INTERVEL", TimeUtil.getDuration(DNSAttributeUtil.convertDwordBigEndian(dnsPropValue, 28)));
                properties.put("RETRY_INTERVAL", TimeUtil.getDuration(DNSAttributeUtil.convertDwordBigEndian(dnsPropValue, 32)));
                properties.put("MIN_TTL", TimeUtil.getDuration(DNSAttributeUtil.convertDwordBigEndian(dnsPropValue, 40)));
                properties.put("TTL_EXPIRES", TimeUtil.getDuration(DNSAttributeUtil.convertDwordBigEndian(dnsPropValue, 36)));
                break;
            }
            case 12: {
                properties.put("FQDN_POINTER", DNSAttributeUtil.decodeName(dnsPropValue, 24));
                break;
            }
            case 13: {
                StringBuilder cpuType = new StringBuilder("");
                StringBuilder osType = new StringBuilder("");
                int segmentLength = dnsPropValue[24];
                int hinfoIndex = 25;
                while (segmentLength-- > 0) {
                    cpuType.append((char)dnsPropValue[hinfoIndex++]);
                }
                hinfoIndex = 24 + segmentLength + 1;
                segmentLength = hinfoIndex++;
                while (segmentLength-- > 0) {
                    osType.append((char)dnsPropValue[hinfoIndex++]);
                }
                properties.put("CPU_TYPE", cpuType.toString());
                properties.put("OS_TYPE", osType.toString());
                break;
            }
            case 15: {
                properties.put("PRIORITY", DNSAttributeUtil.convertWordBigEndian(dnsPropValue, 24));
                properties.put("MX_HOST", DNSAttributeUtil.decodeName(dnsPropValue, 26));
                break;
            }
            case 16: {
                StringBuilder text = new StringBuilder();
                int textSegmentLength = dnsPropValue[24];
                int textIndex = 25;
                while (textSegmentLength-- > 0) {
                    text.append((char)dnsPropValue[textIndex++]);
                }
                properties.put("TEXT", text.toString());
                break;
            }
            case 28: {
                StringBuilder ipv6Builder = new StringBuilder();
                for (int i = 24; i < 40; i += 2) {
                    Integer segment = DNSAttributeUtil.convertWordBigEndian(dnsPropValue, i);
                    ipv6Builder.append(Integer.toHexString(segment));
                    if (i >= 38) continue;
                    ipv6Builder.append(':');
                }
                properties.put("IPV6_ADDRESS", ipv6Builder.toString());
                break;
            }
            case 33: {
                properties.put("PRIORITY", DNSAttributeUtil.convertWordBigEndian(dnsPropValue, 28));
                properties.put("WEIGHT", DNSAttributeUtil.convertWordBigEndian(dnsPropValue, 26));
                properties.put("PORT_NUMBER", DNSAttributeUtil.convertWordBigEndian(dnsPropValue, 24));
                properties.put("SRV_HOST_NAME", DNSAttributeUtil.decodeName(dnsPropValue, 30));
                break;
            }
            default: {
                ArrayList<Integer> dnsRecordData = new ArrayList<Integer>();
                for (int integer : dnsPropValue) {
                    dnsRecordData.add(integer);
                }
                properties.put("DNS_RECORD_DATA", dnsRecordData.toString());
            }
        }
    }

    public static HashMap<String, Object> getDNSNodeType(String dnsRecord) {
        return DNSAttributeUtil.getDNSNodeType(DNSAttributeUtil.getDNSRecordArray(dnsRecord));
    }

    public static HashMap<String, Object> getDNSNodeType(int[] dnsPropValue) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int hostType = DNSAttributeUtil.getRDataType(dnsPropValue);
        properties.put("HOST_TYPE", hostType);
        properties.put("HOST_TYPE_STRING", DNSAttibuteConstants.getHostTypeString(hostType));
        return properties;
    }

    public static int[] getDNSRecordArray(String dnsRecord) {
        String[] dnsRecordString = dnsRecord.split(",");
        int[] dnsPropValue = new int[dnsRecordString.length];
        for (int i = 0; i < dnsRecordString.length; ++i) {
            dnsPropValue[i] = Integer.parseInt(dnsRecordString[i]);
        }
        return dnsPropValue;
    }

    public static HashMap<String, Object> getDnsRecordData(String dnsRecord) {
        return DNSAttributeUtil.getDnsRecordData(DNSAttributeUtil.getDNSRecordArray(dnsRecord));
    }

    public static HashMap<String, Object> getDnsRecordData(int[] dnsPropValue) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int hostType = DNSAttributeUtil.getRDataType(dnsPropValue);
        properties.put("DATA_LENGTH", DNSAttributeUtil.getRDataLength(dnsPropValue));
        properties.put("UPDATED_AT_SERIAL", DNSAttributeUtil.getUpdatedAtSerial(dnsPropValue));
        properties.put("HOST_TYPE", hostType);
        properties.put("HOST_TYPE_STRING", DNSAttibuteConstants.getHostTypeString(hostType));
        properties.put("TTL_SECONDS", DNSAttributeUtil.getTTL(dnsPropValue));
        properties.put("TIME_STAMP", DNSAttributeUtil.getTimeStamp(dnsPropValue));
        properties.put("TIME_STAMP_STRING", DNSAttributeUtil.formatTimeStamp(dnsPropValue));
        DNSAttributeUtil.setRData(properties, dnsPropValue, hostType);
        return properties;
    }

    public static HashMap<String, Object> getDnsPropertyData(int[] dnsPropValue) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int propertyType = dnsPropValue[4];
        switch (propertyType) {
            case 1: {
                break;
            }
        }
        return properties;
    }

    private static int convertWordLittleEndian(int[] dnsPropValue, int startIndex) {
        int value = 0;
        value = dnsPropValue[startIndex + 1];
        value = value * 256 + dnsPropValue[startIndex];
        return value;
    }

    private static int convertWordBigEndian(int[] dnsPropValue, int startIndex) {
        int value = 0;
        value = dnsPropValue[startIndex];
        value = value * 256 + dnsPropValue[startIndex + 1];
        return value;
    }

    private static long convertDwordLittleEndian(int[] dnsPropValue, int startIndex) {
        long value = 0L;
        value = dnsPropValue[startIndex + 3];
        value = value * 256L + (long)dnsPropValue[startIndex + 2];
        value = value * 256L + (long)dnsPropValue[startIndex + 1];
        value = value * 256L + (long)dnsPropValue[startIndex + 0];
        return value;
    }

    private static long convertDwordBigEndian(int[] dnsPropValue, int startIndex) {
        long value = 0L;
        value = dnsPropValue[startIndex];
        value = value * 256L + (long)dnsPropValue[startIndex + 1];
        value = value * 256L + (long)dnsPropValue[startIndex + 2];
        value = value * 256L + (long)dnsPropValue[startIndex + 3];
        return value;
    }

    private static String decodeName(int[] dnsPropValue, int startIndex) {
        StringBuilder nameBuilder = new StringBuilder();
        int segments = dnsPropValue[startIndex + 1];
        int index = startIndex + 2;
        while (segments-- > 0) {
            int segmentLength = dnsPropValue[index++];
            while (segmentLength-- > 0) {
                nameBuilder.append((char)dnsPropValue[index++]);
            }
            nameBuilder.append(".");
        }
        return nameBuilder.toString();
    }
}

