/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects.dns;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSAttibuteConstants;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSObjectQueue;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DNSNodesListener
implements NativeListener {
    private String domainName = null;
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    public boolean isCompleted = false;

    public DNSNodesListener(String domainName) {
        reportLogger.log(Level.INFO, "Started fetching dns node objects for domain : " + domainName);
        this.domainName = domainName;
    }

    @Override
    public void addRow(Properties properties) {
        properties.setProperty("domainName", this.domainName);
        properties.setProperty("objectClass", "dnsNode");
        DNSObjectQueue.getInstance().addToQueue(properties);
    }

    @Override
    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void getDNSNodeObjects() {
        try {
            ADHandler.getObjects(this.domainName, 1L, DomainDetailsAPI.getDefaultNamingContext(this.domainName), DNSAttibuteConstants.getDNSAttributes("dnsNode"), "(&(objectClass=dnsNode))", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ADHandler.getObjects(this.domainName, 1L, DomainDetailsAPI.getDomainDNSZone(this.domainName), DNSAttibuteConstants.getDNSAttributes("dnsNode"), "(&(objectClass=dnsNode))", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ADHandler.getObjects(this.domainName, 1L, DomainDetailsAPI.getForestDNSZone(this.domainName), DNSAttibuteConstants.getDNSAttributes("dnsNode"), "(&(objectClass=dnsNode))", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isCompleted = true;
    }
}

