/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects.dns;

import com.adventnet.sym.adsm.common.server.objects.dns.DNSAttributeUtil;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSUpdateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class DNSObjectQueue
extends Thread {
    private static volatile DNSObjectQueue dnsObjectQueue = null;
    private Vector<Properties> inQ = new Vector();
    private boolean isProcessCompleted = true;

    private DNSObjectQueue() {
        new Action().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DNSObjectQueue getInstance() {
        if (dnsObjectQueue != null) return dnsObjectQueue;
        Class<DNSObjectQueue> clazz = DNSObjectQueue.class;
        synchronized (DNSObjectQueue.class) {
            if (dnsObjectQueue != null) return dnsObjectQueue;
            dnsObjectQueue = new DNSObjectQueue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dnsObjectQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(Properties properties) {
        Vector<Properties> vector = this.inQ;
        synchronized (vector) {
            this.inQ.add(properties);
            if (this.inQ.size() > 500 && this.isProcessCompleted) {
                this.process();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Vector<Properties> inQCopy = null;
        Vector<Properties> vector = this.inQ;
        synchronized (vector) {
            inQCopy = this.inQ;
            this.inQ = new Vector();
        }
        try {
            if (inQCopy.size() > 0) {
                this.isProcessCompleted = false;
                HashMap<String, HashMap<String, Object>> dnsObjectHashtable = new HashMap<String, HashMap<String, Object>>();
                for (Properties properties : inQCopy) {
                    HashMap<String, Object> dnsObjectTable = new HashMap<String, Object>();
                    String objectGuid = (String)((ArrayList)properties.get("objectGUID")).get(0);
                    dnsObjectTable.put("OBJECT_GUID", objectGuid);
                    dnsObjectTable.put("NAME", (String)((ArrayList)properties.get("name")).get(0));
                    dnsObjectTable.put("CANONICAL_NAME", (String)((ArrayList)properties.get("canonicalName")).get(0));
                    dnsObjectTable.put("NAME", (String)((ArrayList)properties.get("name")).get(0));
                    dnsObjectTable.put("DISTINGUISHED_NAME", (String)((ArrayList)properties.get("distinguishedName")).get(0));
                    dnsObjectTable.put("DOMAIN_NAME", properties.get("domainName"));
                    dnsObjectTable.put("OBJECT_CLASS", properties.get("objectClass"));
                    if (properties.get("dNSProperty") != null) {
                        dnsObjectTable.put("DNS_PROPERTY", ((ArrayList)properties.get("dNSProperty")).toString());
                    }
                    if (properties.get("dnsRecord") != null) {
                        ArrayList dnsRecords = (ArrayList)properties.get("dnsRecord");
                        dnsObjectTable.put("DNS_RECORD", dnsRecords.toString());
                        ArrayList<HashMap<String, Object>> dnsRecordTableList = new ArrayList<HashMap<String, Object>>();
                        for (String dnsRecord : dnsRecords) {
                            dnsRecordTableList.add(DNSAttributeUtil.getDnsRecordData(dnsRecord));
                        }
                        dnsObjectTable.put("DNS_RECORD_TABLE_VALUES", dnsRecordTableList);
                    }
                    if (properties.get("dNSTombstoned") != null) {
                        String dnsTombstoned = (String)((ArrayList)properties.get("dNSTombstoned")).get(0);
                        dnsObjectTable.put("DNS_TOMBSTONED", dnsTombstoned.equals("1"));
                    }
                    dnsObjectHashtable.put(objectGuid, dnsObjectTable);
                }
                DNSUpdateUtil.addOrUpdate(dnsObjectHashtable);
            }
            this.isProcessCompleted = true;
        }
        catch (Exception e) {
            this.isProcessCompleted = true;
            e.printStackTrace();
        }
    }

    class Action
    extends Thread {
        private boolean shutDown = false;

        Action() {
        }

        @Override
        public void run() {
            try {
                while (!this.shutDown) {
                    this.checkAndProcess();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void shutDown() {
            this.shutDown = true;
        }

        public void checkAndProcess() {
            this.waitForUpdate(300L);
            if (DNSObjectQueue.this.isProcessCompleted) {
                DNSObjectQueue.this.process();
            }
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

