/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects.dns;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSAttibuteConstants;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSAttributeUtil;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSNodesListener;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSZonesListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DNSUpdateUtil {
    public static void getDNSNodeObjects(String domainName) {
        DNSNodesListener dnsNodesListener = new DNSNodesListener(domainName);
        dnsNodesListener.getDNSNodeObjects();
        while (!dnsNodesListener.isCompleted()) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void getDNSZoneObjects(String domainName) {
        DNSZonesListener dnsZonesListener = new DNSZonesListener(domainName);
        dnsZonesListener.getDNSZoneObjects();
        while (!dnsZonesListener.isCompleted()) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static HashMap<String, Object> getDNSObjectProperties(Properties properties, String domainName, String objectClass) {
        HashMap<String, Object> dnsObjectTable = new HashMap<String, Object>();
        if (properties != null) {
            String objectGuid = (String)((ArrayList)properties.get("objectGUID")).get(0);
            dnsObjectTable.put("OBJECT_GUID", objectGuid);
            dnsObjectTable.put("NAME", (String)((ArrayList)properties.get("name")).get(0));
            dnsObjectTable.put("CANONICAL_NAME", (String)((ArrayList)properties.get("canonicalName")).get(0));
            dnsObjectTable.put("NAME", (String)((ArrayList)properties.get("name")).get(0));
            dnsObjectTable.put("DISTINGUISHED_NAME", (String)((ArrayList)properties.get("distinguishedName")).get(0));
            dnsObjectTable.put("DOMAIN_NAME", domainName);
            dnsObjectTable.put("OBJECT_CLASS", objectClass);
            if (properties.get("dNSProperty") != null) {
                dnsObjectTable.put("DNS_PROPERTY", ((ArrayList)properties.get("dNSProperty")).toString());
            }
            if (properties.get("dnsRecord") != null) {
                ArrayList dnsRecords = (ArrayList)properties.get("dnsRecord");
                dnsObjectTable.put("DNS_RECORD", dnsRecords.toString());
                ArrayList<HashMap<String, Object>> dnsRecordTableList = new ArrayList<HashMap<String, Object>>();
                for (String dnsRecord : dnsRecords) {
                    dnsRecordTableList.add(DNSAttributeUtil.getDnsRecordData(dnsRecord));
                }
                dnsObjectTable.put("DNS_RECORD_TABLE_VALUES", dnsRecordTableList);
            }
            if (properties.get("dNSTombstoned") != null) {
                String dnsTombstoned = (String)((ArrayList)properties.get("dNSTombstoned")).get(0);
                dnsObjectTable.put("DNS_TOMBSTONED", dnsTombstoned.equals("1"));
            }
        }
        return dnsObjectTable;
    }

    public static Properties getDNSObject(String domainName, String dcName, String distinguishedName, String objectClass, String searchAttribute) {
        return DNSUpdateUtil.getDNSObject(domainName, dcName, distinguishedName, objectClass, searchAttribute, DNSAttibuteConstants.getDNSAttributes(objectClass));
    }

    public static Properties getDNSObject(String domainName, String dcName, String distinguishedName, String objectClass, String searchAttribute, ArrayList<String> attributeList) {
        Properties properties = null;
        try {
            if (searchAttribute.equalsIgnoreCase("objectGUID")) {
                properties = ADHandler.getObjectFromGUID(domainName, 1L, distinguishedName, attributeList, dcName);
            } else if (searchAttribute.equalsIgnoreCase("distinguishedName")) {
                properties = ADHandler.getObjectProperties(domainName, 1L, distinguishedName, attributeList, dcName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static void addOrUpdate(HashMap<String, HashMap<String, Object>> dnsObjectHashtable) {
        try {
            Set<String> guidSet = dnsObjectHashtable.keySet();
            String[] guids = guidSet.toArray(new String[guidSet.size()]);
            DataObject baseDataObj = CommonUtil.getPersistence(new boolean[0]).get("AUDDNSObjectDetails", new Criteria(Column.getColumn((String)"AUDDNSObjectDetails", (String)"OBJECT_GUID"), (Object)guids, 8));
            DataObject tobeAddedDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            DataObject tobeUpdatedDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            DNSUpdateUtil.add(baseDataObj, guids, dnsObjectHashtable, tobeAddedDataObject, tobeUpdatedDataObject);
            DNSUpdateUtil.deleteDNSNodeObjects(guids);
            CommonUtil.getPersistence(new boolean[0]).add(tobeAddedDataObject);
            if (!tobeUpdatedDataObject.isEmpty()) {
                CommonUtil.getPersistence(new boolean[0]).update(tobeUpdatedDataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void add(DataObject obj, String[] guids, HashMap<String, HashMap<String, Object>> hashtable, DataObject tobeAddedDataObject, DataObject tobeUpdatedDataObject) {
        try {
            for (String guid : guids) {
                Row row = obj.getRow("AUDDNSObjectDetails", new Criteria(Column.getColumn((String)"AUDDNSObjectDetails", (String)"OBJECT_GUID"), (Object)guid, 0));
                if (row == null) {
                    row = new Row("AUDDNSObjectDetails");
                    HashMap<String, Object> hashtable2 = hashtable.get(guid);
                    Set<String> rowKeySet = hashtable2.keySet();
                    for (String rowColumnName : rowKeySet) {
                        if (rowColumnName.equalsIgnoreCase("DNS_RECORD_TABLE_VALUES")) {
                            ArrayList dnsRecordTableList = (ArrayList)hashtable2.get("DNS_RECORD_TABLE_VALUES");
                            DNSUpdateUtil.setDNSNodeRow(tobeAddedDataObject, dnsRecordTableList, guid);
                            continue;
                        }
                        row.set(rowColumnName, hashtable2.get(rowColumnName));
                    }
                    tobeAddedDataObject.addRow(row);
                    continue;
                }
                DNSUpdateUtil.updateRowValues(row, hashtable, guid, tobeAddedDataObject, tobeUpdatedDataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setDNSNodeRow(DataObject tobeAddedDataObject, ArrayList<HashMap<String, Object>> dnsRecordTableList, String guid) {
        try {
            for (HashMap<String, Object> hashtable3 : dnsRecordTableList) {
                Row row2 = new Row("AUDDNSNodeDetails");
                row2.set("OBJECT_GUID", (Object)guid);
                Set<String> nodeColumnSet = hashtable3.keySet();
                for (String nodeColumnName : nodeColumnSet) {
                    row2.set(nodeColumnName, hashtable3.get(nodeColumnName));
                }
                tobeAddedDataObject.addRow(row2);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static void updateRowValues(Row oldRow, HashMap<String, HashMap<String, Object>> hashtable, String guid, DataObject tobeAddedDataObject, DataObject tobeUpdatedDataObject) {
        try {
            HashMap<String, Object> hashtable2 = hashtable.get(guid);
            Set<String> rowKeySet = hashtable2.keySet();
            boolean isUpdateNeeded = false;
            for (String rowColumnName : rowKeySet) {
                if (rowColumnName.equalsIgnoreCase("DNS_RECORD_TABLE_VALUES")) {
                    ArrayList dnsRecordTableList = (ArrayList)hashtable2.get("DNS_RECORD_TABLE_VALUES");
                    DNSUpdateUtil.setDNSNodeRow(tobeAddedDataObject, dnsRecordTableList, guid);
                    continue;
                }
                if (oldRow.get(rowColumnName) != null && hashtable2.get(rowColumnName) != null && !oldRow.get(rowColumnName).equals(hashtable2.get(rowColumnName))) {
                    isUpdateNeeded = true;
                    oldRow.set(rowColumnName, hashtable2.get(rowColumnName));
                    continue;
                }
                if (oldRow.get(rowColumnName) != null || hashtable2.get(rowColumnName) == null) continue;
                isUpdateNeeded = true;
                oldRow.set(rowColumnName, hashtable2.get(rowColumnName));
            }
            if (isUpdateNeeded) {
                tobeUpdatedDataObject.updateBlindly(oldRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean deleteDNSNodeObjects(String[] guids) {
        boolean isDeleted = false;
        try {
            CommonUtil.getPersistenceLite().delete(new Criteria(Column.getColumn((String)"AUDDNSNodeDetails", (String)"OBJECT_GUID"), (Object)guids, 8));
            isDeleted = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static HashMap<String, Object> getDNSHostType(String domainName, String dcName, String objectName, String searchAttribute, byte operationType) {
        if (operationType == 0) {
            return DNSUpdateUtil.getDNSObjectTypeFromDB(domainName, objectName, searchAttribute);
        }
        HashMap<String, Object> dnsHostType = new HashMap<String, Object>();
        Properties properties = DNSUpdateUtil.getDNSObject(domainName, dcName, objectName, "dnsNode", "distinguishedName");
        if (properties != null) {
            String dnsRecord = ((ArrayList)properties.get("dnsRecord")).get(0).toString();
            String[] dnsRecordString = dnsRecord.split(",");
            int[] dnsPropValue = new int[dnsRecordString.length];
            for (int i = 0; i < dnsRecordString.length; ++i) {
                dnsPropValue[i] = Integer.parseInt(dnsRecordString[i]);
            }
            dnsHostType = DNSAttributeUtil.getDNSNodeType(dnsPropValue);
        }
        return dnsHostType;
    }

    public static HashMap<String, Object> getDNSObjectFromDB(String objectName, String searchAttribute) {
        HashMap<String, Object> dnsObjectTable = new HashMap<String, Object>();
        try {
            DataObject dataObject = DNSUpdateUtil.getDNSObjectDO(objectName, searchAttribute);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDDNSObjectDetails");
                String objectGuid = (String)row.get("OBJECT_GUID");
                List columnNames = row.getColumns();
                for (String columnName : columnNames) {
                    if (row.get(columnName) == null) continue;
                    dnsObjectTable.put(columnName, row.get(columnName));
                }
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDDNSNodeDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
                ArrayList dnsRecordTableList = new ArrayList();
                Iterator rowIterator = dataObject.getRows("AUDDNSNodeDetails", criteria);
                while (rowIterator.hasNext()) {
                    Row row2 = (Row)rowIterator.next();
                    List columnNamesStrings = row2.getColumns();
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (String columnName : columnNamesStrings) {
                        if (columnName.equalsIgnoreCase("RECORD_ID") || columnName.equalsIgnoreCase("OBJECT_GUID") || row2.get(columnName) == null) continue;
                        properties.put(columnName, row2.get(columnName));
                    }
                    dnsRecordTableList.add(properties);
                }
                dnsObjectTable.put("DNS_RECORD_TABLE_VALUES", dnsRecordTableList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dnsObjectTable;
    }

    public static DataObject getDNSObjectDO(String objectName, String searchAttribute) {
        DataObject dataObject = null;
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("AUDDNSObjectDetails");
        tableList.add("AUDDNSNodeDetails");
        try {
            dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, new Criteria(Column.getColumn((String)"AUDDNSObjectDetails", (String)(searchAttribute.equals("distinguishedName") ? "DISTINGUISHED_NAME" : "OBJECT_GUID")), (Object)objectName, 0));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return dataObject;
    }

    public static HashMap<String, Object> getDNSObjectTypeFromDB(String domainName, String objectName, String searchAttribute) {
        HashMap<String, Object> dnsHostType = new HashMap<String, Object>();
        String hostTypeString = DNSAttibuteConstants.DNS_TYPE_ZERO_STRING;
        int hostType = 0;
        try {
            DataObject dataObject = DNSUpdateUtil.getDNSObjectDO(objectName, searchAttribute);
            if (dataObject.size("AUDDNSNodeDetails") > 0) {
                Row row = dataObject.getRow("AUDDNSNodeDetails");
                hostTypeString = (String)row.get("HOST_TYPE_STRING");
                hostType = (Integer)row.get("HOST_TYPE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dnsHostType.put("HOST_TYPE", hostType);
        dnsHostType.put("HOST_TYPE_STRING", hostTypeString);
        return dnsHostType;
    }

    public static void getDNSRecordValues(String dnsNode, boolean isNewNode) {
    }
}

