/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects.dns;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSAttibuteConstants;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSObjectQueue;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DNSZonesListener
implements NativeListener {
    private String domainName = null;
    public boolean isCompleted = false;
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public DNSZonesListener(String domainName) {
        reportLogger.log(Level.INFO, "Started fetching dns zone objects for domain : " + domainName);
        this.domainName = domainName;
    }

    @Override
    public void addRow(Properties properties) {
        properties.setProperty("domainName", this.domainName);
        properties.setProperty("objectClass", "dnsZone");
        DNSObjectQueue.getInstance().addToQueue(properties);
    }

    @Override
    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void getDNSZoneObjects() {
        try {
            ADHandler.getObjects(this.domainName, 1L, DomainDetailsAPI.getDefaultNamingContext(this.domainName), DNSAttibuteConstants.getDNSAttributes("dnsZone"), "(&(objectClass=dnsZone))", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ADHandler.getObjects(this.domainName, 1L, DomainDetailsAPI.getDomainDNSZone(this.domainName), DNSAttibuteConstants.getDNSAttributes("dnsZone"), "(&(objectClass=dnsZone))", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ADHandler.getObjects(this.domainName, 1L, DomainDetailsAPI.getForestDNSZone(this.domainName), DNSAttibuteConstants.getDNSAttributes("dnsZone"), "(&(objectClass=dnsZone))", this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isCompleted = true;
    }
}

