/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.postgres;

import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;

public class PSQLBackupHandler {
    public static String constructQuery(ResultSet rs, HashMap tableColNameMap, String fileName, String tableName) throws Exception {
        StringBuilder query = new StringBuilder();
        while (rs.next()) {
            String colName = rs.getString(1);
            int strLength = query.toString().length();
            if (tableColNameMap.get(tableName.toUpperCase() + "_" + colName.toUpperCase()) != null && ((String)tableColNameMap.get(tableName.toUpperCase() + "_" + colName.toUpperCase())).equalsIgnoreCase(colName)) {
                query.append(", CASE WHEN (");
                query.append(colName);
                query.append("='') THEN ' ' ELSE ");
                query.append(colName);
                query.append(" END ");
                continue;
            }
            if (strLength > 0) {
                colName = rs.getString(2).equalsIgnoreCase("boolean") ? ", CAST(" + colName + " as INT)" : ", " + colName;
            } else {
                query.append("COPY ");
                query.append(" ( SELECT ");
                colName = rs.getString(2).equalsIgnoreCase("boolean") ? "CAST(" + colName + " as INT)," : colName;
            }
            query.append(colName);
        }
        query.append(" FROM ");
        query.append(tableName);
        query.append(" ) TO '");
        query.append(fileName);
        query.append("' NULL AS ''");
        return query.toString();
    }

    public static Long getDBSize(ResultSet rs, Statement stmt) throws Exception {
        Long sizeBytes = 0L;
        rs = stmt.executeQuery("SELECT pg_database_size('adap')");
        if (rs.next()) {
            sizeBytes = (Long)rs.getObject(1);
        }
        return sizeBytes;
    }

    public static String getDecryptString(String columnName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("'encryptbykey(key_guid(''ZOHO_SYMM_KEY''), N''' || pgp_sym_decrypt(");
        sb.append(columnName);
        sb.append(", 'MLite') ||''')' as ");
        sb.append(columnName);
        return sb.toString();
    }

    public static String getColumnString(String tableName) throws Exception {
        return CommonUtil.constructString(new String[]{"select column_name, data_type, is_nullable from information_schema.columns where table_name='", tableName, "' order by ordinal_position"}, null);
    }

    public static String getSelectedColumn(HashMap metaDataMap, String dbServerName) throws Exception {
        String selectedColumn = null;
        for (String key : metaDataMap.keySet()) {
            HashMap map = (HashMap)metaDataMap.get(key);
            String dataType = map.get("DATA_TYPE").toString();
            if (dataType.equalsIgnoreCase("BOOLEAN") && dbServerName.equalsIgnoreCase("postgres")) {
                key = CommonUtil.constructString(new String[]{"CAST(", key, " AS INT) as ", key}, null);
            }
            if (selectedColumn != null) {
                selectedColumn = CommonUtil.constructString(new String[]{selectedColumn, ",", key}, null);
                continue;
            }
            selectedColumn = key;
        }
        return selectedColumn;
    }
}

