/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.schema;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditCatgoryAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.Category;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.schema.Attribute;
import com.adventnet.sym.adsm.common.server.schema.PropertySet;
import com.adventnet.sym.adsm.common.server.schema.SchemaClass;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class SchemaAPI {
    private static SchemaAPI schemaAPI = null;
    private static HashMap<String, PropertySet> propertySetMap = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static HashMap<String, SchemaClass> schemaMap = null;
    private static HashMap<String, SchemaClass> schemaLdapNameMap = null;
    private static HashMap<String, Attribute> attributeMap = null;
    private static Properties attributeDisplayNameMap = null;
    private static HashMap<String, Long> attributeCommonNameMap = null;
    private static HashSet propertySetRightsGuid = null;
    private static HashMap<String, ArrayList> stringAccessMaskMap = null;
    private static Hashtable accessMaskMap = null;
    private static HashMap<Integer, ArrayList<String>> configurationClassList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchemaAPI getInstance() {
        if (schemaAPI != null) return schemaAPI;
        Class<SchemaAPI> clazz = SchemaAPI.class;
        synchronized (SchemaAPI.class) {
            if (schemaAPI != null) return schemaAPI;
            schemaAPI = new SchemaAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return schemaAPI;
        }
    }

    private SchemaAPI() {
        SchemaAPI.setPropertySetMap();
        SchemaAPI.setAttributeMap();
        SchemaAPI.setSchemaClassMap();
        SchemaAPI.setAccessMaskMap();
        this.setConfigurationClasses();
    }

    private static void setPropertySetMap() {
        propertySetMap = new HashMap();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDPropertySets", (Row)null);
            Iterator iterator = dataObject.getRows("AUDPropertySets");
            while (iterator.hasNext()) {
                Row propertySetRow = (Row)iterator.next();
                String rightsGuid = (String)propertySetRow.get("RIGHTS_GUID");
                propertySetMap.put(rightsGuid, new PropertySet(propertySetRow));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setAttributeMap() {
        attributeMap = new HashMap();
        attributeDisplayNameMap = new Properties();
        attributeCommonNameMap = new HashMap();
        propertySetRightsGuid = new HashSet();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAttributes", (Row)null);
            Iterator iterator = dataObject.getRows("AUDAttributes");
            while (iterator.hasNext()) {
                Row attributeRow = (Row)iterator.next();
                Attribute attribute = new Attribute(attributeRow);
                String systemIdGuid = (String)attributeRow.get("SYSTEM_ID_GUID");
                attributeMap.put(systemIdGuid, attribute);
                String rightsGuid = (String)attributeRow.get("RIGHTS_GUID");
                propertySetRightsGuid.add(rightsGuid);
                String ldapDisplayName = (String)attributeRow.get("LDAP_DISPLAY_NAME");
                String commonName = rb.getString((String)attributeRow.get("COMMON_NAME"));
                attributeDisplayNameMap.setProperty(ldapDisplayName.toLowerCase(), commonName);
                attributeCommonNameMap.put(commonName, (Long)attributeRow.get("ATTRIBUTE_CATEGORY_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setSchemaClassMap() {
        schemaMap = new HashMap();
        schemaLdapNameMap = new HashMap();
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("AUDSchemaClasses");
            tableList.add("AUDClassAttributeMap");
            ArrayList<String> leftJoinList = new ArrayList<String>();
            leftJoinList.add("AUDClassAttributeMap");
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDSchemaClasses", (String)"SCHEMA_ID_GUID"), null, 1);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, leftJoinList, criteria);
            Iterator iterator = dataObject.getRows("AUDSchemaClasses");
            while (iterator.hasNext()) {
                Row schemaRow = (Row)iterator.next();
                String schemaIdGuid = (String)schemaRow.get("SCHEMA_ID_GUID");
                String schemaLdapName = (String)schemaRow.get("LDAP_DISPLAY_NAME");
                ArrayList<String> attributeList = new ArrayList<String>();
                Criteria criteria2 = new Criteria(Column.getColumn((String)"AUDClassAttributeMap", (String)"SCHEMA_ID_GUID"), (Object)schemaIdGuid, 0);
                Iterator iterator2 = dataObject.getRows("AUDClassAttributeMap", criteria2);
                while (iterator2.hasNext()) {
                    Row attributeRow = (Row)iterator2.next();
                    attributeList.add((String)attributeRow.get("SYSTEM_ID_GUID"));
                }
                SchemaClass schemaClass = new SchemaClass(schemaRow, attributeList);
                schemaMap.put(schemaIdGuid, schemaClass);
                schemaLdapNameMap.put(schemaLdapName.toLowerCase(), schemaClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setAccessMaskMap() {
        stringAccessMaskMap = new HashMap();
        accessMaskMap = new Hashtable();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAccessMask", (Row)null);
            Iterator iterator = dataObject.getRows("AUDAccessMask");
            while (iterator.hasNext()) {
                Row accessMaskRow = (Row)iterator.next();
                String objectType = (String)accessMaskRow.get("OBJECT_TYPE");
                ArrayList<Properties> stringAccessMaskList = stringAccessMaskMap.get(objectType);
                if (stringAccessMaskList == null) {
                    stringAccessMaskList = new ArrayList<Properties>();
                }
                Properties properties = new Properties();
                String accessMaskString = (String)accessMaskRow.get("ACCESS_MASK");
                properties.setProperty("ACCESS_MASK", accessMaskString);
                properties.setProperty("DISPLAY_NAME", rb.getString((String)accessMaskRow.get("DISPLAY_NAME")));
                properties.setProperty("VISIBLE", accessMaskRow.get("VISIBLE").toString());
                stringAccessMaskList.add(properties);
                stringAccessMaskMap.put(objectType, stringAccessMaskList);
                Hashtable<Long, String> accessMaskTable = (Hashtable<Long, String>)accessMaskMap.get(objectType);
                if (accessMaskTable == null) {
                    accessMaskTable = new Hashtable<Long, String>();
                }
                accessMaskTable.put(Long.decode(accessMaskString), rb.getString((String)accessMaskRow.get("DISPLAY_NAME")));
                accessMaskMap.put(objectType, accessMaskTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, ArrayList> getAccessMaskMap() {
        if (stringAccessMaskMap == null) {
            SchemaAPI.setAccessMaskMap();
        }
        return stringAccessMaskMap;
    }

    public ArrayList getAccessMaskList(Long categoryId) {
        if (stringAccessMaskMap == null) {
            SchemaAPI.setAccessMaskMap();
        }
        Category category = AuditCatgoryAPI.getInstance().getCategoryObject(categoryId);
        String objectType = category.getObjectType();
        return stringAccessMaskMap.get(objectType);
    }

    public Hashtable getAccessMaskMap(String objectType) {
        if (accessMaskMap == null) {
            SchemaAPI.setAccessMaskMap();
        }
        return (Hashtable)accessMaskMap.get(objectType);
    }

    public Set<String> getSchemas() {
        return schemaMap.keySet();
    }

    public SchemaClass getSchemaClass(String schemaIdGuid) {
        if (schemaMap == null) {
            SchemaAPI.setSchemaClassMap();
        }
        return schemaMap.get(schemaIdGuid);
    }

    public SchemaClass getSchemaClassByName(String schemaIdGuid) {
        if (schemaLdapNameMap == null) {
            SchemaAPI.setSchemaClassMap();
        }
        return schemaLdapNameMap.get(schemaIdGuid);
    }

    public Attribute getAttribute(String systemIdGuid) {
        if (attributeMap == null) {
            SchemaAPI.setAttributeMap();
        }
        return attributeMap.get(systemIdGuid);
    }

    public String getAttributeCommonName(String ldapDisplayName) {
        if ((ldapDisplayName = ldapDisplayName.toLowerCase()).equalsIgnoreCase("nTSecurityDescriptor")) {
            return "NT-Security-Descriptor";
        }
        if (ldapDisplayName.equalsIgnoreCase("msExchMailboxSecurityDescriptor")) {
            return "ms-Exch-Mailbox-Security-Descriptor";
        }
        if (attributeDisplayNameMap == null) {
            SchemaAPI.setAttributeMap();
        }
        return attributeDisplayNameMap.getProperty(ldapDisplayName) != null ? attributeDisplayNameMap.getProperty(ldapDisplayName) : ldapDisplayName;
    }

    public Long getAttributeCategoryId(String commonName) {
        if (attributeCommonNameMap == null) {
            SchemaAPI.setAttributeMap();
        }
        return attributeCommonNameMap.get(commonName);
    }

    public PropertySet getPropertySetMap(String schemaIdGuid) {
        if (propertySetMap == null) {
            SchemaAPI.setPropertySetMap();
        }
        return propertySetMap.get(schemaIdGuid);
    }

    public boolean isExtendedAttribute(String rightsGuid) {
        return !propertySetRightsGuid.contains(rightsGuid);
    }

    public static void resetAttributeMap() {
        SchemaAPI.setPropertySetMap();
        SchemaAPI.setAttributeMap();
        SchemaAPI.setSchemaClassMap();
    }

    public static void updateSchemaClasses(Properties schemaProp) {
        try {
            String guid = (String)((ArrayList)schemaProp.get("schemaIDGUID")).get(0);
            guid = guid.substring(1, guid.length() - 1).toLowerCase();
            String name = (String)((ArrayList)schemaProp.get("name")).get(0);
            String cn = (String)((ArrayList)schemaProp.get("cn")).get(0);
            String ldapName = (String)((ArrayList)schemaProp.get("lDAPDisplayName")).get(0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("AUDSchemaClasses");
            row.set("SCHEMA_ID_GUID", (Object)guid);
            row.set("COMMON_NAME", (Object)name);
            row.set("COMMON_DISPLAY_NAME", (Object)cn);
            row.set("LDAP_DISPLAY_NAME", (Object)ldapName);
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            SchemaAPI.setSchemaClassMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAttributes(Properties schemaProp) {
        try {
            String guid = (String)((ArrayList)schemaProp.get("schemaIDGUID")).get(0);
            guid = guid.substring(1, guid.length() - 1).toLowerCase();
            String cn = (String)((ArrayList)schemaProp.get("cn")).get(0);
            String ldapName = (String)((ArrayList)schemaProp.get("lDAPDisplayName")).get(0);
            String rightsGuid = "771727b1-31b8-4cdf-ae62-4fe39fadf89e";
            if ((ArrayList)schemaProp.get("attributeSecurityGUID") != null) {
                rightsGuid = (String)((ArrayList)schemaProp.get("attributeSecurityGUID")).get(0);
                rightsGuid = rightsGuid.substring(1, rightsGuid.length() - 1).toLowerCase();
            }
            Row row = new Row("AUDAttributes");
            row.set("SYSTEM_ID_GUID", (Object)guid);
            row.set("COMMON_NAME", (Object)cn);
            row.set("LDAP_DISPLAY_NAME", (Object)ldapName);
            row.set("RIGHTS_GUID", (Object)rightsGuid);
            row.set("ATTRIBUTE_CATEGORY_ID", (Object)"0");
            CommonUtil.addOrUpdateRow("SYSTEM_ID_GUID", guid, row, "AUDAttributes");
            SchemaAPI.setAttributeMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setConfigurationClasses() {
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDSchemaClasses", (String)"IS_CONFIGURATION_CLASS"), (Object)true, 0);
        try {
            configurationClassList = new HashMap();
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDSchemaClasses", criteria);
            Iterator iterator = dataObject.getRows("AUDSchemaClasses");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                int configSubCategory = row.get("CONFIG_SUB_CATEGORY") == null ? 0 : (Integer)row.get("CONFIG_SUB_CATEGORY");
                ArrayList<String> classesList = configurationClassList.get(configSubCategory) == null ? new ArrayList<String>() : configurationClassList.get(configSubCategory);
                classesList.add(row.get("SCHEMA_ID_GUID").toString().toLowerCase());
                configurationClassList.put(configSubCategory, classesList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int isConfigurationClass(String classId, String idType) {
        SchemaClass schemaClass = this.getSchemaClassByName(classId.toLowerCase());
        return schemaClass != null ? this.isConfigurationClass(schemaClass.getSchemaIdGuid()) : -1;
    }

    public int isConfigurationClass(String classGuid) {
        int configClass = -1;
        if (configurationClassList == null) {
            this.setConfigurationClasses();
        }
        for (Integer integer : configurationClassList.keySet()) {
            if (!configurationClassList.get(integer).contains(classGuid)) continue;
            return integer;
        }
        return configClass;
    }
}

