/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.schema;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.schema.SchemaAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class SchemaUpdate
extends Thread {
    public static final String AUDCLASSATTRIBUTEMAP = "AUDClassAttributeMap";
    public static final String SYSTEM_ID_GUID = "SYSTEM_ID_GUID";
    public static final String SCHEMA_ID_GUID = "SCHEMA_ID_GUID";
    public static final String AUDATTRIBUTES = "AUDAttributes";
    public static final String AUDPROPERTYSETS = "AUDPropertySets";
    public static final String RIGHTS_GUID = "RIGHTS_GUID";
    public static final String COMMON_NAME = "COMMON_NAME";
    public static final String DISPLAY_NAME = "DISPLAY_NAME";
    public static final String LDAP_DISPLAY_NAME = "LDAP_DISPLAY_NAME";
    private String domainName = null;

    public SchemaUpdate(String domainName) {
        this.domainName = domainName;
    }

    @Override
    public void run() {
        try {
            this.updateSchema(this.domainName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateSchema(String domainName) {
        try {
            if (domainName != null) {
                String schemaNamingContext = DomainDetailsAPI.getSchemaNamingContext(domainName);
                Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                String ldapURL = "LDAP://" + DomainDetailsAPI.getDomainDNSName(domainName) + "/" + schemaNamingContext;
                ArrayList<String> attributeList = new ArrayList<String>();
                attributeList.add("distinguishedName");
                attributeList.add("objectGUID");
                attributeList.add("schemaIDGUID");
                DataObject attributesdataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                DataObject propSetsdataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                DataObject classAttributeMapdataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                ArrayList systemIdGuidList = this.getAttributesGuidList();
                for (String schemaClassGuid : SchemaAPI.getInstance().getSchemas()) {
                    String queryString = "(&(objectClass=classSchema)(lDAPDisplayName=" + SchemaAPI.getInstance().getSchemaClass(schemaClassGuid).getLdapDisplayName() + "))";
                    ArrayList classList = ADHandler.getObjectsWithOutListener(domainDetails, schemaNamingContext, attributeList, queryString);
                    if (!classList.isEmpty()) {
                        Properties properties = (Properties)classList.get(0);
                        ldapURL = (String)((ArrayList)properties.get("distinguishedName")).get(0);
                    }
                    Properties prop = ADHandler.getPermissions(domainName, 1L, ldapURL, "{" + schemaClassGuid + "}");
                    ArrayList extendedPermissionList = (ArrayList)prop.get("extendedPermission");
                    DataObject dataObject = SchemaUpdate.getPropertysetsDataObject();
                    this.setExendedPermissions(extendedPermissionList, systemIdGuidList, schemaClassGuid, dataObject, propSetsdataObject, attributesdataObject, classAttributeMapdataObject);
                    Properties schemaPermission = (Properties)prop.get("schemaPermission");
                    this.setSchemaPermissions(schemaPermission, systemIdGuidList, schemaClassGuid, attributesdataObject, classAttributeMapdataObject);
                }
                if (propSetsdataObject != null && !propSetsdataObject.isEmpty()) {
                    CommonUtil.getPersistence(new boolean[0]).update(propSetsdataObject);
                }
                if (attributesdataObject != null && !attributesdataObject.isEmpty()) {
                    CommonUtil.getPersistence(new boolean[0]).update(attributesdataObject);
                }
                if (classAttributeMapdataObject != null && !classAttributeMapdataObject.isEmpty()) {
                    CommonUtil.getPersistence(new boolean[0]).update(classAttributeMapdataObject);
                }
            }
            SchemaAPI.resetAttributeMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setExendedPermissions(ArrayList extendedPermissionList, ArrayList systemIdGuidList, String schemaClassGuid, DataObject dataObject, DataObject propSetsdataObject, DataObject attributesdataObject, DataObject classAttributeMapdataObject) {
        for (int i = 0; i < extendedPermissionList.size(); ++i) {
            try {
                Properties propertyProp = (Properties)extendedPermissionList.get(i);
                ArrayList rightsGuidList = (ArrayList)propertyProp.get("rightsGUID");
                String rightsGuid = (String)rightsGuidList.get(0);
                rightsGuid = rightsGuid.replace("{", "");
                rightsGuid = rightsGuid.replace("}", "");
                rightsGuid = rightsGuid.trim().toLowerCase();
                ArrayList propList = (ArrayList)propertyProp.get("properties");
                if (dataObject == null) continue;
                Criteria crit = new Criteria(Column.getColumn((String)AUDPROPERTYSETS, (String)RIGHTS_GUID), (Object)rightsGuid, 0);
                Row row = dataObject.getRow(AUDPROPERTYSETS, crit);
                if (row != null) {
                    if (propList.isEmpty()) continue;
                    this.setAttributesDataObject(systemIdGuidList, propList, attributesdataObject, rightsGuid, classAttributeMapdataObject, schemaClassGuid);
                    continue;
                }
                Criteria propCrit = new Criteria(Column.getColumn((String)AUDPROPERTYSETS, (String)RIGHTS_GUID), (Object)rightsGuid, 0);
                Row critRow = propSetsdataObject.getRow(AUDPROPERTYSETS, propCrit);
                if (critRow == null) {
                    ArrayList displayNameList = (ArrayList)propertyProp.get("displayName");
                    String displayName = (String)displayNameList.get(0);
                    ArrayList cnList = (ArrayList)propertyProp.get("cn");
                    String cn = (String)cnList.get(0);
                    Row propRow = new Row(AUDPROPERTYSETS);
                    propRow.set(RIGHTS_GUID, (Object)rightsGuid);
                    propRow.set(COMMON_NAME, (Object)cn);
                    propRow.set(DISPLAY_NAME, (Object)displayName);
                    propSetsdataObject.addRow(propRow);
                }
                if (propList.isEmpty()) continue;
                this.setAttributesDataObject(systemIdGuidList, propList, attributesdataObject, rightsGuid, classAttributeMapdataObject, schemaClassGuid);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setSchemaPermissions(Properties schemaPermission, ArrayList systemIdGuidList, String schemaClassGuid, DataObject attributesdataObject, DataObject classAttributeMapdataObject) {
        String[] propTypeArray;
        for (String propType : propTypeArray = new String[]{"mayContain", "mustContain", "systemMayContain", "systemMustContain"}) {
            try {
                ArrayList list = (ArrayList)schemaPermission.get(propType);
                if (list == null || list.isEmpty()) continue;
                this.setAttributesDataObject(systemIdGuidList, list, attributesdataObject, "771727b1-31b8-4cdf-ae62-4fe39fadf89e", classAttributeMapdataObject, schemaClassGuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getAttributeValue(Properties properties, String attributeName) {
        String attributeValue = null;
        for (Object object : (ArrayList)properties.get(attributeName)) {
            attributeValue = (String)object;
        }
        return attributeValue;
    }

    public static DataObject getPropertysetsDataObject() {
        DataObject propertyDataObject = null;
        try {
            propertyDataObject = CommonUtil.getPersistence(new boolean[0]).get(AUDPROPERTYSETS, (Criteria)null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return propertyDataObject;
    }

    public ArrayList getAttributesGuidList() {
        ArrayList<String> attributesGuidList = null;
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AUDATTRIBUTES, (Criteria)null);
            if (!dataObject.isEmpty()) {
                attributesGuidList = new ArrayList<String>();
                Iterator iterator = dataObject.getRows(AUDATTRIBUTES);
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    String systemIdGuid = (String)r.get(SYSTEM_ID_GUID);
                    attributesGuidList.add(systemIdGuid);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return attributesGuidList;
    }

    public void setAttributesDataObject(ArrayList systemIdGuidList, ArrayList propList, DataObject attributesdataObject, String rightsGuid, DataObject classAttributeMapdataObject, String schemaClassId) {
        try {
            for (int i = 0; i < propList.size(); ++i) {
                Properties attributeList = (Properties)propList.get(i);
                ArrayList schemaIdGuidList = (ArrayList)attributeList.get("schemaIDGUID");
                String schemaIdGuid = (String)schemaIdGuidList.get(0);
                schemaIdGuid = schemaIdGuid.replace("{", "");
                schemaIdGuid = schemaIdGuid.replace("}", "");
                schemaIdGuid = schemaIdGuid.trim();
                ArrayList cnList = (ArrayList)attributeList.get("cn");
                String cn = (String)cnList.get(0);
                ArrayList ldapDisplayNameList = (ArrayList)attributeList.get("ldapDisplayName");
                String ldapDisplayName = (String)ldapDisplayNameList.get(0);
                Row attributeRow = new Row(AUDATTRIBUTES);
                attributeRow.set(SYSTEM_ID_GUID, (Object)schemaIdGuid.toLowerCase());
                attributeRow.set(COMMON_NAME, (Object)cn);
                attributeRow.set(LDAP_DISPLAY_NAME, (Object)ldapDisplayName);
                attributeRow.set(RIGHTS_GUID, (Object)rightsGuid);
                Row classAttributeMapRow = new Row(AUDCLASSATTRIBUTEMAP);
                schemaClassId = schemaClassId.replace("{", "");
                schemaClassId = schemaClassId.replace("}", "");
                schemaClassId = schemaClassId.trim();
                classAttributeMapRow.set(SYSTEM_ID_GUID, (Object)schemaIdGuid.toLowerCase());
                classAttributeMapRow.set(SCHEMA_ID_GUID, (Object)schemaClassId);
                if (systemIdGuidList != null && !systemIdGuidList.contains(schemaIdGuid.toLowerCase())) {
                    systemIdGuidList.add(schemaIdGuid.toLowerCase());
                    attributesdataObject.addRow(attributeRow);
                }
                boolean b = SchemaUpdate.getBooleanValue(schemaClassId, schemaIdGuid.toLowerCase());
                Criteria crit = new Criteria(Column.getColumn((String)AUDCLASSATTRIBUTEMAP, (String)SYSTEM_ID_GUID), (Object)schemaIdGuid.toLowerCase(), 0);
                crit = crit.and(new Criteria(Column.getColumn((String)AUDCLASSATTRIBUTEMAP, (String)SCHEMA_ID_GUID), (Object)schemaClassId, 0));
                Row critRow = classAttributeMapdataObject.getRow(AUDCLASSATTRIBUTEMAP, crit);
                if (b || critRow != null) continue;
                classAttributeMapdataObject.addRow(classAttributeMapRow);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean getBooleanValue(String schemaIdGuid, String systemIdGuid) {
        boolean returnVal = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)AUDCLASSATTRIBUTEMAP, (String)SYSTEM_ID_GUID), (Object)systemIdGuid, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)AUDCLASSATTRIBUTEMAP, (String)SCHEMA_ID_GUID), (Object)schemaIdGuid, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AUDCLASSATTRIBUTEMAP, crit);
            returnVal = !dataObject.isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnVal;
    }
}

