/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sql;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;

public class ADAPSQLQueryUtil {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static final Pattern TABLE_NAME_PATTERN = Pattern.compile("\\$\\{TABLE:([^\\}]*)\\}");
    public static final Pattern QUERY_PATTERN = Pattern.compile("\\$\\{adap.AUDSQLQuery.sql_string.([^\\}]*)\\}");
    public static final String FUNCTION_PATTERN_STRING = "\\$\\{PATTERNREPLACE:([^\\}]*)\\}";
    public static final Pattern FUNCTION_PATTERN = Pattern.compile("\\$\\{PATTERNREPLACE:([^\\}]*)\\}");
    public static final String OBJECT_PATTERN_STRING = "\\$\\{OBJECTREPLACE:(.*?)}\\}";
    public static final Pattern OBJECT_PATTERN = Pattern.compile("\\$\\{OBJECTREPLACE:(.*?)}\\}");
    public static final String FILE_OBJECT_PATTERN_STRING = "\\$\\{SHAREREPLACE:(.*?)\\}";
    public static final Pattern FILE_OBJECT_PATTERN = Pattern.compile("\\$\\{SHAREREPLACE:(.*?)\\}");
    public static final String COLUMNALIAS = "COLUMNALIAS";
    public static final String TABLEALIAS = "TABLEALIAS";
    public static final String AUDUNIONQUERY = "AUDUnionQuery";
    public static final String AUDSQLQUERY = "AUDSQLQuery";
    public static final String QUERY_ID = "QUERY_ID";
    public static final String SQL_STRING = "SQL_STRING";
    public static final String COUNT_SQL_STRING = "COUNT_SQL_STRING";
    public static final String GROUPBYUSED = "GROUPBYUSED";
    public static final String GROUP_BY = "GROUP_BY";
    public static final String UNION_USED = "UNION_USED";
    public static final String UNION_COUNT_QUERY = "UNION_COUNT_QUERY";
    private static HashMap compareStringMap = null;

    public static ArrayList getUnionQueries(Long queryId, String queryColumn) {
        ArrayList<Object> unionQueryList = new ArrayList<Object>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)AUDUNIONQUERY, (String)QUERY_ID), (Object)queryId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AUDUNIONQUERY, criteria);
            Iterator iterator = dataObject.getRows(AUDUNIONQUERY);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (unionQueryList.contains(row.get(queryColumn))) continue;
                unionQueryList.add(row.get(queryColumn));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unionQueryList;
    }

    public static String getSQLUnionQuery(Long queryId, String queryColumn, HashMap inputParamsMap, String searchCriteria) {
        String unionQuery = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)AUDUNIONQUERY, (String)QUERY_ID), (Object)queryId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AUDUNIONQUERY, criteria);
            ArrayList inputList = (ArrayList)inputParamsMap.get("inputParams");
            Iterator iterator = dataObject.getRows(AUDUNIONQUERY);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                for (int i = 0; i < inputList.size(); ++i) {
                    HashMap inputMap = (HashMap)inputList.get(i);
                    if (i > 0) {
                        unionQuery = unionQuery + " UNION ALL ";
                    }
                    unionQuery = unionQuery + row.get(queryColumn);
                    unionQuery = unionQuery.replace("${TABLENAME}", (CharSequence)inputMap.get("tableName"));
                    unionQuery = unionQuery.replace("${FROM}", (CharSequence)inputMap.get("from"));
                    unionQuery = unionQuery.replace("${TO}", (CharSequence)inputMap.get("to"));
                    unionQuery = unionQuery.replace("${SCRITERIA}", searchCriteria);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unionQuery;
    }

    public static String removeCharSequence(String constructedSQL, String[] tobeRemovedCharSeq) {
        for (String string : tobeRemovedCharSeq) {
            constructedSQL = constructedSQL.replace(string, "");
        }
        return constructedSQL;
    }

    public static String getLimitValue(Integer startIndex, Integer noOfObjects) {
        StringBuilder limitString = new StringBuilder();
        try {
            limitString.append(" LIMIT ");
            limitString.append(noOfObjects);
            limitString.append(" OFFSET ");
            limitString.append(startIndex - 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return limitString.toString();
    }

    public static String getVisibleColumnQueryString(Long cvId) {
        String columnString = null;
        try {
            columnString = "";
            Boolean visible = true;
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, visible);
            for (Object object : columnList) {
                HashMap columnDetailsMap = (HashMap)object;
                if (!columnString.equals("")) {
                    columnString = columnString + ", ";
                }
                columnString = columnString + ADAPSQLQueryUtil.getColumnQueryString(columnDetailsMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (columnString == null) {
            columnString = "*";
        }
        return columnString;
    }

    public static String getColumnQueryString(HashMap columnDetailsMap) {
        String colStr = "";
        try {
            String tableAlias = (String)columnDetailsMap.get(TABLEALIAS);
            String columnAlias = (String)columnDetailsMap.get(COLUMNALIAS);
            if (tableAlias != null) {
                colStr = tableAlias + ".";
            }
            colStr = colStr + columnAlias;
            colStr = colStr + " as " + columnAlias;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colStr;
    }

    public static String getGroupByString(String groupByValue) throws Exception {
        StringBuilder str = new StringBuilder();
        str.append("COUNT(DISTINCT ");
        String[] token = groupByValue.split(",");
        for (int i = 0; i < token.length; ++i) {
            if (i > 0) {
                str.append("+");
            }
            str.append(token[i]);
        }
        str.append(")");
        return str.toString();
    }

    public static HashMap getInputParamsMap(Long noOfDays, String domainName) throws Exception {
        HashMap<String, String> inputParamsMap = new HashMap<String, String>();
        Long toTime = System.currentTimeMillis() / 1000L;
        Long fromTime = TimeUtil.getFromTime(noOfDays, toTime);
        String domainDNSName = DomainDetailsAPI.getDomainDNSName(domainName);
        String domainFlatName = DomainDetailsAPI.getDomainFlatName(domainName, true);
        inputParamsMap.put("FROM", fromTime.toString());
        inputParamsMap.put("TO", toTime.toString());
        inputParamsMap.put("domainFlatName", domainFlatName);
        inputParamsMap.put("domainDNSName", domainDNSName);
        return inputParamsMap;
    }

    public static String getXColumnValue(String xColumnValue, String inputElement, String graphType) {
        String criteria = null;
        String mColumnVal = null;
        String[] str = null;
        try {
            SimpleDateFormat sdf;
            Date date;
            if (xColumnValue.indexOf(";;;") != -1) {
                String[] tempStr = xColumnValue.split(";;;");
                String[] tempVal = inputElement.split(";;;");
                mColumnVal = tempStr[1] + " = '" + tempVal[1] + "'";
                xColumnValue = tempStr[0];
                inputElement = tempVal[0];
            } else if (inputElement.indexOf(";;;") != -1) {
                inputElement = inputElement.split(";;;")[0];
            }
            if (xColumnValue.equals("HOUR(FROM_UNIXTIME(TIME_GENERATED))") || xColumnValue.contains("DATEPART") && xColumnValue.contains("DATEADD") && xColumnValue.contains("HH") || xColumnValue.contains("DATE_PART") || xColumnValue.contains("TO_CHAR") && xColumnValue.contains("HH")) {
                if (graphType != null && (graphType.equalsIgnoreCase("verticalbar3d") || graphType.equalsIgnoreCase("line"))) {
                    criteria = xColumnValue + " ='" + inputElement + "'";
                } else {
                    Integer hour = null;
                    if (inputElement.contains("E")) {
                        date = new Date(ADAPSQLQueryUtil.bigDecimalToLong(inputElement));
                        hour = date.getHours();
                    } else {
                        hour = Integer.valueOf(inputElement);
                    }
                    criteria = xColumnValue.contains("TO_CHAR") ? xColumnValue + " ='" + (hour < 10 ? "0" + hour : hour) + "'" : xColumnValue + " =" + hour;
                }
            } else if (xColumnValue.contains("DATE_FORMAT") || xColumnValue.contains("convert") && xColumnValue.contains("DATEADD") && xColumnValue.contains("106") || xColumnValue.contains("TO_CHAR") && xColumnValue.contains("DD Mon YY")) {
                sdf = new SimpleDateFormat("dd MMM yy", new Locale("en", "US"));
                date = new Date();
                if (graphType.equalsIgnoreCase("timeseries")) {
                    try {
                        date = new Date(ADAPSQLQueryUtil.bigDecimalToLong(inputElement));
                    }
                    catch (NumberFormatException ex) {
                        date = sdf.parse(inputElement);
                    }
                } else {
                    date = sdf.parse(inputElement);
                }
                Long from = date.getTime() / 1000L;
                date.setHours(23);
                date.setMinutes(59);
                date.setSeconds(59);
                Long to = date.getTime() / 1000L;
                criteria = " TIME_GENERATED BETWEEN " + from + " AND " + to;
            } else if (xColumnValue.equals("FROM_UNIXTIME(TIME_GENERATED)") || xColumnValue.contains("convert") && xColumnValue.contains("DATEADD") && xColumnValue.contains("120")) {
                BigDecimal bigDecimal = new BigDecimal(inputElement);
                date = new Date(bigDecimal.longValue());
                Long from = date.getTime() / 1000L;
                date.setHours(23);
                date.setMinutes(59);
                date.setSeconds(59);
                Long to = date.getTime() / 1000L;
                criteria = " TIME_GENERATED BETWEEN " + from + " AND " + to;
            } else if (xColumnValue.equalsIgnoreCase("TIME_GENERATED,REMARKS")) {
                str = inputElement.split(";;");
                sdf = new SimpleDateFormat("dd MMM yy", new Locale("en", "US"));
                date = sdf.parse(str[0]);
                Long from = date.getTime() / 1000L;
                date.setHours(23);
                date.setMinutes(59);
                date.setSeconds(59);
                Long to = date.getTime() / 1000L;
                criteria = " TIME_GENERATED BETWEEN " + from + " AND " + to + " AND REMARKS ='" + str[1] + "'";
            } else if (xColumnValue.equalsIgnoreCase("USERNAME,EVENT_TYPE_TEXT")) {
                str = inputElement.split(";;");
                criteria = " USERNAME = '" + str[0] + "' AND EVENT_TYPE_TEXT LIKE '%" + str[1] + "%'";
            } else if (graphType.indexOf("stacked") != -1) {
                String[] columnNames = xColumnValue.split(",");
                String[] inputValues = inputElement.split(";;");
                criteria = columnNames[0] + " = '" + inputValues[0] + "' AND  " + columnNames[1] + " = '" + inputValues[1] + "'";
            } else {
                criteria = xColumnValue + " = '" + inputElement + "'";
            }
            if (mColumnVal != null) {
                criteria = criteria + " AND " + mColumnVal;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteria;
    }

    public static String getUnionQueryStackedBarChart(String compareString, String compareVal, Long queryId) {
        String sqlString = null;
        try {
            Table baseTable = Table.getTable((String)AUDUNIONQUERY);
            Table joinTable = Table.getTable((String)"AUDStackedGraphQueryMapping");
            Table joinTable1 = Table.getTable((String)AUDSQLQUERY);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable1, new String[]{QUERY_ID}, new String[]{QUERY_ID}, 2);
            Join join1 = new Join(baseTable, joinTable, new String[]{"UNION_QUERY_ID"}, new String[]{"UNION_QUERY_ID"}, 2);
            Criteria criteria = new Criteria(Column.getColumn((String)AUDSQLQUERY, (String)QUERY_ID), (Object)queryId, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDStackedGraphQueryMapping", (String)"MAPPING_STRING"), (Object)ADAPSQLQueryUtil.getCompareString(compareString), 0));
            Column col = Column.getColumn((String)AUDUNIONQUERY, (String)"*");
            query.addJoin(join);
            query.addJoin(join1);
            query.setCriteria(criteria);
            query.addSelectColumn(col);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Row row = dataObj.getRow(AUDUNIONQUERY);
            if (row != null) {
                if (compareVal.equals("countString")) {
                    sqlString = (String)row.get(UNION_COUNT_QUERY);
                } else if (compareVal.equals("sqlString")) {
                    sqlString = (String)row.get("UNION_QUERY");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sqlString;
    }

    private static void getCompareString() {
        try {
            compareStringMap = new HashMap();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDStackedGraphQueryMapping"));
            query.addSelectColumn(Column.getColumn((String)"AUDStackedGraphQueryMapping", (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows("AUDStackedGraphQueryMapping");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    compareStringMap.put(rb.getString((String)row.get("MAPPING_STRING")).trim(), (String)row.get("MAPPING_STRING"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getCompareString(String compareString) throws Exception {
        String compStrFromDB = compareString;
        if (compareStringMap == null) {
            ADAPSQLQueryUtil.getCompareString();
        }
        compStrFromDB = (String)compareStringMap.get(compareString.trim());
        return compStrFromDB;
    }

    public static Properties getFunctionPattern(String columnName) {
        Properties properties = new Properties();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDSQLQueryColumnPattern", (Row)null);
            Iterator rowIterator = dataObject.getRows("AUDSQLQueryColumnPattern");
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                properties.setProperty(row.get("PATTERN_NAME").toString(), row.get(columnName).toString());
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String formString(String[] str) throws Exception {
        StringBuilder strBuilder = new StringBuilder();
        for (String string : str) {
            strBuilder.append(string);
        }
        return strBuilder.toString();
    }

    private static Long bigDecimalToLong(String inputElement) throws Exception {
        BigDecimal bigDecimal = new BigDecimal(inputElement);
        return bigDecimal.longValue();
    }

    static {
        ADAPSQLQueryUtil.getCompareString();
    }
}

