/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sql;

import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.util.MoveRecreateTableHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.MssqlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DumpFileToDB
extends Thread {
    static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger("ReportLogger");
    private static final String TEMP_ERROR_INFO = "SQLErrTempFileDetails";
    public static ArrayList<String> tempFileList = new ArrayList();
    private static ArrayList<String> errTmpFileList = new ArrayList();
    private static ArrayList<String> metaTableList = null;
    private static String dbName = CommonUtil.getDBServerName();
    private HashMap<String, Integer> tableRowCountMap = null;
    private static volatile DumpFileToDB dumpFileToDB = null;
    private Properties tableColumnsList = null;
    public static String[] metaTables = new String[]{"AUDLogonInfo", "AUDAccountCreation", "AUDADFSLogonLogoffInfo", "AUDADFSLogonLogoffInfo_0", "AUDUserMgmt", "AUDGroupMgmt", "AUDComputerMgmt", "AUDPolicyChange", "AUDOUMgmt", "AUDGPOMgmt", "AUDLogonLogoffInfo", "AUDFileAuditInfo", "AUDComputerAuditInfo", "AUDNPSAuditInfo", "AUDFileIntegrityMonitor", "AUDDNSAuditInfo", "AUDADOAuditInfo", "Owa_Activesync", "AUDLogonInfo_0", "AUDAccountCreation_0", "AUDUserMgmt_0", "AUDGroupMgmt_0", "AUDComputerMgmt_0", "AUDPolicyChange_0", "AUDOUMgmt_0", "AUDGPOMgmt_0", "AUDLogonLogoffInfo_0", "AUDFileAuditInfo_0", "AUDComputerAuditInfo_0", "AUDNPSAuditInfo_0", "AUDFileIntegrityMonitor_0", "AUDDNSAuditInfo_0", "AUDADOAuditInfo_0"};
    public static String[] dataTables = new String[]{"AUDLogonInfo_0", "AUDAccountCreation_0", "AUDUserMgmt_0", "AUDGroupMgmt_0", "AUDComputerMgmt_0", "AUDADFSLogonLogoffInfo", "AUDADFSLogonLogoffInfo_0", "AUDPolicyChange_0", "AUDOUMgmt_0", "AUDGPOMgmt_0", "AUDLogonLogoffInfo_0", "AUDFileAuditInfo_0", "AUDComputerAuditInfo_0", "AUDNPSAuditInfo_0", "AUDFolderACLValues", "AUDFolderACLChanges", "AUDACLVALUES", "AUDFIMFolderACLValues", "AUDFIMFolderACLChanges", "AUDFileIntegrityMonitor_0", "AUDDNSAuditInfo_0", "AUDADOAuditInfo_0", "ADAPUserAuditInfo", "SQLErrTempFileDetails", "AUDLogonInfo", "AUDAccountCreation", "AUDUserMgmt", "AUDGroupMgmt", "AUDComputerMgmt", "AUDPolicyChange", "AUDOUMgmt", "AUDGPOMgmt", "AUDLogonLogoffInfo", "AUDFileAuditInfo", "AUDComputerAuditInfo", "AUDNPSAuditInfo", "AUDFolderACLValues", "AUDFolderACLChanges", "AUDACLVALUES", "AUDFIMFolderACLValues", "AUDFIMFolderACLChanges", "AUDFileIntegrityMonitor", "AUDDNSAuditInfo", "AUDADOAuditInfo", "AUDACLChanges", "AUDUserMgmtCrunch", "AUDComputerMgmtCrunch", "AUDGroupMgmtCrunch", "AUDOUMgmtCrunch", "AUDGPOMgmtCrunch", "AUDDNSAuditInfoCrunch", "AUDADOAuditInfoCrunch", "UserLogonFailuresCrunch", "MachineLogonFailuresCrunch", "ReasonLogonFailuresCrunch", "UserLogonSuccessCrunch", "MachineLogonSuccessCrunch", "LocalLogonSourceCrunch", "LocalLogonUserCrunch"};

    private DumpFileToDB() {
        super("DumpTmpFileToDB");
        logger.log(Level.INFO, "Starting DumpFileToDB Thread");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DumpFileToDB getInstance() {
        if (dumpFileToDB != null) return dumpFileToDB;
        Class<DumpFileToDB> clazz = DumpFileToDB.class;
        synchronized (DumpFileToDB.class) {
            if (dumpFileToDB != null) return dumpFileToDB;
            dumpFileToDB = new DumpFileToDB();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dumpFileToDB;
        }
    }

    @Override
    public void run() {
        this.tableRowCountMap = this.getTableRowCountMap();
        this.tableColumnsList = new Properties();
        metaTableList = new ArrayList();
        for (String tableName : metaTables) {
            metaTableList.add(tableName);
        }
        this.readTmpFileList();
        try {
            while (Boolean.TRUE.booleanValue()) {
                this.process();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        block14: {
            try {
                if (!tempFileList.isEmpty()) {
                    String tempFileName = this.getTempFileList();
                    String tableName = "";
                    tableName = tempFileName.contains("_0_") ? tempFileName.substring(0, tempFileName.indexOf("0_") + 1) : tempFileName.substring(0, tempFileName.lastIndexOf("_"));
                    if (metaTableList.contains(tableName) && this.tableRowCountMap.get(tableName) != null && this.tableRowCountMap.get(tableName) > 500000) {
                        logger.log(Level.INFO, "Moving table" + tableName + " Size:" + this.tableRowCountMap.get(tableName));
                        MoveRecreateTableHandler.getInstance().moveRecreateTable(tableName);
                        this.setTableRowCount(tableName, 0);
                    }
                    String dirName = System.getProperty("server.home") + File.separator + "temp";
                    tempFileName = dirName + File.separator + tempFileName;
                    this.dumpToDatabase(tableName, tempFileName);
                    ArrayList<String> arrayList = tempFileList;
                    synchronized (arrayList) {
                        tempFileList.remove(0);
                        break block14;
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                try {
                    ArrayList<String> tableName = tempFileList;
                    synchronized (tableName) {
                        tempFileList.remove(0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ex.printStackTrace();
            }
        }
    }

    public static synchronized void setTempFileList(String fileName) {
        tempFileList.add(fileName);
    }

    public String getTempFileList() {
        return tempFileList.get(0);
    }

    public int getTableRowCount(String tableName) {
        return this.tableRowCountMap.get(tableName);
    }

    public void setTableRowCount(String tableName, int newCount) {
        this.tableRowCountMap.put(tableName, newCount);
    }

    private void readTmpFileList() {
        try {
            File[] listOfTmpFiles;
            DumpFileToDB.getErrorTempFileLists();
            File tmpFolder = new File(System.getProperty("server.home") + File.separator + "temp" + File.separator);
            block2: for (File listOfTmpFile : listOfTmpFiles = tmpFolder.listFiles()) {
                String tmpFile = listOfTmpFile.getName();
                for (String tableName : dataTables) {
                    if (!tmpFile.startsWith(tableName) || errTmpFileList.contains(tmpFile)) continue;
                    DumpFileToDB.setTempFileList(tmpFile);
                    continue block2;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getTableColumnList(String tableName) {
        String columnOrder = null;
        try {
            columnOrder = this.tableColumnsList.getProperty(tableName);
            if (columnOrder == null) {
                TableDefinition tableDefinition = MetaDataUtil.getTableDefinitionByName((String)tableName);
                ArrayList columns = (ArrayList)tableDefinition.getColumnNames();
                for (int i = 0; i < columns.size(); ++i) {
                    String columnName = (String)columns.get(i);
                    columnOrder = columnOrder == null ? "" : columnOrder + ",";
                    columnOrder = columnOrder + columnName;
                }
                this.tableColumnsList.setProperty(tableName, columnOrder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnOrder;
    }

    public HashMap<String, Integer> getTableRowCountMap() {
        HashMap<String, Integer> tempTableRowCountMap = new HashMap<String, Integer>();
        for (String tableName : metaTables) {
            Integer tableRowCount = MoveRecreateTableHandler.getInstance().getRowCount(tableName);
            logger.log(Level.INFO, "Initing Count for Table [{0}]. Count is [{1}] ", new Object[]{tableName, tableRowCount});
            tempTableRowCountMap.put(tableName, tableRowCount);
        }
        logger.log(Level.INFO, "tableRowCountMap:" + tempTableRowCountMap);
        return tempTableRowCountMap;
    }

    private void dumpToDatabase(String tableName, String tmpFileName) {
        if (tmpFileName != null) {
            try {
                File tmpFile = new File(tmpFileName);
                Integer size = 0;
                String columnOrder = this.getTableColumnList(tableName);
                String filePath = tmpFile.getCanonicalPath();
                filePath = filePath.replace('\\', '/');
                String sql = null;
                Hashtable errorTable = null;
                if (dbName != null && dbName.equalsIgnoreCase("mssql")) {
                    MssqlUtil.getInstance();
                    sql = MssqlUtil.getInsertQuery(tableName, filePath);
                    errorTable = DumpFileToDB.executeCommand(sql, tmpFileName, tableName);
                    if (((Boolean)errorTable.get("isS0002")).booleanValue() && tableName.indexOf("Crunch") == -1) {
                        logger.log(Level.WARNING, "isS0002 confirm,Table {0} is missing", new Object[]{tableName});
                        MoveRecreateTableHandler.getInstance().createTable(tableName);
                        errorTable = DumpFileToDB.executeCommand(sql, tmpFileName, tableName);
                    }
                    if (((Boolean)errorTable.get("Error")).booleanValue()) {
                        DumpFileToDB.addErrToTable((String)errorTable.get("ErrorString"), tmpFileName);
                        logger.log(Level.INFO, "Temp filename  : " + tmpFileName);
                        throw new Exception(rb.getString("adap.common.bcp_dumpfiletodb"));
                    }
                } else if (dbName != null && dbName.equalsIgnoreCase("mysql")) {
                    sql = "LOAD DATA INFILE '" + filePath + "' REPLACE INTO TABLE " + tableName + " FIELDS TERMINATED BY '^' OPTIONALLY ENCLOSED BY '\"' lines terminated by '\r\n'  (" + columnOrder + ")";
                    size = QueryUtil.executeUpdate("Loading File :" + tmpFileName, sql);
                } else {
                    logger.log(Level.FINE, "Insert into PostgreSQL DB ");
                    sql = "COPY " + tableName + " (" + columnOrder + ") from '" + filePath + "' DELIMITER '^' NULL AS '' csv escape '\"'";
                    if (tmpFileName.endsWith(".txt")) {
                        sql = "COPY " + tableName + " (" + columnOrder + ") from '" + filePath + "' NULL AS ''";
                    }
                    size = QueryUtil.copyDataToDB(tableName, columnOrder, filePath);
                }
                this.deleteFile(tableName, tmpFileName);
                if (metaTableList.contains(tableName)) {
                    if (dbName != null && dbName.equalsIgnoreCase("mssql")) {
                        size = errorTable == null || errorTable.get("Count") == null ? MoveRecreateTableHandler.getInstance().getRowCount(tableName) : (Integer)errorTable.get("Count");
                    }
                    if (size > 0) {
                        int rowsCount = this.getTableRowCount(tableName);
                        this.setTableRowCount(tableName, rowsCount + size);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception while loading data to table" + tableName + " : filepath" + tmpFileName);
                String message = e.getMessage();
                this.chkExAndRecreateTable(message, tableName);
            }
        }
    }

    private void deleteFile(String tableName, String tmpFileName) {
        try {
            if (tmpFileName == null) {
                return;
            }
            File tmpFile = new File(tmpFileName);
            tmpFile.delete();
            tmpFile = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void chkExAndRecreateTable(String message, String tableName) {
        String patternStr = ".*Table.*'adap.([a-z]*)'.*doesn't.*exist";
        if (dbName.equalsIgnoreCase("postgres")) {
            patternStr = ".*relation.*\"([a-z]*)\".*does not.*exist";
        } else if (dbName.equalsIgnoreCase("mssql")) {
            patternStr = ".*object.*\"([a-z]*)\".*does not.*exist";
        }
        Pattern tableNotFoundPattern = Pattern.compile(patternStr);
        Matcher match = tableNotFoundPattern.matcher(message);
        if (match.find()) {
            logger.log(Level.WARNING, "Table {0} is missing", new Object[]{tableName});
            MoveRecreateTableHandler.getInstance().createTable(tableName);
        }
    }

    public static Hashtable executeCommand(String command, String tempFileName, String tableName) throws Exception {
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = null;
        boolean error = false;
        boolean isS0002 = false;
        String errorStr = "";
        Hashtable<String, Object> errorTable = new Hashtable<String, Object>();
        while ((line = bufReader.readLine()) != null) {
            if (line.toUpperCase().contains(rb.getString("adap.common.bcp_ERROR"))) {
                error = true;
                logger.log(Level.INFO, "BCP Return line in DumpFileToDB " + line);
                if (line.contains("S0002") || line.contains("42S02")) {
                    isS0002 = true;
                }
                errorStr = errorStr + line + "\n";
                continue;
            }
            if (!line.contains("rows copied")) continue;
            errorTable.put("Count", Integer.parseInt(line.substring(0, line.indexOf("rows")).trim()));
        }
        errorTable.put("Error", error);
        errorTable.put("isS0002", isS0002);
        errorTable.put("ErrorString", errorStr);
        bufReader.close();
        p.waitFor();
        return errorTable;
    }

    public static void addErrToTable(String errorStr, String tempFileName) {
        try {
            Row row = new Row(TEMP_ERROR_INFO);
            String fileName = new File(tempFileName).getName();
            row.set("FILE_NAME", (Object)fileName);
            row.set("PROCESSING_TIME", (Object)(System.currentTimeMillis() / 1000L));
            row.set("ERROR_DETAILS", (Object)errorStr);
            errTmpFileList.add(fileName);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Problem adding error details for the file : " + tempFileName);
        }
    }

    private static void getErrorTempFileLists() {
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(TEMP_ERROR_INFO, (Criteria)null);
            if (!dObj.isEmpty()) {
                Iterator iter = dObj.getRows(TEMP_ERROR_INFO);
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    errTmpFileList.add((String)row.get("FILE_NAME"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ArrayList<String> getMetaTableList() {
        Object con = null;
        Object dataSet = null;
        ArrayList<String> metaTableList = new ArrayList<String>();
        return metaTableList;
    }

    public void updateMetaTableList() {
        try {
            metaTableList = DumpFileToDB.getMetaTableList();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

