/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sql;

import com.adventnet.db.persistence.SequenceGenerator;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.SequenceGeneratorRepository;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.ntfs.NTFSTableUtil;
import com.adventnet.sym.adsm.common.server.sql.DumpFileToDB;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileWriterObject
extends Thread {
    private static Logger logger = Logger.getLogger("ReportLogger");
    private Hashtable<String, ArrayList> filePropTable = null;
    private boolean shutDown = false;
    private Hashtable<String, ArrayList<ColumnDefinition>> tableVsUVHKeys = null;
    private Properties tableVsColumnsList = null;
    private static volatile FileWriterObject fileWriterObject = null;
    private static String dbName = CommonUtil.getDBServerName();
    private static Hashtable dcEventCountTable = new Hashtable();
    private Hashtable<String, Boolean> tableRunningStatus = new Hashtable();

    public FileWriterObject() {
        super.setName("FileWriterObject");
        this.filePropTable = new Hashtable();
        this.tableVsColumnsList = new Properties();
        this.tableVsUVHKeys = new Hashtable();
        this.tableRunningStatus = new Hashtable();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileWriterObject getInstance() {
        if (fileWriterObject != null) return fileWriterObject;
        Class<FileWriterObject> clazz = FileWriterObject.class;
        synchronized (FileWriterObject.class) {
            if (fileWriterObject != null) return fileWriterObject;
            fileWriterObject = new FileWriterObject();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fileWriterObject;
        }
    }

    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public boolean isShutDown() {
        return this.shutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRows(ArrayList<Row> rowList, String domainName, Boolean isEvntCollector) {
        HashMap<String, Integer> tableCountMap = new HashMap<String, Integer>();
        Hashtable<String, ArrayList> hashtable = this.filePropTable;
        synchronized (hashtable) {
            for (Row object : rowList) {
                Row eventRow = object;
                String tableName = eventRow.getTableName();
                ArrayList<Row> list = this.filePropTable.get(tableName);
                if (list == null) {
                    list = new ArrayList<Row>();
                    this.filePropTable.put(tableName, list);
                }
                list.add(eventRow);
                tableCountMap.put(tableName, list.size());
                if (eventRow.getTableName().contains("ACL") || domainName == null || isEvntCollector.booleanValue() || (Long)eventRow.get("MONITOR_ID") == 0L || eventRow.getTableName().contains("_0")) continue;
                Hashtable domainHashtable = (Hashtable)dcEventCountTable.get(domainName);
                if (domainHashtable == null) {
                    domainHashtable = new Hashtable();
                }
                String source = (String)eventRow.get("SOURCE");
                Hashtable<String, Object> timeRecordNumberTable = (Hashtable<String, Object>)domainHashtable.get(source);
                Long timeGenerated = (Long)eventRow.get("TIME_GENERATED");
                if (timeRecordNumberTable == null) {
                    timeRecordNumberTable = new Hashtable<String, Object>();
                    timeRecordNumberTable.put("TIME_GENERATED", timeGenerated);
                    timeRecordNumberTable.put("RECORD_NUMBER", eventRow.get("RECORD_NUMBER"));
                } else {
                    Long time = (Long)timeRecordNumberTable.get("TIME_GENERATED");
                    if (timeGenerated > time) {
                        timeRecordNumberTable.put("TIME_GENERATED", timeGenerated);
                        timeRecordNumberTable.put("RECORD_NUMBER", eventRow.get("RECORD_NUMBER"));
                    }
                }
                domainHashtable.put(source, timeRecordNumberTable);
                dcEventCountTable.put(domainName, domainHashtable);
            }
        }
        Set set = tableCountMap.keySet();
        for (String tableName : set) {
            Integer tableSize = (Integer)tableCountMap.get(tableName);
            if (tableSize <= 1000) continue;
            this.process(tableName);
        }
    }

    public void dumpRows(String tableName, ArrayList rowList) {
        String fileName = this.writeData(tableName, rowList);
        if (fileName != null) {
            DumpFileToDB.setTempFileList(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeData(String tableName, ArrayList list) {
        String fileName;
        block36: {
            fileName = null;
            int size = list.size();
            PrintWriter writer = null;
            FileOutputStream fStream = null;
            try {
                String dirName = System.getProperty("server.home") + File.separator + "temp";
                File dir = new File(dirName);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                Object delimiter = new Character('^');
                String charSetStr = System.getProperty("file.encoding");
                fileName = tableName + "_" + System.currentTimeMillis() + ".csv";
                if (dbName.equalsIgnoreCase("mssql")) {
                    charSetStr = "UTF-16LE";
                    delimiter = new String("|**|");
                    fileName = tableName + "_" + System.currentTimeMillis() + ".txt";
                }
                String fileLocation = dirName + File.separator + fileName;
                fStream = new FileOutputStream(fileLocation, false);
                OutputStreamWriter oStreamWriter = new OutputStreamWriter((OutputStream)fStream, charSetStr);
                writer = delimiter instanceof Character ? new CsvWriter((Writer)oStreamWriter, ((Character)delimiter).charValue()) : new PrintWriter((Writer)oStreamWriter, false);
                TableDefinition tableDefinition = MetaDataUtil.getTableDefinitionByName((String)tableName);
                ArrayList columns = (ArrayList)tableDefinition.getColumnNames();
                logger.log(Level.FINE, "{0} Rows inserted into table {1}", new Object[]{list.size(), tableName});
                for (int i = 0; i < list.size(); ++i) {
                    int j;
                    StringBuffer strVal = new StringBuffer();
                    Object obj = list.get(i);
                    if (obj != null && obj instanceof Row) {
                        Row r = (Row)obj;
                        for (j = 0; j < columns.size(); ++j) {
                            String columnName = (String)columns.get(j);
                            ColumnDefinition coldefn = tableDefinition.getColumnDefinitionByName(columnName);
                            Object columnValue = r.get(columnName);
                            String dataType = coldefn.getDataType();
                            if (coldefn.getUniqueValueGeneration() != null) {
                                DataAccess.generateValues((Row)r);
                            }
                            strVal = delimiter instanceof String && j > 0 ? strVal.append(delimiter) : new StringBuffer();
                            if (columnValue != null) {
                                strVal = columnValue instanceof UniqueValueHolder ? strVal.append(((UniqueValueHolder)columnValue).getValue().toString()) : (dataType.equalsIgnoreCase("BIGINT") && columnValue instanceof String ? strVal.append(columnValue.toString()) : strVal.append(columnValue.toString()));
                                if (delimiter instanceof Character && dbName != null && dbName.equalsIgnoreCase("mysql")) {
                                    String replaceVal = strVal.toString().replaceAll("\\\\", "\\\\\\\\");
                                    strVal = new StringBuffer(replaceVal);
                                }
                            } else {
                                strVal = strVal.append("");
                            }
                            if (!(delimiter instanceof Character)) continue;
                            ((CsvWriter)writer).write(strVal.toString());
                        }
                    } else if (obj instanceof Properties) {
                        Properties properties = (Properties)obj;
                        for (j = 0; j < NTFSTableUtil.folderDetailscolumnNames.length; ++j) {
                            strVal = delimiter instanceof String && j > 0 ? strVal.append(delimiter) : new StringBuffer();
                            String nativeProp = NTFSTableUtil.folderDetailsNativeProp[j];
                            if (NTFSTableUtil.folderDetailscolumnNames[j].equalsIgnoreCase("FILE_ID")) {
                                ColumnDefinition uvhColumnDefinition = tableDefinition.getColumnDefinitionByName("FILE_ID");
                                String uniqueId = FileWriterObject.generateValue(uvhColumnDefinition.getUniqueValueGeneration().getGeneratorName(), tableDefinition);
                                if (uniqueId != null) {
                                    strVal = strVal.append(uniqueId);
                                    if (delimiter instanceof String) {
                                        strVal = strVal.append(delimiter);
                                    }
                                }
                            } else {
                                ArrayList propList = (ArrayList)properties.get(nativeProp);
                                String propVal = null;
                                if (propList != null && !propList.isEmpty()) {
                                    propVal = (String)propList.get(0);
                                }
                                if (propVal == null) {
                                    ColumnDefinition columnDefinition = tableDefinition.getColumnDefinitionByName(NTFSTableUtil.folderDetailscolumnNames[j]);
                                    String dataType = columnDefinition.getDataType();
                                    propVal = dataType.equalsIgnoreCase("BIGINT") || dataType.equalsIgnoreCase("INTEGER") ? "0" : "-";
                                }
                                if (delimiter instanceof Character && "mysql".equalsIgnoreCase(dbName)) {
                                    propVal = propVal.replaceAll("\\\\", "\\\\\\\\");
                                }
                                strVal = strVal.append(propVal);
                            }
                            if (!(delimiter instanceof Character)) continue;
                            ((CsvWriter)writer).write(strVal.toString());
                        }
                    }
                    if (delimiter instanceof Character) {
                        ((CsvWriter)writer).endRecord();
                        continue;
                    }
                    writer.println(strVal.toString());
                }
                if (delimiter instanceof String) {
                    writer.flush();
                }
                try {
                    if (delimiter instanceof Character) {
                        ((CsvWriter)writer).close();
                        break block36;
                    }
                    writer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (fStream != null) {
                        fStream.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return fileName;
    }

    public static String generateValue(String generatorName, TableDefinition tabDefn) throws DataAccessException {
        SequenceGenerator generator = SequenceGeneratorRepository.get((String)generatorName);
        if (generator == null) {
            try {
                SequenceGeneratorRepository.initGeneratorValues((TableDefinition)tabDefn);
                generator = SequenceGeneratorRepository.get((String)generatorName);
            }
            catch (Exception e) {
                throw new DataAccessException("Initializing the SequenceGenerator failed with exception " + e);
            }
        }
        return generator.nextValue().toString();
    }

    public synchronized void waitForUpdate(long t) {
        try {
            super.wait(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String tableName) {
        Boolean tableThreadStatus = Boolean.FALSE;
        Hashtable<String, Boolean> hashtable = this.tableRunningStatus;
        synchronized (hashtable) {
            Boolean value = this.tableRunningStatus.get(tableName);
            if (value == null || !value.booleanValue()) {
                this.tableRunningStatus.put(tableName, Boolean.TRUE);
                tableThreadStatus = Boolean.TRUE;
            }
        }
        if (tableThreadStatus.booleanValue()) {
            Hashtable dcEventCountTableCopy = null;
            ArrayList filePropsListCopy = null;
            Hashtable<String, Serializable> hashtable2 = this.filePropTable;
            synchronized (hashtable2) {
                ArrayList filePropList;
                filePropsListCopy = filePropList = this.filePropTable.get(tableName);
                this.filePropTable.put(tableName, new ArrayList());
                if (!filePropsListCopy.isEmpty()) {
                    dcEventCountTableCopy = dcEventCountTable;
                    dcEventCountTable = new Hashtable();
                }
            }
            if (!filePropsListCopy.isEmpty()) {
                this.dumpRows(tableName, filePropsListCopy);
                EventDataUtil.updateRecordNumber(dcEventCountTableCopy);
            }
            hashtable2 = this.tableRunningStatus;
            synchronized (hashtable2) {
                this.tableRunningStatus.put(tableName, Boolean.FALSE);
            }
        }
    }

    private void processAllTables() {
        Enumeration<String> enumeration = this.filePropTable.keys();
        while (enumeration.hasMoreElements()) {
            String tableName = enumeration.nextElement();
            this.process(tableName);
        }
    }

    public void checkAndProcess() {
        this.waitForUpdate(5000L);
        this.processAllTables();
    }

    @Override
    public void run() {
        try {
            while (!this.shutDown) {
                this.checkAndProcess();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

