/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sql;

import com.adventnet.cp.WrappedConnection;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.transformers.ColumnTransformer;
import com.adventnet.sym.adsm.auditing.server.transformers.ColumnTransformerAPI;
import com.adventnet.sym.adsm.auditing.server.useractivity.UserActivityUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.zoho.cp.LogicalConnection;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class QueryUtil {
    private static Logger logger = Logger.getLogger(QueryUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getRows(String query, ArrayList columnsList, HashMap inputParams, Boolean isEmber) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<Cloneable> rowsList = new ArrayList<Cloneable>();
        try {
            String timeZoneId = TimeUtil.getTimeZoneId();
            if (isEmber.booleanValue()) {
                RelationalAPI relAPI = RelationalAPI.getInstance();
                connection = relAPI.getConnection();
                statement = connection.createStatement();
                resultSet = QueryUtil.executeQuery("Report ", statement, query);
                while (resultSet.next()) {
                    ArrayList rowValuesList = new ArrayList();
                    HashMap rowMap = new HashMap();
                    boolean isMultiRow = false;
                    for (Object object : columnsList) {
                        Object columnValue;
                        HashMap hashMap = (HashMap)object;
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        Long columnConfId = (Long)hashMap.get("COLUMN_CONF_ID");
                        ColumnTransformer transformer = ColumnTransformerAPI.getInstance().getColumnTransformer(columnConfId);
                        if (transformer.getClass().getSimpleName().equals("MultiRowTransformer")) {
                            isMultiRow = true;
                        }
                        if (transformer.getClass().getSimpleName().equals("MultiRowTransformer") && hashMap.get("COLUMNALIAS").toString().equals("USER_SID")) {
                            isMultiRow = true;
                            String displayName = (String)hashMap.get("COLUMNALIAS");
                            Object value = resultSet.getObject(displayName);
                            inputParams.put("USER_SID", value.toString());
                            Long cvId = (Long)hashMap.get("SUBREPORT_CV_ID");
                            ArrayList reportsList = AuditReportAPI.getInstance().getReportRows(cvId, null, inputParams, "TIME_GENERATED", "desc", 0, 0, null, 0, true);
                            for (int i = 0; i < reportsList.size(); ++i) {
                                int j = 0;
                                for (Object e : rowValuesList) {
                                    HashMap subValueMap = (HashMap)e;
                                    Iterator it = subValueMap.entrySet().iterator();
                                    HashMap column = new HashMap();
                                    while (it.hasNext()) {
                                        Map.Entry pair = it.next();
                                        column.put(pair.getKey(), pair.getValue());
                                    }
                                    column.put("isData", true);
                                    if (i != 0) {
                                        column.put("columnValue", "");
                                        column.put("columnalias", column.get("columnalias"));
                                    }
                                    column.put("visible", column.get("visible"));
                                    column.put("bgcolumn", column.get("bgcolumn"));
                                    HashMap map1 = (HashMap)reportsList.get(i);
                                    ArrayList l1 = (ArrayList)map1.get("columnValues");
                                    l1.add(j, column);
                                    ++j;
                                }
                            }
                            rowsList.addAll(reportsList);
                            break;
                        }
                        valueMap.put("isData", true);
                        hashMap.put("timeZoneId", timeZoneId);
                        if (inputParams.get("objectClass") != null) {
                            hashMap.put("objectClass", inputParams.get("objectClass").toString());
                        }
                        if (transformer.getClass().getSimpleName().equals("UserLogonActivityTransformer") && hashMap.get("COLUMNALIAS").toString().equals("USERNAMETEMP")) {
                            hashMap.put("INPUT_PARAMS", inputParams);
                        }
                        if ((columnValue = transformer.transformColumn(hashMap, resultSet, columnsList, null, valueMap, isEmber)) == null) {
                            columnValue = "-";
                        }
                        valueMap.put("columnValue", columnValue);
                        valueMap.put("columnalias", hashMap.get("COLUMNALIAS"));
                        valueMap.put("visible", hashMap.get("VISIBLE"));
                        valueMap.put("bgcolumn", hashMap.get("BGCOLUMN"));
                        rowValuesList.add(valueMap);
                    }
                    if (isMultiRow) continue;
                    rowMap.put("columnValues", rowValuesList);
                    rowsList.add(rowMap);
                }
            } else {
                RelationalAPI relAPI = RelationalAPI.getInstance();
                connection = relAPI.getConnection();
                statement = connection.createStatement();
                resultSet = QueryUtil.executeQuery("Report ", statement, query);
                while (resultSet.next()) {
                    ArrayList<HashMap> rowValuesList = new ArrayList<HashMap>();
                    for (Object object : columnsList) {
                        HashMap hashMap = (HashMap)object;
                        HashMap valueMap = (HashMap)hashMap.clone();
                        Long columnConfId = (Long)hashMap.get("COLUMN_CONF_ID");
                        ColumnTransformer transformer = ColumnTransformerAPI.getInstance().getColumnTransformer(columnConfId);
                        if (inputParams.get("CV_ID") == null || !UserActivityUtil.getInstance().getCvIdList().contains(inputParams.get("CV_ID"))) {
                            hashMap.put("INPUT_PARAMS", inputParams);
                        }
                        hashMap.put("timeZoneId", timeZoneId);
                        valueMap.put("COLUMN_VALUE", transformer.transformColumn(hashMap, resultSet, columnsList, null, valueMap, isEmber));
                        rowValuesList.add(valueMap);
                    }
                    rowsList.add(rowValuesList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rowsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowsCount(String query) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Integer count = 0;
        try {
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            statement = connection.createStatement();
            query = QueryUtil.escape(query);
            resultSet = QueryUtil.executeQuery("Report Count", statement, query);
            while (resultSet.next()) {
                count = count + resultSet.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSingleQuery(String name, String query) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            logger.log(Level.INFO, "Executing Query [{0} for [{1}]]: " + new Object[]{name, query});
            statement.execute(query);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while executing the query: " + query);
            e.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String escape(String query) {
        query = query.replaceAll("\"", "&quot;");
        return query;
    }

    public static ResultSet executeQuery(String name, Statement statement, String sql) throws Exception {
        ResultSet resultSet = null;
        try {
            long queryTime = System.currentTimeMillis();
            sql = QueryUtil.escape(sql);
            logger.log(Level.FINE, "Executing query [{0}] for [{1}]", new Object[]{sql, name});
            resultSet = statement.executeQuery(sql);
            queryTime = System.currentTimeMillis() - queryTime;
            logger.log(Level.FINE, "Time taken for executing query [{0}] for [{1}] time taken is [{2}]", new Object[]{sql, name, queryTime});
        }
        catch (Exception e) {
            logger.log(Level.INFO, "executeQuery exception... SQL is " + sql);
            e.printStackTrace();
            throw new Exception(e);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String name, String sql) throws Exception {
        int count;
        block19: {
            count = 0;
            Connection connection = null;
            Statement statement = null;
            String expMessage = null;
            try {
                connection = RelationalAPI.getInstance().getConnection();
                statement = connection.createStatement();
                count = QueryUtil.executeUpdate(name, statement, sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                expMessage = e.getMessage();
                return (int)expMessage;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (expMessage == null) break block19;
                throw new Exception(expMessage);
            }
        }
        return count;
    }

    public static int executeUpdate(String name, Statement stmt, String sql) throws Exception {
        int count = 0;
        try {
            long intime2 = System.currentTimeMillis();
            logger.log(Level.FINE, "Executing query [{0}] for [{1}]", new Object[]{sql, name});
            boolean result = stmt.execute(sql);
            if (!result) {
                count = stmt.getUpdateCount();
            }
            intime2 = System.currentTimeMillis() - intime2;
            logger.log(Level.FINE, "Time taken for executing query [{0}] for [{1}] time taken is [{2}]", new Object[]{sql, name, intime2});
        }
        catch (Exception e) {
            logger.log(Level.INFO, "executeUpdate exception... SQL is " + sql);
            e.printStackTrace();
            throw new Exception(e);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable executeQuery(String checkStr) throws Exception {
        if (checkStr == null) {
            return null;
        }
        Connection conn = null;
        ResultSet rs = null;
        Statement stmt = null;
        Hashtable<String, Object> returnHash = new Hashtable<String, Object>();
        Vector dataVector = new Vector();
        Vector<String> headerVector = new Vector<String>();
        Vector<String> headerTableNameVector = new Vector<String>();
        returnHash.put("header", headerVector);
        returnHash.put("headerTableName", headerTableNameVector);
        returnHash.put("tabular", dataVector);
        int rowCount = 500;
        try {
            conn = RelationalAPI.getInstance().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(checkStr);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            boolean[] isPasswordField = new boolean[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                String header = rsMetaData.getColumnLabel(i).trim();
                headerVector.addElement(header);
                isPasswordField[i - 1] = header.equalsIgnoreCase("password");
                String headerTableName = rsMetaData.getTableName(i).trim();
                headerTableNameVector.addElement(headerTableName);
            }
            int rowsReturned = 0;
            while (rs.next()) {
                if (rowsReturned > rowCount) {
                    throw new Exception("Number of rows exceeds " + rowCount + ". Please use limit to ensure that no more than " + rowCount + " rows are returned");
                }
                Vector<String> tempVect = new Vector<String>();
                for (int ii = 1; ii <= columnCount; ++ii) {
                    if (isPasswordField[ii - 1]) {
                        tempVect.addElement("********");
                        continue;
                    }
                    String str = rs.getString(ii);
                    tempVect.addElement(str);
                }
                dataVector.addElement(tempVect);
                ++rowsReturned;
            }
        }
        catch (Exception ee) {
            returnHash.put("errorMessage", ee.getMessage());
            ee.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnHash;
    }

    public static int executeUpdate(String query) throws Exception {
        int count = 0;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = RelationalAPI.getInstance().getConnection();
            stmt = conn.createStatement();
            logger.info("Executing update query : " + query);
            count = stmt.executeUpdate(query);
            logger.info("Output of update query : " + count);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getMaxValueOfColumn(String colName, String tableName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Object ret = null;
        try {
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            statement = connection.createStatement();
            String query = "select max(" + colName + ") from " + tableName;
            query = QueryUtil.escape(query);
            resultSet = QueryUtil.executeQuery("Max value", statement, query);
            resultSet.next();
            ret = resultSet.getObject(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getRowsForCustomQuery(String query, String colName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> ret = new ArrayList<String>();
        try {
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            statement = connection.createStatement();
            query = QueryUtil.escape(query);
            resultSet = QueryUtil.executeQuery("Get Rows For Custom Query", statement, query);
            while (resultSet.next()) {
                ret.add(resultSet.getString(colName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static int copyDataToDB(String tableName, String columnOrder, String fileName) throws Exception {
        Long count = 0L;
        Connection connection = null;
        Object cpIn = null;
        CopyManager copyManager = null;
        byte[] insert_values = "1|10\n2|20\n3|30\n4|40".getBytes();
        InputStreamReader fr = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            BaseConnection baseConnection = null;
            if (connection instanceof WrappedConnection) {
                LogicalConnection logicalConnection = (LogicalConnection)((WrappedConnection)connection).getConnection(0);
                baseConnection = (BaseConnection)logicalConnection.getPhysicalConnection();
            } else {
                LogicalConnection logicalConnection = (LogicalConnection)connection;
                baseConnection = (BaseConnection)logicalConnection.getPhysicalConnection();
            }
            fr = new FileReader(fileName);
            copyManager = new CopyManager(baseConnection);
            count = copyManager.copyIn("COPY " + tableName + " (" + columnOrder + ") FROM STDIN DELIMITER '^' NULL AS '' csv escape '\"'", (Reader)fr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Exception while copying rows to Database : File Name is " + fileName);
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return count.intValue();
    }
}

