/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sql;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.MssqlUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordWriter {
    static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger LOGGER = Logger.getLogger("ReportLogger");
    private FileWriter fWriter = null;
    private PrintWriter writer = null;
    private String fileName = null;
    private String tableName = null;

    public RecordWriter(String tableName) {
        LOGGER.log(Level.INFO, "RecordWriter Constructor Called for  {0}", tableName);
        this.tableName = tableName;
        this.initTempFile();
    }

    public void writeData(Long generationId, ArrayList guids) {
        String delimiter = "|**|";
        String dbServerName = CommonUtil.getDBServerName();
        if (dbServerName.equalsIgnoreCase("postgres")) {
            delimiter = "\t";
        }
        int size = guids.size();
        for (int i = 0; i < size; ++i) {
            String guid = (String)guids.get(i);
            if (dbServerName.equalsIgnoreCase("postgres")) {
                this.writer.println(generationId + delimiter + guid.replaceAll("\\\\", "\\\\\\\\"));
                continue;
            }
            this.writer.println(generationId + delimiter + guid.replaceAll("\\\\", "\\\\\\\\") + delimiter);
        }
    }

    public synchronized void flush() {
        this.writeToFile();
        this.dumpToDatabase();
    }

    private void initTempFile() {
        try {
            String dirName = System.getProperty("server.home") + File.separator + "temp";
            File dir = new File(dirName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            this.fileName = dirName + File.separator + this.tableName + "_" + System.currentTimeMillis() + ".txt";
            this.fWriter = new FileWriter(this.fileName, false);
            this.writer = new PrintWriter((Writer)new BufferedWriter(this.fWriter), false);
            LOGGER.log(Level.FINER, "[RecordWriter.initTempFile()] Created new temp file as {0}{1}{2}", new Object[]{dirName, File.separator, this.fileName});
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, " Exception while opening file for table: {0}", this.tableName);
            LOGGER.log(Level.WARNING, " Exception while opening file to log flows: {0}", e);
        }
    }

    private void writeToFile() {
        this.writer.flush();
        this.closeWriters();
    }

    private void closeWriters() {
        try {
            this.writer.close();
            this.fWriter.close();
            this.writer = null;
            this.fWriter = null;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, " Exception while closing file {0}", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dumpToDatabase() {
        RelationalAPI rapi = RelationalAPI.getInstance();
        Connection con = null;
        Statement stmt = null;
        if (this.fileName != null) {
            try {
                String dbServerName = CommonUtil.getDBServerName();
                File tmpFile = new File(this.fileName);
                String filePath = tmpFile.getCanonicalPath();
                filePath = filePath.replace('\\', '/');
                int fl = 0;
                String sql = null;
                if (dbServerName.equalsIgnoreCase("mssql")) {
                    MssqlUtil.getInstance();
                    sql = MssqlUtil.getRecordWriterQuery(this.tableName, filePath);
                    RecordWriter.executeCommand(sql, fl);
                } else if (dbServerName.equalsIgnoreCase("mysql")) {
                    sql = "load data infile '" + filePath + "' replace into table " + this.tableName + " fields terminated by '|**|' ";
                    con = rapi.getConnection();
                    stmt = con.createStatement();
                    stmt.executeUpdate(sql);
                } else {
                    sql = "COPY " + this.tableName + " from '" + filePath + "' NULL AS ''";
                    QueryUtil.executeUpdate("Loading File : ", sql);
                }
                this.deleteFile();
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINER, "[RecordWriter.run()] Exception while loading data to table {0}", this.tableName);
                exp.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exp) {
                    stmt = null;
                    con = null;
                }
            }
        }
    }

    public static synchronized void executeCommand(String command, int fl) throws Exception {
        block3: {
            try {
                Process p = Runtime.getRuntime().exec(command);
                BufferedReader bufReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = bufReader.readLine()) != null) {
                    if (!line.toUpperCase().contains(rb.getString("adap.common.bcp_ERROR"))) continue;
                    LOGGER.log(Level.INFO, "BCP Return line in RecordWriter " + line);
                    throw new Exception("BCP Error came in RecordWriter");
                }
                bufReader.close();
                p.waitFor();
            }
            catch (Exception e) {
                if (++fl >= 2) break block3;
                RecordWriter.executeCommand(command, fl);
            }
        }
    }

    private void deleteFile() {
        try {
            if (this.fileName == null) {
                return;
            }
            File tmpFile = new File(this.fileName);
            boolean del = tmpFile.delete();
            tmpFile = null;
            LOGGER.log(Level.FINER, " Deleted tmp file {0} when closing service{1}", new Object[]{this.fileName, del});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

