/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sql.query;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportParamsAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportSchedulerUtil;
import com.adventnet.sym.adsm.auditing.server.util.MetaTableHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilder;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public abstract class DefaultQueryBuilder
implements QueryBuilder {
    protected static Logger logger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    protected static Properties patternMap = null;
    protected static String columnValue;

    @Override
    public final String getSQLCountString(Long cvId, String searchCriteria, HashMap inputParamsMap) {
        String constructedSQL = null;
        String group_by = null;
        if (inputParamsMap.containsKey("isComplianceReport")) {
            constructedSQL = this.getSQLSumString(cvId, searchCriteria, inputParamsMap);
        } else {
            if (searchCriteria == null) {
                searchCriteria = "1=1";
            }
            try {
                DataObject cvDO = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
                if (cvDO.size("AUDSQLQuery") > 0) {
                    Row row = cvDO.getRow("AUDSQLQuery");
                    String sqlString = (String)row.get("COUNT_SQL_STRING");
                    Boolean group_by_used = (Boolean)row.get("GROUPBYUSED");
                    Boolean unionUsed = (Boolean)row.get("UNION_USED");
                    if (unionUsed.booleanValue()) {
                        ArrayList unionQueryList = ADAPSQLQueryUtil.getUnionQueries((Long)row.get("QUERY_ID"), "UNION_COUNT_QUERY");
                        String queryString = "";
                        for (Object object : unionQueryList) {
                            if (unionQueryList.indexOf(object) > 0) {
                                queryString = queryString + "UNION ALL";
                            }
                            queryString = queryString + " ";
                            queryString = queryString + this.getSQLCountString((String)object, searchCriteria, inputParamsMap);
                            queryString = queryString + " ";
                        }
                        constructedSQL = sqlString = sqlString.replace("${UNION_COUNT_QUERY}", queryString);
                        constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${GRAPHTOPVAL}", "${GROUP_BY}", "${ORDER_BY}", "${COLUMNS}", "${LIMIT}"});
                    } else {
                        constructedSQL = this.getSQLCountString(sqlString, searchCriteria, inputParamsMap);
                        if (group_by_used.booleanValue()) {
                            group_by = ADAPSQLQueryUtil.getGroupByString((String)row.get("GROUP_BY"));
                            constructedSQL = constructedSQL.replace("COUNT(*)", group_by);
                        }
                    }
                }
                constructedSQL = this.replaceSearchString(constructedSQL, searchCriteria);
                constructedSQL = this.replaceFunctionPattern(constructedSQL);
                constructedSQL = this.getConstructedSQL(constructedSQL);
                constructedSQL = this.objectReplaceString(constructedSQL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return constructedSQL;
    }

    @Override
    public String getSQLSumString(Long cvId, String searchCriteria, HashMap inputParamsMap) {
        String constructedSQL = null;
        if (searchCriteria == null) {
            searchCriteria = "1=1";
        }
        try {
            DataObject cvDO = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
            if (cvDO.size("AUDSQLQuery") > 0) {
                Row row = cvDO.getRow("AUDSQLQuery");
                String sqlString = (String)row.get("COUNT_SQL_STRING");
                Boolean unionUsed = (Boolean)row.get("UNION_USED");
                if (unionUsed.booleanValue()) {
                    String unionQuery = ADAPSQLQueryUtil.getSQLUnionQuery((Long)row.get("QUERY_ID"), "UNION_COUNT_QUERY", inputParamsMap, searchCriteria);
                    constructedSQL = sqlString = sqlString.replace("${UNIONQUERY}", unionQuery);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return constructedSQL;
    }

    @Override
    public String getSQLComplianceString(Long cvId, String searchCriteria, HashMap inputParamsMap) {
        String constructedSQL = null;
        if (searchCriteria == null) {
            searchCriteria = "1=1";
        }
        try {
            DataObject cvDO = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
            if (cvDO.size("AUDSQLQuery") > 0) {
                Row row = cvDO.getRow("AUDSQLQuery");
                String sqlString = (String)row.get("SQL_STRING");
                Boolean unionUsed = (Boolean)row.get("UNION_USED");
                if (unionUsed.booleanValue()) {
                    String unionQuery = ADAPSQLQueryUtil.getSQLUnionQuery((Long)row.get("QUERY_ID"), "UNION_QUERY", inputParamsMap, searchCriteria);
                    constructedSQL = sqlString = sqlString.replace("${UNIONQUERY}", unionQuery);
                    constructedSQL = this.replaceComplianceRangeValues(constructedSQL, (String)inputParamsMap.get("offset"), (String)inputParamsMap.get("limit"), (String)inputParamsMap.get("orderBy"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return constructedSQL;
    }

    @Override
    public final String getSQLCountString(Long cvId, String searchCriteria, HashMap inputParamsMap, String countSqlString) {
        String constructedSQL = null;
        if (inputParamsMap.containsKey("isComplianceReport")) {
            constructedSQL = this.getSQLSumString(cvId, searchCriteria, inputParamsMap);
        } else {
            if (searchCriteria == null) {
                searchCriteria = "1=1";
            }
            try {
                DataObject cvDO = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
                String sqlCountString = null;
                if (cvDO.size("AUDSQLQuery") > 0) {
                    Row row = cvDO.getRow("AUDSQLQuery");
                    String sqlString = (String)row.get("COUNT_SQL_STRING");
                    sqlCountString = this.getSQLCountString(countSqlString, searchCriteria, inputParamsMap);
                    constructedSQL = sqlString.replace("${UNION_COUNT_QUERY}", sqlCountString);
                    constructedSQL = constructedSQL.replace("${SCRITERIA}", searchCriteria);
                    constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${GRAPHTOPVAL}", "${GROUP_BY}", "${ORDER_BY}", "${COLUMNS}", "${LIMIT}"});
                    constructedSQL = this.replaceFunctionPattern(constructedSQL);
                    constructedSQL = this.getConstructedSQL(constructedSQL);
                    constructedSQL = this.objectReplaceString(constructedSQL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return constructedSQL;
    }

    @Override
    public final String getSQLString(Long cvId, String searchCriteria, HashMap inputParamsMap, HashMap addionalSQLPropsMap, int count) {
        String constructedSQL = null;
        if (inputParamsMap.containsKey("isComplianceReport")) {
            constructedSQL = this.getSQLComplianceString(cvId, searchCriteria, inputParamsMap);
        } else {
            try {
                String groupBy = null;
                DataObject cvDO = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
                if (searchCriteria == null) {
                    searchCriteria = "1=1";
                }
                if (cvDO.size("AUDSQLQuery") > 0) {
                    Boolean unionUsed;
                    Row row = cvDO.getRow("AUDSQLQuery");
                    constructedSQL = this.replaceFunctionPattern((String)row.get("SQL_STRING"));
                    Boolean group_by_used = (Boolean)row.get("GROUPBYUSED");
                    if (group_by_used.booleanValue()) {
                        groupBy = (String)row.get("GROUP_BY");
                    }
                    if ((unionUsed = (Boolean)row.get("UNION_USED")).booleanValue()) {
                        Long queryId = (Long)row.get("QUERY_ID");
                        String columnString = "";
                        constructedSQL = this.setUnionSQLQuery(cvId, searchCriteria, inputParamsMap, addionalSQLPropsMap, groupBy, queryId, columnString, constructedSQL, "UNION_QUERY");
                        constructedSQL = this.setAdditionalSQLOptions(addionalSQLPropsMap, constructedSQL, count);
                        columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvId);
                        constructedSQL = (constructedSQL = constructedSQL.replace("${SCRITERIA}", searchCriteria)).contains("${ALIAS}") ? constructedSQL.replace("${ALIAS}.", "") : constructedSQL;
                        constructedSQL = constructedSQL.replace("${COLUMNS}", columnString);
                        constructedSQL = this.formGroupByString(constructedSQL, groupBy, addionalSQLPropsMap);
                    } else {
                        String columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvId);
                        constructedSQL = this.getSQLString(constructedSQL, columnString, searchCriteria, inputParamsMap, addionalSQLPropsMap, groupBy);
                        constructedSQL = this.setAdditionalSQLOptions(addionalSQLPropsMap, constructedSQL, 0);
                    }
                    constructedSQL = this.replaceFunctionPattern(constructedSQL);
                    constructedSQL = this.getConstructedSQL(constructedSQL);
                    constructedSQL = this.objectReplaceString(constructedSQL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return constructedSQL;
    }

    @Override
    public final String getSQLString(Long cvId, String searchCriteria, HashMap inputParamsMap, HashMap addionalSQLPropsMap, String sqlUnionSting, int count) {
        String constructedSQL = null;
        if (inputParamsMap.containsKey("isComplianceReport")) {
            constructedSQL = this.getSQLComplianceString(cvId, searchCriteria, inputParamsMap);
        } else {
            try {
                String groupBy = null;
                DataObject cvDO = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
                if (cvDO.size("AUDSQLQuery") > 0) {
                    Row row = cvDO.getRow("AUDSQLQuery");
                    constructedSQL = this.replaceFunctionPattern((String)row.get("SQL_STRING"));
                    Boolean groupByUsed = (Boolean)row.get("GROUPBYUSED");
                    String columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvId);
                    if (groupByUsed.booleanValue()) {
                        groupBy = (String)row.get("GROUP_BY");
                        constructedSQL = this.formGroupByString(constructedSQL, groupBy, addionalSQLPropsMap);
                    } else {
                        constructedSQL = constructedSQL.replace("${GROUP_BY}", " ");
                    }
                    String queryString = this.getSQLString(sqlUnionSting, columnString, searchCriteria, inputParamsMap, addionalSQLPropsMap, groupBy);
                    constructedSQL = constructedSQL.replace("${UNION_QUERY}", queryString);
                    constructedSQL = this.setAdditionalSQLOptions(addionalSQLPropsMap, constructedSQL, count);
                    columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvId);
                    constructedSQL = constructedSQL.replace("${COLUMNS}", columnString);
                    constructedSQL = this.replaceFunctionPattern(constructedSQL);
                    constructedSQL = this.getConstructedSQL(constructedSQL);
                    constructedSQL = this.objectReplaceString(constructedSQL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return constructedSQL;
    }

    @Override
    public final String getSQLString(String sqlQuery, String columnString, String searchCriteria, HashMap inputParamsMap, HashMap addionalSQLPropsMap, String groupBy) {
        String constructedSQL = null;
        try {
            constructedSQL = sqlQuery;
            if (constructedSQL.indexOf("${COLUMNS}") != 1) {
                constructedSQL = constructedSQL.replace("${COLUMNS}", columnString);
            }
            constructedSQL = this.replaceFunctionPattern(constructedSQL);
            constructedSQL = this.getSQLCustomString(constructedSQL, searchCriteria, inputParamsMap);
            constructedSQL = groupBy != null ? this.formGroupByString(constructedSQL, groupBy, addionalSQLPropsMap) : constructedSQL.replace("${GROUP_BY}", " ");
            constructedSQL = this.replaceFunctionPattern(constructedSQL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return constructedSQL;
    }

    @Override
    public final String setAdditionalSQLOptions(HashMap addionalSQLPropsMap, String constructedSQL, int count) throws Exception {
        if (!addionalSQLPropsMap.isEmpty()) {
            if (constructedSQL.indexOf("${ORDER_BY}") == -1) {
                constructedSQL = constructedSQL.concat(" ${ORDER_BY} ${LIMIT}");
            }
            String sortColumn = (String)addionalSQLPropsMap.get("sortColumn");
            String sortOrder = (String)addionalSQLPropsMap.get("sortOrder");
            Integer startIndex = (Integer)addionalSQLPropsMap.get("startIndex");
            Integer noOfObjects = (Integer)addionalSQLPropsMap.get("noOfObjects");
            if (sortColumn != null && noOfObjects != null) {
                constructedSQL = constructedSQL.replace("${ORDER_BY}", "ORDER BY " + sortColumn + " " + sortOrder);
                if (sortOrder.equalsIgnoreCase("DESC")) {
                    constructedSQL = constructedSQL.replace("${CHANGE_ORDER_BY}", "ORDER BY " + sortColumn + " " + "ASC");
                }
                if (sortOrder.equalsIgnoreCase("ASC")) {
                    constructedSQL = constructedSQL.replace("${CHANGE_ORDER_BY}", "ORDER BY " + sortColumn + " " + "DESC");
                }
                Integer innerTopVal = startIndex - 1 + noOfObjects;
                if (count > 0 && count < innerTopVal) {
                    noOfObjects = count % noOfObjects;
                }
                constructedSQL = this.replaceRangeValues(constructedSQL, noOfObjects.toString(), innerTopVal.toString());
            } else {
                constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${ORDER_BY}", "${CHANGE_ORDER_BY}", "${TOPVAL}", "${INNERTOPVAL}", "${LIMIT}", "${INNERLIMIT}"});
                constructedSQL = constructedSQL + " ORDER BY " + sortColumn + " " + sortOrder;
            }
        } else {
            logger.log(Level.INFO, "Empty Addtional SQL Props for mysql & psql, Constucted sql is " + constructedSQL);
        }
        return constructedSQL;
    }

    protected String setUnionSQLQuery(Long cvId, String searchCriteria, HashMap inputParamsMap, HashMap addionalSQLPropsMap, String groupBy, Long queryId, String columnString, String constructedSQL, String queryColumn) throws Exception {
        String queryString = "";
        queryString = this.getUnionSQLQuery(cvId, searchCriteria, inputParamsMap, addionalSQLPropsMap, groupBy, queryId, columnString, queryString, queryColumn);
        constructedSQL = constructedSQL.replace("${UNION_QUERY}", queryString);
        constructedSQL = constructedSQL.replace("${UNION_COUNT_QUERY}", queryString);
        return constructedSQL;
    }

    private String getUnionSQLQuery(Long cvId, String searchCriteria, HashMap inputParamsMap, HashMap addionalSQLPropsMap, String groupBy, Long queryId, String columnString, String queryString, String queryColumn) {
        ArrayList unionQueryList = ADAPSQLQueryUtil.getUnionQueries(queryId, queryColumn);
        columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvId);
        for (Object object : unionQueryList) {
            if (unionQueryList.indexOf(object) > 0) {
                queryString = queryString + "UNION ALL ";
            }
            queryString = queryString + this.getSQLString(this.replaceFunctionPattern((String)object), columnString, searchCriteria, inputParamsMap, addionalSQLPropsMap, groupBy);
        }
        return queryString;
    }

    @Override
    public String getSQLCustomString(String orginalConstructedSQL, String searchCriteria, HashMap inputParamsMap) {
        int i;
        String finalconstructedSQL = null;
        ArrayList tableList = MetaTableHandler.getTableNames(orginalConstructedSQL, inputParamsMap);
        String sqlString = orginalConstructedSQL;
        if (searchCriteria == null) {
            searchCriteria = "1=1";
        }
        if (inputParamsMap.get("allObjectSelected") != null) {
            String[] sidString = new String[]{"AUDAccountCreation.CALLER_USER_SID IN ( ${objectSIDStr} ) AND", "AUDGroupMgmt.CALLER_USER_SID IN ( ${objectSIDStr} ) AND ", "AUDUserMgmt.CALLER_USER_SID IN ( ${objectSIDStr} ) AND ", "AUDComputerMgmt.CALLER_USER_SID IN ( ${objectSIDStr} ) AND ", "AUDUserMgmt.ACCOUNT_SID IN ( ${objectSID} ) AND", "AUDAccountCreation.ACCOUNT_SID IN ( ${objectSID} ) AND", "AUDGroupMgmt.ACCOUNT_SID IN ( ${objectSID} ) AND", "AUDComputerMgmt.ACCOUNT_SID IN ( ${objectSID} ) AND ", "ACCOUNT_SID IN ( ${objectSID} ) AND", "(LOWER(SOURCE) IN ( ${objectName} ) OR  LOWER(SOURCE) IN ( ${objectDNSName} )) AND", "(LOWER(USERNAME) in (${objectName}) ) AND", "AND ((a.ACCESS_MASK='0x1' AND a.ADDITIONAL_INFO2 IN (${guidStr})) OR (a.OBJECT_NAME IN (${guidStr})) OR (a.EVENT_NUMBER=5137 AND a.ADDITIONAL_INFO2 IN (${guidStr})) OR (a.EVENT_NUMBER=5136 AND a.ADDITIONAL_INFO2 IN (${guidStr})))", "a.CALLER_USER_SID IN ( ${objectSIDStr} ) AND", "a.USER_SID IN ( ${objectSID} ) AND", "(a.USERNAME in (${objectName}) ) AND", "(a.SOURCE IN ( ${objectName} ) OR  a.SOURCE IN ( ${objectDNSName} )) AND", "a.ACCOUNT_SID IN ( ${objectSID} ) AND", "AUDLogonInfo.USER_SID IN ( ${objectSID} ) AND", "USER_SID IN ( ${objectSID} ) AND", "CALLER_USER_SID IN ( ${objectSIDStr} ) AND", "((ACCOUNT_SID IN ( ${objectSID})) OR (ACCOUNT_SID IN ( ${objectSIDStr} ))) AND", "AND ((ACCESS_MASK='0x1' AND ADDITIONAL_INFO2 IN (${guidStr})) OR (OBJECT_NAME IN (${guidStr})) OR (EVENT_NUMBER=5137 AND ADDITIONAL_INFO2 IN (${guidStr})) OR (EVENT_NUMBER=5136 AND ADDITIONAL_INFO2 IN (${guidStr})))", "(SOURCE IN ( ${objectName} ) OR  SOURCE IN ( ${objectDNSName} )) AND", "(USERNAME in (${objectName}) ) AND", "AND (OBJECT_GUID IN (${guidStr}))", "AND ((AUDGPOMgmt.ACCESS_MASK='0x1' AND AUDGPOMgmt.ADDITIONAL_INFO2 IN (${guidStr})) OR (AUDGPOMgmt.OBJECT_NAME IN (${guidStr})) OR (AUDGPOMgmt.EVENT_NUMBER=5137 AND AUDGPOMgmt.ADDITIONAL_INFO2 IN (${guidStr})) OR (AUDGPOMgmt.EVENT_NUMBER=5136 AND AUDGPOMgmt.ADDITIONAL_INFO2 IN (${guidStr})))", "AND ((AUDOUMgmt.ACCESS_MASK='0x1' AND AUDOUMgmt.ADDITIONAL_INFO2 IN (${guidStr})) OR (AUDOUMgmt.OBJECT_NAME IN (${guidStr})) OR (AUDOUMgmt.EVENT_NUMBER=5137 AND AUDOUMgmt.ADDITIONAL_INFO2 IN (${guidStr})) OR (AUDOUMgmt.EVENT_NUMBER=5136 AND AUDOUMgmt.ADDITIONAL_INFO2 IN (${guidStr})))", "AUDGroupMgmt.MEMBER_SID IN ( ${objectSIDStr} ) AND", "MEMBER_SID IN ( ${objectSIDStr} ) AND", "(PRINTER_NAME in (${objectName}) ) AND", "AND (AUDComputerAuditInfo.CALLER_USER_SID IN ( ${objectSIDStr} ) )"};
            for (i = 0; i < sidString.length; ++i) {
                sqlString = sqlString.replace(sidString[i], "");
            }
        }
        sqlString = sqlString.replace("${SCRITERIA}", searchCriteria);
        if (inputParamsMap != null && !inputParamsMap.isEmpty()) {
            for (Object key : inputParamsMap.keySet()) {
                String value;
                String string = value = (String)inputParamsMap.get(key) != null ? (String)inputParamsMap.get(key) : "''";
                if (sqlString.indexOf((String)key) == -1) continue;
                String val = "${" + key + "}";
                sqlString = sqlString.replace(val, value);
            }
        }
        String tempSQLString = sqlString;
        for (i = 0; i < tableList.size(); ++i) {
            String[] tableNameList;
            if (finalconstructedSQL == null) {
                finalconstructedSQL = "(";
            }
            if ((tableNameList = (String[])tableList.get(i)) == null) continue;
            int count = 0;
            for (String tableName : tableNameList) {
                if (tableList.size() == 1 && tableNameList.length > 1) {
                    tempSQLString = sqlString;
                }
                Matcher match = ADAPSQLQueryUtil.TABLE_NAME_PATTERN.matcher(tempSQLString);
                String matchStr = "";
                String tempTableName = null;
                while (match.find()) {
                    String queryTableName = "";
                    matchStr = match.group();
                    queryTableName = matchStr.replace("${TABLE:", "");
                    queryTableName = queryTableName.replace("}", "");
                    if (tempTableName != null && queryTableName.equalsIgnoreCase(tempTableName)) continue;
                    tempTableName = queryTableName;
                    if (tableName.indexOf(queryTableName) == -1) continue;
                    tempSQLString = tempSQLString.replace(queryTableName, tableName);
                    tempSQLString = (tempSQLString = tempSQLString.replace("${TABLE:" + tableName + "}", tableName)).contains("${ALIAS}") ? tempSQLString.replace("${ALIAS}", tableName) : tempSQLString;
                }
                finalconstructedSQL = tableNameList.length != 1 && ++count != tableNameList.length ? finalconstructedSQL + tempSQLString + " ) union all ( " : (tableNameList.length == 1 ? "( " + tempSQLString : finalconstructedSQL + tempSQLString);
            }
        }
        if (finalconstructedSQL == null) {
            finalconstructedSQL = "(";
            finalconstructedSQL = finalconstructedSQL + orginalConstructedSQL;
        }
        finalconstructedSQL = finalconstructedSQL + " )";
        return finalconstructedSQL;
    }

    @Override
    public final String getSQLCountString(Long cvID, Long graphOptID, String inputData, HashMap inputParamsMap, String searchCriteria) {
        String constructedSQL = null;
        String group_by = null;
        try {
            DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvID);
            if (cvDO.size("AUDSQLQuery") > 0) {
                Row row = cvDO.getRow("AUDSQLQuery");
                constructedSQL = (String)row.get("COUNT_SQL_STRING");
                constructedSQL = this.replaceSearchString(constructedSQL, searchCriteria);
                Boolean group_by_used = (Boolean)row.get("GROUPBYUSED");
                Boolean unionUsed = (Boolean)row.get("UNION_USED");
                inputData = this.replaceFunctionPattern(inputData);
                String countUnionQuery = ADAPSQLQueryUtil.getUnionQueryStackedBarChart(inputData, "countString", (Long)row.get("QUERY_ID"));
                String queryString = "";
                if (countUnionQuery != null) {
                    queryString = this.getSQLCountString(countUnionQuery, null, inputParamsMap);
                    constructedSQL = constructedSQL.replace("${UNION_COUNT_QUERY}", queryString);
                    constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${GRAPHTOPVAL}", "${GROUP_BY}", "${ORDER_BY}", "${COLUMNS}", "${LIMIT}"});
                } else if (unionUsed.booleanValue()) {
                    ArrayList unionQueryList = ADAPSQLQueryUtil.getUnionQueries((Long)row.get("QUERY_ID"), "UNION_COUNT_QUERY");
                    for (Object object : unionQueryList) {
                        if (unionQueryList.indexOf(object) > 0) {
                            queryString = queryString + "UNION ALL";
                        }
                        queryString = queryString + " ";
                        queryString = queryString + this.getSQLCountString((String)object, searchCriteria, inputParamsMap);
                        queryString = queryString + " ";
                    }
                    constructedSQL = constructedSQL.replace("${UNION_COUNT_QUERY}", queryString);
                    constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${GRAPHTOPVAL}", "${GROUP_BY}", "${ORDER_BY}", "${COLUMNS}", "${LIMIT}"});
                } else {
                    constructedSQL = this.getSQLCountString(constructedSQL, searchCriteria, inputParamsMap);
                    if (group_by_used.booleanValue()) {
                        group_by = "COUNT( DISTINCT " + (String)row.get("GROUP_BY") + " )";
                        constructedSQL = constructedSQL.replace("COUNT(*)", group_by);
                    }
                }
                constructedSQL = this.replaceFunctionPattern(constructedSQL);
                constructedSQL = this.getConstructedSQL(constructedSQL);
                constructedSQL = this.objectReplaceString(constructedSQL);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return constructedSQL;
    }

    @Override
    public String getSQLCountString(String sqlString, String searchCriteria, HashMap inputParamsMap) {
        String constructedSQL = null;
        try {
            constructedSQL = sqlString;
            constructedSQL = this.getSQLCustomString(constructedSQL, searchCriteria, inputParamsMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return constructedSQL;
    }

    @Override
    public String getConstructedSQL(String constructedSQL) throws Exception {
        Matcher match = ADAPSQLQueryUtil.QUERY_PATTERN.matcher(constructedSQL);
        while (match.find()) {
            String queryStringForI18N = match.group().replace("${", "");
            queryStringForI18N = queryStringForI18N.replace("}", "");
            constructedSQL = constructedSQL.replace("${" + queryStringForI18N + "}", rb.getString(queryStringForI18N));
        }
        return constructedSQL;
    }

    @Override
    public String getGraphReportCountSQLString(Long cvId, Long graphOptID, String domainName, String inputElement, Long noOfDays, String chartType) {
        String constructedSQL;
        block16: {
            constructedSQL = null;
            try {
                DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvId);
                Criteria crit = new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"GRAPH_OPT_ID"), (Object)graphOptID, 0);
                if (cvDO.size("AUDSQLQuery") <= 0) break block16;
                Row row = cvDO.getRow("AUDSQLQuery");
                Row graphRow = cvDO.getRow("AUDGraphOptions", crit);
                constructedSQL = (String)row.get("COUNT_SQL_STRING");
                HashMap inputParamsMap = ADAPSQLQueryUtil.getInputParamsMap(noOfDays, domainName);
                String searchCriteria = (String)graphRow.get("CRITERIA");
                String xColumnValue = this.replaceFunctionPattern((String)graphRow.get("XCOLUMN"));
                searchCriteria = !searchCriteria.equals("-") ? searchCriteria + " AND " + ADAPSQLQueryUtil.getXColumnValue(xColumnValue, inputElement, chartType) : null;
                String queryString = "";
                AuditReportAPI.getInstance();
                if (AuditReportAPI.isReportGraph(graphOptID).booleanValue()) {
                    AuditReportAPI.getInstance();
                    if (AuditReportAPI.isInputNeeded(graphOptID).booleanValue()) {
                        AuditReportAPI.getInstance();
                        inputParamsMap = AuditReportAPI.getInputMap(graphOptID, inputParamsMap, null);
                    }
                    searchCriteria = ADAPSQLQueryUtil.getXColumnValue(xColumnValue, inputElement, chartType);
                    constructedSQL = this.getSQLCountString(cvId, graphOptID, inputElement, inputParamsMap, searchCriteria);
                } else {
                    if (chartType.equalsIgnoreCase("stackedhorizontalbar") || chartType.equalsIgnoreCase("stackedverticalbar") || chartType.equalsIgnoreCase("stackedhorizontalbar3d") || chartType.equalsIgnoreCase("stackedverticalbar3d")) {
                        String[] str = inputElement.split(";;");
                        String inputElement1 = "";
                        for (int i = 0; i < str.length; ++i) {
                            inputElement1 = i == str.length - 1 ? inputElement1 + str[i] : inputElement1 + str[i] + " ";
                        }
                        String unionQuery = ADAPSQLQueryUtil.getUnionQueryStackedBarChart(inputElement1, "countString", (Long)row.get("QUERY_ID"));
                        if (unionQuery != null) {
                            queryString = this.getSQLCountString(unionQuery, searchCriteria, inputParamsMap);
                        } else {
                            Boolean unionUsed = (Boolean)row.get("UNION_USED");
                            if (unionUsed.booleanValue()) {
                                ArrayList unionQueryList = ADAPSQLQueryUtil.getUnionQueries((Long)row.get("QUERY_ID"), "UNION_COUNT_QUERY");
                                for (Object object : unionQueryList) {
                                    if (unionQueryList.indexOf(object) > 0) {
                                        queryString = queryString + "UNION ALL";
                                    }
                                    queryString = queryString + " ";
                                    queryString = queryString + this.getSQLCountString((String)object, searchCriteria, inputParamsMap);
                                    queryString = queryString + " ";
                                }
                            }
                        }
                    } else {
                        Boolean unionUsed = (Boolean)row.get("UNION_USED");
                        if (unionUsed.booleanValue()) {
                            ArrayList unionQueryList = ADAPSQLQueryUtil.getUnionQueries((Long)row.get("QUERY_ID"), "UNION_COUNT_QUERY");
                            for (Object object : unionQueryList) {
                                if (unionQueryList.indexOf(object) > 0) {
                                    queryString = queryString + "UNION ALL";
                                }
                                queryString = queryString + " ";
                                queryString = queryString + this.getSQLCountString((String)object, searchCriteria, inputParamsMap);
                                queryString = queryString + " ";
                            }
                        }
                    }
                    constructedSQL = constructedSQL.replace("${UNION_COUNT_QUERY}", queryString);
                    constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${GRAPHTOPVAL}", "${GROUP_BY}", "${ORDER_BY}", "${COLUMNS}", "${LIMIT}"});
                    constructedSQL = this.replaceFunctionPattern(constructedSQL);
                    constructedSQL = this.getConstructedSQL(constructedSQL);
                }
                constructedSQL = this.objectReplaceString(constructedSQL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return constructedSQL;
    }

    @Override
    public final String getSQLString(Long cvID, Long graphOptID, String inputData, HashMap inputParamsMap, String searchCriteria, HashMap addionalSQLPropsMap, int count) {
        String constructedSQL = null;
        String group_by = null;
        try {
            DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvID);
            if (cvDO.size("AUDSQLQuery") > 0) {
                Row row = cvDO.getRow("AUDSQLQuery");
                constructedSQL = (String)row.get("SQL_STRING");
                Boolean group_by_used = (Boolean)row.get("GROUPBYUSED");
                if (group_by_used.booleanValue()) {
                    group_by = (String)row.get("GROUP_BY");
                }
                Boolean unionUsed = (Boolean)row.get("UNION_USED");
                inputData = this.replaceFunctionPattern(inputData);
                String sqlUnionQuery = ADAPSQLQueryUtil.getUnionQueryStackedBarChart(inputData, "sqlString", (Long)row.get("QUERY_ID"));
                String queryString = "";
                String columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvID);
                if (sqlUnionQuery != null) {
                    queryString = ADAPSQLQueryAPI.getInstance().getSQLString(sqlUnionQuery, columnString, null, inputParamsMap, addionalSQLPropsMap, group_by);
                    columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvID);
                    constructedSQL = constructedSQL.replace("${UNION_QUERY}", queryString);
                    constructedSQL = constructedSQL.replace("${COLUMNS}", columnString);
                    constructedSQL = this.formGroupByString(constructedSQL, group_by, addionalSQLPropsMap);
                    if (!addionalSQLPropsMap.isEmpty()) {
                        constructedSQL = this.setAdditionalSQLOptions(addionalSQLPropsMap, constructedSQL, count);
                    }
                } else if (unionUsed.booleanValue()) {
                    ArrayList unionQueryList = ADAPSQLQueryUtil.getUnionQueries((Long)row.get("QUERY_ID"), "UNION_QUERY");
                    for (Object object : unionQueryList) {
                        if (unionQueryList.indexOf(object) > 0) {
                            queryString = queryString + "UNION ALL ";
                        }
                        queryString = queryString + " ";
                        queryString = queryString + ADAPSQLQueryAPI.getInstance().getSQLString((String)object, columnString, searchCriteria, inputParamsMap, addionalSQLPropsMap, group_by);
                        queryString = queryString + " ";
                    }
                    constructedSQL = constructedSQL.replace("${UNION_QUERY}", queryString);
                    columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvID);
                    if (!addionalSQLPropsMap.isEmpty()) {
                        constructedSQL = this.setAdditionalSQLOptions(addionalSQLPropsMap, constructedSQL, count);
                        constructedSQL = constructedSQL.replace("${COLUMNS}", columnString);
                    }
                } else {
                    constructedSQL = ADAPSQLQueryAPI.getInstance().getSQLString(constructedSQL, columnString, searchCriteria, inputParamsMap, addionalSQLPropsMap, group_by);
                    if (!addionalSQLPropsMap.isEmpty()) {
                        constructedSQL = this.setAdditionalSQLOptions(addionalSQLPropsMap, constructedSQL, count);
                    }
                }
                constructedSQL = this.replaceFunctionPattern(constructedSQL);
                constructedSQL = this.getConstructedSQL(constructedSQL);
                constructedSQL = this.objectReplaceString(constructedSQL);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return constructedSQL;
    }

    @Override
    public final String getGraphSQLString(Long cvId, String domainName, Long graphOptID, Long noOfDays) {
        String constructedSQL = null;
        try {
            DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvId);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"GRAPH_OPT_ID"), (Object)graphOptID, 0);
            if (cvDO.size("AUDSQLQuery") > 0) {
                String columnName = "COUNT_SQL_STRING";
                Row row = cvDO.getRow("AUDSQLQuery");
                Row graphRow = cvDO.getRow("AUDGraphOptions", crit);
                String xColumnString = this.replaceFunctionPattern((String)graphRow.get("XCOLUMN"));
                String groupByString = this.replaceFunctionPattern((String)graphRow.get("GROUP_BY"));
                constructedSQL = (String)row.get(columnName);
                String searchCriteria = (String)graphRow.get("CRITERIA");
                HashMap inputParamsMap = ADAPSQLQueryUtil.getInputParamsMap(noOfDays, domainName);
                HashMap addionalSQLPropsMap = new HashMap();
                Boolean unionUsed = (Boolean)row.get("UNION_USED");
                if (unionUsed.booleanValue()) {
                    Long queryId = (Long)row.get("QUERY_ID");
                    String columnString = "," + (String)row.get("GROUP_BY");
                    constructedSQL = this.setUnionSQLQuery(cvId, searchCriteria, inputParamsMap, addionalSQLPropsMap, "", queryId, columnString, constructedSQL, "UNION_COUNT_QUERY");
                }
                String totalColumnString = "";
                String xColumnAsName = "";
                totalColumnString = "," + groupByString;
                if (xColumnString.equalsIgnoreCase(groupByString) && xColumnString.contains("DATEPART") && xColumnString.contains("DATEADD")) {
                    xColumnAsName = xColumnString + " as '" + xColumnString.replace("'", "''") + "'";
                    totalColumnString = "," + xColumnAsName;
                }
                if (!xColumnString.equalsIgnoreCase(groupByString)) {
                    xColumnAsName = xColumnString + " as '" + xColumnString.replace("'", "''") + "'";
                    String groupbyAsName = groupByString + " as '" + groupByString.replace("'", "''") + "'";
                    totalColumnString = "," + xColumnAsName + "," + groupbyAsName;
                }
                if (graphRow.get("MCOLUMN") != null) {
                    totalColumnString = totalColumnString + "," + (String)graphRow.get("MCOLUMN");
                    groupByString = groupByString + "," + (String)graphRow.get("MCOLUMN");
                }
                String sortOrder = (String)graphRow.get("SORT_ORDER");
                String limitValue = (String)graphRow.get("LIMIT_VALUE");
                constructedSQL = sortOrder != null ? constructedSQL.replace("${ORDER_BY}", " ORDER BY adapcount " + sortOrder) : constructedSQL.replace("${ORDER_BY}", "");
                if (limitValue != null) {
                    constructedSQL = this.replaceGraphRangeValues(constructedSQL, limitValue);
                } else {
                    constructedSQL = constructedSQL.replace("${GRAPHTOPVAL}", "");
                    constructedSQL = constructedSQL.replace("${LIMIT}", "");
                }
                constructedSQL = constructedSQL.replace("${COLUMNS}", totalColumnString);
                if (groupByString != null || !groupByString.equals("-")) {
                    String groupBy = " GROUP BY " + groupByString;
                    constructedSQL = constructedSQL.replace("${GROUP_BY}", groupBy);
                }
                constructedSQL = this.replaceFunctionPattern(constructedSQL);
                constructedSQL = this.getConstructedSQL(constructedSQL);
                constructedSQL = this.objectReplaceString(constructedSQL);
                String ms_hour = "DATEPART(HH,DATEADD(ss,TIME_GENERATED+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101'))";
                String xLabelValue = graphRow.get("XLABEL").toString();
                String dbServerName = CommonUtil.getDBServerName();
                if (xLabelValue.trim().endsWith("HOUR") && !constructedSQL.contains("ORDER BY")) {
                    if (dbServerName.equals("pgsql")) {
                        constructedSQL = constructedSQL + " ORDER BY TO_CHAR";
                    } else if (dbServerName.equals("mssql")) {
                        constructedSQL = constructedSQL + " ORDER BY " + ms_hour;
                    }
                } else if (xLabelValue.trim().endsWith("DAY") && !constructedSQL.contains("ORDER BY")) {
                    constructedSQL = constructedSQL.contains("MIN_TIME") ? constructedSQL + ",MIN_TIME   ORDER BY MIN_TIME" : constructedSQL + " ORDER BY MIN(TIME_GENERATED)";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return constructedSQL;
    }

    @Override
    public String getGraphReportSQLString(Long cvId, Long graphOptID, String domainName, String inputElement, Integer startIndex, Integer range, Long noOfDays, String chartType, int count) {
        String constructedSQL = null;
        try {
            DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvId);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"GRAPH_OPT_ID"), (Object)graphOptID, 0);
            if (cvDO.size("AUDSQLQuery") > 0) {
                Row row = cvDO.getRow("AUDSQLQuery");
                Row graphRow = cvDO.getRow("AUDGraphOptions", crit);
                constructedSQL = (String)row.get("SQL_STRING");
                Boolean groupByUsed = (Boolean)row.get("GROUPBYUSED");
                String groupByStr = null;
                if (groupByUsed.booleanValue()) {
                    groupByStr = (String)row.get("GROUP_BY");
                }
                String columnString = "";
                if (constructedSQL.indexOf("${COLUMNS}") != 1) {
                    columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvId);
                    constructedSQL = constructedSQL.replace("${COLUMNS}", columnString);
                }
                String searchCriteria = (String)graphRow.get("CRITERIA");
                String xColumnValue = this.replaceFunctionPattern((String)graphRow.get("XCOLUMN"));
                searchCriteria = !searchCriteria.equals("-") ? searchCriteria + " AND " + ADAPSQLQueryUtil.getXColumnValue(xColumnValue, inputElement, chartType) : null;
                HashMap inputParamsMap = ADAPSQLQueryUtil.getInputParamsMap(noOfDays, domainName);
                Boolean unionUsed = (Boolean)row.get("UNION_USED");
                HashMap<String, Object> addionalSQLPropsMap = new HashMap<String, Object>();
                String queryString = "";
                AuditReportAPI.getInstance();
                if (AuditReportAPI.isReportGraph(graphOptID).booleanValue()) {
                    AuditReportAPI.getInstance();
                    if (AuditReportAPI.isInputNeeded(graphOptID).booleanValue()) {
                        AuditReportAPI.getInstance();
                        inputParamsMap = AuditReportAPI.getInputMap(graphOptID, inputParamsMap, null);
                    }
                    addionalSQLPropsMap.put("sortColumn", "TIME_GENERATED");
                    addionalSQLPropsMap.put("sortOrder", "DESC");
                    addionalSQLPropsMap.put("startIndex", startIndex);
                    addionalSQLPropsMap.put("noOfObjects", range);
                    searchCriteria = ADAPSQLQueryUtil.getXColumnValue(xColumnValue, inputElement, chartType);
                    constructedSQL = this.getSQLString(cvId, graphOptID, inputElement, inputParamsMap, searchCriteria, addionalSQLPropsMap, count);
                } else {
                    if (chartType.equalsIgnoreCase("stackedhorizontalbar") || chartType.equalsIgnoreCase("stackedverticalbar") || chartType.equalsIgnoreCase("stackedhorizontalbar3d") || chartType.equalsIgnoreCase("stackedverticalbar3d")) {
                        columnString = ADAPSQLQueryUtil.getVisibleColumnQueryString(cvId);
                        String[] str = inputElement.split(";;");
                        String inputElement1 = "";
                        for (int i = 0; i < str.length; ++i) {
                            inputElement1 = i == str.length - 1 ? inputElement1 + str[i] : inputElement1 + str[i] + " ";
                        }
                        String unionQuery = ADAPSQLQueryUtil.getUnionQueryStackedBarChart(inputElement1, "sqlString", (Long)row.get("QUERY_ID"));
                        if (unionQuery != null) {
                            queryString = this.getSQLString(unionQuery, columnString, searchCriteria, inputParamsMap, addionalSQLPropsMap, groupByStr);
                            constructedSQL = constructedSQL.replace("${UNION_QUERY}", queryString);
                            unionUsed = false;
                        }
                    }
                    if (unionUsed.booleanValue()) {
                        Long queryId = (Long)row.get("QUERY_ID");
                        constructedSQL = queryString = this.setUnionSQLQuery(cvId, searchCriteria, inputParamsMap, addionalSQLPropsMap, groupByStr, queryId, columnString, constructedSQL, "UNION_QUERY");
                    }
                    Integer innerTopVal = startIndex - 1 + range;
                    if (count > 0 && count < innerTopVal) {
                        range = count % range;
                    }
                    constructedSQL = this.replaceRangeValues(constructedSQL, range.toString(), innerTopVal.toString());
                    constructedSQL = constructedSQL.replace("${ORDER_BY}", "ORDER BY TIME_GENERATED DESC");
                    constructedSQL = constructedSQL.replace("${CHANGE_ORDER_BY}", "ORDER BY TIME_GENERATED ASC");
                    constructedSQL = this.replaceFunctionPattern(constructedSQL);
                    constructedSQL = this.getConstructedSQL(constructedSQL);
                    constructedSQL = this.objectReplaceString(constructedSQL);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return constructedSQL;
    }

    @Override
    public String replaceGraphRangeValues(String constructedSQL, String rangeString) {
        constructedSQL = constructedSQL.replace("${LIMIT}", "LIMIT " + rangeString);
        constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${GRAPHTOPVAL}"});
        return constructedSQL;
    }

    @Override
    public String replaceRangeValues(String constructedSQL, String rangeString, String innerRangeString) {
        constructedSQL = constructedSQL.replace("${LIMIT}", "LIMIT " + rangeString);
        constructedSQL = constructedSQL.replace("${INNERLIMIT}", "LIMIT " + innerRangeString);
        constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${TOPVAL}", "${INNERTOPVAL}"});
        return constructedSQL;
    }

    @Override
    public String replaceComplianceRangeValues(String constructedSQL, String offset, String limit, String orderBy) {
        constructedSQL = !limit.equalsIgnoreCase("-1") ? constructedSQL.replace("${LIMIT}", "ORDER BY " + orderBy + " LIMIT " + limit + " OFFSET " + offset) : constructedSQL.replace("${LIMIT}", "ORDER BY " + orderBy);
        constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${TOP}", "${ROWNUM}"});
        return constructedSQL;
    }

    @Override
    public final String replaceFunctionPattern(String constructedSQL) {
        Matcher matcher = ADAPSQLQueryUtil.FUNCTION_PATTERN.matcher(constructedSQL);
        while (matcher.find()) {
            String key = matcher.group(1);
            constructedSQL = constructedSQL.replaceFirst("\\$\\{PATTERNREPLACE:([^\\}]*)\\}", patternMap.getProperty(key));
        }
        return constructedSQL;
    }

    private String formGroupByString(String constructedSQL, String groupBy, HashMap addionalSQLPropsMap) throws Exception {
        String sortColumn = (String)addionalSQLPropsMap.get("sortColumn");
        if (groupBy != null && sortColumn != null && !groupBy.contains(sortColumn)) {
            groupBy = ADAPSQLQueryUtil.formString(new String[]{groupBy, ",", sortColumn});
        }
        constructedSQL = constructedSQL.replace("${GROUP_BY}", ADAPSQLQueryUtil.formString(new String[]{"GROUP BY ", groupBy}));
        return constructedSQL;
    }

    private String replaceSearchString(String constructedSQL, String searchCriteria) throws Exception {
        return constructedSQL.replace("${SCRITERIA}", searchCriteria);
    }

    @Override
    public final String objectReplaceString(String constructedSQL) {
        try {
            Matcher matcher = ADAPSQLQueryUtil.OBJECT_PATTERN.matcher(constructedSQL);
            constructedSQL = this.objectReplaceString(constructedSQL, matcher, "${OBJECTREPLACE:");
            matcher = ADAPSQLQueryUtil.FILE_OBJECT_PATTERN.matcher(constructedSQL);
            constructedSQL = this.objectReplaceString(constructedSQL, matcher, "${SHAREREPLACE:");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return constructedSQL;
    }

    public final String objectReplaceString(String constructedSQL, Matcher matcher, String replaceStr) throws Exception {
        while (matcher.find()) {
            String queryStringForObj = matcher.group().replace(replaceStr, "");
            queryStringForObj = queryStringForObj.substring(0, queryStringForObj.length() - 1);
            String[] inputs = queryStringForObj.split(";;;");
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("objectClass", inputs[0]);
            String objectGuidStr = inputs[3];
            inputParams.put("object_guid", new ArrayList<String>(Arrays.asList(objectGuidStr.split(","))));
            HashMap inputParamsMap = new HashMap();
            AuditReportParamsAPI.getObjectValues(0L, inputParams, inputParamsMap);
            inputParamsMap = ReportSchedulerUtil.formInputParamsMap(inputs[1], inputParams, inputParamsMap);
            String[] inputStr = inputs[2].split(",");
            String value = (String)inputParamsMap.get(inputStr[0]);
            for (int i = 1; i < inputStr.length; ++i) {
                value = value + ", " + inputParamsMap.get(inputStr[i]);
            }
            if ("mysql".equalsIgnoreCase(CommonUtil.getDBServerName())) {
                value = value.replace("\\\\\\\\", "\\");
            } else if ("postgres".equalsIgnoreCase(CommonUtil.getDBServerName())) {
                value = value.replace("\\\\", "\\");
            }
            constructedSQL = constructedSQL.replace(replaceStr + queryStringForObj + "}", value);
        }
        return constructedSQL;
    }

    @Override
    public void updatePatternMap() {
        patternMap = ADAPSQLQueryUtil.getFunctionPattern(columnValue);
    }
}

