/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sql.query;

import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.query.DefaultQueryBuilder;
import java.util.HashMap;

public class MySQLQueryBuilder
extends DefaultQueryBuilder {
    MySQLQueryBuilder() {
        columnValue = "MYSQL_COLUMN_VALUE";
        patternMap = ADAPSQLQueryUtil.getFunctionPattern(columnValue);
    }

    @Override
    public String getBusinessSearchCriteria(String businessParams, boolean count) {
        String searchCriteria1 = null;
        String searchCriteria2 = null;
        HashMap<String, String> businessAlertValues = BusinessServerSettings.getBusinessHourSettings();
        String timeString = businessAlertValues.isEmpty() ? "" : businessAlertValues.get("FromTime");
        try {
            if (!businessParams.equalsIgnoreCase("false") && !timeString.equals("")) {
                int fromTime = Integer.parseInt(businessAlertValues.get("FromTime"));
                int toTime = Integer.parseInt(businessAlertValues.get("ToTime"));
                searchCriteria1 = "HOUR(from_unixtime(" + (count ? "" : "${ALIAS}.") + "time_generated))";
                searchCriteria2 = "DAYOFWEEK(from_unixtime(" + (count ? "" : "${ALIAS}.") + "time_generated))";
                String queryDays = BusinessServerSettings.getQueryDays();
                if (businessParams.equalsIgnoreCase("business")) {
                    searchCriteria1 = searchCriteria1 + " between  " + fromTime + " and " + (toTime - 1);
                    searchCriteria2 = " and " + searchCriteria2 + " in " + queryDays;
                } else {
                    searchCriteria1 = "(" + searchCriteria1 + " not between  " + fromTime + " and " + (toTime - 1) + " or " + searchCriteria2 + " not in " + queryDays + ")";
                    searchCriteria2 = "";
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return searchCriteria1 != null ? searchCriteria1 + searchCriteria2 : null;
    }

    @Override
    public String getMinCrunchTimeValue(String timeFloor, int tzOffset, int scheduler) {
        String floor = null;
        try {
            floor = scheduler == 0 ? "((FLOOR((" + timeFloor + "+(" + tzOffset + "))/3600)*3600)-(" + tzOffset + "))" : (scheduler == 1 ? "((FLOOR((" + timeFloor + "+(" + tzOffset + "))/86400)*86400)-(" + tzOffset + "))" : (scheduler == 2 ? "UNIX_TIMESTAMP(cast(date_format( FROM_UNIXTIME(" + timeFloor + "),\"%Y-%m-01\")as date))" : (scheduler == 3 ? "UNIX_TIMESTAMP(cast(date_format( FROM_UNIXTIME(" + timeFloor + "),\"%Y-01-01\")as date) + INTERVAL ((3*EXTRACT(QUARTER FROM FROM_UNIXTIME(" + timeFloor + ")))-3) MONTH)" : (scheduler == 4 ? "UNIX_TIMESTAMP(cast(date_format( FROM_UNIXTIME(" + timeFloor + "),\"%Y-01-01\")as date) + INTERVAL (floor((EXTRACT(MONTH FROM FROM_UNIXTIME(" + timeFloor + "))-1)/6)*6) MONTH)" : "UNIX_TIMESTAMP(cast(date_format( FROM_UNIXTIME(" + timeFloor + "),\"%Y-01-01\")as date))"))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return floor;
    }
}

