/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sql.query;

import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.query.DefaultQueryBuilder;
import java.util.HashMap;

public class PSQLQueryBuilder
extends DefaultQueryBuilder {
    PSQLQueryBuilder() {
        columnValue = "POSTGRES_COLUMN_VALUE";
        patternMap = ADAPSQLQueryUtil.getFunctionPattern(columnValue);
    }

    @Override
    public String getBusinessSearchCriteria(String businessParams, boolean count) {
        String searchCriteria1 = null;
        String searchCriteria2 = null;
        HashMap<String, String> businessAlertValues = BusinessServerSettings.getBusinessHourSettings();
        String timeString = businessAlertValues.isEmpty() ? "" : businessAlertValues.get("FromTime");
        try {
            if (!businessParams.equalsIgnoreCase("false") && !timeString.equals("")) {
                int fromTime = Integer.parseInt(businessAlertValues.get("FromTime"));
                int toTime = Integer.parseInt(businessAlertValues.get("ToTime"));
                searchCriteria1 = "to_number(to_char(TO_TIMESTAMP(" + (count ? "" : "${ALIAS}.") + "time_generated),'HH24'),'99G999D9S')";
                searchCriteria2 = " to_number(to_char(TO_TIMESTAMP(" + (count ? "" : "${ALIAS}.") + "time_generated),'D'),'99G999D9S')";
                String queryDays = BusinessServerSettings.getQueryDays();
                if (businessParams.equalsIgnoreCase("business")) {
                    searchCriteria1 = searchCriteria1 + " between  " + fromTime + " and " + (toTime - 1);
                    searchCriteria2 = " and " + searchCriteria2 + " in " + queryDays;
                } else {
                    searchCriteria1 = "(" + searchCriteria1 + " not between  " + fromTime + " and " + (toTime - 1) + " or " + searchCriteria2 + " not in " + queryDays + ")";
                    searchCriteria2 = "";
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return searchCriteria1 != null ? searchCriteria1 + searchCriteria2 : null;
    }

    @Override
    public String getMinCrunchTimeValue(String timeFloor, int tzOffset, int scheduler) {
        String floor = null;
        try {
            if (scheduler == 0) {
                floor = "((FLOOR((" + timeFloor + "+(" + tzOffset + "))/3600)*3600)-(" + tzOffset + "))";
            } else if (scheduler == 1) {
                floor = "((FLOOR((" + timeFloor + "+(" + tzOffset + "))/86400)*86400)-(" + tzOffset + "))";
            } else if (scheduler == 2) {
                floor = "(DATE_PART('EPOCH',DATE_TRUNC('MONTH',TIMESTAMP 'EPOCH' + (" + timeFloor + "+(" + tzOffset + ")) * INTERVAL '1 SECOND'))-(" + tzOffset + "))";
            } else if (scheduler == 3) {
                floor = "(DATE_PART('EPOCH',DATE_TRUNC('QUARTER',TIMESTAMP 'EPOCH' + (" + timeFloor + "+(" + tzOffset + ")) * INTERVAL '1 SECOND'))-(" + tzOffset + "))";
            } else if (scheduler == 4) {
                floor = "(DATE_PART('EPOCH',(DATE_TRUNC('YEAR',TIMESTAMP 'EPOCH' + (" + timeFloor + "+(" + tzOffset + ")) * INTERVAL '1 SECOND')+ (FLOOR((EXTRACT";
                floor = floor + "(MONTH FROM (TIMESTAMP 'EPOCH' + (" + timeFloor + "+(" + tzOffset + ")) * INTERVAL '1 SECOND'))-1)/6)*6)* INTERVAL '1 MONTH'))-(" + tzOffset + "))";
            } else {
                floor = "(DATE_PART('EPOCH',DATE_TRUNC('YEAR',TIMESTAMP 'EPOCH' + (" + timeFloor + "+(" + tzOffset + ")) * INTERVAL '1 SECOND'))-(" + tzOffset + "))";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return floor;
    }
}

