/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sql.query;

import com.adventnet.sym.adsm.common.server.admin.BusinessServerSettings;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.query.DefaultQueryBuilder;
import java.util.HashMap;

public class SQLServerQueryBuilder
extends DefaultQueryBuilder {
    SQLServerQueryBuilder() {
        columnValue = "MSSQL_COLUMN_VALUE";
        patternMap = ADAPSQLQueryUtil.getFunctionPattern(columnValue);
    }

    @Override
    public String getBusinessSearchCriteria(String businessParams, boolean count) {
        String searchCriteria1 = null;
        String searchCriteria2 = null;
        HashMap<String, String> businessAlertValues = BusinessServerSettings.getBusinessHourSettings();
        String timeString = businessAlertValues.isEmpty() ? "" : businessAlertValues.get("FromTime");
        try {
            if (!businessParams.equalsIgnoreCase("false") && !timeString.equals("")) {
                int fromTime = Integer.parseInt(businessAlertValues.get("FromTime"));
                int toTime = Integer.parseInt(businessAlertValues.get("ToTime"));
                searchCriteria1 = "DATEPART(hh,DATEADD(ss," + (count ? "" : "${ALIAS}.") + "time_generated+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101'))";
                searchCriteria2 = "DATEPART(dw,DATEADD(ss," + (count ? "" : "${ALIAS}.") + "time_generated+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101'))";
                String queryDays = BusinessServerSettings.getQueryDays();
                if (businessParams.equalsIgnoreCase("business")) {
                    searchCriteria1 = searchCriteria1 + " between  " + fromTime + " and " + (toTime - 1);
                    searchCriteria2 = " and " + searchCriteria2 + " in " + queryDays;
                } else {
                    searchCriteria1 = "(" + searchCriteria1 + " not between  " + fromTime + " and " + (toTime - 1) + " or " + searchCriteria2 + " not in " + queryDays + ")";
                    searchCriteria2 = "";
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return searchCriteria1 != null ? searchCriteria1 + searchCriteria2 : null;
    }

    @Override
    public String getMinCrunchTimeValue(String timeFloor, int tzOffset, int scheduler) {
        String floor = null;
        try {
            if (scheduler == 0) {
                floor = "((FLOOR((" + timeFloor + "+(" + tzOffset + "))/3600)*3600)-(" + tzOffset + "))";
            } else if (scheduler == 1) {
                floor = "((FLOOR((" + timeFloor + "+(" + tzOffset + "))/86400)*86400)-(" + tzOffset + "))";
            } else if (scheduler == 2) {
                floor = "(DATEDIFF(s, '19700101',CAST(CAST(YEAR(DATEADD(s, " + timeFloor + "+(" + tzOffset + "), '19700101')) AS VARCHAR(4)) + '/' + CAST(MONTH";
                floor = floor + "(DATEADD(s, " + timeFloor + "+(" + tzOffset + "), '19700101')) AS VARCHAR(2)) + '/01' AS DATETIME))-(" + tzOffset + "))";
            } else if (scheduler == 3) {
                floor = "(DATEDIFF(s, '19700101',CAST(CAST(YEAR(DATEADD(s, " + timeFloor + "+(" + tzOffset + "), '19700101')) AS VARCHAR(4)) + '/' +CAST(((3*DATEPART";
                floor = floor + "(q,DATEADD(s, " + timeFloor + "+(" + tzOffset + "), '19700101')))-2) AS VARCHAR(2)) + '/01' AS DATETIME))-(" + tzOffset + "))";
            } else if (scheduler == 4) {
                floor = "(DATEDIFF(s, '19700101',CAST(CAST(YEAR(DATEADD(s, " + timeFloor + "+(" + tzOffset + "), '19700101')) AS VARCHAR(4)) + '/' + CAST(((((MONTH";
                floor = floor + "(DATEADD(s, " + timeFloor + "+(" + tzOffset + "), '19700101'))-1)/6)*6)+1) AS VARCHAR(2)) + '/01' AS DATETIME))-(" + tzOffset + "))";
            } else {
                floor = "(DATEDIFF(s, '19700101',CAST(CAST(YEAR(DATEADD(s, " + timeFloor + "+(" + tzOffset + "), '19700101')) AS VARCHAR(4)) + '/' + '01/01' AS DATETIME))-(" + tzOffset + "))";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return floor;
    }

    @Override
    public String replaceRangeValues(String constructedSQL, String rangeString, String innerRangeString) {
        constructedSQL = constructedSQL.replace("${TOPVAL}", "TOP " + rangeString);
        constructedSQL = constructedSQL.replace("${INNERTOPVAL}", "TOP " + innerRangeString);
        constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${LIMIT}", "${INNERLIMIT}"});
        return constructedSQL;
    }

    @Override
    public String replaceComplianceRangeValues(String constructedSQL, String offset, String limit, String orderBy) {
        String orderByString = "SUM(" + orderBy.substring(0, orderBy.indexOf(" ")) + ")" + orderBy.substring(orderBy.indexOf(" ") + 1);
        constructedSQL = constructedSQL.replace("${TOP}", "SELECT * FROM(");
        constructedSQL = constructedSQL.replace("${ROWNUM}", ",ROW_NUMBER() OVER (ORDER BY " + orderByString + ") AS ROWNUM");
        constructedSQL = !limit.equalsIgnoreCase("-1") ? constructedSQL.replace("${LIMIT}", ")AS DERIVEDTABLE WHERE DERIVEDTABLE.ROWNUM BETWEEN " + offset + " AND " + limit) : constructedSQL.replace("${LIMIT}", ")AS DERIVEDTABLE");
        return constructedSQL;
    }

    @Override
    public String replaceGraphRangeValues(String constructedSQL, String rangeString) {
        if (rangeString != null && !"".equals(rangeString)) {
            constructedSQL = constructedSQL.replace("${GRAPHTOPVAL}", "TOP " + rangeString);
        }
        constructedSQL = ADAPSQLQueryUtil.removeCharSequence(constructedSQL, new String[]{"${LIMIT}", "${GRAPHTOPVAL}"});
        return constructedSQL;
    }
}

