/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlertSchedulerUtil {
    private static final String EVENT_TASK_NAME = "ClearAlerts";
    private static Logger logger = Logger.getLogger("ADMangLogger");

    public static boolean createAlertScheduler(HashMap schedulerPropsMap) {
        boolean creationStatus = false;
        try {
            DataObject schDo = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row schRow = new Row("AUDAlertScheduler");
            schRow.set("SCHEDULE_ID", schedulerPropsMap.get("scheduleId"));
            schRow.set("TIME_PERIOD", schedulerPropsMap.get("alertLife"));
            schRow.set("UNIT_OF_TIME", schedulerPropsMap.get("units"));
            schDo.addRow(schRow);
            CommonUtil.getPersistence(new boolean[0]).add(schDo);
            creationStatus = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            creationStatus = false;
        }
        logger.log(Level.INFO, "Create Alert Scheduler :" + creationStatus);
        return creationStatus;
    }

    public static DataObject getSchDo() {
        String event_task_name = EVENT_TASK_NAME;
        DataObject dobj = null;
        try {
            Long task_id = SchedulerUtil.getTaskID(event_task_name);
            Criteria crit = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"TASK_ID"), (Object)task_id, 0);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("Scheduled_Task");
            tableList.add("Schedule");
            tableList.add("AUDAlertScheduler");
            dobj = CommonUtil.getPersistence(new boolean[0]).get(tableList, crit);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dobj;
    }

    public static void modifyAlertScheduler(HashMap schedulerPropsMap) {
        try {
            DataObject dobj = AlertSchedulerUtil.getSchDo();
            Row row = dobj.getRow("Scheduled_Task");
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row schRow = dobj.getRow("AUDAlertScheduler");
            schRow.set("TIME_PERIOD", schedulerPropsMap.get("alertLife"));
            dobj.updateRow(schRow);
            logger.log(Level.INFO, "Successfully Updated :");
            CommonUtil.getPersistence(new boolean[0]).update(dobj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static HashMap viewAlertScheduler() {
        HashMap<String, Object> schMap = null;
        try {
            DataObject dobj = AlertSchedulerUtil.getSchDo();
            if (dobj.size("Scheduled_Task") > 0) {
                schMap = new HashMap<String, Object>();
                Row row = dobj.getRow("Scheduled_Task");
                schMap.put("scheduleId", (Long)row.get("SCHEDULE_ID"));
                schMap.put("adminStatus", (Integer)row.get("ADMIN_STATUS"));
                Row schRow = dobj.getRow("AUDAlertScheduler");
                schMap.put("alertLife", schRow.get("TIME_PERIOD"));
            } else {
                schMap = new HashMap();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.log(Level.INFO, "schMap is  " + schMap);
        return schMap;
    }

    public static void deleteAlerts(Long schedulerId) {
        try {
            String status = SchedulerUtil.getStatus(schedulerId);
            if (status != null && status.equalsIgnoreCase("Enabled")) {
                Criteria criteria = new Criteria(Column.getColumn((String)"AUDAlertScheduler", (String)"SCHEDULE_ID"), (Object)schedulerId, 0);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertScheduler", criteria);
                if (dataObject.size("AUDAlertScheduler") > 0) {
                    Row row = dataObject.getRow("AUDAlertScheduler");
                    Long TIME_PERIOD = (Long)row.get("TIME_PERIOD") * 86400L;
                    Long FROM = System.currentTimeMillis() / 1000L - TIME_PERIOD;
                    Criteria crit = new Criteria(Column.getColumn((String)"AUDAlert", (String)"CREATION_TIME"), (Object)FROM, 6);
                    CommonUtil.getPersistenceLite().delete(crit);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAlerts() {
        RelationalAPI rapi = null;
        Connection connection = null;
        Statement stmt = null;
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDAlertScheduler", (Row)null);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDAlertScheduler");
                Long days = (Long)row.get("TIME_PERIOD") * 86400L;
                Long currentTime = System.currentTimeMillis() / 1000L;
                Long diffTime = currentTime - days;
                rapi = RelationalAPI.getInstance();
                connection = rapi.getConnection();
                stmt = connection.createStatement();
                logger.info("Before Starting the Process, Time is ::: " + currentTime);
                String dbServerName = CommonUtil.getDBServerName();
                String query = "";
                if (dbServerName.equalsIgnoreCase("mssql")) {
                    query = "DELETE TOP (10000) FROM AUDALERT WHERE CREATION_TIME <= " + diffTime + "";
                } else if (dbServerName.equalsIgnoreCase("mysql")) {
                    query = "DELETE FROM AUDALERT WHERE CREATION_TIME <= " + diffTime + " limit 10000";
                } else if (dbServerName.equalsIgnoreCase("postgres")) {
                    query = "DELETE FROM AUDALERT WHERE ALERT_ID IN (SELECT ALERT_ID FROM AUDALERT WHERE CREATION_TIME <= " + diffTime + " LIMIT 10000)";
                }
                int count = 10000;
                while (count == 10000) {
                    count = QueryUtil.executeUpdate("Delete Alerts:", stmt, query);
                }
                logger.info("After Finishing the Process, Time is ::: " + System.currentTimeMillis());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public static HashMap getScheduledId(String scheduleName) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"Scheduled_Task"));
            Join join = new Join("Scheduled_Task", "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            selectQuery.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)scheduleName, 0, false);
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Scheduled_Task", (String)"TASK_ID"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Row row = dataObject.getRow("Scheduled_Task");
            if (row != null) {
                Long scheduleId = Long.valueOf(row.get("SCHEDULE_ID").toString());
                Long taskId = Long.valueOf(row.get("TASK_ID").toString());
                map.put("scheduleId", scheduleId);
                map.put("taskId", taskId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static boolean deleteAlertScheduleRow() {
        boolean b = true;
        try {
            DataObject dobj = AlertSchedulerUtil.getSchDo();
            Row row = dobj.getRow("Scheduled_Task");
            Long scheduleId = (Long)row.get("SCHEDULE_ID");
            Criteria crit = new Criteria(Column.getColumn((String)"AUDAlertScheduler", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            CommonUtil.getPersistenceLite().delete(crit);
        }
        catch (Exception e) {
            b = false;
            e.printStackTrace();
        }
        return b;
    }
}

