/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.csvreader.CsvReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class BCPUtilities {
    private static Logger logger = Logger.getLogger("QueryLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unzipFile(String filePath, String extractDir) {
        FileInputStream fis = null;
        ZipInputStream zipIs = null;
        ZipEntry zEntry = null;
        String retFileName = null;
        File dir = new File(extractDir);
        try {
            if (!dir.exists()) {
                dir.mkdir();
            }
            fis = new FileInputStream(filePath);
            zipIs = new ZipInputStream(new BufferedInputStream(fis));
            while ((zEntry = zipIs.getNextEntry()) != null) {
                FileOutputStream fos = null;
                try {
                    byte[] tmp = new byte[4096];
                    String opFilePath = extractDir + File.separator + zEntry.getName();
                    logger.log(Level.INFO, "Extracting file to " + opFilePath);
                    fos = new FileOutputStream(opFilePath);
                    int size = 0;
                    while ((size = zipIs.read(tmp)) != -1) {
                        fos.write(tmp, 0, size);
                    }
                    fos.flush();
                    fos.close();
                    retFileName = extractDir + File.separator + zEntry.getName();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (fos == null) continue;
                    fos.close();
                }
            }
            zipIs.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.log(Level.INFO, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.log(Level.INFO, e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(String fileToZip) {
        byte[] buffer = new byte[1024];
        FileOutputStream fos = null;
        FileInputStream in = null;
        try {
            int len;
            File f = new File(fileToZip);
            String outputFile = fileToZip.replaceFirst("\\.csv", "\\.zip");
            fos = new FileOutputStream(outputFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry(f.getName());
            zos.putNextEntry(ze);
            in = new FileInputStream(fileToZip);
            while ((len = in.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            in.close();
            zos.closeEntry();
            zos.close();
            logger.log(Level.INFO, "Done");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            logger.log(Level.INFO, ex.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void convertFormatToMssql(String fileName) throws Exception {
        String delimiter = "|**|";
        CsvReader csvReader = new CsvReader((Reader)new FileReader(fileName), ',');
        String fileCsv = fileName.replaceFirst("\\.csv", "\\.sql");
        logger.log(Level.INFO, "FILECSV " + fileCsv);
        PrintWriter writer = new PrintWriter(fileCsv, "UTF-8");
        logger.log(Level.INFO, "Converting file : " + fileName);
        while (csvReader.readRecord()) {
            for (int i = 0; i < csvReader.getColumnCount(); ++i) {
                writer.print(csvReader.get(i));
                writer.print(delimiter);
            }
            writer.print("|**|**|\r\n");
        }
        writer.close();
        csvReader.close();
        File orignalFile = new File(fileName);
        File toBeRenamed = new File(fileCsv);
        if (orignalFile.delete()) {
            logger.log(Level.INFO, "File delete success");
        } else {
            logger.log(Level.INFO, "File delete failure " + orignalFile);
        }
        if (toBeRenamed.renameTo(orignalFile)) {
            logger.log(Level.INFO, "Renamed successfully!");
        } else {
            logger.log(Level.INFO, "Rename failure " + orignalFile);
        }
        logger.log(Level.INFO, "Converted Successfully. File Name : " + fileName);
    }

    public static void main(String[] args) {
        try {
            if (args[1] == null) {
                logger.log(Level.INFO, "Usage : BCPUtilities <operation> <Dir_with_files_to_convert> <Output_Folder>");
                logger.log(Level.INFO, "Operation : a. Convert File compatability from old archives , b. Zip the archive files");
                System.exit(-1);
            }
            File folder = new File(args[1]);
            File[] listOfFiles = null;
            listOfFiles = "ZipCreation".equalsIgnoreCase(args[0]) ? folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith("csv");
                }
            }) : folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith("zip");
                }
            });
            for (int i = 0; i < listOfFiles.length; ++i) {
                String fileToConvert = args[1] + "\\" + listOfFiles[i].getName();
                logger.log(Level.INFO, "Operation for the file : " + fileToConvert);
                if ("ZipCreation".equals(args[0])) {
                    BCPUtilities.zipFile(fileToConvert);
                    continue;
                }
                String retFile = BCPUtilities.unzipFile(fileToConvert, args[2]);
                BCPUtilities.convertFormatToMssql(retFile);
                logger.log(Level.INFO, "Converted File : " + retFile);
                BCPUtilities.zipFile(retFile);
                File delFile = new File(retFile);
                if (delFile.delete()) {
                    logger.log(Level.INFO, "File delete success");
                    continue;
                }
                logger.log(Level.INFO, "File delete failure" + retFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(Level.INFO, ex.getMessage());
        }
    }
}

