/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.archive.ArchiveFileAPI;
import com.adventnet.sym.adsm.auditing.server.backupdata.Backup;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreArchivedEventTable;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class BackupTableUtil {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(BackupTableUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getCategoriesList() {
        ArrayList<String> categoryList = new ArrayList<String>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDBackUpMetaTable"));
            Join audBackUpMetaEventCategoriesJoin = new Join("AUDBackUpMetaTable", "AUDBackupDataConfig", new String[]{"TABLE_NAME"}, new String[]{"TABLE_NAME"}, 2);
            selectQuery.addJoin(audBackUpMetaEventCategoriesJoin);
            ArrayList<Column> groupList = new ArrayList<Column>();
            groupList.add(Column.getColumn((String)"AUDBackupDataConfig", (String)"CATEGORY_DISPLAY_NAME"));
            GroupByClause gr = new GroupByClause(groupList);
            selectQuery.setGroupByClause(gr);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackupDataConfig", (String)"CATEGORY_DISPLAY_NAME"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selectQuery, connection);
            categoryList.add("All");
            while (dataSet.next()) {
                String categoryName = rb.getString((String)dataSet.getValue("CATEGORY_DISPLAY_NAME"));
                categoryList.add(categoryName);
            }
            categoryList.add(rb.getString("adap.AdminController.Import_Log_File"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return categoryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getBackUpTableSettings() {
        Connection connection = null;
        DataSet dataSet = null;
        ArrayList backUpDataList = new ArrayList();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDBackupDataConfig"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"IMPORTLOG_TABLE"), (Object)false, 0);
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackupDataConfig", (String)"TABLE_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackupDataConfig", (String)"TIME_PERIOD"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackupDataConfig", (String)"IS_BACKUP"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackupDataConfig", (String)"CATEGORY_DISPLAY_NAME"));
            SortColumn sortColumn = new SortColumn("AUDBackupDataConfig", "TABLE_NAME", true);
            selectQuery.addSortColumn(sortColumn);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                HashMap<String, Object> backUpDataMap = new HashMap<String, Object>();
                String tableName = (String)dataSet.getValue("TABLE_NAME");
                String categoryName = rb.getString((String)dataSet.getValue("CATEGORY_DISPLAY_NAME"));
                long timePeriod = Long.valueOf(dataSet.getValue("TIME_PERIOD").toString());
                boolean isBackUp = Boolean.valueOf(dataSet.getValue("IS_BACKUP").toString());
                backUpDataMap.put("TABLE_NAME", tableName);
                backUpDataMap.put("CATEGORY_NAME", categoryName);
                backUpDataMap.put("TIME_PERIOD", timePeriod);
                backUpDataMap.put("IS_BACKUP", isBackUp);
                backUpDataList.add(backUpDataMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return backUpDataList;
    }

    public static boolean updateBackUpTableData(ArrayList updateBackUpDataList, String folder) {
        boolean b = true;
        try {
            HashMap<String, String> archiveConfigMap = new HashMap<String, String>();
            archiveConfigMap.put("BASE_ARCHIVE_DIRECTORY", folder);
            String[] tableNameList = new String[updateBackUpDataList.size()];
            for (int i = 0; i < updateBackUpDataList.size(); ++i) {
                String tableName;
                HashMap updateDetailsMap = (HashMap)updateBackUpDataList.get(i);
                tableNameList[i] = tableName = (String)updateDetailsMap.get("TABLE_NAME");
            }
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"TABLE_NAME"), (Object)tableNameList, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDBackupDataConfig", criteria);
            for (int i = 0; i < updateBackUpDataList.size(); ++i) {
                HashMap updateDetailsMap1 = (HashMap)updateBackUpDataList.get(i);
                String tableName1 = (String)updateDetailsMap1.get("TABLE_NAME");
                Criteria tableNameCriteria = new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"TABLE_NAME"), (Object)tableName1, 0);
                Row row = dataObject.getRow("AUDBackupDataConfig", tableNameCriteria);
                row.set("TIME_PERIOD", updateDetailsMap1.get("TIME_PERIOD"));
                row.set("IS_BACKUP", updateDetailsMap1.get("IS_BACKUP"));
                dataObject.updateRow(row);
            }
            ArchiveFileAPI.getInstance().addOrUpdateArchiveConfig(archiveConfigMap);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            b = false;
            e.printStackTrace();
        }
        return b;
    }

    public static ArrayList getCategoryTableNames() {
        ArrayList<String> tableNameList = new ArrayList<String>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDBackupDataConfig"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackupDataConfig", (String)"TABLE_NAME"));
            DataObject dObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dObject.getRows("AUDBackupDataConfig");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String tableName = (String)row.get("TABLE_NAME");
                tableNameList.add(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableNameList;
    }

    public static void backupData() {
        try {
            ArrayList backUpTablesAndTimePeriod = BackupTableUtil.getBackUpTableAndTimePeriod();
            if (backUpTablesAndTimePeriod.size() > 0) {
                HashMap metaTableMap = BackupTableUtil.getMetaTables(backUpTablesAndTimePeriod);
                Set keySet = metaTableMap.keySet();
                for (String keyName : keySet) {
                    ArrayList metatableNameList = (ArrayList)metaTableMap.get(keyName);
                    if (metatableNameList.isEmpty()) continue;
                    BackupTableUtil.dumpTable(metatableNameList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getBackUpTableAndTimePeriod() {
        ArrayList tableNameList = new ArrayList();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDBackupDataConfig"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"IS_BACKUP"), (Object)true, 0);
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackupDataConfig", (String)"TABLE_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDBackupDataConfig", (String)"TIME_PERIOD"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("AUDBackupDataConfig");
            while (iterator.hasNext()) {
                HashMap<String, Object> tableNameAndTimePeriodMap = new HashMap<String, Object>();
                Row row = (Row)iterator.next();
                String tableName = (String)row.get("TABLE_NAME");
                long timePeriod = Long.valueOf(row.get("TIME_PERIOD").toString());
                tableNameAndTimePeriodMap.put("TABLE_NAME", tableName);
                tableNameAndTimePeriodMap.put("TIME_PERIOD", timePeriod);
                tableNameList.add(tableNameAndTimePeriodMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableNameList;
    }

    public static HashMap getMetaTables(ArrayList backUpTablesAndTimePeriod) {
        HashMap metaTableMap = new HashMap();
        try {
            for (int i = 0; i < backUpTablesAndTimePeriod.size(); ++i) {
                HashMap tableAndPeriodMap = (HashMap)backUpTablesAndTimePeriod.get(i);
                String tableName = (String)tableAndPeriodMap.get("TABLE_NAME");
                long timePeriod = Long.valueOf(tableAndPeriodMap.get("TIME_PERIOD").toString());
                Long TIME_PERIOD = timePeriod * 86400L;
                Long FROM = System.currentTimeMillis() / 1000L - TIME_PERIOD;
                SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDMetaTable"));
                Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"), (Object)tableName, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"), (Object)FROM, 7));
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"), (Object)0, 5));
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"IMPORT_TABLE"), (Object)false, 0));
                selectQuery.setCriteria(crit);
                selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"));
                selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"LOOKUP_TABLENAME"));
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
                Iterator iterator = dataObject.getRows("AUDMetaTable");
                ArrayList<String> metaTableList = new ArrayList<String>();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    String metaTableName = (String)row.get("LOOKUP_TABLENAME");
                    metaTableList.add(metaTableName);
                }
                metaTableMap.put(tableName, metaTableList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metaTableMap;
    }

    public static boolean dumpTable(ArrayList metaTableNameList) {
        try {
            for (int i = 0; i < metaTableNameList.size(); ++i) {
                String metaTableName = (String)metaTableNameList.get(i);
                boolean b = Backup.getInstance().dumpTable(metaTableName);
                logger.info("BACKUP TABLE : " + metaTableName + " : Return val :" + b);
                if (!b) continue;
                BackupTableUtil.backUpmetaTableRow(metaTableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean backUpmetaTableRow(String metaTableName) {
        try {
            boolean b;
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AUDMetaTable"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDMetaTable", (String)"LOOKUP_TABLENAME"), (Object)metaTableName, 0);
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"TABLE_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"START_TIME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"END_TIME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"START_INDEX"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"END_INDEX"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"LOOKUP_TABLENAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AUDMetaTable", (String)"IMPORT_TABLE"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Row row = dataObject.getRow("AUDMetaTable");
            HashMap<String, Object> backupDataMap = new HashMap<String, Object>();
            if (row != null) {
                String tableName = (String)row.get("TABLE_NAME");
                Long startTime = Long.valueOf(row.get("START_TIME").toString());
                Long endTime = Long.valueOf(row.get("END_TIME").toString());
                Long startIndex = Long.valueOf(row.get("START_INDEX").toString());
                Long endIndex = Long.valueOf(row.get("END_INDEX").toString());
                String lookupTableName = (String)row.get("LOOKUP_TABLENAME");
                String fileName = lookupTableName + ".zip";
                Backup.getInstance();
                String backupDir = Backup.getBackupDir();
                Boolean importTable = (Boolean)row.get("IMPORT_TABLE");
                backupDataMap.put("TABLE_NAME", tableName);
                backupDataMap.put("START_TIME", startTime);
                backupDataMap.put("END_TIME", endTime);
                backupDataMap.put("START_INDEX", startIndex);
                backupDataMap.put("END_INDEX", endIndex);
                backupDataMap.put("LOOKUP_TABLENAME", lookupTableName);
                backupDataMap.put("FILE_NAME", fileName);
                backupDataMap.put("BASE_DB_BACKUP_DIRECTORY", backupDir);
                backupDataMap.put("IS_REGENERATE_DATA", false);
                backupDataMap.put("IMPORT_TABLE", importTable);
            }
            if (b = BackupTableUtil.addInBackUpMetaTable(backupDataMap)) {
                CommonUtil.getPersistenceLite().delete(crit);
                String dropTableQR = "DROP TABLE  " + metaTableName;
                QueryUtil.executeSingleQuery("DROP BACKUP TABLE", dropTableQR);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean addInBackUpMetaTable(HashMap backupDataMap) {
        boolean b = true;
        try {
            Row row = new Row("AUDBackUpMetaTable");
            row.set("TABLE_NAME", (Object)((String)backupDataMap.get("TABLE_NAME")));
            row.set("START_TIME", (Object)Long.valueOf(backupDataMap.get("START_TIME").toString()));
            row.set("END_TIME", (Object)Long.valueOf(backupDataMap.get("END_TIME").toString()));
            row.set("START_INDEX", (Object)Long.valueOf(backupDataMap.get("START_INDEX").toString()));
            row.set("END_INDEX", (Object)Long.valueOf(backupDataMap.get("END_INDEX").toString()));
            row.set("LOOKUP_TABLENAME", (Object)((String)backupDataMap.get("LOOKUP_TABLENAME")));
            row.set("FILE_NAME", (Object)((String)backupDataMap.get("FILE_NAME")));
            row.set("BASE_DB_BACKUP_DIRECTORY", (Object)((String)backupDataMap.get("BASE_DB_BACKUP_DIRECTORY")));
            row.set("IS_REGENERATE_DATA", (Object)Boolean.valueOf(backupDataMap.get("IS_REGENERATE_DATA").toString()));
            row.set("IMPORT_TABLE", (Object)Boolean.valueOf(backupDataMap.get("IMPORT_TABLE").toString()));
            DataObject metaDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            metaDO.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(metaDO);
        }
        catch (Exception e) {
            b = false;
            e.printStackTrace();
        }
        return b;
    }

    public static void archiveEvents() {
        BackupTableUtil.backupData();
        RestoreArchivedEventTable.deleteFromDB();
    }
}

