/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class CleanUpUtil {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpObjectDetails() {
        RelationalAPI rapi = null;
        Connection con = null;
        Statement stmt = null;
        String query = null;
        long currentTime = System.currentTimeMillis();
        try {
            long days = 604800000L;
            long diffTime = currentTime - days;
            query = "delete from ADSMObjectGenerationDetails where CREATION_TIME < " + diffTime;
            rapi = RelationalAPI.getInstance();
            con = rapi.getConnection();
            stmt = con.createStatement();
            int count = 20;
            while (count == 20) {
                count = stmt.executeUpdate(query);
            }
            System.out.println("Deletion completed.......");
        }
        catch (Exception e) {
            System.out.println("Exception while deleting rows from the reportresult tables");
            e.printStackTrace();
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpScheduleHistory() {
        RelationalAPI rapi = null;
        Connection con = null;
        Statement stmt = null;
        String query = null;
        long currentTime = System.currentTimeMillis();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long noOfDays = 2592000000L;
            Date date = new Date(currentTime - noOfDays);
            String finishTime = sdf.format(date);
            query = "delete from Schedule_Audit where SCHEDULE_FINISH_TIME < '" + finishTime + "';";
            rapi = RelationalAPI.getInstance();
            con = rapi.getConnection();
            stmt = con.createStatement();
            stmt.executeUpdate(query);
            System.out.println("Histroy deleted successfully.");
        }
        catch (Exception exp) {
            System.out.println("Exception while Deleting schedule history :" + exp);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {}
        }
    }

    public static void moveHsErrLogFiles() {
        try {
            reportLogger.log(Level.INFO, "Going to move hs_err files");
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String destPath = productHome + File.separator + "logs";
            File sourceFolder = new File(destPath);
            File[] listOfFiles = sourceFolder.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                File file;
                if (!listOfFiles[i].isFile() || !(file = listOfFiles[i]).getName().startsWith("Thread_Dump")) continue;
                file.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void copyPgSQLLogFiles() {
        try {
            reportLogger.log(Level.INFO, "Going to copy PgSQL Log files");
            String productHome = System.getProperty("product.home");
            if (productHome == null) {
                productHome = System.getProperty("server.home");
            }
            String srcPath = productHome + File.separator + "pgsql" + File.separator + "data" + File.separator + "pg_log";
            String destPath = productHome + File.separator + "logs";
            File sourceFolder = new File(srcPath);
            if (sourceFolder.exists()) {
                File destFolder = new File(destPath);
                FileUtils.copyDirectory((File)sourceFolder, (File)destFolder);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

