/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.ReadOnlyPersistence;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommonUtil {
    private static Persistence persistence = null;
    private static Persistence persistenceLite = null;
    private static Persistence dbSyncPersistence = null;
    private static ReadOnlyPersistence cachedPersistence = null;
    private static String isDemo = null;
    private static String[] specialChars = new String[]{"~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "-", "+", "=", "{", "}", "|", "[", "]", "'", "\\", ":", "?", ">", "<", ",", ".", "/", "'", ";", "`"};
    public static String patternStr = "[{][0-9A-Za-z-]*[}]";
    public static Hashtable<String, String> sysParams = new Hashtable();

    public static ArrayList getComputersAndEventFetchMode(String baseTableName, String tableName, String joinColumnName, String uniqueIdColumnName, String nameColumnName) {
        ArrayList computerList = new ArrayList();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)uniqueIdColumnName), null, 1);
            criteria = baseTableName.equals("ADSMDCConfiguration") ? criteria.and(Column.getColumn((String)tableName, (String)"OS_VERSION"), (Object)"6.*", 2) : criteria.and(Column.getColumn((String)baseTableName, (String)"VERSION"), (Object)"6.*", 2);
            Join join = new Join(baseTableName, tableName, new String[]{joinColumnName}, new String[]{joinColumnName}, 2);
            Table baseTable = Table.getTable((String)baseTableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            query.addJoin(join);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (dataObject.size(tableName) > 0) {
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Hashtable<String, Object> computerInfo = new Hashtable<String, Object>();
                    Row row = (Row)iterator.next();
                    computerInfo.put("Id", (Long)row.get(uniqueIdColumnName));
                    Criteria cri = new Criteria(Column.getColumn((String)baseTableName, (String)joinColumnName), row.get(joinColumnName), 0);
                    Row dcRow = dataObject.getRow(baseTableName, cri);
                    computerInfo.put("Name", (String)dcRow.get(nameColumnName));
                    computerInfo.put("FetchMode", row.get("EVENT_FETCH_MODE").toString());
                    computerList.add(computerInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return computerList;
    }

    public static Boolean isGUID(String expression) {
        if (expression != null) {
            Pattern pattern = Pattern.compile(patternStr);
            Matcher match = pattern.matcher(expression);
            return match.matches();
        }
        return false;
    }

    public static ArrayList getDCEventFetchMode(String baseTableName, String tableName, String joinColumnName, String uniqueIdColumnName, String nameColumnName) {
        ArrayList computerList = new ArrayList();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)uniqueIdColumnName), null, 1);
            Join join = new Join(baseTableName, tableName, new String[]{joinColumnName}, new String[]{joinColumnName}, 2);
            Table baseTable = Table.getTable((String)baseTableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            query.addJoin(join);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Criteria crit = null;
            DataObject dataObject1 = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", crit);
            if (dataObject.size(tableName) > 0) {
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Hashtable<String, Object> computerInfo = new Hashtable<String, Object>();
                    Row row = (Row)iterator.next();
                    Criteria cri = new Criteria(Column.getColumn((String)baseTableName, (String)joinColumnName), row.get(joinColumnName), 0);
                    Row dcRow = dataObject.getRow(baseTableName, cri);
                    Criteria criti = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"NAME"), (Object)((String)dcRow.get(nameColumnName)), 0);
                    criti = criti.and(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)((String)dcRow.get("DOMAIN_NAME")), 0);
                    Row dcRow1 = dataObject1.getRow("ADSMComputerGeneralDetails", criti = criti.or(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DNS_NAME"), (Object)((String)dcRow.get(nameColumnName)), 0));
                    if (dcRow1 == null || (String)dcRow1.get("VERSION") == null) continue;
                    String osVersion = (String)dcRow1.get("VERSION");
                    Long scheduleId = (Long)row.get("SCHEDULE_ID");
                    String status = SchedulerUtil.getStatus(scheduleId);
                    if (!osVersion.startsWith("6.") || !"Enabled".equalsIgnoreCase(status)) continue;
                    computerInfo.put("Id", (Long)row.get(uniqueIdColumnName));
                    computerInfo.put("Name", (String)dcRow.get(nameColumnName));
                    computerInfo.put("FetchMode", row.get("EVENT_FETCH_MODE").toString());
                    computerList.add(computerInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return computerList;
    }

    public static Persistence getPersistence(boolean ... flags) {
        if (flags.length > 0 && flags[0]) {
            if (dbSyncPersistence != null) {
                return dbSyncPersistence;
            }
            try {
                dbSyncPersistence = (Persistence)BeanUtil.lookup((String)"DBSyncPersistence");
                return dbSyncPersistence;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (persistence != null) {
            return persistence;
        }
        try {
            persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
            return persistence;
        }
        catch (Exception me) {
            me.printStackTrace();
            return null;
        }
    }

    public static Persistence getPersistenceLite() {
        if (persistenceLite != null) {
            return persistenceLite;
        }
        try {
            persistenceLite = (Persistence)BeanUtil.lookup((String)"PersistenceLite");
            return persistenceLite;
        }
        catch (Exception me) {
            me.printStackTrace();
            return null;
        }
    }

    public static Persistence getPersistenceNT() {
        if (persistence != null) {
            return persistence;
        }
        try {
            persistence = (Persistence)BeanUtil.lookup((String)"PersistenceLite");
            return persistence;
        }
        catch (Exception me) {
            me.printStackTrace();
            return null;
        }
    }

    public static ReadOnlyPersistence getCachedPersistence() {
        if (cachedPersistence != null) {
            return cachedPersistence;
        }
        try {
            cachedPersistence = (ReadOnlyPersistence)BeanUtil.lookup((String)"CachedPersistence");
            return cachedPersistence;
        }
        catch (Exception me) {
            me.printStackTrace();
            return null;
        }
    }

    public static String getDBServerName() {
        String dbServerName = null;
        try {
            dbServerName = PersistenceInitializer.getConfigurationValue((String)"DBName");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dbServerName;
    }

    public static Row getRowObject(Hashtable prop, String[] propArray, String tableName) {
        Row row = new Row(tableName);
        return CommonUtil.updateRow(row, prop, propArray);
    }

    public static Row getRowObject(Row row, HashMap map) {
        for (Map.Entry entry : map.entrySet()) {
            row.set((String)entry.getKey(), entry.getValue());
        }
        return row;
    }

    public static Row updateRow(Row row, Hashtable prop, String[] propArray) {
        for (int i = 0; i < propArray.length; ++i) {
            if (prop.get(propArray[i]) != null) {
                row.set(propArray[i], prop.get(propArray[i]));
                continue;
            }
            row.set(propArray[i], (Object)"Not Set");
        }
        return row;
    }

    public static Row updateRow(Row row, Hashtable prop) {
        Enumeration e = prop.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            row.set(key, prop.get(key));
        }
        return row;
    }

    public static Row updateRow(Row row, Properties prop) {
        return CommonUtil.updateRow(row, (Hashtable)prop);
    }

    public static ArrayList getList(DataObject obj, String[] propArray, String tableName) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            Iterator it = obj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                for (int i = 0; i < propArray.length; ++i) {
                    String s = propArray[i];
                    if (r.get(s) == null) continue;
                    p.put(s, r.get(s));
                }
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getCheckList(DataObject obj, String[] propArray, String tableName) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            Iterator it = obj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                for (String s : propArray) {
                    if (r.get(s) == null) continue;
                    if (s.equals("CREATION_TIME") || s.equals("MODIFIED_TIME")) {
                        p.put(s, CommonUtil.getDateFromFileTime((Long)r.get(s)));
                        continue;
                    }
                    p.put(s, r.get(s));
                }
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getList(DataObject obj, String tableName) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            Iterator it = obj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                List columnNames = r.getColumns();
                for (int i = 0; i < columnNames.size(); ++i) {
                    String columnName = (String)columnNames.get(i);
                    if (r.get(columnName) == null) continue;
                    p.put(columnName, r.get(columnName));
                }
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Properties getProperties(DataObject obj, String tableName) {
        Properties p = new Properties();
        try {
            Row r = obj.getRow(tableName);
            List columnNames = r.getColumns();
            for (int i = 0; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                if (r.get(columnName) == null) continue;
                p.put(columnName, r.get(columnName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static ArrayList getBookMarks(String domainName) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMBookMarks"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMBookMarks", (String)"BOOKMARK_DOMAIN"), (Object)domainName, 0);
            query.setCriteria(criteria);
            ArrayList<Column> columnList = new ArrayList<Column>();
            columnList.add(Column.getColumn((String)"ADSMBookMarks", (String)"BOOKMARK_DOMAIN"));
            columnList.add(Column.getColumn((String)"ADSMBookMarks", (String)"BOOKMARK_NAME"));
            columnList.add(Column.getColumn((String)"ADSMBookMarks", (String)"BOOKMARK_LOCATION"));
            columnList.add(Column.getColumn((String)"ADSMBookMarks", (String)"BOOKMARK_DESCRIPTION"));
            columnList.add(Column.getColumn((String)"ADSMBookMarks", (String)"BOOKMARK_ID"));
            query.addSelectColumns(columnList);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObj.getRows("ADSMBookMarks");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                p.setProperty("BOOKMARK_NAME", (String)r.get("BOOKMARK_NAME"));
                p.setProperty("BOOKMARK_LOCATION", (String)r.get("BOOKMARK_LOCATION"));
                p.setProperty("BOOKMARK_DESCRIPTION", (String)r.get("BOOKMARK_DESCRIPTION"));
                p.setProperty("BOOKMARK_DOMAIN", (String)r.get("BOOKMARK_DOMAIN"));
                p.put("BOOKMARK_ID", (Long)r.get("BOOKMARK_ID"));
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static boolean deleteBookMarks(String id) throws Exception {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMBookMarks", (String)"BOOKMARK_ID"), (Object)Long.valueOf(id), 0);
            CommonUtil.getPersistenceLite().delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    public static String getSearchPattern(String searchText) {
        int i;
        String searchPattern = null;
        StringBuffer searchBuffer = new StringBuffer();
        boolean flag = false;
        for (i = 0; i < searchText.length(); ++i) {
            if (searchText.charAt(i) != '*') continue;
            flag = true;
        }
        if (flag) {
            for (i = 0; i < searchText.length(); ++i) {
                if (searchText.charAt(i) == '*') {
                    searchBuffer.append(".*");
                    continue;
                }
                searchBuffer.append(searchText.charAt(i));
            }
            searchPattern = searchBuffer.toString();
        } else {
            searchPattern = ".*" + searchText + ".*";
        }
        return searchPattern;
    }

    public static String formatDate(Long value, String dateFormat) {
        return TimeUtil.formatDate(value, dateFormat);
    }

    public static String formatDate(Long value) {
        return TimeUtil.formatDate(value);
    }

    public static String formatAccountExpiresDate(Long value) {
        String formattedCurrentDate;
        long time = value;
        Date date = new Date(time);
        String dateFormat = "MMM dd,yyyy";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        String formattedDate = simpleDateFormat.format(date);
        if (formattedDate.startsWith(formattedCurrentDate = (simpleDateFormat = new SimpleDateFormat(dateFormat = "MMM dd,yyyy")).format(date = new Date(time = System.currentTimeMillis())))) {
            formattedDate = formattedDate.replaceFirst(formattedCurrentDate, "Today");
        } else {
            date = new Date(time -= 86400000L);
            formattedCurrentDate = simpleDateFormat.format(date);
            if (formattedDate.startsWith(formattedCurrentDate)) {
                formattedDate = formattedDate.replaceFirst(formattedCurrentDate, "Yesterday");
            }
        }
        return "End of " + formattedDate;
    }

    public static Long getFileTimeFromSystemTime(Long systemTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1600, 11, 31, 0, 0, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Long millis = calendar.getTimeInMillis();
        Long fileTime = (systemTime - millis) * 10000L;
        return fileTime;
    }

    public static Long getSystemTimeFromFileTime(Long fileTime) {
        Long systemTime = fileTime / 10000L;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1600, 11, 31, 0, 0, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Long millis = calendar.getTimeInMillis();
        systemTime = systemTime + millis;
        return systemTime;
    }

    public static String getDateFromFileTime(Long fileTime) {
        Long systemTime = fileTime / 10000L;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1601, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Long millis = calendar.getTimeInMillis();
        systemTime = systemTime + millis;
        return CommonUtil.formatDate(systemTime);
    }

    public static String getAccountExpiresDateFromFileTime(Long fileTime) {
        return CommonUtil.formatAccountExpiresDate(CommonUtil.getSystemTimeFromFileTime(fileTime));
    }

    public static int getCSVImportObjectCount() {
        int count = 0;
        try {
            String tableName = "ADSMAUNamingAttributes";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            Column col = Column.getColumn((String)tableName, (String)"*");
            query.addSelectColumn(col);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"CREATION_MESSAGE"), (Object)"*Successfully*", 2);
            query.setCriteria(crit);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            count = dataObject.size(tableName);
            if (count == -1) {
                count = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static int getUpdatedObjects(String tableName) {
        int count = 0;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            Column col = Column.getColumn((String)tableName, (String)"*");
            query.addSelectColumn(col);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"MESSAGE"), (Object)"Successfully Modified", 0);
            query.setCriteria(crit);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            count = dataObject.size(tableName);
            if (count == -1) {
                count = 0;
            }
            System.out.println("count of updated objects : " + count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static String getBuildNumber() {
        return CommonUtil.getPropertyValue("product.build_number");
    }

    public static String getProductVersion() {
        return CommonUtil.getPropertyValue("product.version");
    }

    public static String getArchitecture() {
        return CommonUtil.getPropertyValue("product.processor_architecture");
    }

    public static String getPropertyValue(String propertyName) {
        String buildNumber = null;
        try {
            String fileHome = System.getProperty("server.home") + File.separator + "conf";
            Properties installProp = new Properties();
            File installFile = new File(fileHome + File.separator + "product.conf");
            if (installFile.exists()) {
                installProp.load(new FileInputStream(installFile));
                buildNumber = installProp.getProperty(propertyName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buildNumber;
    }

    public static boolean isDemo() {
        if (isDemo == null) {
            try {
                String fileHome = System.getProperty("server.home") + File.separator + "conf";
                Properties installProp = new Properties();
                File installFile = new File(fileHome + File.separator + "demo.conf");
                if (installFile.exists()) {
                    installProp.load(new FileInputStream(installFile));
                    isDemo = installProp.getProperty("demo.isDemo");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return isDemo.equals("true");
    }

    public static String getURL(String user) {
        return CommonUtil.getURL(user, true);
    }

    public static String getURL(String user, boolean clicks) {
        String url = "";
        String fileHome = System.getProperty("server.home") + File.separator + "conf";
        String installTime = "000000";
        try {
            Properties installProp = new Properties();
            File installFile = new File(fileHome + File.separator + "customerInfo.txt");
            if (installFile.exists()) {
                installProp.load(new FileInputStream(installFile));
                installTime = installProp.getProperty("InstallationTime");
            }
        }
        catch (Exception ex) {
            System.err.println("Problem in getting install time");
        }
        if (user.equals("T")) {
            url = url + "ry=b&fi=96&pi=51&it=" + installTime;
        } else if (user.equals("F")) {
            url = url + "ry=c&fi=96&pi=51&it=" + installTime;
        }
        url = url + "&bn=" + CommonUtil.getBuildNumber();
        return url;
    }

    public static Long getLong(String string) {
        Long long1 = 0L;
        try {
            long1 = Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return long1;
    }

    public static String getFormattedString(String string) {
        byte[] bs = string.getBytes();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bs.length; ++i) {
            byte b = bs[i];
            if (b == 92) {
                builder.append("\\\\");
                continue;
            }
            if (b == 9) {
                builder.append("\\t");
                continue;
            }
            if (b == 10) {
                builder.append("\\n");
                continue;
            }
            if (b == 13) {
                builder.append("\\r");
                continue;
            }
            if (b == 12) {
                builder.append("\\f");
                continue;
            }
            if (b == 8) {
                builder.append("\\b");
                continue;
            }
            builder.append((char)b);
        }
        return builder.toString();
    }

    public static long getNoOfDays(Long longObj) {
        longObj = CommonUtil.getSystemTimeFromFileTime(longObj);
        Calendar currDate = Calendar.getInstance();
        currDate.setTimeInMillis(System.currentTimeMillis());
        GregorianCalendar laterDate = new GregorianCalendar();
        laterDate.set(currDate.get(1), currDate.get(2), currDate.get(5), 0, 0, 0);
        Calendar setDate = Calendar.getInstance();
        setDate.setTimeInMillis(longObj);
        GregorianCalendar earlierDate = new GregorianCalendar();
        earlierDate.set(setDate.get(1), setDate.get(2), setDate.get(5), 0, 0, 0);
        long duration = laterDate.getTimeInMillis() - earlierDate.getTimeInMillis();
        long nDays = (duration + 3600000L) / 86400000L;
        return nDays;
    }

    public static Criteria getActionCriteria(String tableName, Long[] actionIds) {
        Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"ACTION_ID"), (Object)actionIds, 8);
        crit = crit.or(new Criteria(Column.getColumn((String)tableName, (String)"ACTION_ID"), null, 0));
        return crit;
    }

    public static String escapeDN(String string) {
        String[] DN_ESCAPE_CHARECTERS = new String[]{"/"};
        if (string == null) {
            return null;
        }
        return CommonUtil.escapeString(string, DN_ESCAPE_CHARECTERS);
    }

    public static String escapeString(String string, String[] escapeChars) {
        String escapedString = string;
        for (String s : escapeChars) {
            if (!escapedString.contains(s)) continue;
            escapedString = s.equalsIgnoreCase("\\") ? escapedString.replaceAll("\\\\", "\\\\\\\\") : escapedString.replaceAll(s, "\\\\" + s);
        }
        return escapedString;
    }

    public static String deEscapeString(String string, String[] escapeChars) {
        String escapedString = string;
        for (int i = 0; i < escapedString.length(); ++i) {
            Character sp = Character.valueOf(escapedString.charAt(i));
            if (!sp.equals(Character.valueOf('\\'))) continue;
            escapedString = escapedString.replace("\\", "");
        }
        System.out.println("De Escaped String : " + escapedString);
        return escapedString;
    }

    public static String escapedTableName(String string) {
        String escapedString = string;
        for (String s : specialChars) {
            if (!escapedString.contains(s)) continue;
            escapedString = escapedString.replace(s, "_");
        }
        return escapedString;
    }

    public static void updateSytemTime() {
        try {
            Long systemTime = System.currentTimeMillis();
            String tableName = "SystemParams";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"PARAM_NAME"), (Object)"SystemTime", 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (dataObj != null) {
                Row row = dataObj.getRow(tableName);
                if (systemTime != null) {
                    row.set("PARAM_VALUE", (Object)systemTime.toString());
                }
                dataObj.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getSearchString(String value) throws Exception {
        int len = value.length();
        if ((value = EscapeUtil.escSplCharsAsSQLForLike(value)).charAt(0) == '*' && value.charAt(len - 1) == '*') {
            value = value.substring(1, len - 1);
            value = "%" + value + "%";
        } else if (value.charAt(len - 1) == '*') {
            value = value.substring(0, len - 1);
            value = value + "%";
        } else if (value.charAt(len - 1) == '%') {
            value = value.substring(0, len - 1);
            value = value + "%";
        } else if (value.charAt(0) == '*') {
            value = value.substring(1, len);
            value = "%" + value;
        } else {
            value = "%" + value + "%";
        }
        return value;
    }

    public static String constructString(String[] str, Appendable strBuilder) throws Exception {
        return CommonUtil.appendString(str, strBuilder).toString();
    }

    public static Appendable appendString(String[] str, Appendable strBuilder) throws Exception {
        if (strBuilder == null) {
            strBuilder = new StringBuilder();
        }
        for (int i = 0; i < str.length; ++i) {
            strBuilder.append(str[i]);
        }
        return strBuilder;
    }

    public static String getOSVersion(String windowsVersion) {
        String OsVersion = null;
        try {
            OsVersion = windowsVersion.startsWith("5.0") ? "2k" : (windowsVersion.startsWith("5.") ? "2k3" : (windowsVersion.startsWith("6.0") ? "2k8" : (windowsVersion.startsWith("6.1") ? "2k8r2" : (windowsVersion.startsWith("6.2") ? "2k12" : "2k8r2"))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return OsVersion;
    }

    public static void addOrUpdateRow(String primaryKey, Object primaryKeyValue, Row row, String tableName) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)primaryKey), primaryKeyValue, 0);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
        if (!dObj.isEmpty()) {
            dObj.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        } else {
            dObj.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dObj);
        }
    }

    public static boolean isArchiveConfigured() {
        boolean status = true;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"TIME_PERIOD"), (Object)new Long(0L), 5);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDBackupDataConfig", (String)"IS_BACKUP"), (Object)true, 0));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDBackupDataConfig", crit);
            if (dObj.isEmpty()) {
                status = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = false;
        }
        return status;
    }

    public static String getSysParams(String key) {
        String value = null;
        value = sysParams.get(key);
        if (value == null) {
            try {
                String table_SystemParams = "SystemParams";
                String col_ParamValue = "PARAM_VALUE";
                String col_ParamName = "PARAM_NAME";
                DataObject sysParamDO = CommonUtil.getPersistence(new boolean[0]).get(table_SystemParams, new Criteria(Column.getColumn((String)table_SystemParams, (String)col_ParamName), (Object)key, 0));
                value = !sysParamDO.isEmpty() ? (String)sysParamDO.getFirstRow(table_SystemParams).get(col_ParamValue) : "";
                sysParams.put(key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (value != null && value.equals("")) {
            value = null;
        }
        return value;
    }
}

