/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateQueue;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;

public class DBObjectUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdate(String baseTableName, String keyColumnName, ArrayList guidList, Hashtable tableRowMap, Hashtable relationalMap) {
        Connection connection = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            String[] guids = new String[guidList.size()];
            for (int i = 0; i < guidList.size(); ++i) {
                guids[i] = (String)guidList.get(i);
            }
            Column col = Column.getColumn((String)baseTableName, (String)keyColumnName);
            Criteria crit = new Criteria(col, (Object)guids, 8);
            ObjectUpdateQueue.reportLogger.log(Level.INFO, "Checking the old Values for the table to the SIDs Count " + guidList.size());
            DataObject baseDataObj = CommonUtil.getPersistence(new boolean[0]).get(baseTableName, crit);
            DBObjectUtil.add(baseDataObj, baseTableName, tableRowMap);
            DBObjectUtil.processTables(baseTableName, keyColumnName, guids, tableRowMap);
            DBObjectUtil.processRTTables(keyColumnName, guids, relationalMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void processTables(String baseTableName, String keyColumnName, String[] guids, Hashtable h) {
        try {
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String tableName = (String)e.nextElement();
                if (tableName.equalsIgnoreCase(baseTableName)) continue;
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)keyColumnName), (Object)guids, 8);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                DBObjectUtil.add(dataObj, tableName, h);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processRTTables(String keyColumnName, String[] guids, Hashtable h) {
        try {
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String tableName = (String)e.nextElement();
                ArrayList list = (ArrayList)h.get(tableName);
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)keyColumnName), (Object)guids, 8);
                CommonUtil.getPersistenceLite().delete(crit);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                TableDefinition ta = MetaDataUtil.getTableDefinitionByName((String)tableName);
                ArrayList columns = (ArrayList)ta.getColumnNames();
                for (int i = 0; i < list.size(); ++i) {
                    Row r = (Row)list.get(i);
                    Criteria criteria = null;
                    for (int j = 0; j < columns.size(); ++j) {
                        Object columnValue;
                        String columnName = (String)columns.get(j);
                        ColumnDefinition coldefn = ta.getColumnDefinitionByName(columnName);
                        if (coldefn.getUniqueValueGeneration() != null || (columnValue = r.get(columnName)) == null) continue;
                        criteria = criteria == null ? new Criteria(Column.getColumn((String)tableName, (String)columnName), columnValue, 0) : criteria.and(new Criteria(Column.getColumn((String)tableName, (String)columnName), columnValue, 0));
                    }
                    Row oldRow = dataObj.getRow(tableName, criteria);
                    if (oldRow != null) continue;
                    dataObj.addRow(r);
                }
                ObjectUpdateQueue.reportLogger.log(Level.INFO, "Adding the new Values to the table " + tableName);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                ObjectUpdateQueue.reportLogger.log(Level.INFO, "After adding the new Values to the table" + tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void add(DataObject obj, String tableName, Hashtable h) {
        try {
            ArrayList list = (ArrayList)h.get(tableName);
            for (int i = 0; i < list.size(); ++i) {
                Row r = (Row)list.get(i);
                Row oldRow = obj.getRow(tableName, r);
                if (oldRow == null) {
                    obj.addRow(r);
                    continue;
                }
                DBObjectUtil.updateRowValues(oldRow, r, tableName);
                obj.updateRow(oldRow);
            }
            ObjectUpdateQueue.reportLogger.log(Level.INFO, "Adding the new Values to the table " + tableName);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
            ObjectUpdateQueue.reportLogger.log(Level.INFO, "After adding the new Values to the table" + tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateRowValues(Row oldRow, Row newRow, String tableName) {
        try {
            int[] changedColumns = newRow.getChangedColumnIndex();
            int lastLogonIndex = MetaDataUtil.getTableDefinitionByName((String)tableName).getColumnIndex("LAST_LOGON_TIME");
            int domainControllerIndex = MetaDataUtil.getTableDefinitionByName((String)tableName).getColumnIndex("DOMAIN_CONTROLLER_NAME");
            for (int i = 0; i < changedColumns.length; ++i) {
                if (changedColumns[i] == lastLogonIndex) {
                    DBObjectUtil.checkNewValues(oldRow, newRow, lastLogonIndex);
                    continue;
                }
                if (changedColumns[i] == domainControllerIndex) continue;
                Object obj = newRow.get(changedColumns[i]);
                oldRow.set(changedColumns[i], obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkNewValues(Row oldRow, Row newRow, int lastLogonIndex) {
        long oldVal = (Long)oldRow.get(lastLogonIndex);
        long newVal = (Long)newRow.get(lastLogonIndex);
        String dcLatest = (String)newRow.get("DOMAIN_CONTROLLER_NAME");
        String dcOldest = (String)oldRow.get("DOMAIN_CONTROLLER_NAME");
        if (newVal > oldVal) {
            oldRow.set(lastLogonIndex, (Object)newVal);
            oldRow.set("DOMAIN_CONTROLLER_NAME", (Object)dcLatest);
        } else {
            oldRow.set(lastLogonIndex, (Object)oldVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getObjects(String tableName, String columnName, ArrayList attributeList, Criteria crit) {
        Connection connection = null;
        ArrayList resultList = null;
        DataSet dataSet = null;
        try {
            int i;
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            Table baseTable = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            ArrayList<String> tableNames = new ArrayList<String>();
            for (i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                String table = attributeProperties.getProperty("TABLE_NAME");
                if (relationalType.equals(1)) continue;
                Column column = Column.getColumn((String)table, (String)attributeProperties.getProperty("ATTRIB_COLUMN_NAME"));
                selectColumnList.add(column);
                if (tableNames.contains(table) || table.equalsIgnoreCase(tableName)) continue;
                tableNames.add(table);
            }
            for (i = 0; i < tableNames.size(); ++i) {
                String table = (String)tableNames.get(i);
                Join join = new Join(baseTable, Table.getTable((String)table), new String[]{columnName}, new String[]{columnName}, 2);
                query.addJoin(join);
            }
            query.addSelectColumns(selectColumnList);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)columnName));
            if (crit != null) {
                query.setCriteria(crit);
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            resultList = new ArrayList();
            while (dataSet.next()) {
                Hashtable<String, String> resultTable = new Hashtable<String, String>();
                DBObjectUtil.fillResult(dataSet, resultTable, attributeList);
                String guid = (String)dataSet.getValue(selectColumnList.size() + 1);
                if (guid != null) {
                    resultTable.put(columnName, guid);
                }
                resultList.add(resultTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return resultList;
    }

    private static void fillResult(DataSet dataSet, Hashtable result, ArrayList attributeList) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                Properties attributeProperties = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                if (relationalType.equals(1)) continue;
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                if (dataSet.getValue(columnName) == null) continue;
                Object obj = dataSet.getValue(columnName);
                result.put(attributeId, obj.toString());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Long getUVHValues(String tableName, String uvhString) {
        Long uvh = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"UVHValues", (String)"TABLE_NAME"), (Object)tableName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"UVHValues", (String)"PATTERN"), (Object)uvhString, 0));
            DataObject dataObject = CommonUtil.getCachedPersistence().get("UVHValues", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("UVHValues");
                uvh = (Long)row.get("GENVALUES");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uvh;
    }

    public static Long[] getUVHValues(String tableName, String[] uvhStrings) {
        Long[] uvHs = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"UVHValues", (String)"TABLE_NAME"), (Object)tableName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"UVHValues", (String)"PATTERN"), (Object)uvhStrings, 8));
            DataObject dataObject = CommonUtil.getCachedPersistence().get("UVHValues", criteria);
            if (!dataObject.isEmpty()) {
                int count = dataObject.size("UVHValues");
                uvHs = new Long[count];
                int i = 0;
                Iterator iterator = dataObject.getRows("UVHValues");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    uvHs[i] = (Long)row.get("GENVALUES");
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uvHs;
    }

    public static Long getFileId(String fileName) {
        Long fileId = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ConfFile", (String)"URL"), (Object)fileName, 11);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ConfFile", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ConfFile");
                fileId = (Long)row.get("FILEID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileId;
    }

    public static Long getTableId(String tableName) {
        Long tableId = 0L;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"TableDetails", (String)"TABLE_NAME"), (Object)tableName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("TableDetails", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("TableDetails");
                tableId = (Long)row.get("TABLE_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableId;
    }

    public static Long getDefaultReport() {
        Long reportId = 0L;
        try {
            String pattern = ADSMPersUtil.getSyMParameter("DEFAULT_REPORT_ID");
            reportId = DBObjectUtil.getUVHValues("AUDReports", pattern);
            if (reportId == null) {
                reportId = Long.parseLong(pattern);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportId;
    }

    public static boolean setDefaultReport(String reportId) {
        boolean status = false;
        try {
            ADSMPersUtil.updateSyMParameter("DEFAULT_REPORT_ID", reportId);
            status = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return status;
    }
}

