/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;

public class EscapeUtil {
    public static final char[] SPECIALCHARS_HTML = new char[]{'&', '\'', '\"', '<', '>'};
    public static final String[] REPL_SPECIALCHARS_HTML = new String[]{"&amp;", "&#39;", "&quot;", "&lt;", "&gt;"};
    public static final char[] LIKE_SPECIALCHARS_SQL = new char[]{'\'', '%', '_', '\\', '\"'};
    public static final String[] LIKE_REPL_SPECIALCHARS_SQL = new String[]{"\\'", "\\%", "\\_", "\\\\\\\\", "\\\""};
    public static final char[] IN_SPECIALCHARS_SQL = new char[]{'\'', '\\', '\"'};
    public static final String[] IN_REPL_SPECIALCHARS_SQL = new String[]{"\\'", "\\\\", "\\\""};
    public static final char[] JS_SPECIALCHARS = new char[]{'\r', '\n', '\"', '\'', '/', '\\'};
    public static final String[] JS_REPL_SPECIALCHARS = new String[]{"\\r", "\\n", "\\\"", "\\'", "\\/", "\\\\"};
    public static final char[] REGEX_SPECIALCHARS = new char[]{'\\', '(', '[', '{', '^', '$', '|', ')', '?', '*', '+', '.'};
    public static final String[] REGEX_REPL_SPECIALCHARS = new String[]{"\\\\", "\\(", "\\[", "\\{", "\\^", "\\$", "\\|", "\\)", "\\?", "\\*", "\\+", "\\."};
    public static final char[] SPECIALCHARS_XML = new char[]{'&', '\'', '\"', '<', '>'};
    public static final String[] REPL_SPECIALCHARS_XML = new String[]{"&amp;", "&apos;", "&quot;", "&lt;", "&gt;"};
    public static final char[] EQUAL_SPECIALCHARS_MSSQL = new char[]{'\''};
    public static final String[] EQUAL_REPL_SPECIALCHARS_MSSQL = new String[]{"''"};
    public static final char[] LIKE_SPECIALCHARS_MSSQL = new char[]{'\'', '%', '\"', '_'};
    public static final String[] LIKE_REPL_SPECIALCHARS_MSSSQL = new String[]{"''", "\\%", "\\\"", "[_]"};
    public static final char[] LIKE_SPECIALCHARS_PGSQL = new char[]{'\\', '\'', '%', '\"', '_'};
    public static final String[] LIKE_REPL_SPECIALCHARS_PGSSQL = new String[]{"\\\\", "''", "\\%", "\\\"", "\\_"};
    public static final char[] IN_SPECIALCHARS_PGSQL = new char[]{'\'', '\"'};
    public static final String[] IN_REPL_SPECIALCHARS_PGSQL = new String[]{"''", "\\\""};
    public static final char[] IN_SPECIALCHARS_MSSQL = new char[]{'\'', '\"'};
    public static final String[] IN_REPL_SPECIALCHARS_MSSQL = new String[]{"''", "\\\""};
    private static String dbName = CommonUtil.getDBServerName();

    public static String replaceCharExcludeNumbersFromCheck(Object str, char[] matchChar, String[] replaceStr) {
        if (str == null) {
            return null;
        }
        if (str instanceof Number || str instanceof Boolean) {
            return String.valueOf(str);
        }
        return EscapeUtil.replaceChar(str, matchChar, replaceStr);
    }

    public static String replaceChar(Object str, char[] matchChar, String[] replaceStr) {
        if (str == null) {
            return null;
        }
        String strToEsc = String.valueOf(str);
        StringBuilder sbf = null;
        int length = strToEsc.length();
        int splSize = matchChar.length;
        block0: for (int i = 0; i < length; ++i) {
            char ch = strToEsc.charAt(i);
            for (int j = 0; j < splSize; ++j) {
                if (matchChar[j] != ch) continue;
                if (sbf == null) {
                    sbf = new StringBuilder(strToEsc.length() + 10);
                    sbf.append(strToEsc.substring(0, i));
                }
                sbf.append(replaceStr[j]);
                continue block0;
            }
            if (sbf == null) continue;
            sbf.append(ch);
        }
        return sbf != null ? sbf.toString() : strToEsc;
    }

    public static String escSplCharsAsHTML(Object str) {
        return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, SPECIALCHARS_HTML, REPL_SPECIALCHARS_HTML);
    }

    public static String escSplCharsAsSQLForLike(Object str) {
        if (dbName.equalsIgnoreCase("mssql")) {
            return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, LIKE_SPECIALCHARS_MSSQL, LIKE_REPL_SPECIALCHARS_MSSSQL);
        }
        if (dbName.equalsIgnoreCase("mysql")) {
            return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, LIKE_SPECIALCHARS_SQL, LIKE_REPL_SPECIALCHARS_SQL);
        }
        return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, LIKE_SPECIALCHARS_PGSQL, LIKE_REPL_SPECIALCHARS_PGSSQL);
    }

    public static String escSplCharsAsSQL(Object str) {
        if (dbName.equalsIgnoreCase("mssql")) {
            return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, IN_SPECIALCHARS_MSSQL, IN_REPL_SPECIALCHARS_MSSQL);
        }
        if (dbName.equalsIgnoreCase("mysql")) {
            return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, IN_SPECIALCHARS_SQL, IN_REPL_SPECIALCHARS_SQL);
        }
        return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, IN_SPECIALCHARS_PGSQL, IN_REPL_SPECIALCHARS_PGSQL);
    }

    public static String escSplCharsAsJS(Object str) {
        return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, JS_SPECIALCHARS, JS_REPL_SPECIALCHARS);
    }

    public static String escSplCharsAsXML(Object str) {
        return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, SPECIALCHARS_XML, REPL_SPECIALCHARS_XML);
    }

    public static String escRegExCharAsJavaString(Object str) {
        return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, REGEX_SPECIALCHARS, REGEX_REPL_SPECIALCHARS);
    }

    public static String escSplCharsAsJSThenHtml(Object str) {
        if (str == null) {
            return null;
        }
        if (str instanceof Number) {
            return String.valueOf(str);
        }
        String val = EscapeUtil.escSplCharsAsJS(str);
        return EscapeUtil.escSplCharsAsHTML(val);
    }

    public static String escSplCharsAsMSSQL(Object str) {
        return EscapeUtil.replaceCharExcludeNumbersFromCheck(str, EQUAL_SPECIALCHARS_MSSQL, EQUAL_REPL_SPECIALCHARS_MSSQL);
    }

    public static boolean isListOfLongNumbers(String value, char sepChar) {
        int j = value.length();
        for (int i = 0; i < j; ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9' || c == '-' || c == sepChar || c == ' ') continue;
            return false;
        }
        return true;
    }

    public static void replaceCharacters(String existingPattern, String replacePattern) {
        if ("mssql".equalsIgnoreCase(dbName)) {
            StringBuilder queryBuilder = new StringBuilder("update audsecpolicypath set policy_key=replace(policy_key,'");
            queryBuilder.append(existingPattern);
            queryBuilder.append("','");
            queryBuilder.append(replacePattern);
            queryBuilder.append("')");
            try {
                QueryUtil.executeUpdate(queryBuilder.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private EscapeUtil() {
    }
}

