/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FormatUtil {
    private static final Logger EVENT_LOGGER = Logger.getLogger("ReportLogger");

    public static String getFormatMessage(Row eventRow, String format) {
        int prevIndex = 0;
        int index = format.indexOf("%");
        int length = format.length();
        StringBuffer value = new StringBuffer();
        while (index != -1) {
            int nextIndex = format.indexOf("%", index + 1);
            String prevStr = format.substring(prevIndex, index);
            prevStr = prevStr.replaceAll("\"", "");
            value.append(prevStr);
            if (nextIndex != -1) {
                String noOfLetters = "";
                if (length > nextIndex + 1 && Character.isDigit(format.charAt(nextIndex + 1))) {
                    noOfLetters = new Character(format.charAt(nextIndex + 1)).toString();
                    if (length > nextIndex + 2 && Character.isDigit(format.charAt(nextIndex + 2))) {
                        noOfLetters = noOfLetters + new Character(format.charAt(nextIndex + 2)).toString();
                    }
                }
                String eventVariable = format.substring(index + 1, nextIndex);
                try {
                    if (eventRow != null && eventRow.getColumns().contains(eventVariable) && eventRow.get(eventVariable) != null) {
                        if (eventVariable.equalsIgnoreCase("TIME_GENERATED")) {
                            value.append(CommonUtil.formatDate(1000L * (Long)eventRow.get(eventVariable)));
                        } else {
                            value.append(eventRow.get(eventVariable).toString());
                        }
                    }
                }
                catch (Exception e) {
                    EVENT_LOGGER.log(Level.WARNING, "IN FormatUtil : " + e.getMessage());
                }
                prevIndex = nextIndex + 1;
                index = format.indexOf("%", nextIndex + 1);
                continue;
            }
            prevIndex = index;
            index = nextIndex;
        }
        String lastStr = format.substring(prevIndex).replaceAll("\"", "");
        value.append(lastStr);
        String s = value.toString();
        String ret = s.trim();
        return ret;
    }
}

