/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.json.JSONObject;

public class GraphUtil {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static LinkedHashMap<Long, HashMap> getHomeGraphList(int graphType) {
        LinkedHashMap<Long, HashMap> graphMap = new LinkedHashMap<Long, HashMap>();
        try {
            String homeGraphsTableName = "AUDHomeGraphs";
            String graphOptionsTableName = "AUDGraphOptions";
            String graphOptIdColumn = "GRAPH_OPT_ID";
            String prorityIdColumn = "PRIORITY_ID";
            Criteria criteria = null;
            if (graphType > 0) {
                criteria = new Criteria(Column.getColumn((String)homeGraphsTableName, (String)"GRAPH_TYPE"), (Object)graphType, 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)homeGraphsTableName, (String)"VISIBLE"), (Object)true, 0));
            }
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)homeGraphsTableName));
            Join join = new Join(homeGraphsTableName, graphOptionsTableName, new String[]{graphOptIdColumn}, new String[]{graphOptIdColumn}, 2);
            selectQuery.addJoin(join);
            selectQuery.addSelectColumn(Column.getColumn((String)homeGraphsTableName, (String)graphOptIdColumn));
            selectQuery.addSelectColumn(Column.getColumn((String)homeGraphsTableName, (String)"FIRST_GRAPH_DURATION"));
            selectQuery.addSelectColumn(Column.getColumn((String)homeGraphsTableName, (String)"SECOND_GRAPH_DURATION"));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)graphOptIdColumn));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)"GRAPH_TITLE"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)homeGraphsTableName, (String)prorityIdColumn), true));
            if (criteria != null) {
                selectQuery.setCriteria(criteria);
            }
            DataObject homeGraphDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator it = homeGraphDataObject.getRows(homeGraphsTableName);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Long graphOptId = (Long)row.get(graphOptIdColumn);
                Criteria criteria2 = new Criteria(Column.getColumn((String)graphOptionsTableName, (String)graphOptIdColumn), (Object)graphOptId, 0);
                Row graphOptRow = homeGraphDataObject.getRow(graphOptionsTableName, criteria2);
                HashMap<String, Object> detailsMap = new HashMap<String, Object>();
                detailsMap.put("GRAPH_TITLE", rb.getString((String)graphOptRow.get("GRAPH_TITLE")));
                detailsMap.put("FIRST_GRAPH_DURATION", (Long)row.get("FIRST_GRAPH_DURATION"));
                detailsMap.put("SECOND_GRAPH_DURATION", (Long)row.get("SECOND_GRAPH_DURATION"));
                graphMap.put(graphOptId, detailsMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graphMap;
    }

    public static LinkedHashMap<Long, HashMap> getHomeGraphList() {
        LinkedHashMap<Long, HashMap> graphMap = new LinkedHashMap<Long, HashMap>();
        try {
            DataObject selectGraphDO = CommonUtil.getPersistence(new boolean[0]).get("AUDHomeGraphs", new Criteria(Column.getColumn((String)"AUDHomeGraphs", (String)"VISIBLE"), (Object)true, 0));
            Iterator it = selectGraphDO.getRows("AUDHomeGraphs");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Long graphOptId = (Long)row.get("GRAPH_OPT_ID");
                HashMap<String, Long> detailsMap = new HashMap<String, Long>();
                detailsMap.put("FIRST_GRAPH_DURATION", (Long)row.get("FIRST_GRAPH_DURATION"));
                detailsMap.put("SECOND_GRAPH_DURATION", (Long)row.get("SECOND_GRAPH_DURATION"));
                graphMap.put(graphOptId, detailsMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graphMap;
    }

    public static JSONObject getDataModel(Long graphOptId) {
        JSONObject graphDataModel = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDHomeGraphs", (String)"GRAPH_OPT_ID"), (Object)graphOptId, 0);
            DataObject dO = CommonUtil.getPersistence(new boolean[0]).get("AUDHomeGraphs", crit);
            if (!dO.isEmpty()) {
                graphDataModel = new JSONObject();
                Row graphRow = dO.getRow("AUDHomeGraphs");
                List columns = graphRow.getColumns();
                for (String col : columns) {
                    graphDataModel.put(col, graphRow.get(col));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graphDataModel;
    }

    public static HashMap<String, Object> getHomeGraphModel(AdventNetResourceBundle rb2, Long graphOptId) {
        HashMap<String, Object> detailsMap = new HashMap<String, Object>();
        try {
            String homeGraphsTableName = "AUDHomeGraphs";
            String graphOptionsTableName = "AUDGraphOptions";
            String graphOptIdColumn = "GRAPH_OPT_ID";
            String prorityIdColumn = "PRIORITY_ID";
            Criteria criteria = null;
            criteria = new Criteria(Column.getColumn((String)homeGraphsTableName, (String)"GRAPH_OPT_ID"), (Object)graphOptId, 0);
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)homeGraphsTableName));
            Join join = new Join(homeGraphsTableName, graphOptionsTableName, new String[]{graphOptIdColumn}, new String[]{graphOptIdColumn}, 2);
            selectQuery.addJoin(join);
            selectQuery.addSelectColumn(Column.getColumn((String)homeGraphsTableName, (String)graphOptIdColumn));
            selectQuery.addSelectColumn(Column.getColumn((String)homeGraphsTableName, (String)"FIRST_GRAPH_DURATION"));
            selectQuery.addSelectColumn(Column.getColumn((String)homeGraphsTableName, (String)"SECOND_GRAPH_DURATION"));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)graphOptIdColumn));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)"GRAPH_TITLE"));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)"XLABEL"));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)"YLABEL"));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)"GRAPH_TYPE"));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)"CV_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)"GRAPH_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)graphOptionsTableName, (String)"MCOLUMN"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)homeGraphsTableName, (String)prorityIdColumn), true));
            if (criteria != null) {
                selectQuery.setCriteria(criteria);
            }
            DataObject homeGraphDataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator it = homeGraphDataObject.getRows(homeGraphsTableName);
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Criteria criteria2 = new Criteria(Column.getColumn((String)graphOptionsTableName, (String)graphOptIdColumn), (Object)graphOptId, 0);
                Row graphOptRow = homeGraphDataObject.getRow(graphOptionsTableName, criteria2);
                detailsMap.put("GRAPH_TITLE", rb2.getString((String)graphOptRow.get("GRAPH_TITLE")));
                detailsMap.put("GRAPH_TYPE", (String)graphOptRow.get("GRAPH_TYPE"));
                detailsMap.put("XLABEL", rb2.getString((String)graphOptRow.get("XLABEL")));
                detailsMap.put("YLABEL", rb2.getString((String)graphOptRow.get("YLABEL")));
                detailsMap.put("GRAPH_OPT_ID", (Long)graphOptRow.get("GRAPH_OPT_ID"));
                detailsMap.put("GRAPH_NAME", (String)graphOptRow.get("GRAPH_NAME"));
                detailsMap.put("MCOLUMN", (String)graphOptRow.get("MCOLUMN"));
                detailsMap.put("CV_ID", (Long)graphOptRow.get("CV_ID"));
                detailsMap.put("FIRST_GRAPH_DURATION", (Long)row.get("FIRST_GRAPH_DURATION"));
                detailsMap.put("SECOND_GRAPH_DURATION", (Long)row.get("SECOND_GRAPH_DURATION"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detailsMap;
    }
}

