/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.emc.EMCHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.netapp.NetAppHandler;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.admin.EventErrorAlert;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.tools.prevalent.Wield;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenseUtil {
    private static String licenseType = "";
    private static Hashtable<String, Properties> licenseProp = new Hashtable();
    public static final int DOMAIN_CONTROLLER = 1;
    public static final int FILE_SERVER = 4;
    public static final int MEMBER_SERVER = 22;
    public static final String COMPUTER_EVENT_TABLE_NAME = "AUDComputerEventRead";
    public static final String DC_EVENT_TABLE_NAME = "AUDDCEventRead";
    public static final String COMPUTER_DETAILS_TABLE = "ADSMComputerGeneralDetails";
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger("ReportLogger");

    public static void resetLicenseType() {
        licenseType = null;
    }

    public static String getLicenseType() {
        try {
            Wield wield = Wield.getInstance();
            licenseType = wield.getUserType();
            if (licenseType == null || licenseType.equals("")) {
                licenseType = "F";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            licenseType = "F";
        }
        return licenseType;
    }

    public static String getLicenseTypeString() {
        Wield wield = Wield.getInstance();
        String licensType = wield.getLicenseTypeString();
        return licensType;
    }

    public static String getUserType() {
        return Wield.getInstance().getUserType();
    }

    public static long getExpiryDays() {
        long days = Wield.getInstance().getEvaluationDays();
        if (days <= 20L) {
            return days;
        }
        return 0L;
    }

    public static synchronized String getLicenseProperty(String module, String property) {
        String val = null;
        Properties moduleProp = null;
        if (licenseProp.get(module) == null) {
            Wield wield = Wield.getInstance();
            if (wield == null) {
                System.out.println("License API not Initialized");
                return null;
            }
            moduleProp = wield.getModuleProperties(module);
            licenseProp.put(module, moduleProp);
        } else {
            moduleProp = licenseProp.get(module);
        }
        if (moduleProp != null) {
            val = moduleProp.getProperty(property);
        }
        return val;
    }

    public static void resetValues() {
        licenseProp = new Hashtable();
    }

    public static boolean isProfEdn() {
        return LicenseUtil.getLicenseTypeString().equalsIgnoreCase("Standard") ? LicenseUtil.isProfEvalPeriod() : true;
    }

    public static boolean isProfEvalPeriod() {
        boolean isProfEval = false;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"SystemParams"));
            Criteria criteria = new Criteria(Column.getColumn((String)"SystemParams", (String)"PARAM_NAME"), (Object)"ProfEvalPeriod", 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"SystemParams", (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getRow("SystemParams");
                Long startingTime = Long.parseLong((String)row.get("PARAM_VALUE"));
                Long timeDiff = System.currentTimeMillis() / 1000L - startingTime;
                if (timeDiff < 2592000L) {
                    isProfEval = true;
                }
            }
        }
        catch (DataAccessException ex) {
            ex.printStackTrace();
        }
        return isProfEval;
    }

    public static void sendLicenseExpiryAlert() throws Exception {
        String message = "";
        if (LicenseUtil.getLicenseType().equals("F")) {
            message = RB.getString("adap.MSHandler.You_are_using_a_free");
        } else if (LicenseUtil.getLicenseType().equals("R") && LicenseUtil.getExpiryDays() > 0L) {
            message = RB.handleGetObject("adap.license_page.upgrade_license.license_content.subscription_expires_in", new String[]{Long.toString(LicenseUtil.getExpiryDays())});
        }
        if (!message.equals("")) {
            Row row;
            String toAddress;
            HashMap<String, Object> sendMailMap = new HashMap<String, Object>();
            DataObject dObj = EventErrorAlert.getDataObj();
            if (!dObj.isEmpty() && !(toAddress = (String)(row = dObj.getRow("SystemParams")).get("PARAM_VALUE")).equals("no")) {
                sendMailMap.put("toAddress", toAddress.split(","));
                sendMailMap.put("subject", RB.getString("adap.LicenseUtil.LicenseExpiryAlert"));
                sendMailMap.put("message", message);
                boolean sendMailStatus = SendMailAPI.getInstance().sendMail(sendMailMap);
            }
        }
    }

    public static void validateLicense() {
        try {
            String licenseType = LicenseUtil.getLicenseType();
            if (licenseType.equalsIgnoreCase("F")) {
                ArrayList enabledEventSchedulers = EventSchedulerUtil.getEventSchedulers(3);
                for (Object object : enabledEventSchedulers) {
                    Long scheduleId = (Long)object;
                    EventSchedulerUtil.enableDisableScheduler(scheduleId, "Disable");
                }
                LicenseUtil.disableEnableMemberServers(16, 0, true);
                LicenseUtil.disableEnableMemberServers(4, 0, true);
                LicenseUtil.disableEnableMemberServers(64, 0, true);
                LicenseUtil.disableEnableMemberServers(256, 0, true);
                LicenseUtil.disableEnableMemberServers(131072, 0, true);
                LicenseUtil.disableEnableMemberServers(524288, 0, true);
                LicenseUtil.disableEnableMemberServers(4096, 25, true);
            } else {
                LicenseUtil.disableServers(16);
                LicenseUtil.disableServers(4);
                LicenseUtil.disableServers(64);
                LicenseUtil.disableServers(256);
                LicenseUtil.disableServers(524288);
                LicenseUtil.disableServers(131072);
                LicenseUtil.disableServers(4096);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void disableServers(Integer machineType) throws Exception {
        Integer noOfServers = MSHandler.getLicenseCount(machineType);
        LicenseUtil.disableEnableMemberServers(machineType, noOfServers, true);
    }

    public static void disableEnableMemberServers(Integer machineType, Integer noOfServers, Boolean disableOnly) {
        block33: {
            try {
                boolean printerGuidlistadd;
                ArrayList list = null;
                String message = null;
                int[] machineTypes = null;
                if ((machineType & 4) == 4 || (machineType & 0x40) == 64) {
                    machineTypes = new int[]{4, 64};
                } else if ((machineType & 0x10) == 16) {
                    machineTypes = new int[]{16};
                } else if ((machineType & 0x100) == 256 || (machineType & 0x20000) == 131072 || (machineType & 0x80000) == 524288) {
                    machineTypes = new int[]{256, 131072, 524288};
                } else if ((machineType & 0x1000) == 4096) {
                    machineTypes = new int[]{4096};
                }
                int count = ServerConfigAPI.getConfiguredServerCount(machineTypes);
                ArrayList<String> printerGuidList = new ArrayList<String>();
                if ((machineType & 0x10) == 16) {
                    count += ServerConfigAPI.getPrintServerCount() - ServerConfigAPI.getPrintMemberServerCount(16, false);
                }
                logger.log(Level.INFO, "License: MachineType : " + machineType);
                logger.log(Level.INFO, "License: Enabled Servers : " + count);
                logger.log(Level.INFO, "License: Count From License: " + noOfServers);
                boolean excess = true;
                String enableDisable = "Disable";
                int diffCount = count - noOfServers;
                logger.log(Level.INFO, "License:Excess Count is" + diffCount);
                if (diffCount < 0 && !disableOnly.booleanValue()) {
                    diffCount = noOfServers - count;
                    excess = false;
                    enableDisable = "Enable";
                }
                HashMap<String, Object> cri = new HashMap<String, Object>();
                cri.put("sortColumn", "RECENT_EVENT_TIME");
                cri.put("tableName", COMPUTER_EVENT_TABLE_NAME);
                cri.put("startIndex", 1);
                cri.put("noOfObjects", Math.abs(diffCount));
                if (excess) {
                    cri.put("sortOrder", "asc");
                    list = ServerConfigAPI.getConfiguredServersExceptSyncedDevice(null, cri, null, null, null, new int[]{machineType}, 0);
                } else {
                    cri.put("sortOrder", "desc");
                    list = ServerConfigAPI.getConfiguredServers(null, cri, null, null, null, new int[]{machineType * 2}, 0);
                }
                logger.log(Level.INFO, "List size:" + list.size());
                ArrayList printServersList = new ArrayList();
                if ((machineType & 0x10) == 16) {
                    printServersList = PrintHandler.getConfiguredServers(null, new HashMap());
                }
                if (diffCount <= 0 || list.size() <= 0 && printServersList.size() <= 0) break block33;
                ArrayList<Long> idsList = new ArrayList<Long>();
                ArrayList<String> nameList = new ArrayList<String>();
                for (int i = 0; i < list.size() && diffCount > 0; --diffCount, ++i) {
                    Properties props = (Properties)list.get(i);
                    if ((machineType & 0x10) == 16) {
                        printerGuidList.add((String)props.get("OBJECT_GUID"));
                    }
                    idsList.add((Long)props.get("COMPUTER_ID"));
                    nameList.add((String)props.get("COMPUTER_NAME"));
                }
                if (excess) {
                    printerGuidlistadd = (diffCount > 0 || noOfServers == 0) && (machineType & 0x10) == 16;
                    for (int i = 0; i < printServersList.size() && printerGuidlistadd; ++i) {
                        Properties props = (Properties)printServersList.get(i);
                        printerGuidList.add((String)props.get("OBJECT_GUID"));
                        printerGuidlistadd = --diffCount > 0 || noOfServers == 0;
                    }
                } else {
                    printerGuidlistadd = diffCount > 0 && (machineType & 0x10) == 16;
                    for (int i = 0; i < printServersList.size() && printerGuidlistadd; ++i) {
                        Properties props = (Properties)printServersList.get(i);
                        boolean printerEnabled = (Boolean)props.get("ENABLED");
                        String printerObjectGUID = (String)props.get("OBJECT_GUID");
                        if (printerEnabled || printerGuidList.contains(printerObjectGUID)) continue;
                        printerGuidList.add(printerObjectGUID);
                        printerGuidlistadd = --diffCount > 0 && (machineType & 0x10) == 16;
                    }
                }
                logger.log(Level.INFO, "License : " + enableDisable + " list Name " + nameList);
                logger.log(Level.INFO, "License : " + enableDisable + " list " + idsList);
                if (machineType.equals(16)) {
                    logger.log(Level.INFO, "PrinterGuids list" + printerGuidList);
                    message = MSHandler.updateMemberServers(null, enableDisable, idsList, null, machineType, new boolean[0]);
                    PrintHandler.enableDiablePrintServers(!excess, printerGuidList, null, null);
                } else if (machineType.equals(4)) {
                    message = FileServerHandler.updateFileServers(null, enableDisable, idsList, null);
                } else if (machineType.equals(64)) {
                    message = ClusterHandler.updateClusterNodes(null, null, null, idsList, enableDisable, null);
                } else if (machineType.equals(256)) {
                    message = NetAppHandler.updateNetAppFilers(null, enableDisable, idsList, null);
                } else if (machineType.equals(524288)) {
                    message = NetAppHandler.updateNetAppFilers(null, enableDisable, idsList, null);
                } else if (machineType.equals(131072)) {
                    message = EMCHandler.updateEMCServers(null, enableDisable, idsList, null);
                } else if (machineType.equals(4096)) {
                    message = MSHandler.updateMemberServers(null, enableDisable, idsList, null, machineType, new boolean[0]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

