/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.manageengine.ads.fw.mail.MailHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import org.json.JSONObject;

public class MailServerUtil {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static String[] mailServerAttr = new String[]{"MAIL_SERVER", "SMTP_PORT", "FROM_ADDRESS", "USER_NAME", "PASSWORD", "IS_AUTHENTICATION_REQUIRED", "PLAIN_TEXT_MAIL", "USE_SECURE_CONN"};
    public static Session session;

    public static Properties getMailServerSettings() {
        Properties prop = new Properties();
        try {
            JSONObject mailSettings = MailHandler.getMailSettings();
            prop.put("MAIL_SERVER", mailSettings.optString("SERVER_NAME"));
            prop.put("SMTP_PORT", (Object)(mailSettings.has("PORT") && !mailSettings.getString("PORT").trim().equals("") ? Long.parseLong(mailSettings.getString("PORT")) : 25L));
            prop.put("FROM_ADDRESS", mailSettings.has("FROM_MAIL_ID") ? mailSettings.getString("FROM_MAIL_ID") : "noreply@adauditplus.com");
            prop.put("USER_NAME", mailSettings.optString("USER_NAME"));
            prop.put("PASSWORD", mailSettings.optString("PASSWORD"));
            prop.put("IS_AUTHENTICATION_REQUIRED", (Object)(!mailSettings.optString("USER_NAME").equals("") ? 1 : 0));
            prop.put("PLAIN_TEXT_MAIL", (Object)(mailSettings.has("ENABLE_HTML_FORMAT") ? !Boolean.valueOf(mailSettings.getString("ENABLE_HTML_FORMAT")).booleanValue() : false));
            String secureConnection = "none";
            if (mailSettings.has("CONNECTION_SECURITY_ID")) {
                long securityId = Long.parseLong(mailSettings.getString("CONNECTION_SECURITY_ID"));
                if (securityId == 1L) {
                    secureConnection = "ssl";
                } else if (securityId == 2L) {
                    secureConnection = "tls";
                }
            }
            prop.put("USE_SECURE_CONN", secureConnection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static boolean setMailServerSettings(Properties prop) {
        boolean updated = false;
        try {
            boolean toBeUpdate = true;
            Properties p = MailServerUtil.getMailServerSettings();
            if (prop.equals(p)) {
                toBeUpdate = false;
            }
            if (toBeUpdate) {
                JSONObject settings = new JSONObject((Map)prop);
                JSONObject mailServerSettings = new JSONObject();
                mailServerSettings.put("SERVER_NAME", (Object)settings.getString("MAIL_SERVER"));
                mailServerSettings.put("PORT", (Object)settings.getString("SMTP_PORT"));
                mailServerSettings.put("USER_NAME", (Object)settings.optString("USER_NAME"));
                mailServerSettings.put("PASSWORD", (Object)settings.optString("PASSWORD"));
                mailServerSettings.put("FROM_MAIL_ID", (Object)settings.getString("FROM_ADDRESS"));
                String htmlFormat = "true";
                if (Boolean.valueOf(settings.getString("PLAIN_TEXT_MAIL")).booleanValue()) {
                    htmlFormat = "false";
                }
                mailServerSettings.put("ENABLE_HTML_FORMAT", (Object)htmlFormat);
                String securityID = "";
                if (settings.getString("USE_SECURE_CONN").equals("ssl")) {
                    securityID = "1";
                } else if (settings.getString("USE_SECURE_CONN").equals("tls")) {
                    securityID = "2";
                }
                mailServerSettings.put("CONNECTION_SECURITY_ID", (Object)securityID);
                MailHandler.setMailSettings((JSONObject)mailServerSettings, (boolean[])new boolean[0]);
                updated = true;
                SendMailAPI.getInstance().updateMailServerSettings();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return updated;
    }

    public static boolean mailServerConfig() {
        boolean mailserverConfig = false;
        try {
            JSONObject mailSettings = MailHandler.getMailSettings();
            if (mailSettings.has("SERVER_NAME") && mailSettings.has("PORT")) {
                mailserverConfig = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mailserverConfig;
    }

    public static String sendTestMail(Properties mailServerProperties) throws Exception {
        try {
            String subject = rb.getString("adap.MailServerUtil.Test_Mail");
            String message = rb.getString("adap.MailServerUtil.Test_Mail");
            HashMap<String, Object> mailDetails = new HashMap<String, Object>();
            Properties prop = new Properties();
            mailDetails.put("message", message);
            mailDetails.put("subject", subject);
            for (String key : mailServerAttr) {
                if (mailServerProperties.get(key) == null) continue;
                prop.put(key, mailServerProperties.get(key));
            }
            if (mailServerProperties.get("TO_ADDRESS") != null) {
                mailDetails.put("toAddress", mailServerProperties.getProperty("TO_ADDRESS").split(","));
            }
            new SendMailAPI(prop).sendMail(mailDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage() == null) {
                return e.toString();
            }
            return e.getMessage();
        }
        return rb.getString("adap.common.text.status_msg.success");
    }
}

