/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.sym.adsm.common.server.mysql.tools.ChangeDBServer;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;

public class MssqlUtil {
    public static String dbServer = null;
    public static String dbPort = null;
    public static String dbUser = null;
    public static String dbPass = null;
    public static String dbName = null;
    public static String instanceName = null;
    public static String bcpDir = null;
    public static Boolean isWinAuth = false;
    private static MssqlUtil mssqlUtil = null;

    public MssqlUtil() {
        try {
            MssqlUtil.setBCPDir();
            isWinAuth = ChangeDBServer.isWinAuthType();
            HashMap dbparams = ChangeDBServer.getDBDetails("mssql");
            dbServer = (String)dbparams.get("HOST");
            dbName = (String)dbparams.get("DATABASE");
            dbUser = (String)dbparams.get("USERNAME");
            dbPass = (String)dbparams.get("PASSWORD");
            instanceName = (String)dbparams.get("INSTANCENAME");
            dbPort = (String)dbparams.get("PORT");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MssqlUtil getInstance() {
        if (mssqlUtil != null) return mssqlUtil;
        Class<MssqlUtil> clazz = MssqlUtil.class;
        synchronized (MssqlUtil.class) {
            mssqlUtil = new MssqlUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mssqlUtil;
        }
    }

    public static Properties getDBProps() {
        Properties dbprop = null;
        try {
            String dbFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
            dbprop = PersistenceInitializer.getDBProps((String)dbFilePath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dbprop;
    }

    public static String getLoadQuery(String lookupTableName, String csvName, Boolean utf8) {
        String loadDataQuery = null;
        try {
            loadDataQuery = "cmd /c \"\"" + bcpDir + "\\bcp.exe\"  " + dbName + ".dbo." + lookupTableName + " in \"" + csvName + "\" -S " + dbServer;
            if (instanceName != null && !instanceName.equals("")) {
                loadDataQuery = loadDataQuery + "\\" + instanceName;
            } else if (dbPort != null && !dbPort.equals("")) {
                loadDataQuery = loadDataQuery + "," + dbPort;
            }
            loadDataQuery = isWinAuth != false ? loadDataQuery + " -T " : loadDataQuery + " -U " + dbUser + " -P \"" + dbPass + "\"";
            String charType = "-w";
            if (utf8.booleanValue()) {
                charType = "-c";
            }
            loadDataQuery = loadDataQuery + " -t \"|**|\" -r \"|**|**|\\n\" -e ..\\logs\\datainerr_restore.txt " + charType + " -E -q\"";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return loadDataQuery;
    }

    public static String getBackupQuery(String tableName, String fileName) {
        String backupQuery = null;
        try {
            backupQuery = "cmd /c \"\"" + bcpDir + "\\\\bcp.exe\"  \"SELECT * FROM " + dbName + ".dbo." + tableName + "\" queryout \"" + fileName + "\" -S " + dbServer;
            if (instanceName != null && !instanceName.equals("")) {
                backupQuery = backupQuery + "\\" + instanceName;
            } else if (dbPort != null && !dbPort.equals("")) {
                backupQuery = backupQuery + "," + dbPort;
            }
            backupQuery = isWinAuth != false ? backupQuery + " -T " : backupQuery + " -U " + dbUser + " -P \"" + dbPass + "\"";
            backupQuery = backupQuery + " -t \"|**|\" -r \"|**|**|\\n\" -e ..\\logs\\datainerr_archive.txt -w -E -q\"";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return backupQuery;
    }

    public static synchronized String getInsertQuery(String tableName, String filePath) {
        String insertQuery = null;
        try {
            insertQuery = "cmd /c \"\"" + bcpDir + "\\bcp.exe\"  " + dbName + ".dbo." + tableName + " in \"" + filePath + "\" -S " + dbServer;
            if (instanceName != null && !instanceName.equals("")) {
                insertQuery = insertQuery + "\\" + instanceName;
            } else if (dbPort != null && !dbPort.equals("")) {
                insertQuery = insertQuery + "," + dbPort;
            }
            insertQuery = isWinAuth != false ? insertQuery + " -T " : insertQuery + " -U " + dbUser + " -P \"" + dbPass + "\"";
            if (filePath.endsWith(".csv")) {
                insertQuery = insertQuery + " -t \"^\" -q -e ..\\logs\\datainerr.txt -w \"";
            } else if (filePath.endsWith(".txt")) {
                insertQuery = insertQuery + " -t \"|**|\" -r \"\\n\" -e ..\\logs\\datainerr.txt -w -E -q\"";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return insertQuery;
    }

    public static synchronized String getRecordWriterQuery(String tableName, String filePath) {
        String recordWriterQuery = null;
        try {
            recordWriterQuery = "cmd /c \"\"" + bcpDir + "\\bcp.exe\"  " + dbName + ".dbo." + tableName + " in \"" + filePath + "\" -S " + dbServer;
            if (instanceName != null && !instanceName.equals("")) {
                recordWriterQuery = recordWriterQuery + "\\" + instanceName;
            } else if (dbPort != null && !dbPort.equals("")) {
                recordWriterQuery = recordWriterQuery + "," + dbPort;
            }
            recordWriterQuery = isWinAuth != false ? recordWriterQuery + " -T " : recordWriterQuery + " -U " + dbUser + " -P \"" + dbPass + "\"";
            recordWriterQuery = recordWriterQuery + " -t \"|**|\" -r \"|**|\\n\" -e ..\\logs\\datainerr_objUpd.txt -c -E -q\"";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return recordWriterQuery;
    }

    public static void setBCPDir() {
        try {
            bcpDir = System.getProperty("server.dir").replace("\\", "\\\\") + "\\\\" + "bin";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

