/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchedulerUtil {
    private static Long scheduleId = 0L;
    private static final String EVENT_TASK_NAME = "EventUpdate";
    private static Logger logger = Logger.getLogger("ADMangLogger");

    public static boolean updatePeriodicScheduler(HashMap schedulerPropsMap) {
        boolean flag = false;
        try {
            Long[] schedule_id = (Long[])schedulerPropsMap.get("SCHEDULE_ID");
            Column column = Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID");
            Criteria crit = new Criteria(column, (Object)schedule_id, 8);
            logger.log(Level.INFO, "criteria is " + crit);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("Periodic", crit);
            if (dataObject.isEmpty()) {
                DataObject schDo = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                for (int len = 0; len < schedule_id.length; ++len) {
                    Row periodicRow = new Row("Periodic");
                    periodicRow.set("SCHEDULE_ID", (Object)schedule_id[len]);
                    periodicRow.set("TIME_PERIOD", schedulerPropsMap.get("TIME_PERIOD"));
                    periodicRow.set("UNIT_OF_TIME", schedulerPropsMap.get("UNIT_OF_TIME"));
                    schDo.addRow(periodicRow);
                    SchedulerUtil.updateTime(schDo, schedule_id[len], -1L);
                }
                schDo = CommonUtil.getPersistence(new boolean[0]).add(schDo);
                flag = true;
            } else {
                Iterator iterator = dataObject.getRows("Periodic");
                while (iterator.hasNext()) {
                    Row periodic = (Row)iterator.next();
                    Long timePeriod = (Long)schedulerPropsMap.get("TIME_PERIOD");
                    String unitOfTime = (String)schedulerPropsMap.get("UNIT_OF_TIME");
                    periodic.set("TIME_PERIOD", (Object)timePeriod);
                    periodic.set("UNIT_OF_TIME", (Object)unitOfTime);
                    Timestamp startTimestamp = (Timestamp)periodic.get("START_DATE");
                    Long startTime = startTimestamp.getTime();
                    if (startTime > System.currentTimeMillis()) {
                        if (unitOfTime.equals("Minutes")) {
                            startTime = System.currentTimeMillis() + timePeriod * 60L * 1000L;
                        }
                        periodic.set("START_DATE", (Object)new Timestamp(startTime));
                    }
                    dataObject.updateRow(periodic);
                    SchedulerUtil.updateTime(dataObject, (Long)periodic.get("SCHEDULE_ID"), -1L);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static void updateTime(DataObject schDo, Long schedule_id, Long previousScheduleTime) {
        try {
            Column cols = Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID");
            Criteria cri = new Criteria(cols, (Object)schedule_id, 0);
            DataObject taskInp = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", cri);
            if (!taskInp.isEmpty()) {
                Row r = taskInp.getFirstRow("Task_Input");
                boolean isRescheduled = false;
                if (!previousScheduleTime.equals(-1L)) {
                    isRescheduled = true;
                }
                Long time = ScheduleUtil.calculateNextScheduleTime((DataObject)schDo, (Long)-1L, (boolean)isRescheduled);
                logger.log(Level.INFO, " Next Schedule Time for Schedule Id [{0}] is [{1}] : ", new Object[]{schedule_id, time});
                r.set("SCHEDULE_TIME", (Object)new Timestamp(time));
                taskInp.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(taskInp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long getTaskID(String taskName) {
        Long id = 0L;
        try {
            Column col = Column.getColumn((String)"TaskEngine_Task", (String)"TASK_NAME");
            Criteria crit = new Criteria(col, (Object)taskName, 0);
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("TaskEngine_Task", crit);
            if (!dob.isEmpty()) {
                Row r = dob.getFirstRow("TaskEngine_Task");
                id = (Long)r.get("TASK_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static void enableDisableScheduler(Long schedulerId, String status) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)schedulerId, 0);
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", c);
            Iterator iter = dob.getRows("Scheduled_Task");
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                if (status.equalsIgnoreCase("Disable")) {
                    r.set("ADMIN_STATUS", (Object)4);
                } else {
                    r.set("ADMIN_STATUS", (Object)3);
                }
                dob.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(dob);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getStatus(Long scId) {
        String status = null;
        int status_int = 0;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)scId, 0);
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", c);
            Iterator iter = dob.getRows("Scheduled_Task");
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                status_int = (Integer)r.get("ADMIN_STATUS");
            }
            status = status_int == 3 ? "Enabled" : "Disabled";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static Hashtable getScheduledReportsDetails(Long scheduleId) {
        String ScheduleName = null;
        Long Schedule_Id = 0L;
        String domainName = null;
        boolean i = false;
        ArrayList reportIDS = new ArrayList();
        Hashtable<String, Object> reportDetails = new Hashtable<String, Object>();
        try {
            Column col = Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID");
            Criteria crit = new Criteria(col, (Object)scheduleId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getRow("Schedule");
                ScheduleName = (String)r.get("SCHEDULE_NAME");
            }
            reportDetails.put("ScheduleName", ScheduleName);
            Column col1 = Column.getColumn((String)"ADSMScheduler", (String)"SCHEDULE_ID");
            Criteria crit1 = new Criteria(col1, (Object)scheduleId, 0);
            DataObject dataObj1 = CommonUtil.getPersistence(new boolean[0]).get("ADSMScheduler", crit1);
            if (!dataObj1.isEmpty()) {
                Row r = dataObj1.getRow("ADSMScheduler");
                Schedule_Id = (Long)r.get("SCHEDULE_ID");
                domainName = (String)r.get("DOMAIN_NAME");
            }
            reportDetails.put("domainName", domainName);
            Column col2 = Column.getColumn((String)"ADSMScheduleReportsMapping", (String)"SCHEDULE_ID");
            Criteria criteria = new Criteria(col2, (Object)Schedule_Id, 0);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMScheduleReportsMapping"));
            query.addSelectColumn(Column.getColumn((String)"ADSMScheduleReportsMapping", (String)"*"));
            query.addSortColumn(new SortColumn("ADSMScheduleReportsMapping", "SCHEDULE_PRIORITY", true));
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObject.getRows("ADSMScheduleReportsMapping");
            while (it.hasNext()) {
                Hashtable<String, Number> inputs = new Hashtable<String, Number>();
                Row r = (Row)it.next();
                Integer report_id = (Integer)r.get("REPORT_ID");
                Long unique_id = (Long)r.get("SCHEDULER_VALUES_MAPPING");
                inputs.put("report_id", report_id);
                inputs.put("unique_id", unique_id);
                reportIDS.add(inputs);
            }
            reportDetails.put("reportIDS", reportIDS);
            ArrayList<String> mailId = new ArrayList<String>();
            Column column = Column.getColumn((String)"ADSMNotificationIds", (String)"SCHEDULE_ID");
            Criteria criteria1 = new Criteria(column, (Object)Schedule_Id, 0);
            DataObject datobject = CommonUtil.getPersistence(new boolean[0]).get("ADSMNotificationIds", criteria1);
            Iterator iterator = datobject.getRows("ADSMNotificationIds");
            while (iterator.hasNext()) {
                Row r = (Row)iterator.next();
                String mail_id = (String)r.get("MAIL_ID");
                mailId.add(mail_id);
            }
            reportDetails.put("mailId", mailId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportDetails;
    }

    public static ArrayList<Long> getSchedulersForTask(String taskColumn, Object value) {
        ArrayList<Long> scheduleIds = new ArrayList<Long>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"TaskEngine_Task", (String)taskColumn), value, 0);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("TaskEngine_Task");
            tableList.add("Scheduled_Task");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
            Iterator iterator = dataObject.getRows("Scheduled_Task");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                scheduleIds.add((Long)row.get("SCHEDULE_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduleIds;
    }

    public static Object[] getScheduleIds(Long taskId) throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"Task_Input"));
        Join leftJoin = new Join(Table.getTable((String)"Task_Input"), Table.getTable((String)"Default_Task_Input"), new String[]{"INSTANCE_ID"}, new String[]{"INSTANCE_ID"}, 2);
        query.addJoin(leftJoin);
        query.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"*"));
        System.out.println("query is " + query);
        DataObject dobj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        ArrayList<Long> list = new ArrayList<Long>();
        Object[] scheduleIds = new Object[]{"0"};
        if (!dobj.isEmpty()) {
            Iterator iter = dobj.getRows("Task_Input");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                list.add((Long)row.get("SCHEDULE_ID"));
            }
            scheduleIds = list.toArray();
        }
        return scheduleIds;
    }

    public static String getLastFileUpdateTime() {
        String lastRunTime = "-";
        try {
            String scheduleIdUVH = "Schedule:schedule_id:UVH@10001";
            Long scheduleId = DBObjectUtil.getUVHValues("Schedule", scheduleIdUVH);
            Date date = SchedulerUtil.getLastScheduleRunTime(scheduleId);
            String LastFileUpdateScheduler = ADSMPersUtil.getSyMParameter("LastFileUpdateScheduler");
            if (LastFileUpdateScheduler != null && date != null) {
                Date manualLastRunTime = new Date(Long.valueOf(LastFileUpdateScheduler));
                if (date.compareTo(manualLastRunTime) < 0) {
                    date = manualLastRunTime;
                }
                lastRunTime = TimeUtil.getSimpleDateFormat(date);
            }
            if (date != null && LastFileUpdateScheduler == null) {
                lastRunTime = TimeUtil.getSimpleDateFormat(date);
            }
            if (date == null && LastFileUpdateScheduler != null) {
                lastRunTime = TimeUtil.getSimpleDateFormat(new Date(Long.valueOf(LastFileUpdateScheduler)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lastRunTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getLastScheduleRunTime(Long scheduleId) {
        Date date = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String dbServerName = CommonUtil.getDBServerName();
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = "";
            query = dbServerName.equalsIgnoreCase("mssql") ? "SELECT TOP 1SCHEDULE_FINISH_TIME FROM Schedule_Audit WHERE SCHEDULE_ID=" + scheduleId + " AND " + "TASK_EXECUTION_STATUS" + "='SUCCESS' ORDER BY " + "SCHEDULE_FINISH_TIME" + " DESC" : "SELECT SCHEDULE_FINISH_TIME FROM Schedule_Audit WHERE SCHEDULE_ID=" + scheduleId + " AND " + "TASK_EXECUTION_STATUS" + "='SUCCESS' ORDER BY " + "SCHEDULE_FINISH_TIME" + " DESC LIMIT 1";
            resultSet = QueryUtil.executeQuery("Schedule Audit History Query", statement, query);
            while (resultSet.next()) {
                Timestamp timestamp = resultSet.getTimestamp(1);
                date = new Date(timestamp.getTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return date;
    }
}

