/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static SimpleDateFormat sdf = null;
    private static String dateFormat = "MMM dd,yyyy hh:mm:ss a";
    private static String date = "MMM dd,yyyy";
    private static String time = "hh:mm:ss a";
    private static final Long DAY_IN_HUNDRED_NANO_SECONDS = 864000000000L;
    private static final Long HOUR_IN_HUNDRED_NANO_SECONDS = 36000000000L;
    private static final Long MINUTE_IN_HUNDRED_NANO_SECONDS = 600000000L;
    private static final Long HUNDRED_NANO_SECONDS = 10000000L;
    private static final Long DAY_IN_SECONDS = 86400L;
    private static final Long HOUR_IN_SECONDS = 3600L;
    private static final Long MINUTE_IN_SECONDS = 60L;
    private static final long FILETIME_EPOCH_DIFF = 11644473600000L;
    private static final long FILETIME_ONE_MILLISECOND = 10000L;
    private static String timeZoneId = TimeUtil.getDefaultTimeZoneId();

    public static void setDateFormat(String newFormat) {
        dateFormat = newFormat;
    }

    public static String getDateFormat() {
        return dateFormat;
    }

    public static void setDate(String newFormat) {
        date = newFormat;
        dateFormat = date + " " + time;
    }

    public static String getDate() {
        return date;
    }

    public static void setTime(String newFormat) {
        time = newFormat;
        dateFormat = date + " " + time;
    }

    public static String getTime() {
        return time;
    }

    public static String getEVTQueryEventTime(Long timeGenerated) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(timeGenerated);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        sdf.setCalendar(calendar);
        String formatedDate = sdf.format(calendar.getTime());
        formatedDate = formatedDate + "Z";
        return formatedDate;
    }

    public static HashMap<String, Object> getTimePeriod(String inputParams) {
        Date dt1 = new Date();
        Date dt2 = new Date();
        HashMap<String, Object> periodMap = new HashMap<String, Object>();
        Long startTime = 0L;
        Long endTime = 0L;
        int day = 0;
        Long temp = 0L;
        long currTime = System.currentTimeMillis();
        if (inputParams.equalsIgnoreCase("onehour")) {
            startTime = (currTime - 3600000L) / 1000L;
            endTime = currTime / 1000L;
        } else if (inputParams.equalsIgnoreCase("twohours")) {
            startTime = (currTime - 0x6DDD00L) / 1000L;
            endTime = currTime / 1000L;
        } else if (inputParams.equalsIgnoreCase("sixhours")) {
            startTime = (currTime - 21600000L) / 1000L;
            endTime = currTime / 1000L;
        } else if (inputParams.equalsIgnoreCase("eighthours")) {
            startTime = (currTime - 28800000L) / 1000L;
            endTime = currTime / 1000L;
        } else if (inputParams.equalsIgnoreCase("twelvehours")) {
            startTime = (currTime - 43200000L) / 1000L;
            endTime = currTime / 1000L;
        } else if (inputParams.equalsIgnoreCase("twfourhours")) {
            startTime = (currTime - 86400000L) / 1000L;
            endTime = currTime / 1000L;
        } else if (inputParams.equalsIgnoreCase("Yesterday")) {
            day = dt1.getDate();
            dt1.setDate(day - 1);
            dt1 = TimeUtil.setZero(dt1);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            dt2.setDate(day - 1);
            dt2 = TimeUtil.setDate(dt2, 23, 59, 59);
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Today")) {
            dt1 = TimeUtil.setZero(dt1);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("thisWeek")) {
            Long temp1 = dt1.getDay();
            Long stop = dt2.getTime();
            temp = temp1 * 86400000L;
            dt1 = new Date(stop - temp);
            dt1 = TimeUtil.setZero(dt1);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = stop / 1000L;
        } else if (inputParams.equalsIgnoreCase("thisMonth")) {
            dt1.setDate(1);
            dt1 = TimeUtil.setZero(dt1);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Last_Month")) {
            int mon = dt1.getMonth();
            int[] month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
            dt1.setMonth(mon - 1);
            dt1.setDate(1);
            dt1 = TimeUtil.setZero(dt1);
            dt2.setMonth(mon - 1);
            if (dt2.getYear() % 4 == 0 && dt2.getMonth() == 1) {
                dt2.setDate(29);
            } else if (dt2.getMonth() == 1) {
                dt2.setDate(28);
            } else {
                dt2.setDate(month[dt2.getMonth()]);
            }
            dt2 = TimeUtil.setDate(dt2, 23, 59, 59);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Last_7_Days")) {
            temp = dt2.getTime();
            dt1 = new Date(temp - 604800000L);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = temp / 1000L;
        } else if (inputParams.equalsIgnoreCase("Last_30_Days")) {
            Long stop = dt2.getTime();
            dt1 = new Date(stop - 2592000000L);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Last_60_Days")) {
            Long stop = dt2.getTime();
            dt1 = new Date(stop - 5184000000L);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Last_90_Days")) {
            Long stop = dt2.getTime();
            dt1 = new Date(stop - 7776000000L);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Before_7_Days")) {
            temp = dt2.getTime();
            dt1 = new Date(temp - 604800000L);
            startTime = 0L;
            endTime = Long.valueOf(dt1.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Before_30_Days")) {
            Long stop = dt2.getTime();
            dt1 = new Date(stop - 2592000000L);
            startTime = 0L;
            endTime = Long.valueOf(dt1.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Before_60_Days")) {
            Long stop = dt2.getTime();
            dt1 = new Date(stop - 5184000000L);
            startTime = 0L;
            endTime = Long.valueOf(dt1.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Before_90_Days")) {
            Long stop = dt2.getTime();
            dt1 = new Date(stop - 7776000000L);
            startTime = 0L;
            endTime = Long.valueOf(dt1.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("lastWeek")) {
            day = dt1.getDate();
            dt1.setDate(day - 7 - dt1.getDay());
            dt1 = TimeUtil.setZero(dt1);
            day = dt2.getDate();
            dt2.setDate(day - dt2.getDay() - 1);
            dt2 = TimeUtil.setDate(dt2, 23, 59, 59);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("lastHour")) {
            int hour = dt1.getHours();
            dt1 = TimeUtil.setDate(dt1, hour - 1, 0, 0);
            dt2 = TimeUtil.setDate(dt2, hour, 0, 0);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Last_6_Months")) {
            Long stop = dt2.getTime();
            dt1 = new Date(stop - 15552000000L);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Last_one_year")) {
            Long stop = dt2.getTime();
            dt1 = new Date(stop - 31536000000L);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("Last_Year")) {
            GregorianCalendar dt = new GregorianCalendar();
            int year = dt.get(1);
            dt1.setYear(year - 1900 - 1);
            dt2.setYear(year - 1900 - 1);
            dt1 = TimeUtil.setDate(dt1, 0, 1, 0, 0, 0);
            dt2 = TimeUtil.setDate(dt2, 11, 31, 23, 59, 59);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("This_Year")) {
            dt1 = TimeUtil.setDate(dt1, 0, 1, 0, 0, 0);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        } else if (inputParams.equalsIgnoreCase("workhour")) {
            day = dt1.getDate();
            dt1.setDate(day - 1);
            TimeUtil.setDate(dt1, 8, 0, 0);
            startTime = Long.valueOf(dt1.getTime()) / 1000L;
            dt2.setDate(day - 1);
            dt2 = TimeUtil.setDate(dt2, 18, 0, 0);
            endTime = Long.valueOf(dt2.getTime()) / 1000L;
        }
        periodMap.put("FROM", startTime);
        periodMap.put("TO", endTime);
        return periodMap;
    }

    public static HashMap getLastNPeriod(int period, Long last_n) {
        long dateOffset = 0L;
        Date dt1 = new Date();
        Date dt2 = new Date();
        HashMap<String, Long> periodMap = new HashMap<String, Long>();
        if (period == 10) {
            dateOffset = 3600000L * last_n;
        } else if (period == 20) {
            dateOffset = 86400000L * last_n;
        } else if (period == 30) {
            int year = dt1.getYear();
            int month = dt1.getMonth();
            long days = 0L;
            while (last_n >= 12L) {
                last_n = last_n - 12L;
                days = year % 4 == 0 && month >= 1 || month <= 1 && (year - 1) % 4 == 0 ? (days += 366L) : (days += 365L);
                --year;
            }
            int[] months = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
            while (last_n > 0L) {
                days = month == 2 && year % 4 == 0 ? (days += 29L) : (month != 0 ? (days += (long)months[month - 1]) : (days += (long)months[11]));
                month = month == 0 ? 11 : --month;
                Long l = last_n;
                Long l2 = last_n = Long.valueOf(last_n - 1L);
            }
            dateOffset = 86400000L * days;
        }
        dt1.setTime(dt1.getTime() - dateOffset);
        Long from = Long.valueOf(dt1.getTime()) / 1000L;
        Long to = Long.valueOf(dt2.getTime()) / 1000L;
        periodMap.put("FROM", from);
        periodMap.put("TO", to);
        return periodMap;
    }

    private static Date setZero(Date dt) {
        return TimeUtil.setDate(dt, 0, 0, 0);
    }

    private static Date setDate(Date dt, int hr, int min, int sec) {
        dt.setHours(hr);
        dt.setMinutes(min);
        dt.setSeconds(sec);
        return dt;
    }

    private static Date setDate(Date dt, int month, int day, int hr, int min, int sec) {
        dt.setMonth(month);
        dt.setDate(day);
        TimeUtil.setDate(dt, hr, min, sec);
        return dt;
    }

    public static Long getTimePeriod(String time, String hour) {
        String[] timeArray = time.split("-");
        int year = Integer.parseInt(timeArray[0]);
        int month = Integer.parseInt(timeArray[1]) - 1;
        int day = Integer.parseInt(timeArray[2]);
        int hr = Integer.parseInt(hour);
        int min = 0;
        GregorianCalendar dt = new GregorianCalendar(year, month, day, hr, min);
        Long date = Long.valueOf(dt.getTimeInMillis()) / 1000L;
        return date;
    }

    public static Long getTimePeriod(String time, String hour, String minute) {
        String[] timeArray = time.split("-");
        int year = Integer.parseInt(timeArray[0]);
        int month = Integer.parseInt(timeArray[1]) - 1;
        int day = Integer.parseInt(timeArray[2]);
        int hr = Integer.parseInt(hour);
        int min = Integer.parseInt(minute);
        GregorianCalendar dt = new GregorianCalendar(year, month, day, hr, min);
        Long date = Long.valueOf(dt.getTimeInMillis()) / 1000L;
        return date;
    }

    public static Long getDaysFromSeconds(String seconds) {
        Long days = 0L;
        try {
            if (seconds != null) {
                Long secondsLong = Long.parseLong(seconds);
                days = TimeUtil.getDaysFromSeconds(secondsLong);
            }
        }
        catch (NumberFormatException e) {
            System.out.println(seconds + " is not a valid number");
            e.printStackTrace();
        }
        return days;
    }

    public static Long getDaysFromSeconds(Long seconds) {
        return seconds / 86400L;
    }

    public static Long getMinutesFromSeconds(String seconds) {
        Long minutes = 0L;
        try {
            if (seconds != null) {
                Long secondsLong = Long.parseLong(seconds);
                minutes = TimeUtil.getMinutesFromSeconds(secondsLong);
            }
        }
        catch (NumberFormatException e) {
            System.out.println(seconds + " is not a valid number");
            e.printStackTrace();
        }
        return minutes;
    }

    public static Long getMinutesFromSeconds(Long seconds) {
        return seconds / 60L;
    }

    public static String getSimpleDateFormat(Date date) throws Exception {
        sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    public static String getDateFormat(Date date) throws Exception {
        sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    public static String getTimeFormat(Date date) throws Exception {
        sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    public static String getHour(Long minutes) throws Exception {
        sdf = new SimpleDateFormat(time);
        Date date = new Date();
        date.setHours(minutes.intValue() / 60);
        date.setMinutes(minutes.intValue() % 60);
        return sdf.format(date);
    }

    public static String getTimeZoneId() {
        return timeZoneId;
    }

    private static String getDefaultTimeZoneId() {
        String timeZoneIdTemp = " ";
        if (ADSMPersUtil.getSyMParameter("TIMEZONE_ID").equals("-")) {
            timeZoneIdTemp = TimeZone.getDefault().getID();
            ADSMPersUtil.updateSyMParameter("TIMEZONE_ID", TimeZone.getDefault().getID());
        } else {
            timeZoneIdTemp = ADSMPersUtil.getSyMParameter("TIMEZONE_ID");
        }
        return timeZoneIdTemp;
    }

    public static void setTimeZoneId(String newTimeZoneId) {
        timeZoneId = newTimeZoneId;
    }

    public static String formatDate(long value, String argDateFormat, String timeZoneId) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTimeInMillis(value);
        Date date = calendar.getTime();
        argDateFormat = dateFormat;
        sdf = new SimpleDateFormat(argDateFormat);
        sdf.setCalendar(calendar);
        return sdf.format(date);
    }

    public static String formatDate(Long value, String argDateFormat) {
        return TimeUtil.formatDate((long)value, argDateFormat);
    }

    public static String formatDate(long value, String argDateFormat) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTimeInMillis(value);
        Date date = calendar.getTime();
        argDateFormat = dateFormat;
        sdf = new SimpleDateFormat(argDateFormat);
        sdf.setCalendar(calendar);
        return sdf.format(date);
    }

    public static int getTimeZoneOffset() {
        TimeZone timeZone = TimeZone.getTimeZone(TimeZone.getDefault().getID());
        return timeZone.getOffset(new Date().getTime()) / 1000;
    }

    public static int getDayOfWeek(Long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
        cal.setTimeInMillis(date * 1000L);
        return cal.get(7);
    }

    public static int getMonthOfYear(Long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
        cal.setTimeInMillis(date * 1000L);
        return cal.get(2);
    }

    public static int getYear(Long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
        cal.setTimeInMillis(date * 1000L);
        return cal.get(1);
    }

    public static Long getMonthFloor(int month, Long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
        cal.setTimeInMillis(date * 1000L);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        if (month >= 0 && month < 12) {
            cal.set(2, month);
        }
        return cal.getTimeInMillis() / 1000L;
    }

    public static Long getFromFloor(Integer timePeriod) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (timePeriod == 0) {
            cal.add(5, -1);
        } else if (timePeriod == 1) {
            cal.add(5, -7);
        } else if (timePeriod == 2) {
            cal.set(7, 1);
            cal.add(3, -1);
        } else if (timePeriod == 3) {
            cal.set(5, 1);
        } else if (timePeriod == 4) {
            cal.set(5, 1);
            cal.add(2, -1);
        } else if (timePeriod == 5) {
            cal.set(5, 1);
            cal.set(2, 0);
        } else if (timePeriod == 6) {
            cal.set(5, 1);
            cal.set(2, 0);
            cal.add(1, -1);
        } else if (timePeriod == 7) {
            cal.set(7, 1);
        } else if (timePeriod == 8) {
            int month = cal.get(2);
            int quarter = month - month % 3;
            cal.set(5, 1);
            cal.set(2, quarter);
        } else if (timePeriod == 9) {
            int month = cal.get(2);
            int quarter = month - month % 3;
            cal.set(5, 1);
            cal.set(2, quarter);
            cal.add(2, -3);
        } else if (timePeriod > 100 && timePeriod < 200) {
            int offset = timePeriod % 100;
            cal.set(5, 1);
            cal.add(2, offset * -1);
        } else if (timePeriod > 200 && timePeriod < 300) {
            int offset = timePeriod % 100;
            int month = cal.get(2);
            int quarter = month - month % 3;
            cal.set(5, 1);
            cal.set(2, quarter);
            cal.add(2, offset * -3);
        } else if (timePeriod > 300 && timePeriod < 400) {
            int offset = timePeriod % 100;
            cal.set(5, 1);
            cal.set(2, 0);
            cal.add(1, offset * -1);
        } else if (timePeriod > 100000000) {
            int temp = timePeriod / 1000;
            int startMonth = temp % 100;
            int startYear = temp / 100;
            cal.set(5, 1);
            cal.set(2, startMonth - 1);
            cal.set(1, startYear);
        }
        return cal.getTimeInMillis() / 1000L;
    }

    public static Long getToFloor(Integer timePeriod) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (timePeriod == 2) {
            cal.set(7, 1);
        } else if (timePeriod == 4 || timePeriod > 100 && timePeriod < 200) {
            cal.set(5, 1);
        } else if (timePeriod == 6 || timePeriod > 300 && timePeriod < 400) {
            cal.set(5, 1);
            cal.set(2, 0);
        } else if (timePeriod == 9 || timePeriod > 200 && timePeriod < 300) {
            int month = cal.get(2);
            int quarter = month - month % 3;
            cal.set(5, 1);
            cal.set(2, quarter);
        } else if (timePeriod > 100000000) {
            int temp = timePeriod;
            int diff = temp % 1000;
            int startMonth = (temp /= 1000) % 100;
            int startYear = temp / 100;
            cal.set(5, 1);
            cal.set(2, startMonth - 1);
            cal.set(1, startYear);
            cal.add(2, diff);
        }
        return cal.getTimeInMillis() / 1000L;
    }

    public static String getDelayedCrunchTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
        cal.add(12, 30);
        Date date = cal.getTime();
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setCalendar(cal);
        return sdf.format(date);
    }

    public static Long getTodayFloor() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(TimeZone.getDefault().getID()));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis() / 1000L;
    }

    public static String formatDate(Long value) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTimeInMillis(value);
        Date date = calendar.getTime();
        sdf = new SimpleDateFormat(dateFormat);
        sdf.setCalendar(calendar);
        return sdf.format(date);
    }

    public static String formatDefaultTimeZoneDate(Long value) {
        String timeZoneId = TimeZone.getDefault().getID();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        calendar.setTimeInMillis(value);
        Date date = calendar.getTime();
        sdf = new SimpleDateFormat(dateFormat);
        sdf.setCalendar(calendar);
        return sdf.format(date);
    }

    public static String formatDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        Date date = calendar.getTime();
        sdf = new SimpleDateFormat(dateFormat);
        sdf.setCalendar(calendar);
        return sdf.format(date);
    }

    public static String formatAccountExpiresDate(Long value) {
        String formattedCurrentDate;
        long time = value;
        Date date = new Date(time);
        String xdateFormat = "MMM dd,yyyy";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(xdateFormat);
        String formattedDate = simpleDateFormat.format(date);
        if (formattedDate.startsWith(formattedCurrentDate = (simpleDateFormat = new SimpleDateFormat(xdateFormat = "MMM dd,yyyy")).format(date = new Date(time = System.currentTimeMillis())))) {
            formattedDate = formattedDate.replaceFirst(formattedCurrentDate, "Today");
        } else {
            date = new Date(time -= 86400000L);
            formattedCurrentDate = simpleDateFormat.format(date);
            if (formattedDate.startsWith(formattedCurrentDate)) {
                formattedDate = formattedDate.replaceFirst(formattedCurrentDate, "Yesterday");
            }
        }
        return "End of " + formattedDate;
    }

    public static String getWMIEventTime(Long timeGenerated) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(timeGenerated * 1000L);
        Date date = calendar.getTime();
        sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setCalendar(calendar);
        String formatedDate = sdf.format(date);
        formatedDate = formatedDate + ".000000-000";
        return formatedDate;
    }

    public static int getEventTime(String timeGenerated) throws Exception {
        SimpleDateFormat cimDateTime = new SimpleDateFormat("yyyyMMddHHmmssZ");
        String[] timeInfo = timeGenerated.split("\\.");
        String zoneOffset = timeInfo[1].substring(6, 7);
        String zone = timeInfo[1].substring(7);
        int zoneInt = Integer.parseInt(zone);
        int hours = zoneInt / 60;
        if (hours < 10) {
            zoneOffset = zoneOffset + "0";
        }
        zoneOffset = zoneOffset + hours;
        int minutes = zoneInt % 60;
        if (minutes < 10) {
            zoneOffset = zoneOffset + "0";
        }
        zoneOffset = zoneOffset + minutes;
        timeGenerated = timeInfo[0] + zoneOffset;
        Date date = cimDateTime.parse(timeGenerated);
        int time = Long.valueOf(date.getTime() / 1000L).intValue();
        return time;
    }

    public static Long getFromTime(Long noOfDays, Long toTime) {
        Long fromTime = toTime - noOfDays * 24L * 3600L;
        return fromTime;
    }

    public static Long getTimeFromdwTimeStamp(Long timeStamp) {
        Long systemTime = timeStamp * 3600L * 1000L;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1601, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Long millis = calendar.getTimeInMillis();
        systemTime = systemTime + millis;
        return systemTime;
    }

    public static Long getUnixTimeFromFileTime(Long fileTime) {
        Long systemTime = fileTime / 10000L;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1601, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        Long millis = calendar.getTimeInMillis();
        systemTime = systemTime + millis;
        return systemTime / 1000L;
    }

    public static String getGPOModifiedTime(String dateString, String outputFormatString, String suffix, Long offset, boolean isNegativeOffset) {
        String formatedDate = null;
        try {
            String[] dateStringArray = dateString.split("\\.");
            dateString = dateStringArray[0];
            SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
            Date date = inputDateFormat.parse(dateString);
            SimpleDateFormat outputSDF = new SimpleDateFormat(outputFormatString, Locale.ENGLISH);
            if (!isNegativeOffset) {
                Long time = date.getTime();
                time = time + offset;
                date.setTime(time);
            } else {
                Long time = date.getTime();
                time = time - offset;
                date.setTime(time);
            }
            formatedDate = outputSDF.format(date);
            formatedDate = formatedDate + suffix;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return formatedDate;
    }

    public static Long getTimeFromGPOXMLTime(String dateString) {
        Long modifiedTime = 0L;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date date = dateFormat.parse(dateString);
            modifiedTime = date.getTime() / 1000L;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return modifiedTime;
    }

    public static String getDuration(Long time) {
        int seconds;
        int minutes;
        int hours;
        StringBuilder duration = new StringBuilder();
        int days = new Long(time / DAY_IN_SECONDS).intValue();
        if (days > 0) {
            duration.append(days);
            duration.append(RB.getString("adap.admin.administration.clear_alerts.text.days"));
        }
        if ((hours = new Long((time = Long.valueOf(time % DAY_IN_SECONDS)) / HOUR_IN_SECONDS).intValue()) > 0) {
            if (!duration.toString().equals("")) {
                duration.append(", ");
            }
            duration.append(hours);
            duration.append(RB.getString("adap.common.text.hours"));
        }
        if ((minutes = new Long((time = Long.valueOf(time % HOUR_IN_SECONDS)) / MINUTE_IN_SECONDS).intValue()) > 0) {
            if (!duration.toString().equals("")) {
                duration.append(", ");
            }
            duration.append(minutes);
            duration.append(RB.getString("adap.common.text.minutes"));
        }
        if ((seconds = new Long(time = Long.valueOf(time % MINUTE_IN_SECONDS)).intValue()) > 0) {
            if (!duration.toString().equals("")) {
                duration.append(", ");
            }
            duration.append(seconds);
            duration.append(RB.getString("adap.common.text.seconds"));
        }
        return duration.toString();
    }

    public static String getPSODuration(String timeinLong) {
        int seconds;
        int minutes;
        int hours;
        StringBuilder psoDuration = new StringBuilder();
        Long time = Long.parseLong(timeinLong = timeinLong.substring(timeinLong.indexOf("-") + 1));
        int days = new Long(time / DAY_IN_HUNDRED_NANO_SECONDS).intValue();
        if (days > 0) {
            psoDuration.append(days);
            psoDuration.append(RB.getString("adap.admin.administration.clear_alerts.text.days"));
        }
        if ((hours = new Long((time = Long.valueOf(time % DAY_IN_HUNDRED_NANO_SECONDS)) / HOUR_IN_HUNDRED_NANO_SECONDS).intValue()) > 0) {
            if (!psoDuration.toString().equals("")) {
                psoDuration.append(", ");
            }
            psoDuration.append(hours);
            psoDuration.append(RB.getString("adap.common.text.hours"));
        }
        if ((minutes = new Long((time = Long.valueOf(time % HOUR_IN_HUNDRED_NANO_SECONDS)) / MINUTE_IN_HUNDRED_NANO_SECONDS).intValue()) > 0) {
            if (!psoDuration.toString().equals("")) {
                psoDuration.append(", ");
            }
            psoDuration.append(minutes);
            psoDuration.append(RB.getString("adap.common.text.minutes"));
        }
        if ((seconds = new Long((time = Long.valueOf(time % MINUTE_IN_HUNDRED_NANO_SECONDS)) / HUNDRED_NANO_SECONDS).intValue()) > 0) {
            if (!psoDuration.toString().equals("")) {
                psoDuration.append(", ");
            }
            psoDuration.append(seconds);
            psoDuration.append(RB.getString("adap.common.text.seconds"));
        }
        return psoDuration.toString();
    }

    public static long millisToFiletime(long millis) {
        return (millis + 11644473600000L) * 10000L;
    }
}

