/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.category.ObjectAccessListener;
import com.adventnet.sym.adsm.auditing.server.delegation.DelegationConstants;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.objects.ADAPObjectCacheAPI;
import com.adventnet.sym.adsm.common.server.objects.UserAccountControl;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public final class UserAttributeUtil {
    private static final ADAPObjectCacheAPI ADAP_OBJECT_CACHE_API = ADAPObjectCacheAPI.getInstance();

    public static void setACLChanges(ArrayList<Row> rowList, String domainName, String attributeTxt) {
        try {
            Row row = rowList.get(0);
            DataAccess.generateValues((Row)row);
            String newStringSecDesc = (String)row.get("ATTRIBUTES_NEW_VALUE");
            String originalStringSecDesc = (String)row.get("ATTRIBUTES_OLD_VALUE");
            Hashtable newAceTable = null;
            Hashtable originalAceTable = null;
            if (newStringSecDesc != null) {
                newAceTable = ADHandler.getSecurityDescriptorFromStringSD(domainName, newStringSecDesc);
            }
            if (originalStringSecDesc != null) {
                originalAceTable = ADHandler.getSecurityDescriptorFromStringSD(domainName, originalStringSecDesc);
            }
            if (newAceTable != null) {
                Enumeration enumeration = newAceTable.keys();
                while (enumeration.hasMoreElements()) {
                    String keyStr = (String)enumeration.nextElement();
                    if (!keyStr.equals("Dacl") && !keyStr.equals("Sacl")) continue;
                    ArrayList newAcl = (ArrayList)newAceTable.get(keyStr);
                    ArrayList originalAcl = null;
                    if (originalAceTable != null) {
                        originalAcl = (ArrayList)originalAceTable.get(keyStr);
                    }
                    String aceType = attributeTxt.equalsIgnoreCase("ms-Exch-Mailbox-Security-Descriptor") ? "MB" : "DS";
                    ObjectAccessListener.compareAcList(domainName, rowList, newAcl, originalAcl, "AUDACLChanges", aceType);
                }
            }
            for (int i = 0; i < rowList.size(); ++i) {
                Row aclRow = rowList.get(i);
                aclRow.set("CORRELATION_ID", row.get("CORRELATION_ID"));
            }
            if (row != null) {
                Row newOldValueRow = new Row("AUDACLVALUES");
                newOldValueRow.set("ACCOUNT_DOMAIN", row.get("ACCOUNT_DOMAIN"));
                newOldValueRow.set("CORRELATION_ID", row.get("CORRELATION_ID"));
                newOldValueRow.set("ATTRIBUTES_NEW_VALUE", row.get("ATTRIBUTES_NEW_VALUE"));
                newOldValueRow.set("ATTRIBUTES_OLD_VALUE", row.get("ATTRIBUTES_OLD_VALUE"));
                rowList.add(newOldValueRow);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getIPAddress(Long ipAddress) {
        String ipAddressString = "";
        try {
            Long FourthOctet = 1L;
            Long ThirdOctet = 256L;
            Long SecondOctet = 65536L;
            Long FirstOctet = 0x1000000L;
            Long ret = 0L;
            if (ipAddress >= 0L) {
                ret = ipAddress / FirstOctet;
                ipAddressString = ret.toString();
                ipAddressString = ipAddressString + ".";
                Long intFirstRemainder = ipAddress % FirstOctet;
                ret = intFirstRemainder / SecondOctet;
                ipAddressString = ipAddressString + ret.toString();
                ipAddressString = ipAddressString + ".";
                Long intSecondRemainder = intFirstRemainder % SecondOctet;
                ret = intSecondRemainder / ThirdOctet;
                ipAddressString = ipAddressString + ret.toString();
                ipAddressString = ipAddressString + ".";
                Long intThirdRemainder = intSecondRemainder % ThirdOctet;
                ret = intThirdRemainder / FourthOctet;
                ipAddressString = ipAddressString + ret.toString();
            } else {
                ret = 255L + ipAddress / FirstOctet;
                ipAddressString = ret.toString();
                ipAddressString = ipAddressString + ".";
                Long intFirstRemainder = ipAddress % FirstOctet;
                ret = 255L + intFirstRemainder / SecondOctet;
                ipAddressString = ipAddressString + ret.toString();
                ipAddressString = ipAddressString + ".";
                Long intSecondRemainder = intFirstRemainder % SecondOctet;
                ret = 255L + intSecondRemainder / ThirdOctet;
                ipAddressString = ipAddressString + ret.toString();
                ipAddressString = ipAddressString + ".";
                Long intThirdRemainder = intSecondRemainder % ThirdOctet;
                ret = 256L + intThirdRemainder / FourthOctet;
                ipAddressString = ipAddressString + ret.toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ipAddressString;
    }

    public static Pattern getUserParameterPattern(String patternStr) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(patternStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pattern;
    }

    public static String decodeValue(String str) {
        StringBuilder finalAnswer = new StringBuilder();
        for (int i = 0; i < str.length(); i += 3) {
            int i1 = str.codePointAt(i);
            int i2 = str.codePointAt(i + 1);
            int i3 = str.codePointAt(i + 2);
            String data = UserAttributeUtil.getBytes(i1) + UserAttributeUtil.getBytes(i2) + UserAttributeUtil.getBytes(i3);
            String header = data.substring(0, 4);
            String ctrlY = data.substring(4, 10);
            String yyyy = data.substring(10, 14);
            String ctrlX = data.substring(14, 20);
            String xxxx = data.substring(20, 24);
            int x = Integer.parseInt(ctrlX, 2);
            int y = Integer.parseInt(ctrlY, 2);
            if (ctrlX.equals("011010")) {
                x += 9;
            }
            if (ctrlY.equals("011010")) {
                y += 9;
            }
            Integer ans = (x <<= 4) | y;
            Byte bt = Byte.valueOf(ans.toString());
            finalAnswer.append(bt.toString());
        }
        return finalAnswer.toString();
    }

    private static String getBytes(int number) {
        String str = Integer.toBinaryString(number);
        int len = str.length();
        StringBuilder builder = new StringBuilder();
        if (len < 8) {
            int pack = 8 - len;
            for (int i = 0; i < pack; ++i) {
                builder.append("0");
            }
            builder.append(str);
        } else {
            builder.append(str);
        }
        return builder.toString();
    }

    public static String getUserFlagString(String userAccControl) {
        Long val = userAccControl == null || userAccControl.equals("") ? 0L : Long.valueOf(userAccControl);
        int intVal = val.intValue();
        String UACFlagStr = UserAccountControl.getUACString(intVal);
        return UACFlagStr;
    }

    public static String getAccountExpTime(Long attributeVal) {
        Long diffTime = 116444736000000000L;
        attributeVal = (attributeVal - diffTime) / 10000L;
        String dateFormat = "yyyy.MM.dd G 'at' HH:mm:ss z";
        String formatDate = CommonUtil.formatDate(attributeVal, dateFormat);
        return formatDate;
    }

    public static Hashtable getACLTable(String domainName, Hashtable aclTable, String type) {
        Hashtable<String, String> aclhashTable = new Hashtable<String, String>();
        String trustee = (String)aclTable.get("Trustee");
        String name = ADAP_OBJECT_CACHE_API.getObjectNameFromSID(domainName, trustee, "NAME", null);
        if (name == null) {
            name = trustee;
        }
        Integer aclType = (Integer)aclTable.get("AceType");
        Integer aclFlags = (Integer)aclTable.get("AceFlags");
        aclhashTable.put("SECURITY_PRINCIPAL", name);
        aclhashTable.put("PERMISSION", !type.equalsIgnoreCase("NT-Security-Descriptor") ? DelegationConstants.getAccessMaskString(aclTable.get("AccessMask").toString(), "MB") : DelegationConstants.getPermissionString(aclTable, domainName));
        aclhashTable.put("ACE_TYPE", DelegationConstants.getFileAceTypeString(aclType, aclFlags));
        aclhashTable.put("APPLIES_TO", DelegationConstants.getAppliesToString(aclTable, domainName));
        aclhashTable.put("INHERITED_ACE", DelegationConstants.isInheritedString(aclFlags));
        return aclhashTable;
    }

    public static ArrayList getACLList(String domainName, Hashtable aclTable, String type) {
        ArrayList<Hashtable> aclList = new ArrayList<Hashtable>();
        try {
            ArrayList saclList = (ArrayList)aclTable.get("Sacl");
            ArrayList daclList = (ArrayList)aclTable.get("Dacl");
            if (saclList != null) {
                for (Object saclObject : saclList) {
                    Hashtable saclTable = (Hashtable)saclObject;
                    Hashtable saclhashTable = UserAttributeUtil.getACLTable(domainName, saclTable, type);
                    saclhashTable.put("ACL", "SACL");
                    aclList.add(saclhashTable);
                }
            }
            if (daclList != null) {
                for (Object daclObject : daclList) {
                    Hashtable daclTable = (Hashtable)daclObject;
                    Hashtable daclhashTable = UserAttributeUtil.getACLTable(domainName, daclTable, type);
                    daclhashTable.put("ACL", "DACL");
                    aclList.add(daclhashTable);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return aclList;
    }

    public static String getCanonicalName(String distinguishedName) {
        String canonicalName = null;
        try {
            LdapName ldapName = new LdapName(distinguishedName);
            List<Rdn> rdnList = ldapName.getRdns();
            for (Rdn rdn : rdnList) {
                String rdnType = rdn.getType();
                if (rdnType.equalsIgnoreCase("dc")) {
                    if (canonicalName == null) {
                        canonicalName = rdn.getValue().toString();
                        continue;
                    }
                    canonicalName = rdn.getValue().toString() + "." + canonicalName;
                    continue;
                }
                canonicalName = canonicalName + "/" + rdn.getValue().toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return canonicalName;
    }
}

