/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipUtility {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static TreeSet sort = null;
    private static int archiveBufferSize = 8192;

    public static void createZipFile(String directoryName, String zipFileName, boolean isDirectoryRemove, ArrayList<String> filesList) throws Exception {
        File directory = new File(directoryName);
        if (directory.isDirectory()) {
            int i;
            System.out.println("zipFileName is " + zipFileName);
            zipFileName = directory.getAbsolutePath() + File.separator + zipFileName + ".zip";
            File[] files = directory.listFiles();
            ArrayList<Long> arr = new ArrayList<Long>(files.length);
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(zipFileName);
            ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(dest));
            out.setEncoding(rb.getString("adap.ZipUtility.mail.ZipEncoding"));
            out.setMethod(8);
            byte[] data = new byte[archiveBufferSize];
            int j = 0;
            for (i = 0; i < files.length; ++i) {
                int count;
                reportLogger.log(Level.INFO, "FILE NAME    : " + files[i].getName());
                reportLogger.log(Level.INFO, "Is Directory : " + files[i].isDirectory());
                if (files[i].isDirectory() || files[i].getName().endsWith(".zip")) continue;
                String fileName = files[i].getName();
                boolean isAvailable = false;
                for (int size = 0; size < filesList.size(); ++size) {
                    if (!fileName.contains(filesList.get(size))) continue;
                    isAvailable = true;
                }
                if (!isAvailable) continue;
                try {
                    arr.add(j, new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss").parse(fileName).getTime());
                }
                catch (ParseException pe) {
                    reportLogger.log(Level.INFO, "parsing exception occured in direcory " + directoryName);
                    arr.add(j, System.currentTimeMillis());
                }
                reportLogger.log(Level.INFO, "ADDING  {0} To zip {1}", new Object[]{fileName, zipFileName});
                FileInputStream fi = new FileInputStream(files[i]);
                origin = new BufferedInputStream(fi, archiveBufferSize);
                ZipArchiveEntry entry = new ZipArchiveEntry(fileName);
                out.putArchiveEntry((ArchiveEntry)entry);
                while ((count = origin.read(data, 0, archiveBufferSize)) != -1) {
                    out.write(data, 0, count);
                }
                fi.close();
                origin.close();
                ++j;
            }
            sort = new TreeSet(arr);
            if (origin != null) {
                origin.close();
            }
            if (out != null) {
                out.closeArchiveEntry();
                out.close();
            }
            if (dest != null) {
                dest.close();
            }
            for (i = 0; i < files.length; ++i) {
                for (int size = 0; size < filesList.size(); ++size) {
                    if (!files[i].getName().contains(filesList.get(size))) continue;
                    files[i].delete();
                }
            }
            if (isDirectoryRemove) {
                directory.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZipFile(String directoryName, String zipFileName, boolean isDirectoryRemove, ArrayList emptyFileList, ArrayList<String> filesList) throws Exception {
        File directory = new File(directoryName);
        if (directory.isDirectory()) {
            zipFileName = directory.getAbsolutePath() + File.separator + zipFileName + ".zip";
            File[] files = directory.listFiles();
            ArrayList<Long> arr = new ArrayList<Long>();
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(zipFileName);
            ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(dest));
            FileInputStream fi = null;
            try {
                out.setEncoding(rb.getString("adap.ZipUtility.mail.ZipEncoding"));
                out.setMethod(8);
                byte[] data = new byte[archiveBufferSize];
                String temp = null;
                int k = 0;
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory() || files[i].getName().endsWith(".zip")) continue;
                    for (int size = 0; size < filesList.size(); ++size) {
                        int count;
                        if (!files[i].getName().contains(filesList.get(size))) continue;
                        boolean zipsendflag = false;
                        temp = files[i].getName().replaceAll("_", " ");
                        for (int j = 1; j < emptyFileList.size() - 1; ++j) {
                            if (temp.indexOf((String)emptyFileList.get(j)) == -1) continue;
                            zipsendflag = true;
                        }
                        if (zipsendflag) continue;
                        String fileName = files[i].getName();
                        try {
                            arr.add(k, new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss").parse(fileName).getTime());
                        }
                        catch (ParseException pe) {
                            reportLogger.log(Level.INFO, "parsing exception occured in direcory " + directoryName);
                            arr.add(k, System.currentTimeMillis());
                        }
                        reportLogger.log(Level.INFO, "ADDING  {0} To zip {1}", new Object[]{fileName, zipFileName});
                        fi = new FileInputStream(files[i]);
                        origin = new BufferedInputStream(fi, archiveBufferSize);
                        ZipArchiveEntry entry = new ZipArchiveEntry(fileName);
                        out.putArchiveEntry((ArchiveEntry)entry);
                        while ((count = origin.read(data, 0, archiveBufferSize)) != -1) {
                            out.write(data, 0, count);
                        }
                        try {
                            fi.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        origin.close();
                        ++k;
                    }
                }
                sort = new TreeSet(arr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (fi != null) {
                        fi.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    if (origin != null) {
                        origin.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    if (out != null) {
                        out.closeArchiveEntry();
                        out.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    if (dest != null) {
                        dest.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
                if (isDirectoryRemove) {
                    directory.delete();
                }
            }
        }
    }
}

