/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.validation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class NonConfiguredDCDetails {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static NonConfiguredDCDetails nonConfiguredDCDetails = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NonConfiguredDCDetails getInstance() {
        if (nonConfiguredDCDetails != null) return nonConfiguredDCDetails;
        Class<NonConfiguredDCDetails> clazz = NonConfiguredDCDetails.class;
        synchronized (NonConfiguredDCDetails.class) {
            nonConfiguredDCDetails = new NonConfiguredDCDetails();
            // ** MonitorExit[var0] (shouldn't be in output)
            return nonConfiguredDCDetails;
        }
    }

    public static Hashtable domainControllerList(String domainname) throws Exception {
        Hashtable dcNameList = null;
        String table = "ADSMDCConfiguration";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)table, (String)"DOMAIN_NAME"), (Object)domainname, 0);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(table, criteria);
            ArrayList<String> dcList = new ArrayList<String>();
            ArrayList<String> netBiosName = new ArrayList<String>();
            ArrayList<String> dnsHostName = new ArrayList<String>();
            Iterator itr = dataobject.getRows(table);
            while (itr.hasNext()) {
                Row s = (Row)itr.next();
                String temp = String.valueOf(s.get("DOMAIN_CONTROLLER_NAME"));
                dcList.add(temp);
            }
            if (dcList == null || dcList.isEmpty()) {
                return null;
            }
            dcNameList = ADHandler.findDC(domainname, dcList);
            Set keys = dcNameList.keySet();
            for (String key : keys) {
                if (key.equals("errorfromdc") || key.equals("format")) continue;
                for (int counter1 = 0; counter1 < dcList.size() && !key.equalsIgnoreCase((String)dcList.get(counter1)) && !((String)dcList.get(counter1)).equalsIgnoreCase((String)dcNameList.get(key)); ++counter1) {
                    if (counter1 != dcList.size() - 1) continue;
                    netBiosName.add(key);
                    dnsHostName.add((String)dcNameList.get(key));
                }
            }
            dcNameList.put("configuredDCs", dcList);
            dcNameList.put("NotConfiguredNetBios", netBiosName);
            dcNameList.put("NotConfiguredDnsHost", dnsHostName);
            if (dcNameList.get("format").equals("dnsHostName")) {
                dcNameList.put("validDCNames", dnsHostName);
            } else {
                dcNameList.put("validDCNames", netBiosName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dcNameList;
    }

    public static String getThreadDump() {
        StringBuilder dump = new StringBuilder();
        try {
            ThreadInfo[] threadinfos;
            Long time = System.currentTimeMillis();
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss  yyyy:MM:dd");
            String lastmod = format.format(new Date(time));
            dump.append("$ Log is generated at " + lastmod);
            ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
            for (ThreadInfo threadinfo : threadinfos = threadmxbean.getThreadInfo(threadmxbean.getAllThreadIds(), Integer.MAX_VALUE)) {
                StackTraceElement[] stacktraceElements;
                dump.append("\n\nThread Name:");
                dump.append('\"');
                dump.append(threadinfo.getThreadName());
                dump.append("\" ");
                dump.append("\nThread ID:");
                dump.append('\"');
                dump.append(threadinfo.getThreadId());
                dump.append("\" ");
                dump.append("\n java.lang.Thread.State: ");
                Thread.State sta = threadinfo.getThreadState();
                dump.append((Object)sta);
                for (StackTraceElement stacktraceElement : stacktraceElements = threadinfo.getStackTrace()) {
                    dump.append("\n       at ");
                    dump.append(stacktraceElement);
                }
                String lockOwnername = threadinfo.getLockOwnerName() != null ? threadinfo.getLockOwnerName() : "-";
                String lockName = threadinfo.getLockName() != null ? threadinfo.getLockName() : "-";
                dump.append("\n Lock Owner Name:" + lockOwnername);
                dump.append("\n Lock Name:" + lockName);
                dump.append("\n\n");
            }
            FileWriter write = new FileWriter(System.getProperty("user.dir") + File.separator + File.separator + ".." + File.separator + "logs" + File.separator + "Thread_Dump_" + time + ".txt", false);
            write.write(dump.toString());
            write.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return rb.getString("adap.support.problem_in_thread_dump");
        }
        return rb.getString("adap.support.thread_dump_successfull");
    }

    public void heapFileCleaner() {
        String userDir = System.getProperty("user.dir");
        this.dumpFileHandler(userDir + File.separator + File.separator + ".." + File.separator + "logs", 1);
    }

    public void dumpFileHandler(String userDir, int mode) {
        ArrayList<File> dumpFiles = new ArrayList<File>();
        File file = new File(userDir);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        File[] fileList = file.listFiles();
        int fileList_size = fileList.length;
        for (int i = 0; i < fileList_size; ++i) {
            if (fileList[i].isDirectory() || !fileList[i].getName().startsWith("java_pid")) continue;
            dumpFiles.add(fileList[i]);
        }
        if (dumpFiles.size() > 0) {
            File[] files = new File[dumpFiles.size()];
            files = dumpFiles.toArray(files);
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.lastModified() < f2.lastModified() ? 1 : 0;
                }
            });
            for (int i = 0; i < dumpFiles.size(); ++i) {
                boolean delete = true;
                if (mode == 1) {
                    for (int j = 0; j < (dumpFiles.size() > 1 ? 2 : 1); ++j) {
                        if (!((File)dumpFiles.get(i)).getName().equals(files[j].getName())) continue;
                        delete = false;
                        break;
                    }
                }
                if (!delete) continue;
                ((File)dumpFiles.get(i)).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipFile(String file, String dest) {
        byte[] buffer = new byte[1024];
        try {
            File fi = new File(file);
            int namemodifier = 0;
            String ziptemp = "";
            String zipname = fi.getName();
            zipname = zipname.substring(0, zipname.indexOf("."));
            String zipfile = dest + File.separator + zipname + ".zip";
            File fi1 = new File(zipfile);
            while (fi1.exists()) {
                ziptemp = zipname;
                ziptemp = ziptemp + "(" + String.valueOf(namemodifier) + ")";
                zipfile = dest + File.separator + ziptemp + ".zip";
                fi1 = new File(zipfile);
                ++namemodifier;
            }
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            ZipEntry ze = null;
            try {
                fos = new FileOutputStream(zipfile);
                zos = new ZipOutputStream(fos);
                ze = new ZipEntry(fi.getName());
                zos.putNextEntry(ze);
                try (FileInputStream in = null;){
                    int len;
                    in = new FileInputStream(file);
                    while ((len = in.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    zos.closeEntry();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (zos != null) {
                    zos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void heapManage() {
        try {
            HeapFileCleaner HeapFileCleaner2 = new HeapFileCleaner();
            HeapFileCleaner2.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getFolderSizeDetails(String fileName, ArrayList<String> fileList) {
        String serverDir = "";
        String file = "";
        String size = "";
        StringBuilder wr = new StringBuilder();
        try {
            Long time = System.currentTimeMillis();
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss  yyyy:MM:dd");
            String lastmod = format.format(new Date(time));
            wr.append("$ Log is generated at " + lastmod + System.getProperty("line.separator"));
            serverDir = System.getProperty("server.dir");
            if (serverDir.equals("")) {
                serverDir = System.getProperty("user.dir") + File.separator + ".." + File.separator;
            }
            file = serverDir + File.separator + "logs" + File.separator + "CustomFolderSizeDetails.txt";
            if (fileName.equals("")) {
                fileName = serverDir;
                file = serverDir + File.separator + "logs" + File.separator + "ProductFolderSizeDetails.txt";
            }
            size = NonConfiguredDCDetails.getSize(NonConfiguredDCDetails.folderSize(new File(fileName), fileList, 0, wr));
            wr.append(System.getProperty("line.separator") + System.getProperty("line.separator") + "[Parent Folder:" + fileName + "] [Total size:" + size + "]" + System.getProperty("line.separator"));
            FileWriter wr1 = new FileWriter(file);
            wr1.write(wr.toString());
            wr1.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fileName + ";;" + size;
    }

    public static String getSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " Bytes";
        }
        long kB = bytes / 1024L;
        if (kB < 1024L) {
            return kB + " KB";
        }
        long Mb = kB / 1024L;
        return Mb + " MB";
    }

    public static long folderSize(File directory, ArrayList<String> list, int i, StringBuilder wr) throws Exception {
        long length = 0L;
        File[] files = directory.listFiles();
        if (files != null) {
            int files_size = files.length;
            for (int j = 0; j < files_size; ++j) {
                if (files[j].isFile()) {
                    length += files[j].length();
                    continue;
                }
                long sizz = NonConfiguredDCDetails.folderSize(files[j], list, i + 1, wr);
                if (i == 0) {
                    String siz = NonConfiguredDCDetails.getSize(sizz);
                    list.add(files[j].getName() + ";;" + files[j].getPath() + ";;" + siz);
                    wr.append("[Folder Name:" + files[j].getName() + "] [Folder path:" + files[j].getPath() + "] [size:" + siz + "]" + System.getProperty("line.separator"));
                }
                length += sizz;
            }
        }
        return length;
    }

    class HeapFileCleaner
    extends Thread {
        HeapFileCleaner() {
        }

        @Override
        public void run() {
            try {
                NonConfiguredDCDetails.this.heapFileCleaner();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

