/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.wengine;

import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.objects.dns.DNSUpdateUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.adventnet.tools.prevalent.ConsoleOut;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DNSUpdateTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        block4: {
            reportLogger.log(Level.INFO, "Scheduling the DNS Objects Updating Task.....");
            try {
                for (String domainName : DomainDetailsAPI.getConfiguredDomainList()) {
                    DNSUpdateUtil.getDNSZoneObjects(domainName);
                    DNSUpdateUtil.getDNSNodeObjects(domainName);
                }
            }
            catch (Exception ex) {
                reportLogger.log(Level.INFO, "DBG:: Exception while Event Update task..");
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof OutOfMemoryError)) break block4;
                ConsoleOut.println((String)"ADAP-OUTOFMEMORY");
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "DNSObjectUpdateTask";
    }
}

