/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.wengine;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.delegation.AuditPolicyHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDUtil;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DailyUpdateTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        reportLogger.log(Level.INFO, "Scheduling the Daily Report Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
        Long ScheduleId = taskContext.getScheduleID();
        Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)taskContext.getScheduleID(), 0);
        String scheduleName = "";
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
            Row r = obj.getFirstRow("Schedule");
            scheduleName = (String)r.get("SCHEDULE_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Hashtable getScheduledReportsDetails = SchedulerUtil.getScheduledReportsDetails(ScheduleId);
        ArrayList reportIDS = (ArrayList)getScheduledReportsDetails.get("reportIDS");
        ObjectUpdateHandler.runDailyReport(reportIDS);
        Hashtable props = new Hashtable();
        ArrayList<String> updates = new ArrayList<String>();
        updates.add("Add Policy");
        props.put("actionList", updates);
        try {
            Hashtable domains = DomainHandler.getConfiguredDomains();
            String domainName = null;
            Enumeration e = domains.keys();
            while (e.hasMoreElements()) {
                try {
                    String dn = (String)e.nextElement();
                    Properties p = (Properties)domains.get(dn);
                    domainName = p.getProperty("DOMAIN_NAME");
                    reportLogger.log(Level.INFO, "Schedule upadte is started for domain:" + domainName);
                    DomainProcess.getInstance().process(Long.valueOf(System.currentTimeMillis()).toString(), domainName, 1L, "update", props);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AuditPolicyHandler.systemParamsEntryRemover();
        TDUtil.syncWithAD();
        reportLogger.log(Level.INFO, "Completed the Daily Report Scheduler Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
    }

    public void stopTask() throws TaskExecutionException {
    }

    public String toString() {
        return "DailyReportTask";
    }
}

