/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.wengine;

import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterHandler;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.ntfs.FileUpdateTask;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUpdateScheduler
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        reportLogger.log(Level.INFO, "Scheduling the Folder update Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
        String IsFileUpdateSchedulerRunning = ADSMPersUtil.getSyMParameter("IsFileUpdateSchedulerRunning");
        String FileCreationThroughEvents = ADSMPersUtil.getSyMParameter("FileCreationThroughEvents");
        if ("true".equals(IsFileUpdateSchedulerRunning)) {
            return;
        }
        ADSMPersUtil.updateSyMParameter("IsFileUpdateSchedulerRunning", "true");
        ArrayList domainList = DomainHandler.getConfiguredList(1L);
        for (Object domainObject : domainList) {
            Properties properties = (Properties)domainObject;
            String domainName = properties.getProperty("DOMAIN_NAME");
            HashMap hashMap = FileServerHandler.getConfiguredShares(domainName);
            if (hashMap == null || hashMap.isEmpty()) continue;
            Set serverSet = hashMap.keySet();
            for (Object serverObject : serverSet) {
                String serverName = (String)serverObject;
                String osVersion = "";
                try {
                    if (FileCreationThroughEvents.equals("true") && ((osVersion = EventDataUtil.getComputerOsVersion(serverName, domainName)) == null || osVersion.equals(""))) {
                        osVersion = DirectoryObjectAPI.getInstance().getObjectOsVersion(domainName, "", serverName, "computer");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (ServerConfigAPI.isFileServerEnabled(serverName) && (FileCreationThroughEvents.equals("false") || osVersion != null && osVersion != "" && (!osVersion.startsWith("6.") || osVersion.startsWith("6.0")))) {
                    try {
                        reportLogger.log(Level.INFO, "Started fetching folders and files for server :" + serverName);
                        reportLogger.log(Level.INFO, "Hashmap is  :" + hashMap);
                        reportLogger.log(Level.INFO, "Hashmap get Server name  is  :" + hashMap.get(serverName));
                        FileUpdateTask fileUpdateTask = new FileUpdateTask(domainName, serverName, (Properties)hashMap.get(serverName), false, false);
                        fileUpdateTask.updateFiles();
                    }
                    catch (Exception e) {
                        reportLogger.log(Level.WARNING, "Error while updating files for server : " + serverName + ". The Error is : " + e.getMessage());
                        e.printStackTrace();
                    }
                    reportLogger.log(Level.INFO, "Finished fetching folders and files for server :" + serverName);
                    continue;
                }
                if (ClusterUtil.isClusterCapConfigured(domainName, serverName)) {
                    try {
                        reportLogger.log(Level.INFO, "Started fetching folders and files for CAP :" + serverName);
                        reportLogger.log(Level.INFO, "Hashmap is  :" + hashMap);
                        reportLogger.log(Level.INFO, "Hashmap get CAP name  is  :" + hashMap.get(serverName));
                        Boolean isEnabled = false;
                        ArrayList clusterNodes = ClusterHandler.getConfiguredClusterNodes(domainName, serverName);
                        if (clusterNodes != null) {
                            for (int i = 0; i < clusterNodes.size(); ++i) {
                                String clusterNodeName;
                                Properties nodeProps = (Properties)clusterNodes.get(i);
                                Integer machineType = (Integer)nodeProps.get("MACHINE_TYPE");
                                if ((machineType & 0x40) != 64) continue;
                                isEnabled = true;
                                if (!FileCreationThroughEvents.equals("true") || (osVersion = EventDataUtil.getComputerOsVersion(clusterNodeName = (String)nodeProps.get("COMPUTER_NAME"), domainName)) != null && !osVersion.equals("")) break;
                                osVersion = DirectoryObjectAPI.getInstance().getObjectOsVersion(domainName, "", clusterNodeName, "computer");
                                break;
                            }
                        }
                        if (isEnabled.booleanValue()) {
                            if (FileCreationThroughEvents.equals("false") || osVersion != null && osVersion != "" && (!osVersion.startsWith("6.") || osVersion.startsWith("6.0"))) {
                                reportLogger.log(Level.INFO, "File creation scheduler started for cluster");
                                FileUpdateTask fileUpdateTask = new FileUpdateTask(domainName, serverName, (Properties)hashMap.get(serverName), false, true);
                                fileUpdateTask.updateFiles();
                            }
                        } else {
                            reportLogger.log(Level.INFO, "No Cluster Nodes are Enabled for CAP Name: " + serverName);
                        }
                    }
                    catch (Exception e) {
                        reportLogger.log(Level.WARNING, "Error while updating files for CAP : " + serverName + ". The Error is : " + e.getMessage());
                        e.printStackTrace();
                    }
                    reportLogger.log(Level.INFO, "Finished fetching folders and files for server :" + serverName);
                    continue;
                }
                reportLogger.log(Level.INFO, "The Disabled file server {[0]} is excluded from File update scheduler", new Object[]{serverName});
            }
        }
        ADSMPersUtil.updateSyMParameter("LastFileUpdateScheduler", Long.valueOf(System.currentTimeMillis()).toString());
        ADSMPersUtil.updateSyMParameter("IsFileUpdateSchedulerRunning", "false");
        reportLogger.log(Level.INFO, "Completed the Folder update Scheduler Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
    }

    public void stopTask() throws TaskExecutionException {
    }
}

