/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.wengine;

import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.model.GraphGenerator;
import com.adventnet.sym.adsm.common.server.util.GraphUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ads.fw.api.RestAPIUtil;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GraphSchedulerTask
implements Task {
    public static boolean isHomeGraphRefreshRunning = false;
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    private static boolean isAD360Integrated() {
        try {
            if (CommonUtil.isProductIntegrated((String)"ManageEngine ADManager Plus")) {
                RestAPIUtil.getAPIURL((String)"ManageEngine ADManager Plus", (String)"LOAD_DASHBOARD_CONTAINERS");
            }
        }
        catch (Exception e) {
            return false;
        }
        return CommonUtil.isProductIntegrated((String)"ManageEngine AD360");
    }

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        reportLogger.log(Level.INFO, "Scheduling the Graph Scheduler Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
        if (!isHomeGraphRefreshRunning) {
            isHomeGraphRefreshRunning = true;
        }
        ArrayList domainList = DomainHandler.getConfiguredList(1L);
        for (Object object : domainList) {
            Properties properties = (Properties)object;
            String domainName = properties.getProperty("DOMAIN_NAME");
            try {
                Class<?> classToInvoke = Class.forName("com.adventnet.sym.adsm.common.webclient.graphs.schedule.DefaultGraphGenerator");
                LinkedHashMap<Long, HashMap> graphMap = GraphUtil.getHomeGraphList();
                GraphGenerator generator = (GraphGenerator)classToInvoke.newInstance();
                Set<Long> graphIDSet = graphMap.keySet();
                for (Long graphOptId : graphIDSet) {
                    HashMap detailsMap = graphMap.get(graphOptId);
                    Long firstGraphDuration = (Long)detailsMap.get("FIRST_GRAPH_DURATION");
                    if (GraphSchedulerTask.isAD360Integrated()) {
                        generator.generateGraph(graphOptId, domainName, firstGraphDuration, new ArrayList<HashMap>());
                    }
                    generator.generateHighCharts(graphOptId, domainName, firstGraphDuration, new ArrayList<HashMap<String, Object>>());
                    Long secondGraphDuration = (Long)detailsMap.get("SECOND_GRAPH_DURATION");
                    if (GraphSchedulerTask.isAD360Integrated()) {
                        generator.generateGraph(graphOptId, domainName, secondGraphDuration, new ArrayList<HashMap>());
                    }
                    generator.generateHighCharts(graphOptId, domainName, secondGraphDuration, new ArrayList<HashMap<String, Object>>());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        isHomeGraphRefreshRunning = false;
        reportLogger.log(Level.INFO, "Completed the Graph Scheduler Scheduler Task.......scheduleId:" + taskContext.getScheduleID() + ", taskId:  " + taskContext.getTaskID() + ", InstanceId: " + taskContext.getID());
    }

    public void stopTask() throws TaskExecutionException {
    }
}

