/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.wengine;

import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemoryManagerTask
implements Task {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long totalfreeMemory = freeMemory + (maxMemory - allocatedMemory);
        long totalusedMemory = maxMemory - totalfreeMemory;
        reportLogger.log(Level.INFO, "max memory: " + maxMemory);
        reportLogger.log(Level.INFO, "allocated memory: " + allocatedMemory);
        reportLogger.log(Level.INFO, "free memory: " + freeMemory);
        reportLogger.log(Level.INFO, "total free memory: " + totalfreeMemory);
        reportLogger.log(Level.INFO, "total used memory: " + totalusedMemory);
        float used = new Long(totalusedMemory).floatValue();
        float aval = new Long(maxMemory).floatValue();
        float usedPer = used / aval * 100.0f;
        if (usedPer > 80.0f) {
            reportLogger.log(Level.INFO, "Range Exceed % of Total Memory used: " + usedPer);
            this.writeToFile(new Float(usedPer).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String val) {
        reportLogger.log(Level.INFO, "writeToFile starts");
        String content = new Date(System.currentTimeMillis()).toString() + ":Application uses " + val + "% of java heap space.";
        String productHome = System.getProperty("product.home");
        String memOutDirStr = productHome + File.separator + "logs";
        reportLogger.log(Level.INFO, "content: " + content);
        reportLogger.log(Level.INFO, "productHome: " + productHome);
        reportLogger.log(Level.INFO, "memOutDirStr: " + memOutDirStr);
        File memOutDir = new File(memOutDirStr);
        if (!memOutDir.exists()) {
            boolean status = memOutDir.mkdir();
            reportLogger.log(Level.INFO, "memOutDir created: ");
        }
        if (memOutDir.exists()) {
            String processFileStr = productHome + File.separator + "logs" + File.separator + "memOut.txt";
            reportLogger.log(Level.INFO, "processFileStr : " + processFileStr);
            File processFile = new File(processFileStr);
            InputStreamReader inputFileReader = null;
            OutputStreamWriter outFileWriter = null;
            String Inline = null;
            String wholefile = "";
            try {
                if (processFile.exists()) {
                    inputFileReader = new FileReader(processFile);
                    BufferedReader bfre = new BufferedReader(inputFileReader);
                    while ((Inline = bfre.readLine()) != null) {
                        wholefile = wholefile + Inline + "\r\n";
                    }
                }
                wholefile = wholefile + content + "\r\n";
                outFileWriter = new FileWriter(processFile);
                outFileWriter.write(wholefile);
                reportLogger.log(Level.INFO, "File Write Success: ");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (inputFileReader != null) {
                        inputFileReader.close();
                    }
                    if (outFileWriter != null) {
                        outFileWriter.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

