/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.EventDataHandler;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.delegation.GpoHandler;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.monitor.ViewComputers;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;

public class ConfigureComputerAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger(ConfigureComputerAction.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward runMSEventScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.log(Level.INFO, "My Notification Print...");
        String msIdStr = request.getParameter("msId");
        String message = "";
        String messageType = "Success";
        if (msIdStr != null) {
            Long msId = Long.parseLong(msIdStr);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"COMPUTER_ID"), (Object)msId, 0);
            ArrayList<String> list = new ArrayList<String>();
            list.add("ADSMComputerGeneralDetails");
            list.add("AUDComputerEventRead");
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(list, criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADSMComputerGeneralDetails");
                Row eventRow = dataObject.getRow("AUDComputerEventRead");
                try {
                    EventDataHandler.getInstance().getEventDataFromDC((String)row.get("DOMAIN_NAME"), (String)row.get("NAME"), ((Integer)eventRow.get("MACHINE_TYPE")).intValue(), (String)row.get("OBJECT_GUID"));
                    message = rb.handleGetObject("adap.ConfigureComputerAction.Started_fetching_Event_Data_from", new String[]{(String)row.get("NAME")});
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfigureComputerAction.Started_fetching_Event_Data_from", new String[]{(String)row.get("NAME")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Run_Ms_scheduler_manually", "-"}));
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        logger.log(Level.INFO, "Error while fetching event from [{0}] is [{1}]", new Object[]{(String)row.get("NAME"), e.getMessage()});
                    } else {
                        e.printStackTrace();
                    }
                    messageType = rb.getString("adap.ConfigureComputerAction.Error");
                    message = rb.handleGetObject("Error while fetching event data from computer : ") + (String)row.get("NAME") + " \"" + e.getMessage() + "\"";
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("Error while fetching event data from computer : ") + (String)row.get("NAME") + " \"" + e.getMessage() + "\"", 8, 8, "adap.ADAPUserAuditSeverities.audit_name.Run_Ms_scheduler_manually", "-"}));
                }
            }
        }
        ClientUtil.setStatusXMLElement(response, messageType, message);
        return mapping.findForward(null);
    }

    public ActionForward updateMemberServers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"listofMS", (ADAPAuthObject)authObj);
        logger.log(Level.INFO, "am in updateMemberServers");
        DynaActionForm bean = (DynaActionForm)form;
        String domainName = (String)bean.get("DOMAIN_NAME");
        String message = "";
        ArrayList msNameList = new ArrayList();
        try {
            if (accessType == 32) {
                String msIdStr = request.getParameter("msId");
                StringTokenizer st = new StringTokenizer(msIdStr, ";;;");
                ArrayList<Long> msList = new ArrayList<Long>();
                while (st.hasMoreTokens()) {
                    String msId = st.nextToken();
                    msList.add(Long.parseLong(msId));
                }
                String manageAction = request.getParameter("ManageAction");
                String selectedTile = request.getParameter("selectedTile");
                int[] machineTypes = MSHandler.getMachineTypes((String)request.getParameter("selectedTile"), (String)"Enable");
                message = MSHandler.updateMemberServers((String)domainName, (String)manageAction, msList, (String)request.getParameter("timePeriod"), (Integer)machineTypes[0], (boolean[])new boolean[0]);
                msNameList = ReportUtil.getMSNamesFromId(msList, (String)"COMPUTER_ID");
                domainName = request.getParameter("domainName");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Modified_Servers_successfully", new String[]{Long.toString(msList.size()), manageAction}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.changed_computers_successfully", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Changed_Computers", new String[]{msNameList.toString()})}));
                logger.log(Level.INFO, "domainName is " + domainName);
            } else {
                message = rb.getString("adap.access_denied.ConfigureComputerAction.update");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Problem_modifying_computers", new String[]{message}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.changed_computers_successfully", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Changed_Computers", new String[]{msNameList.toString()})}));
        }
        try {
            this.getConfiguredMemberServers(bean, request, domainName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        request.setAttribute("message", (Object)message);
        return mapping.findForward("viewComputers");
    }

    public ActionForward addMemberServers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"listofMS", (ADAPAuthObject)authObj);
        String message = null;
        DynaActionForm bean = (DynaActionForm)form;
        String domainName = (String)bean.get("DOMAIN_NAME");
        ArrayList msNameList = new ArrayList();
        try {
            if (accessType == 32) {
                String objectGuids = request.getParameter("objectGuid");
                String userSelection = request.getParameter("userSelection");
                StringTokenizer st = new StringTokenizer(objectGuids, ",");
                ArrayList guidList = new ArrayList();
                ArrayList<String> tempGuidList = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String objectGuid = st.nextToken();
                    if (tempGuidList.contains(objectGuid)) continue;
                    HashMap<String, String> computerMap = new HashMap<String, String>();
                    computerMap.put("OBJECT_GUID", objectGuid);
                    guidList.add(computerMap);
                    tempGuidList.add(objectGuid);
                }
                if (guidList.isEmpty()) {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.getString("adap.ConfigureComputerAction.No_computer_are_selected_for_auditing"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.No_computers_added", "-"}));
                    throw new Exception("adap.ConfigureComputerAction.No_computer_are_selected_for_auditing");
                }
                String selectedTile = request.getParameter("selectedTile");
                int[] machineTypes = MSHandler.getMachineTypes((String)request.getParameter("selectedTile"), (String)"Enable");
                message = MSHandler.addORUpdateServers((String)domainName, guidList, (String)userSelection, (int)machineTypes[0], (boolean[])new boolean[0]);
                msNameList = ReportUtil.getMSNamesFromId(guidList, (String)"OBJECT_GUID");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.add_computers", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Added_Computers", new String[]{msNameList.toString()})}));
            } else {
                message = rb.getString("adap.access_denied.ConfigureComputerAction.add");
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (DataAccessException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
            if (message.indexOf("Duplicate entry") != -1) {
                message = rb.getString("adap.ConfigureComputerAction.The_Member_Servers_already_Configured");
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", message, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.add_computers", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.Added_Computers", new String[]{msNameList.toString()})}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        domainName = (String)session.getAttribute("MONITOR_DOMAIN_NAME");
        this.getConfiguredMemberServers(bean, request, domainName);
        request.setAttribute("message", (Object)message);
        return mapping.findForward("viewComputers");
    }

    private void getConfiguredMemberServers(DynaActionForm bean, HttpServletRequest request, String domainName) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        bean.set("PAGE_NUMBER", (Object)"1");
        bean.set("FROM_INDEX", (Object)1);
        HashMap<String, Object> addnParamsMap = new HashMap<String, Object>();
        addnParamsMap.put("sortColumn", (String)bean.get("sortColumn"));
        addnParamsMap.put("sortOrder", (String)bean.get("sortOrder"));
        addnParamsMap.put("noOfObjects", bean.get("RANGE"));
        addnParamsMap.put("startIndex", bean.get("FROM_INDEX"));
        addnParamsMap.put("tableName", (String)bean.get("tableName"));
        String selectedTile = request.getParameter("selectedTile");
        String filterAction = (String)bean.get("action");
        if (filterAction == null) {
            filterAction = "All";
        }
        HashMap valueMap = ViewComputers.getSearchString(request, bean);
        int[] machineTypes = MSHandler.getMachineTypes((String)selectedTile, (String)filterAction);
        int count = ServerConfigAPI.getConfiguredServerCount((String)domainName, (String)((String)valueMap.get("searchCriteria")), (String)((String)valueMap.get("searchMsgCri")), (int[])machineTypes, null);
        ArrayList list = new ArrayList();
        if (count > 0) {
            list = ServerConfigAPI.getConfiguredServers((String)domainName, addnParamsMap, (String)((String)valueMap.get("searchCriteria")), (String)((String)valueMap.get("searchMsgCri")), null, (int[])machineTypes, (Integer)count);
        }
        Boolean gpoStatus = null;
        if ((machineTypes[0] & 0x1000) == 4096 || (machineTypes[0] & 0x2000) == 8192 || (machineTypes[0] & 0x10) == 16 || (machineTypes[0] & 0x20) == 32) {
            gpoStatus = GpoHandler.getGpoStatus((String)domainName, (Integer)machineTypes[0]);
        }
        String uvhString = "AUDCVConfig:cv_id:10003";
        Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
        ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, Boolean.valueOf(true));
        String gpoGuids = "";
        if (gpoStatus != null) {
            PolicyHandler polHandler = new PolicyHandler();
            boolean auditDDCPolicyState = polHandler.getAuditPolicy(domainName, "{6AC1786C-016F-11D2-945F-00C04fB984F9}", false);
            if (!auditDDCPolicyState && !gpoStatus.booleanValue()) {
                gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
                gpoGuids = gpoGuids + ",";
                gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
            } else if (!gpoStatus.booleanValue()) {
                gpoGuids = gpoGuids + "{31B2F340-016D-11D2-945F-00C04FB984F9}";
            } else if (!auditDDCPolicyState) {
                gpoGuids = gpoGuids + "{6AC1786C-016F-11D2-945F-00C04fB984F9}";
            }
        }
        request.setAttribute("gpoGuids", (Object)gpoGuids);
        request.setAttribute("columnList", (Object)columnList);
        request.setAttribute("list", (Object)list);
        request.setAttribute("count", (Object)count);
        request.setAttribute("PolicyStatus", (Object)gpoStatus);
        if (selectedTile.equalsIgnoreCase("listofWS")) {
            ArrayList<String> rangeList = new ArrayList<String>();
            rangeList.add("100");
            rangeList.add("200");
            rangeList.add("500");
            rangeList.add("1000");
            request.setAttribute("RangeList", rangeList);
        }
        TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Configuration", rb.handleGetObject("adap.ConfigureComputerAction.audit_entry.get_configured_server", new String[]{domainName}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.view_list_of_computers", "-"}));
    }
}

