/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.alert;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.alert.AlertProfileHandler;
import com.adventnet.sym.adsm.auditing.server.alert.GPOAlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.alert.PrintAlertProfileAPI;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class ModifyAlertProfileAction
extends Action {
    public static String[] ignoreKeyStrings = new String[]{"CREATION_TIME", "MODIFICATION_TIME", "IS_ENABLED", "IS_BUSINESS_HOUR_ENABLED", "thresholdDetails", "UserNameAlert", "businessHourDetails"};

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm alertProfileBean = (DynaActionForm)form;
        String forwardPath = "alertProfile";
        try {
            HashMap map;
            Row row;
            DataObject dataObj;
            String[] nameList;
            ArrayList domainNameList;
            Boolean b;
            HashMap businessHourMap;
            HashMap CallerUserNameMap;
            HashMap thresholdMap;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            String alertProfileIdString = request.getParameter("alertProfileId");
            Long alertProfileId = Long.parseLong(alertProfileIdString);
            alertProfileBean.initialize(mapping);
            alertProfileBean.set("operation", (Object)"modify");
            ArrayList<Integer> severityList = new ArrayList<Integer>();
            severityList.add(1);
            severityList.add(2);
            severityList.add(3);
            ArrayList<String> severityTextList = new ArrayList<String>();
            severityTextList.add(rb.getString("adap.common.text.attention"));
            severityTextList.add(rb.getString("adap.common.text.trouble"));
            severityTextList.add(rb.getString("adap.common.text.critical"));
            alertProfileBean.set("severityList", severityList);
            alertProfileBean.set("severityTextList", severityTextList);
            HashMap alertProfileMap = AlertProfileHandler.getAlertProfile((Long)alertProfileId);
            Set keySet = alertProfileMap.keySet();
            List<String> ignoreKeyList = Arrays.asList(ignoreKeyStrings);
            for (Object object : keySet) {
                String key = (String)object;
                if (ignoreKeyList.contains(key)) continue;
                alertProfileBean.set(key, alertProfileMap.get(key));
            }
            ArrayList monitorList = (ArrayList)alertProfileBean.get("monitorList");
            ArrayList<String> monitorNameList = new ArrayList<String>();
            if (monitorList == null) {
                monitorList = new ArrayList();
                alertProfileBean.set("monitorList", monitorList);
                request.setAttribute("message", (Object)rb.getString("adap.ModifyAlertProfileAction.Not_able_to_get_Report"));
            }
            for (Object object2 : monitorList) {
                Long monitorId = (Long)object2;
                alertProfileBean.set("DOMAIN_NAME", (Object)AlertProfileHandler.getDomainName((Long)monitorId));
                monitorNameList.add(rb.getString((String)AuditMonitorAPI.getInstance().getMonitorProperty(monitorId, "MONITOR_NAME")));
            }
            alertProfileBean.set("monitorNameList", monitorNameList);
            HashMap notificationMap = AlertProfileHandler.getAlertNotification((Long)alertProfileId);
            if (!notificationMap.isEmpty()) {
                alertProfileBean.set("TO_ADDRESS1", notificationMap.get("toAddress"));
                alertProfileBean.set("MAIL_SUBJECT", notificationMap.get("MAIL_SUBJECT"));
                request.setAttribute("checkBox", (Object)"true");
            }
            if (!(thresholdMap = (HashMap)alertProfileMap.get("thresholdDetails")).isEmpty()) {
                alertProfileBean.set("thresholdInterval", thresholdMap.get("thresholdInterval"));
                alertProfileBean.set("thresholdCount", thresholdMap.get("thresholdCount"));
                request.setAttribute("thresholdCheckBox", (Object)"true");
            }
            if (!(CallerUserNameMap = (HashMap)alertProfileMap.get("UserNameAlert")).isEmpty()) {
                request.setAttribute("callerUserNameCheckBox", (Object)"true");
            }
            if ((businessHourMap = (HashMap)alertProfileMap.get("businessHourDetails")).size() > 0) {
                if (((Boolean)businessHourMap.get("included")).booleanValue()) {
                    request.setAttribute("IS_BUSINESS_HOUR", (Object)"true");
                    request.setAttribute("included", (Object)"true");
                } else if (!((Boolean)businessHourMap.get("included")).booleanValue()) {
                    request.setAttribute("IS_BUSINESS_HOUR", (Object)"true");
                    request.setAttribute("excluded", (Object)"true");
                }
            }
            if ((b = GPOAlertProfileAPI.isGPOAlertProfile((Long)alertProfileId)).booleanValue()) {
                domainNameList = (ArrayList)DomainHandler.getConfiguredDomainsList().get("DomainNameList");
                nameList = domainNameList.toArray(new String[domainNameList.size()]);
                dataObj = GPOAlertProfileAPI.getAlertCriteriaDO((Long)alertProfileId);
                row = dataObj.getRow("AUDAlertCriteria");
                alertProfileBean.set("DOMAIN_NAME", row.get("DOMAIN_NAME"));
                alertProfileBean.set("domainNames", (Object)nameList);
                map = GPOAlertProfileAPI.getGPONameGuidMap((Long)alertProfileId);
                request.setAttribute("gpoSettingsMap", (Object)map);
            }
            if (PrintAlertProfileAPI.isPrinterAlertProfile((Long)alertProfileId).booleanValue()) {
                domainNameList = (ArrayList)DomainHandler.getConfiguredDomainsList().get("DomainNameList");
                nameList = domainNameList.toArray(new String[domainNameList.size()]);
                dataObj = PrintAlertProfileAPI.getAlertCriteriaDO((Long)alertProfileId);
                row = dataObj.getRow("AUDPrinterAlertCriteria");
                alertProfileBean.set("DOMAIN_NAME", row.get("DOMAIN_NAME"));
                alertProfileBean.set("domainNames", (Object)nameList);
                map = PrintAlertProfileAPI.getPrinterNameMap((Long)alertProfileId);
                request.setAttribute("printerSettingsMap", (Object)map);
            }
            alertProfileBean.set("selectedObjectsMap", (Object)AlertProfileHandler.getAlertDetails((Object)alertProfileId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPath);
    }
}

