/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.auditing.webclient.alert;

import com.adventnet.sym.adsm.auditing.server.alert.AlertAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.webclient.alert.AuditAlertBean;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.CommonBeanUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class ViewAlertsAction
extends DispatchAction {
    public ActionForward viewAlerts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditAlertBean auditAlertBean = (AuditAlertBean)form;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        String forward = "auditAlerts";
        String alertStatus = "active";
        try {
            if (request.getParameter("init") != null) {
                auditAlertBean.initializeBean(request);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.alert_was_generated"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.Alerts_generated", "-"}));
            }
            if (request.getParameter("alertStatus") != null) {
                alertStatus = request.getParameter("alertStatus");
            }
            auditAlertBean.set("alertStatus", alertStatus);
            if (request.getParameter("sortColumn") != null) {
                auditAlertBean.set("sortColumn", request.getParameter("sortColumn"));
                auditAlertBean.set("sortOrder", request.getParameter("sortOrder"));
            }
            if (request.getParameter("PAGE_NUMBER") == null) {
                auditAlertBean.set("PAGE_NUMBER", "1");
                auditAlertBean.set("FROM_INDEX", 1);
            }
            HashMap inputParamsMap = auditAlertBean.getInputParamsValues();
            if (alertStatus.equals("active")) {
                inputParamsMap.put("SEVERITY", "0");
            } else {
                inputParamsMap.put("SEVERITY", "-1");
            }
            String countStr = AlertAPI.getInstance().getAlertsCount(null, inputParamsMap);
            countStr = countStr.replace("AND SEVERITY=${SEVERITYID}", " ");
            request.getSession().setAttribute("countStr", (Object)countStr);
            countStr = countStr.replace("${ALERTCOLUMNS}", "");
            countStr = countStr.replace("${ALERT_GROUP_BY}", "");
            int count = QueryUtil.getRowsCount((String)countStr);
            request.setAttribute("count", (Object)count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward viewAlertRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditAlertBean auditAlertBean = (AuditAlertBean)form;
        String forward = "alertRows";
        try {
            if (request.getParameter("init") != null) {
                auditAlertBean.initializeBean(request);
            }
            if (request.getParameter("sortColumn") != null) {
                auditAlertBean.set("sortColumn", request.getParameter("sortColumn"));
                auditAlertBean.set("sortOrder", request.getParameter("sortOrder"));
            }
            if (request.getParameter("PAGE_NUMBER") == null) {
                auditAlertBean.set("PAGE_NUMBER", "1");
                auditAlertBean.set("FROM_INDEX", 1);
            }
            HashMap inputParamsMap = auditAlertBean.getInputParamsValues();
            if (auditAlertBean.get("alertStatus").equals("active")) {
                inputParamsMap.put("SEVERITY", "0");
            } else {
                inputParamsMap.put("SEVERITY", "-1");
            }
            String SEVERITYID = request.getParameter("severityid");
            if (SEVERITYID != null) {
                inputParamsMap.put("SEVERITYID", SEVERITYID);
            }
            String search = request.getParameter("search");
            String searchCriteria = null;
            if (search != null && request.getParameter("cvID") != null) {
                Long cvID = Long.valueOf(request.getParameter("cvID"));
                searchCriteria = this.getColumnSearchCriteria(request, cvID);
            }
            String countStr = AlertAPI.getInstance().getAlertsCount(searchCriteria, inputParamsMap);
            countStr = countStr.replace("AND SEVERITY=${SEVERITYID}", "");
            countStr = countStr.replace("${ALERTCOLUMNS}", "");
            countStr = countStr.replace("${ALERT_GROUP_BY}", "");
            int count = QueryUtil.getRowsCount((String)countStr);
            ArrayList alertList = AlertAPI.getInstance().getAlertRows(searchCriteria, inputParamsMap, (String)auditAlertBean.get("sortColumn"), (String)auditAlertBean.get("sortOrder"), ((Integer)auditAlertBean.get("FROM_INDEX")).intValue(), ((Integer)auditAlertBean.get("RANGE")).intValue(), SEVERITYID, Integer.valueOf(count));
            String uvhString = "AUDCVConfig:cv_id:10001";
            Long cvId = DBObjectUtil.getUVHValues((String)"AUDCVConfig", (String)uvhString);
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, Boolean.valueOf(true));
            request.setAttribute("alertList", (Object)alertList);
            request.setAttribute("columnList", (Object)columnList);
            request.setAttribute("count", (Object)count);
            request.getSession().setAttribute("countStr", (Object)countStr);
            request.setAttribute("severityId", (Object)SEVERITYID);
            request.setAttribute("cvId", (Object)cvId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public String getColumnSearchCriteria(HttpServletRequest request, Long cvId) {
        String columnName = "";
        String tableName = "";
        String searchCriteria = "";
        try {
            Boolean visible = true;
            ArrayList columnList = AUDCustomViewAPI.getInstance().getVisibleColumnList(cvId, visible);
            HashMap valueMap = CommonBeanUtil.getSearchString(request, columnList);
            String searchString = (String)valueMap.get("searchString");
            searchCriteria = (String)valueMap.get("searchCriteria");
            if (searchString != null) {
                request.setAttribute("searchString", (Object)searchString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchCriteria;
    }

    public static String getSearchString(String searchString, Long id) {
        String val = "";
        int index = searchString.indexOf("search_" + id + "=");
        if (index != -1) {
            val = searchString.indexOf("&", index) != -1 ? searchString.substring(searchString.indexOf("=", index) + 1, searchString.indexOf("&", index)) : searchString.substring(searchString.indexOf("=", index) + 1);
        }
        return val;
    }

    public ActionForward clearAlerts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditAlertBean auditAlertBean = (AuditAlertBean)form;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            String action = request.getParameter("action");
            String INPUT_IDs = request.getParameter("inputIds");
            String[] inputIds = INPUT_IDs.split(";;;");
            Long[] alertId = new Long[inputIds.length];
            for (int i = 0; i < inputIds.length; ++i) {
                alertId[i] = Long.valueOf(inputIds[i]);
            }
            AlertAPI.getInstance().clearAlerts(alertId, action);
            String message = inputIds.length + " alert was deleted";
            int accessType = 16;
            if (action.equals("clear")) {
                message = inputIds.length + " alert was cleared";
                accessType = 8;
            }
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Alerts", message, accessType, 8, "adap.ADAPUserAuditSeverities.audit_name.Alert_cleared", "-"}));
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.Failed_to_clear_alert"), 8, 16, "ADAPUserAuditSeverities.audit_name.Failed_to_clear_alerts", "-"}));
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward showAlertDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditAlertBean auditAlertBean = (AuditAlertBean)form;
        String forward = "showAlertDetails";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Long alert_id = 0L;
            if (request.getParameter("alert_id") != null) {
                alert_id = Long.parseLong(request.getParameter("alert_id"));
            }
            HashMap detailsMap = AlertAPI.getInstance().showAlertDetails(alert_id);
            String tableName = (String)detailsMap.get("tableName");
            Long uniqueId = (Long)detailsMap.get("uniqueId");
            String queryString = "SELECT * FROM " + tableName + " WHERE UNIQUE_ID = " + uniqueId;
            if (tableName.equalsIgnoreCase("AudGPOAuditInfo")) {
                request.setAttribute("gpoAudit", (Object)true);
                request.setAttribute("uniqueId", (Object)uniqueId);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.GPO_Alert_Viewed"), 4, 8, "ADAPUserAuditSeverities.audit_name.GPO_Alert_Viewed", "-"}));
            } else if (tableName.equalsIgnoreCase("AUDPrintjobsinqueue")) {
                forward = "showPrinterDetails";
                ArrayList rowList = PrintHandler.getRows((Long)uniqueId);
                request.setAttribute("rowList", (Object)rowList);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.Printers_Alert_Viewed"), 4, 8, "ADAPUserAuditSeverities.audit_name.Printer_Alert_Viewed", "-"}));
            } else {
                if (!tableName.equals("")) {
                    Long cvID = AUDCustomViewAPI.getInstance().getReportCVId((Long)detailsMap.get("reportID"));
                    ArrayList columnList = AUDCustomViewAPI.getInstance().getColumnList(cvID);
                    ArrayList rowList = QueryUtil.getRows((String)queryString, (ArrayList)columnList, new HashMap(), (Boolean)false);
                    request.setAttribute("columnList", (Object)columnList);
                    request.setAttribute("rowList", (Object)rowList);
                    request.setAttribute("alertDetails", (Object)true);
                    ArrayList reportsList = AlertAPI.getInstance().getRowList(alert_id, tableName);
                    if (request.getParameter("threshold") != null || request.getParameter("homePage") != null) {
                        if (rowList.size() <= 1 && (reportsList == null || reportsList.size() > 1) && request.getParameter("threshold") == null) {
                            ArrayList rowList1 = QueryUtil.getRows((String)queryString, (ArrayList)AuditReportAPI.getInstance().getVisibleColumnList(cvID), new HashMap(), (Boolean)false);
                            request.setAttribute("columnListThres", (Object)AuditReportAPI.getInstance().getVisibleColumnList(cvID));
                            request.setAttribute("reportsList", (Object)rowList1);
                            request.setAttribute("alert_id", (Object)alert_id);
                        } else {
                            request.setAttribute("columnListThres", (Object)AlertAPI.getInstance().columnList);
                            request.setAttribute("reportsList", (Object)reportsList);
                            if (request.getParameter("goBack") != null) {
                                request.setAttribute("goBack", (Object)"true");
                                request.setAttribute("alert_id", (Object)alert_id);
                            }
                            forward = "showAlertInDialog";
                        }
                    } else {
                        request.setAttribute("alert_id", (Object)alert_id);
                        request.setAttribute("columnList", (Object)columnList);
                        request.setAttribute("rowList", (Object)rowList);
                    }
                } else {
                    request.setAttribute("alertDetails", (Object)false);
                }
                request.setAttribute("gpoAudit", (Object)false);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "Alerts", rb.getString("adap.ViewAlertsAction.audit_entry.Alert_details_viewed"), 4, 8, "ADAPUserAuditSeverities.audit_name.Alert_Details_viewed", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    public ActionForward homePageAlertDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuditAlertBean auditAlertBean = (AuditAlertBean)form;
        String forward = "homeAlertFrame";
        try {
            auditAlertBean.initializeBean(request);
            auditAlertBean.set("alertStatus", "active");
            auditAlertBean.set("sortColumn", "CREATION_TIME");
            auditAlertBean.set("sortOrder", "DESC");
            auditAlertBean.set("PAGE_NUMBER", "1");
            auditAlertBean.set("FROM_INDEX", 1);
            HashMap inputParamsMap = auditAlertBean.getInputParamsValues();
            inputParamsMap.put("SEVERITY", "0");
            ArrayList alertList = AlertAPI.getInstance().getAlertRows(null, inputParamsMap, (String)auditAlertBean.get("sortColumn"), (String)auditAlertBean.get("sortOrder"), ((Integer)auditAlertBean.get("FROM_INDEX")).intValue(), ((Integer)auditAlertBean.get("RANGE")).intValue(), null, new Integer(0));
            request.setAttribute("alertList", (Object)alertList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forward);
    }
}

